/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.board.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.board.model.BoardGroup;
import com.inscada.mono.board.w.c_ska;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="board")
@CheckAtLeastOneNotNull(fieldNames={"boardGroupId", "boardGroup"})
public class Board
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="board_group_id")
    private BoardGroup boardGroup;
    @Min(value=0L)
    private Float x;
    @Min(value=0L)
    private Float width;
    @Id
    @Column(name="board_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="boardSeq")
    @GenericGenerator(name="boardSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="board_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Min(value=0L)
    private Float y;
    @NotNull
    private c_ska type;
    @Min(value=0L)
    private Float height;
    @NotBlank
    private String config;
    private Boolean header;
    @Column(name="board_group_id", updatable=false, insertable=false)
    private Integer boardGroupId;

    public Float getY() {
        Board a;
        return a.y;
    }

    public Integer getId() {
        Board a;
        return a.id;
    }

    public BoardGroup getBoardGroup() {
        Board a;
        return a.boardGroup;
    }

    public void setBoardGroupId(Integer a) {
        a.boardGroupId = a;
    }

    public int hashCode() {
        Board a;
        Object[] objectArray = new Object[4];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getBoardGroupId();
        objectArray[2] = a.getType();
        objectArray[3] = a.getConfig();
        return Objects.hash(objectArray);
    }

    public Float getX() {
        Board a;
        return a.x;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Float getWidth() {
        Board a;
        return a.width;
    }

    public void setHeight(Float a) {
        a.height = a;
    }

    public Board() {
        Board a;
    }

    public void setWidth(Float a) {
        a.width = a;
    }

    public void setHeader(Boolean a) {
        a.header = a;
    }

    public void setX(Float a) {
        a.x = a;
    }

    public void setConfig(String a) {
        a.config = a;
    }

    public boolean equals(Object a) {
        Board a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof Board)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (Board)a;
        return Objects.equals(a2.getBoardGroupId(), a.getBoardGroupId()) && a2.getType() == a.getType() && Objects.equals(a2.getConfig(), a.getConfig());
    }

    public void setBoardGroup(BoardGroup a) {
        Board a2;
        Board board = a2;
        board.boardGroup = a;
        board.boardGroupId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getBoardGroupId() {
        Board a;
        return a.boardGroupId;
    }

    public void setType(c_ska a) {
        a.type = a;
    }

    public void setY(Float a) {
        a.y = a;
    }

    public Boolean getHeader() {
        Board a;
        return a.header;
    }

    public Float getHeight() {
        Board a;
        return a.height;
    }

    public String getConfig() {
        Board a;
        return a.config;
    }

    public c_ska getType() {
        Board a;
        return a.type;
    }
}

