/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.restcontrollers;

import com.inscada.mono.animation.enums.c_ila;
import com.inscada.mono.animation.k.c_ida;
import com.inscada.mono.animation.k.c_jka;
import com.inscada.mono.animation.messages.EvalAnimationMessage;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.animation.model.AnimationElement;
import com.inscada.mono.animation.model.AnimationScript;
import com.inscada.mono.animation.model.RunAnimScriptDto;
import com.inscada.mono.fs.restcontrollers.FileController;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.user.k.c_ca;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/animations"})
public class AnimationController
extends ProjectBasedImportExportController {
    private final c_ida d;
    private final c_jka g;

    @GetMapping(value={"/{animationId}/svg"})
    public ResponseEntity<InputStreamResource> getAnimationSvg(@PathVariable(value="animationId") Integer a) {
        a = this.g.m_wj(a);
        byte[] byArray = a.getSvgContent().getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream = new InputStreamResource((InputStream)byteArrayInputStream);
        String[] stringArray = new String[1];
        stringArray[0] = "attachment; filename=\"" + a.getName() + ".svg\"";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header(FileController.m_ck((Object)"\u0002m/v$l5/\u0005k2r.q(v(m/"), stringArray)).contentLength((long)byArray.length).contentType(MediaType.valueOf((String)c_ca.m_ck((Object)"b\u0016j\u001cnTx\rlPs\u0016g"))).body((Object)byteArrayInputStream);
    }

    public AnimationController(c_jka a, c_ida a2, c_cd a3, c_ll a4) {
        AnimationController a5;
        AnimationController animationController = a5;
        super(a3, EnumSet.of(c_ao.f), a4);
        animationController.g = a;
        animationController.d = a2;
    }

    @DeleteMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        this.g.m_jja(animationId, a);
    }

    @PutMapping(value={"/{animationId}/placeholders"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatePlaceholders(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.g.m_xyb(animationId, a);
    }

    @GetMapping(value={"/{animationId}/scripts"})
    public Collection<AnimationScript> getAnimationScripts(@PathVariable(value="animationId") Integer a) {
        return this.g.m_sxb(a);
    }

    @PutMapping(value={"/{animationId}/svg"}, consumes={"text/plain"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationSvg(@PathVariable(value="animationId") Integer animationId, @RequestBody String a) {
        this.g.m_iea(animationId, a);
    }

    @MessageMapping(value={"/eval-animation"})
    public void animationResultMessage(@Payload EvalAnimationMessage evalAnimationMessage, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.d.m_wnc(evalAnimationMessage, a.getName(), sessionId);
    }

    @PutMapping(value={"/{animationId}/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer elementId, @Valid @RequestBody AnimationElement a) {
        this.g.m_qxb(animationId, elementId, a);
    }

    @GetMapping(value={"/project/{projectId}"}, params={"name"})
    public Animation getAnimationByProjectId(@PathVariable(value="projectId") Integer projectId, @RequestParam(name="name") String a) {
        return this.g.m_dg(projectId, a);
    }

    @DeleteMapping(value={"/elements/{elementId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElement(@PathVariable(value="elementId") Integer a) {
        this.g.m_vpc(a);
    }

    @PostMapping(value={"/{animationId}/clone"}, params={"name"})
    public ResponseEntity<Animation> cloneAnimation(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="name") String name, UriComponentsBuilder a) {
        animationId = this.g.m_zia(animationId, name);
        Object[] objectArray = new Object[1];
        objectArray[0] = animationId.getId();
        return ResponseEntity.created((URI)a.path(FileController.m_ck((Object)"-:c/k,c5k.l\bf<")).buildAndExpand(objectArray).toUri()).body((Object)animationId);
    }

    @DeleteMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        this.g.m_ozb(animationId, a);
    }

    @DeleteMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimation(@PathVariable(value="animationId") Integer a) {
        this.g.m_qa(a);
    }

    @GetMapping(value={"/project/names"}, params={"projectId", "names"})
    public Collection<Animation> getAnimationsByProjectAndNames(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="names") Set<String> a) {
        return this.g.m_nea(projectId, a);
    }

    @GetMapping(value={"/{animationId}/elements"})
    public Collection<AnimationElement> getAnimationElements(@PathVariable(value="animationId") Integer a) {
        return this.g.m_lja(a);
    }

    @GetMapping
    public Collection<Animation> getAnimations(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_la(a);
    }

    @GetMapping(value={"/name/elements"}, params={"name", "type"})
    public AnimationElement getAnimationElementByNameAndType(@RequestParam(name="name") String name, @RequestParam(name="type") c_ila a) {
        return this.g.m_tjc(name, a);
    }

    @GetMapping(value={"/{animationId}/scripts/{scriptId}"})
    public AnimationScript getAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer a) {
        return this.g.m_zbc(animationId, a);
    }

    @PutMapping(value={"/{animationId}/scripts/{scriptId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimationScript(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="scriptId") Integer scriptId, @Valid @RequestBody AnimationScript a) {
        this.g.m_tvb(animationId, scriptId, a);
    }

    @GetMapping(value={"/{animationId}"})
    public Animation getAnimation(@PathVariable(value="animationId") Integer a) {
        return this.g.m_ya(a);
    }

    @PutMapping(value={"/{animationId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAnimation(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody Animation a) {
        this.g.m_xzb(animationId, a);
    }

    @GetMapping(value={"/{animationId}/elements/{elementId}"})
    public AnimationElement getAnimationElement(@PathVariable(value="animationId") Integer animationId, @PathVariable(value="elementId") Integer a) {
        return this.g.m_cfa(animationId, a);
    }

    @MessageMapping(value={"/run-animation-script"})
    public void runAnimationScript(@Payload RunAnimScriptDto runAnimScriptDto, @Header(value="simpSessionId") String sessionId, Principal a) {
        this.d.m_tqc(runAnimScriptDto, a.getName(), sessionId);
    }

    @PostMapping(value={"/{animationId}/elements"})
    public ResponseEntity<AnimationElement> createAnimationElement(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationElement animationElement, UriComponentsBuilder a) {
        animationElement = this.g.m_xac(animationId, animationElement);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationElement.getId();
        return ResponseEntity.created((URI)a.path(c_ca.m_ck((Object)"$\u0000j\u0015b\u0016j\u000fb\u0014e2o\u0006$\u001eg\u001ef\u001ee\u000fxTp\u001eg\u001ef\u001ee\u000fB\u001fv")).buildAndExpand(objectArray).toUri()).body((Object)animationElement);
    }

    @GetMapping(value={"/project"}, params={"projectName", "name"})
    public Animation getAnimationByProjectName(@RequestParam(name="projectName") String projectName, @RequestParam(name="name") String a) {
        return this.g.m_idc(projectName, a);
    }

    @PostMapping
    public ResponseEntity<Animation> createAnimation(@Valid @RequestBody Animation animation, UriComponentsBuilder a) {
        animation = this.g.m_avb(animation);
        Object[] objectArray = new Object[1];
        objectArray[0] = animation.getId();
        return ResponseEntity.created((URI)a.path(FileController.m_ck((Object)"-:c/k,c5k.l\bf<")).buildAndExpand(objectArray).toUri()).body((Object)animation);
    }

    @GetMapping(value={"/{animationId}/elements"}, params={"type"})
    public Collection<AnimationElement> getAnimationElementsByType(@PathVariable(value="animationId") Integer animationId, @RequestParam(name="type") c_ila a) {
        return this.g.m_ohc(animationId, a);
    }

    @PostMapping(value={"/{animationId}/scripts"})
    public ResponseEntity<AnimationScript> createAnimationScript(@PathVariable(value="animationId") Integer animationId, @Valid @RequestBody AnimationScript animationScript, UriComponentsBuilder a) {
        animationScript = this.g.m_pzb(animationId, animationScript);
        Object[] objectArray = new Object[2];
        objectArray[0] = animationId;
        objectArray[1] = animationScript.getId();
        return ResponseEntity.created((URI)a.path(c_ca.m_ck((Object)"$\u0000j\u0015b\u0016j\u000fb\u0014e2o\u0006$\bh\tb\u000b\u007f\b$\u0000x\u0018y\u0012{\u000fB\u001fv")).buildAndExpand(objectArray).toUri()).body((Object)animationScript);
    }

    @DeleteMapping(value={"/{animationId}/elements"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAnimationElementsByIds(@PathVariable(value="animationId") Integer animationId, @RequestParam(value="elementIds") Integer[] a) {
        this.g.m_hgc(animationId, a);
    }
}

