/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.animation.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.animation.enums.c_aca;
import com.inscada.mono.animation.enums.c_ila;
import com.inscada.mono.animation.model.Animation;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="animation_element")
@CheckAtLeastOneNotNull(fieldNames={"animationId", "animation"})
public class AnimationElement
extends SpaceBaseModel {
    @NotNull
    private c_ila type;
    @Size(max=255)
    private String dsc;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="animation_id", updatable=false)
    private Animation animation;
    @Size(max=255)
    private String name;
    @NotNull
    @Column(name="status_flag")
    private Boolean status;
    @Column(name="animation_id", insertable=false, updatable=false)
    private Integer animationId;
    @NotBlank
    private String expression;
    @NotBlank
    @Size(max=100)
    @Column(name="dom_id")
    private String domId;
    @NotBlank
    private String props;
    @Id
    @Column(name="anim_element_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="animationElementSeq")
    @GenericGenerator(name="animationElementSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="animation_element_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @NotNull
    @Column(name="expression_type")
    private c_aca expressionType;

    public String getProps() {
        AnimationElement a;
        return a.props;
    }

    public Integer getAnimationId() {
        AnimationElement a;
        return a.animationId;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setExpression(String a) {
        a.expression = a;
    }

    public void setDomId(String a) {
        a.domId = a;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setAnimation(Animation a) {
        AnimationElement a2;
        AnimationElement animationElement = a2;
        animationElement.animation = a;
        animationElement.animationId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setAnimationId(Integer a) {
        a.animationId = a;
    }

    public String getDomId() {
        AnimationElement a;
        return a.domId;
    }

    public int hashCode() {
        AnimationElement a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getAnimationId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public c_aca getExpressionType() {
        AnimationElement a;
        return a.expressionType;
    }

    public void setStatus(Boolean a) {
        a.status = a;
    }

    public AnimationElement(String a, String a2, c_ila a3, c_aca a4, String a5, String a6, String a7, Boolean a8) {
        AnimationElement a9;
        AnimationElement animationElement = a9;
        AnimationElement animationElement2 = a9;
        AnimationElement animationElement3 = a9;
        AnimationElement animationElement4 = a9;
        animationElement4.name = a;
        animationElement4.dsc = a2;
        animationElement3.type = a3;
        animationElement3.expressionType = a4;
        animationElement2.expression = a5;
        animationElement2.domId = a6;
        animationElement.props = a7;
        animationElement.status = a8;
    }

    public String getExpression() {
        AnimationElement a;
        return a.expression;
    }

    public void setExpressionType(c_aca a) {
        a.expressionType = a;
    }

    public void setProps(String a) {
        a.props = a;
    }

    public String getDsc() {
        AnimationElement a;
        return a.dsc;
    }

    public String getName() {
        AnimationElement a;
        return a.name;
    }

    public Animation getAnimation() {
        AnimationElement a;
        return a.animation;
    }

    public c_ila getType() {
        AnimationElement a;
        return a.type;
    }

    public void setType(c_ila a) {
        a.type = a;
    }

    public Integer getId() {
        AnimationElement a;
        return a.id;
    }

    public boolean equals(Object a) {
        AnimationElement a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof AnimationElement)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (AnimationElement)a;
        return a2.getAnimationId().equals(a.getAnimationId()) && a2.getName().equals(a.getName());
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Boolean getStatus() {
        AnimationElement a;
        return a.status;
    }

    public AnimationElement() {
        AnimationElement a;
    }
}

