/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.repositories.AlarmGroupRepository;
import com.inscada.mono.auth.security.c_yba;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.services.c_sg;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ac;
import com.inscada.mono.shared.exceptions.c_ck;
import com.inscada.mono.shared.exceptions.c_mi;
import com.inscada.mono.system.model.Stats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@EnableSpaceFilter
public class c_kfa {
    private final c_sg j;
    private static final String[] E;
    private final ApplicationEventPublisher L;
    private final c_ll d;
    private final AlarmGroupRepository g;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    @DisableSpaceFilter
    public Collection<AlarmGroup> m_te(Set<Integer> a) {
        c_kfa a2;
        if ((a = a2.g.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_xa(Integer a) {
        if (a != null) {
            c_kfa a2;
            a2.g.deleteByProjectId(a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_la(Integer a) {
        c_kfa a2;
        if ((a = a2.g.findByProjectId((Integer)a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Order(value=4)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_ke(ProjectDeleteEvent a) {
        c_kfa a2;
        a2.m_xa(a.getProject().getId());
    }

    private /* synthetic */ void m_sic(AlarmGroup a) {
        if (a.getOnScript() != null && !a.getOnScript().getProject().equals((Object)a.getProject())) {
            throw new c_mi(Stats.m_ck((Object)"\u007f _>SlY>Q9NlN>Q&[/Jl_\"ZlQ\"\u001e?]>W<JlN>Q&[/JlS9M8\u001e!_8]$"));
        }
        if (a.getOffScript() != null && !a.getOffScript().getProject().equals((Object)a.getProject())) {
            throw new c_mi(c_yba.m_ck((Object)"43\u0014-\u0018\u007f\u0012-\u001a*\u0005\u007f\u0005-\u001a5\u0010<\u0001\u007f\u00141\u0011\u007f\u001a9\u0013\u007f\u0006<\u00076\u0005+U/\u00070\u001f:\u0016+U2\u0000,\u0001\u007f\u0018>\u0001<\u001d"));
        }
        if (a.getAckScript() != null && !a.getAckScript().getProject().equals((Object)a.getProject())) {
            throw new c_mi(Stats.m_ck((Object)"\rR-L!\u001e+L#K<\u001e<L#T)]8\u001e-P(\u001e-]'\u001e?]>W<JlN>Q&[/JlS9M8\u001e!_8]$"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_ya(Integer a) {
        c_kfa a2;
        return a2.g.findById((Object)a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_dg(Integer a, String a2) {
        c_kfa a3;
        return a3.g.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_aa() {
        c_kfa a;
        return a.g.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public Collection<AlarmGroup> m_pqc(Set<Integer> a) {
        c_kfa a2;
        if ((a = a2.g.findAllById(a)) == null) {
            return Collections.emptyList();
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_qa(Integer a) {
        c_kfa a2;
        if ((a = a2.m_ya(a)) != null) {
            Set set = a.getAlarms();
            if (!set.isEmpty()) {
                throw new c_ac("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
            }
            c_kfa c_kfa2 = a2;
            c_kfa2.g.delete((Object)a);
            c_kfa2.L.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, (AlarmGroup)a));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM_GROUP')")
    public AlarmGroup m_rhc(AlarmGroup a) {
        c_kfa a2;
        c_kfa c_kfa2 = a2;
        c_kfa2.m_ilc(a);
        return (AlarmGroup)c_kfa2.g.save((Object)a);
    }

    private /* synthetic */ void m_mkc(AlarmGroup a, AlarmGroup a2, boolean a3) {
        c_kfa a4;
        AlarmGroup alarmGroup = a2;
        a4.m_yjc(a);
        BeanUtils.copyProperties((Object)a, (Object)alarmGroup, (String[])E);
        a4.m_sic(alarmGroup);
        if (a3) {
            a4.L.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a4, a2));
        }
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_kjc(AlarmGroup a, boolean a2) {
        AlarmGroup alarmGroup;
        c_kfa a3;
        AlarmGroup alarmGroup2 = a;
        a3.m_yjc(alarmGroup2);
        if ((alarmGroup2.getId() != null ? (alarmGroup = a3.m_ya(a.getId())) : (alarmGroup = a3.m_dg(a.getProjectId(), a.getName()))) != null) {
            a3.m_mkc(a, alarmGroup, a2);
            return;
        }
        c_kfa c_kfa2 = a3;
        c_kfa2.m_sic(a);
        c_kfa2.g.save((Object)a);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = c_yba.m_ck((Object)"6\u0011");
        stringArray[1] = Stats.m_ck((Object)"?N-])");
        stringArray[2] = c_yba.m_ck((Object)"\u0005-\u001a5\u0010<\u0001");
        stringArray[3] = Stats.m_ck((Object)"_ _>S?");
        stringArray[4] = c_yba.m_ck((Object)"\u0016-\u0010>\u0001:\u0011\u001d\f");
        stringArray[5] = Stats.m_ck((Object)"]>[-J%Q\"z-J)");
        stringArray[6] = c_yba.m_ck((Object)"3\u0014,\u0001\u0012\u001a;\u001c9\u001c:\u0011\u001d\f");
        stringArray[7] = Stats.m_ck((Object)"R-M8s#Z%X%[(z-J)");
        E = stringArray;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_wj(Integer a) {
        c_kfa a2;
        AlarmGroup alarmGroup = a2.m_ya(a);
        if (alarmGroup == null) {
            throw new c_ck("Alarm group not found with id of " + a);
        }
        return alarmGroup;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP') and hasAuthority('CREATE_ALARM_GROUP')")
    public void m_bu(List<AlarmGroup> a2, boolean a3) {
        c_kfa a4;
        a2.forEach(a -> {
            RepeatableScript repeatableScript;
            c_kfa a2;
            if (a.getProject() == null) {
                AlarmGroup alarmGroup = a;
                alarmGroup.setProject(a2.d.m_wj(alarmGroup.getProjectId()));
            }
            if (a.getOnScript() == null && a.getOnScriptId() != null) {
                repeatableScript = a2.j.m_wj(a.getOnScriptId());
                a.setOnScript(repeatableScript);
            }
            if (a.getOffScript() == null && a.getOffScriptId() != null) {
                repeatableScript = a2.j.m_wj(a.getOffScriptId());
                a.setOffScript(repeatableScript);
            }
            if (a.getAckScript() == null && a.getAckScriptId() != null) {
                repeatableScript = a2.j.m_wj(a.getAckScriptId());
                a.setAckScript(repeatableScript);
            }
        });
        Object object = a2.stream().map(AlarmGroup::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.g.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(AlarmGroup::getProjectId, Collectors.mapping(AlarmGroup::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_kfa a2;
            return a2.g.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(AlarmGroup::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<AlarmGroup> arrayList = new ArrayList<AlarmGroup>();
        HashSet<AlarmGroup> hashSet = new HashSet<AlarmGroup>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a2.next();
            if ((alarmGroup.getId() != null ? (AlarmGroup)map.get(alarmGroup.getId()) : (AlarmGroup)object.get(ImmutablePair.of((Object)alarmGroup.getProjectId(), (Object)alarmGroup.getName()))) != null) {
                AlarmGroup alarmGroup2;
                AlarmGroup alarmGroup3 = alarmGroup2;
                a4.m_mkc(alarmGroup, alarmGroup3, false);
                hashSet.add(alarmGroup3);
                arrayList.add(alarmGroup2);
                continue;
            }
            a4.m_sic(alarmGroup);
            arrayList.add(alarmGroup);
        }
        a4.g.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_kfa a2;
                a2.L.publishEvent((ApplicationEvent)new AlarmGroupChangeEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM_GROUP')")
    public AlarmGroup m_ho(Integer a, String a2) {
        c_kfa a3;
        if ((a = a3.m_dg(a, a2)) == null) {
            throw new c_ck("Alarm group not found with name of " + a2);
        }
        return a;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM_GROUP')")
    public void m_lnc(Integer a, AlarmGroup a2) {
        c_kfa a3;
        c_kfa c_kfa2 = a3;
        a = c_kfa2.m_wj(a);
        c_kfa2.m_mkc(a2, (AlarmGroup)a, true);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM_GROUP')")
    public void m_xjc(List<Integer> a2) {
        c_kfa a3;
        if (!(a2 = a3.g.findAllById(a2)).isEmpty()) {
            c_kfa c_kfa2 = a3;
            List list = a2;
            c_kfa2.g.deleteInBatch((Iterable)list);
            list.forEach(a -> {
                c_kfa a2;
                Set set = a.getAlarms();
                if (!set.isEmpty()) {
                    throw new c_ac("Alarm group deletion failed. Alarm exists: " + ((Alarm)set.iterator().next()).getName());
                }
                a2.L.publishEvent((ApplicationEvent)new AlarmGroupDeleteEvent((Object)a2, a));
            });
        }
    }

    public c_kfa(c_ll a, c_sg a2, AlarmGroupRepository a3, ApplicationEventPublisher a4) {
        c_kfa a5;
        c_kfa c_kfa2 = a5;
        c_kfa c_kfa3 = a5;
        c_kfa3.d = a;
        c_kfa3.j = a2;
        c_kfa2.g = a3;
        c_kfa2.L = a4;
    }

    public void m_ilc(AlarmGroup a) {
        c_kfa a2;
        c_kfa c_kfa2 = a2;
        c_kfa2.m_yjc(a);
        c_kfa2.m_sic(a);
    }
}

