/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.alarm.repositories.AlarmRepository;
import com.inscada.mono.alarm.services.c_kfa;
import com.inscada.mono.auth.restcontrollers.AuthController;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_uba;
import com.inscada.mono.project.events.ProjectDeleteEvent;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.exceptions.c_ck;
import com.inscada.mono.shared.exceptions.c_mi;
import com.inscada.mono.sms.k.c_fc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@EnableSpaceFilter
public abstract class c_eea<T extends Alarm> {
    protected final c_kfa M;
    protected final AlarmRepository<T> j;
    protected final c_ll E;
    protected final c_uba L;
    protected static final String[] d;
    protected final ApplicationEventPublisher g;

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<String> m_fkc(Integer a) {
        c_eea a2;
        return a2.j.findDistinctPartsByProjectId(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_ulc(T a, boolean a2) {
        Alarm alarm;
        c_eea a3;
        T t = a;
        a3.m_epc(t);
        if ((t.getId() != null ? (alarm = a3.m_ya(a.getId())) : (alarm = a3.m_dg(a.getProjectId(), a.getName()))) != null) {
            a3.m_dic(a, alarm, a2);
            return;
        }
        c_eea c_eea2 = a3;
        c_eea2.m_hnc(a);
        c_eea2.j.save(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_laa(Pageable a) {
        c_eea a2;
        return a2.j.findAll(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM') and hasAuthority('CREATE_ALARM')")
    public void m_bu(List<T> a2, boolean a3) {
        c_eea a4;
        a2.forEach(arg_0 -> a4.m_epc(arg_0));
        Object object = a2.stream().map(Alarm::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        object = new HashSet(a4.j.findAllById(object));
        a2.stream().collect(Collectors.groupingBy(Alarm::getProjectId, Collectors.mapping(Alarm::getName, Collectors.toSet()))).entrySet().stream().flatMap(a -> {
            c_eea a2;
            return a2.j.findByProjectIdAndNameIn((Integer)a.getKey(), (Set)a.getValue()).stream();
        }).forEach(arg_0 -> object.add(arg_0));
        Map map = object.stream().collect(Collectors.toMap(Alarm::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(a -> ImmutablePair.of((Object)a.getProjectId(), (Object)a.getName()), Function.identity()));
        ArrayList<Alarm> arrayList = new ArrayList<Alarm>();
        HashSet<Alarm> hashSet = new HashSet<Alarm>();
        a2 = a2.iterator();
        while (a2.hasNext()) {
            Alarm alarm = (Alarm)a2.next();
            if ((alarm.getId() != null ? (Alarm)map.get(alarm.getId()) : (Alarm)object.get(ImmutablePair.of((Object)alarm.getProjectId(), (Object)alarm.getName()))) != null) {
                Alarm alarm2;
                Alarm alarm3 = alarm2;
                a4.m_dic(alarm, alarm3, false);
                hashSet.add(alarm3);
                arrayList.add(alarm2);
                continue;
            }
            a4.m_hnc(alarm);
            arrayList.add(alarm);
        }
        a4.j.bulkSave(arrayList);
        if (a3) {
            hashSet.forEach(a -> {
                c_eea a2;
                a2.g.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a2, a));
            });
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_dg(Integer a, String a2) {
        c_eea a3;
        return (T)a3.j.findOneByProjectIdAndName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_wkc(Integer a, String[] a2) {
        c_eea a3;
        return a3.j.findByProjectIdAndNameIn(a, Arrays.stream(a2).collect(Collectors.toSet()));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_ho(Integer a, String a2) {
        c_eea a3;
        Alarm alarm = a3.m_dg(a, a2);
        if (alarm == null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a;
            objectArray[1] = a2;
            throw new c_ck(String.format(AuthController.m_ck((Object)"c|CbO0L\u007fV0D\u007fW~F*\u0002`P\u007fHuAd\u0002yF*\u00025F<\u0002~C}G*\u00025Q"), objectArray));
        }
        return (T)alarm;
    }

    protected c_eea(c_ll a, c_kfa a2, AlarmRepository<T> a3, c_uba a4, ApplicationEventPublisher a5) {
        c_eea a6;
        c_eea c_eea2 = a6;
        c_eea c_eea3 = a6;
        a6.E = a;
        c_eea3.M = a2;
        c_eea3.j = a3;
        c_eea2.L = a4;
        c_eea2.g = a5;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_ALARM')")
    public T m_jgc(T a) {
        c_eea a2;
        c_eea c_eea2 = a2;
        c_eea2.m_nhc(a);
        a = (Alarm)c_eea2.j.save(a);
        a2.g.publishEvent((ApplicationEvent)new AlarmAddEvent((Object)a2, a));
        return a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_klc(AlarmFilter a, Pageable a2) {
        c_eea a3;
        return a3.j.findAlarmsByFilter(a, a2);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_qa(Integer a) {
        c_eea a2;
        if ((a = a2.m_ya(a)) != null) {
            c_eea c_eea2 = a2;
            c_eea2.j.delete((Object)a);
            c_eea2.g.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, (Alarm)a));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_kgc(Integer a, String a2) {
        c_eea a3;
        return a3.j.findByGroupName(a, a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_xlc(Collection<Integer> a) {
        c_eea a2;
        return a2.j.findAllById(a);
    }

    private /* synthetic */ void m_dic(T a, T a2, boolean a3) {
        c_eea a4;
        if (!a.getClass().equals(a2.getClass())) {
            throw new c_mi(c_fc.m_ck((Object)"W\u0011w\u000f{]b\u0004f\u0018e]e\u0015y\bz\u00196\u001fs]e\u001c{\u0018"));
        }
        T t = a2;
        a4.m_epc(a);
        BeanUtils.copyProperties(a, t, (String[])d);
        a4.m_hnc(t);
        if (a3) {
            a4.g.publishEvent((ApplicationEvent)new AlarmChangeEvent((Object)a4, a2));
        }
    }

    @Order(value=3)
    @EventListener(value={ProjectDeleteEvent.class})
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_ke(ProjectDeleteEvent a) {
        c_eea a2;
        a2.m_xa(a.getProject().getId());
    }

    public void m_nhc(T a) {
        c_eea a2;
        c_eea c_eea2 = a2;
        c_eea2.m_epc(a);
        c_eea2.m_hnc(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Page<T> m_ypa(Integer a, Pageable a2) {
        c_eea a3;
        return a3.j.findByProjectId(a, a2);
    }

    protected void m_hnc(T a) {
        AnalogAlarm analogAlarm;
        if (!a.getGroup().getProject().equals((Object)a.getProject())) {
            throw new c_mi(AuthController.m_ck((Object)"QNqP}\u0002wP\u007fW`\u0002`P\u007fHuAd\u0002qLt\u0002qNqP}\u0002`P\u007fHuAd\u0002}WcV0OqVsJ"));
        }
        if (a.getOnTimeVariable() != null && !a.getOnTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mi(c_fc.m_ck((Object)"<z\u001cd\u00106\rd\u0012|\u0018u\t6\u001cx\u00196\u000bw\u000f\u007f\u001ct\u0011s]f\u000fy\u0017s\u001eb]{\be\t6\u0010w\tu\u0015"));
        }
        if (a.getOffTimeVariable() != null && !a.getOffTimeVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mi(AuthController.m_ck((Object)"c|CbO0RbMzGsV0C~F0TqPyCrNu\u0002`P\u007fHuAd\u0002}WcV0OqVsJ"));
        }
        if (a instanceof DigitalAlarm) {
            DigitalAlarm digitalAlarm = (DigitalAlarm)a;
            if (!digitalAlarm.getVariableA().getProject().equals((Object)a.getProject())) {
                throw new c_mi(c_fc.m_ck((Object)"<z\u001cd\u00106\rd\u0012|\u0018u\t6\u001cx\u00196\u000bw\u000f\u007f\u001ct\u0011s]f\u000fy\u0017s\u001eb]{\be\t6\u0010w\tu\u0015"));
            }
            if (digitalAlarm.getVariableB() != null && !digitalAlarm.getVariableB().getProject().equals((Object)a.getProject())) {
                throw new c_mi(AuthController.m_ck((Object)"c|CbO0RbMzGsV0C~F0TqPyCrNu\u0002`P\u007fHuAd\u0002}WcV0OqVsJ"));
            }
        } else if (a instanceof AnalogAlarm && !(analogAlarm = (AnalogAlarm)a).getVariable().getProject().equals((Object)a.getProject())) {
            throw new c_mi(c_fc.m_ck((Object)"<z\u001cd\u00106\rd\u0012|\u0018u\t6\u001cx\u00196\u000bw\u000f\u007f\u001ct\u0011s]f\u000fy\u0017s\u001eb]{\be\t6\u0010w\tu\u0015"));
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_aa() {
        c_eea a;
        return a.j.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_ya(Integer a) {
        c_eea a2;
        return (T)((Alarm)a2.j.findById((Object)a).orElse(null));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_xa(Integer a) {
        if (a != null) {
            c_eea a2;
            a2.j.deleteByProjectId(a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_la(Integer a) {
        c_eea a2;
        return a2.j.findByProjectId(a);
    }

    protected void m_epc(T a) {
        Variable variable;
        c_eea a2;
        if (a.getProject() == null) {
            T t = a;
            t.setProject(a2.E.m_wj(t.getProjectId()));
        }
        if (a.getGroup() == null) {
            T t = a;
            t.setGroup(a2.M.m_wj(t.getGroupId()));
        }
        if (a.getOnTimeVariable() == null && a.getOnTimeVariableId() != null) {
            variable = a2.L.m_wj(a.getOnTimeVariableId());
            a.setOnTimeVariable(variable);
        }
        if (a.getOffTimeVariable() == null && a.getOffTimeVariableId() != null) {
            variable = a2.L.m_wj(a.getOffTimeVariableId());
            a.setOffTimeVariable(variable);
        }
        if (a instanceof DigitalAlarm) {
            Variable variable2;
            variable = (DigitalAlarm)a;
            if (variable.getVariableA() == null) {
                variable2 = a2.L.m_wj(variable.getVariableAId());
                variable.setVariableA(variable2);
            }
            if (variable.getVariableB() == null && variable.getVariableBId() != null) {
                variable2 = a2.L.m_wj(variable.getVariableBId());
                variable.setVariableB(variable2);
                return;
            }
        } else if (a instanceof AnalogAlarm && (variable = (AnalogAlarm)a).getVariable() == null) {
            Variable variable3 = a2.L.m_wj(variable.getVariableId());
            variable.setVariable(variable3);
        }
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = AuthController.m_ck((Object)"yF");
        stringArray[1] = c_fc.m_ck((Object)"\u000ef\u001cu\u0018");
        stringArray[2] = AuthController.m_ck((Object)"RbMzGsV");
        stringArray[3] = c_fc.m_ck((Object)"\u001ad\u0012c\r");
        stringArray[4] = AuthController.m_ck((Object)"AbGqVuFR[");
        stringArray[5] = c_fc.m_ck((Object)"u\u000fs\u001cb\u0014y\u0013R\u001cb\u0018");
        stringArray[6] = AuthController.m_ck((Object)"|CcV]MtKvKuFR[");
        stringArray[7] = c_fc.m_ck((Object)"z\u001ce\t[\u0012r\u0014p\u0014s\u0019R\u001cb\u0018");
        d = stringArray;
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_ALARM')")
    public void m_oic(List<Integer> a2) {
        c_eea a3;
        c_eea c_eea2 = a3;
        a2 = c_eea2.m_xlc(a2);
        c_eea2.j.deleteInBatch(a2);
        a2.forEach(a -> {
            c_eea a2;
            a2.g.publishEvent((ApplicationEvent)new AlarmDeleteEvent((Object)a2, a));
        });
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_ALARM')")
    public void m_zfc(Integer a, T a2) {
        c_eea a3;
        c_eea c_eea2 = a3;
        a = c_eea2.m_wj(a);
        c_eea2.m_dic(a2, (Alarm)a, true);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Collection<T> m_uoc(Integer a) {
        c_eea a2;
        return a2.j.findByGroupIdAndIsActiveTrue(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public T m_wj(Integer a) {
        c_eea a2;
        Alarm alarm = a2.m_ya(a);
        if (alarm == null) {
            throw new c_ck("Alarm not found with id of " + a);
        }
        return (T)alarm;
    }
}

