/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.events.AlarmAddEvent;
import com.inscada.mono.alarm.events.AlarmChangeEvent;
import com.inscada.mono.alarm.events.AlarmDeleteEvent;
import com.inscada.mono.alarm.events.AlarmGroupChangeEvent;
import com.inscada.mono.alarm.events.AlarmGroupDeleteEvent;
import com.inscada.mono.alarm.k.c_iba;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.c_fga;
import com.inscada.mono.alarm.services.c_kfa;
import com.inscada.mono.alarm.services.c_sfa;
import com.inscada.mono.alarm.services.c_zka;
import com.inscada.mono.auth.c_kka;
import com.inscada.mono.cluster.k.c_vha;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_j;
import com.inscada.mono.communication.base.restcontrollers.ConnectionController;
import com.inscada.mono.log.services.c_ng;
import com.inscada.mono.project.events.ProjectDeactivateEvent;
import com.inscada.mono.shared.exceptions.c_ch;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.model.Space;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener {
    private final c_ng I;
    public static final short H = 105;
    private final c_kfa A;
    private final c_zka i;
    private final JedisPooled G;
    public static final short J = 101;
    public static final short e = 108;
    public static final short a = 107;
    public static final short k = 103;
    private static final Logger b = LoggerFactory.getLogger(AlarmManager.class);
    private final c_j l;
    private final Lock m;
    public static final short M = 104;
    public static final short j = 106;
    public static final short E = 102;
    private static final String L = "activeAlarmGroups";
    public static final short d = 109;
    private final c_sfa g;

    public void notLeader() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        String string = alarmManager.l.m_gb().getNodeId();
        b.info(ConnectionController.m_ck((Object)"h\u0011H\u000fD0H\u0013H\u001aL\u000f\u0013]}\u0015@\u000e\t\u0013F\u0019L]\u0001\u0006TT\t\u0014Z]g2\t1f3n8{]}5l]e8h9l/\u0007]z\tF\rY\u0014G\u001a\t\u001cE\u0011\t\u0011F\u001eH\u0011\t\u001cE\u001c[\u0010\t\u0014G\u000eY\u0018J\tF\u000fZS\u0007S"), (Object)string);
        alarmManager.m.lock();
        try {
            a.i.m_upc();
            b.info(ExceptionDetails.m_ck((Object)";<\u001b\"\u0017\u001d\u001b>\u001b7\u001f\"Zx4?\u000ep65\u001b4\u001f\"Z+\u0007y@p;<\u0016p\u0016?\u00191\u0016p\u001b<\u001b\"\u0017p\u0013>\t \u001f3\u000e9\u0015>Z$\u001b#\u0011#Z8\u001b&\u001fp\u00185\u001f>Z\"\u001f!\u000f5\t$\u001f4Z$\u0015p\t$\u0015 T"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            b.error(ConnectionController.m_ck((Object)"<E\u001c[\u0010d\u001cG\u001cN\u0018[]\u00013F\t\t1L\u001cM\u0018[]R\u0000\u0000G\t8[\u000fF\u000f\t\u0019\\\u000f@\u0013N]Y\u000fF\u001eL\u000eZ]F\u001b\t\u000e]\u0012Y\r@\u0013N]E\u0012J\u001cE]H\u0011H\u000fD]@\u0013Z\rL\u001e]\u0012[\u000e\u0013]R\u0000"), objectArray);
            return;
        }
        finally {
            a.m.unlock();
        }
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_kka.m_kvb(() -> {
            AlarmManager a2;
            a2.m.lock();
            try {
                c_fga c_fga2 = a2.i.m_slc(a.getId());
                if (c_fga2 != null) {
                    c_fga2.m_udb();
                    a2.i.m_llc(a.getId(), c_fga2);
                }
                String[] stringArray = new String[1];
                stringArray[0] = a.getId().toString();
                a2.G.srem(L, stringArray);
                return;
            }
            finally {
                a2.m.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    @Order(value=2)
    @EventListener(value={ProjectDeactivateEvent.class})
    public void handleProjectDeactivateEvent(ProjectDeactivateEvent a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.info(ExceptionDetails.m_ck((Object)"\u001c?\u0011>\u0015(jZ\u0018\u001b>\u001e<\u0013>\u001dp*\"\u0015:\u001f3\u000e\u0014\u001f1\u0019$\u0013&\u001b$\u001f\u0015\f5\u0014$Z6\u0015\"Z \b?\u00105\u0019$Z\u0019>jZ+\u0007"), (Object)a.getProject().getId());
            a2.deactivateAlarmGroupsByProjectIdInternal(a.getProject().getId());
            return;
        }
        b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]`\u001aG\u0012[\u0014G\u001a\t-[\u0012C\u0018J\tm\u0018H\u001e]\u0014_\u001c]\u0018l\u000bL\u0013]]O\u0012[]Y\u000fF\u0017L\u001e]]`9\u0013]R\u0000"), (Object)a.getProject().getId());
    }

    protected void activateAlarmGroupInternal(AlarmGroup a) {
        AlarmManager a2;
        c_kka.m_kvb(() -> {
            AlarmManager a2;
            a2.m.lock();
            try {
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new c_ch("Project should be active to start alarm group " + a.getName());
                }
                c_fga c_fga2 = a2.i.m_sqc(a);
                c_fga2.m_bb();
                if (c_fga2.m_ngc()) {
                    String[] stringArray = new String[1];
                    stringArray[0] = a.getId().toString();
                    a2.G.sadd(L, stringArray);
                }
                return;
            }
            finally {
                a2.m.unlock();
            }
        }, (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String a, AlarmGroup a2) {
        AlarmManager a3;
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = a;
            objectArray[1] = a2.getName();
            objectArray[2] = a2.getId();
            b.info(ExceptionDetails.m_ck((Object)"\u0011\u00161\b=71\u00141\u001d5\bpR\u001c\u001f1\u001e5\bp\u0001-SjZ\u0002\u001f#\u000e?\b9\u00147Z1\u00161\b=Z7\b?\u000f @p\u0001-Zx3\u0014@p\u0001-S"), objectArray);
            a3.activateAlarmGroupInternal(a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = a2.getName();
            objectArray[1] = a2.getId();
            objectArray[2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.I.m_lga(a2.getProject()).m_c("Alarm Group Restore (Leader " + a + ")", String.format(ConnectionController.m_ck((Object)"\f\u000e\tU`9\u0013]\f\u0019\u0000]O\u001c@\u0011L\u0019\t\tF][\u0018Z\tF\u000fLS\t>H\bZ\u0018\u0013]\f\u000e"), objectArray));
            try {
                b.warn(ExceptionDetails.m_ck((Object)"\u0011\u00161\b=71\u00141\u001d5\bpR\u001c\u001f1\u001e5\bp\u0001-SjZ\u0011\u000e$\u001f=\n$\u0013>\u001dp\u000e?Z4\u001f1\u0019$\u0013&\u001b$\u001fp\u001b<\u001b\"\u0017p\u001d\"\u0015%\np\u0001-Z1\u001c$\u001f\"Z\"\u001f#\u000e?\b1\u000e9\u0015>Z6\u001b9\u0016%\b5T"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal(a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = a;
                objectArray2[1] = a2.getId();
                objectArray2[2] = exception2.getMessage();
                objectArray2[3] = exception2;
                b.error(ConnectionController.m_ck((Object)"<E\u001c[\u0010d\u001cG\u001cN\u0018[]\u00011L\u001cM\u0018[]R\u0000\u0000G\t;H\u0014E\u0018M]]\u0012\t\u0019L\u001cJ\t@\u000bH\tL]H\u0011H\u000fD]N\u000fF\bY]R\u0000\t\u001cO\tL\u000f\t\u000fL\u000e]\u0012[\u001c]\u0014F\u0013\t\u001bH\u0014E\b[\u0018\u0013]R\u0000"), objectArray2);
                return;
            }
        }
    }

    protected c_iba getAlarmStatusInternal(Alarm a) {
        AlarmManager a2;
        if (a == null) {
            return c_iba.L;
        }
        c_fga c_fga2 = a2.i.m_slc(a.getGroup().getId());
        if (c_fga2 != null && c_fga2.m_ngc() && c_fga2.m_tnc(a.getId())) {
            return c_iba.d;
        }
        return c_iba.L;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_iba> getAlarmStatuses(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"\u001c?\u0011>\u0015(jZ\u0017\u001f$\u000e9\u00147Z1\u0016<Z1\u00161\b=Z#\u000e1\u000e%\t5\tp\u001c?\bp\n\"\u0015:\u001f3\u000ep\u0001-Z<\u00153\u001b<\u0016)T"), (Object)a);
            return a2.getAlarmStatusesByProjectIdInternal(a);
        }
        b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]{\u0018X\bL\u000e]\u0014G\u001a\t\u0011L\u001cM\u0018[]O\u0012[]H\u0011E]H\u0011H\u000fD]Z\tH\t\\\u000eL\u000e\t\u001bF\u000f\t\r[\u0012C\u0018J\t\t\u0006TS"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.l.m_sb(Short.valueOf((short)105), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get alarm statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_iba getAlarmStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.g.m_dg(a, a2)) == null) {
            return c_iba.L;
        }
        return a3.getAlarmStatus(a.getId());
    }

    protected Map<Integer, c_iba> getAlarmGroupStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.A.m_la((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroup::getId, arg_0 -> a2.getAlarmGroupStatusInternal(arg_0)));
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.A.m_la((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    protected void deactivateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.A.m_wj(a));
    }

    public AlarmManager(c_sfa a, c_kfa a2, c_zka a3, c_ng a4, JedisPooled a5, c_j a6) {
        AlarmManager a7;
        AlarmManager alarmManager = a7;
        AlarmManager alarmManager2 = a7;
        AlarmManager alarmManager3 = a7;
        AlarmManager alarmManager4 = a7;
        alarmManager4.m = new ReentrantLock();
        alarmManager3.g = a;
        alarmManager3.A = a2;
        alarmManager2.i = a3;
        alarmManager2.I = a4;
        alarmManager.G = a5;
        alarmManager.l = a6;
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"6\u0015;\u0014?\u0002@p>5\u001b3\u000e9\f1\u000e9\u00147Z1\u0016<Z1\u00161\b=Z7\b?\u000f \tp\u001c?\bp\n\"\u0015:\u001f3\u000ep\u0001-Z<\u00153\u001b<\u0016)T"), (Object)a);
            a2.deactivateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]{\u0018X\bL\u000e]\u0014G\u001a\t\u0011L\u001cM\u0018[]]\u0012\t\u0019L\u001cJ\t@\u000bH\tL]H\u0011E]H\u0011H\u000fD]N\u000fF\bY\u000e\t\u001bF\u000f\t\r[\u0012C\u0018J\t\t\u0006TS"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.l.m_sb(Short.valueOf((short)109), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC deactivate alarm groups for project " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmAddEvent.class})
    public void handleAlarmAddEvent(AlarmAddEvent a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            c_fga c_fga2;
            Alarm alarm = a.getAlarm();
            b.info(ExceptionDetails.m_ck((Object)"6\u0015;\u0014?\u0002@p21\u00144\u00169\u00147Z\u0011\u00161\b=;4\u001e\u0015\f5\u0014$Z6\u0015\"Z1\u00161\b=Z\u0019>jZ+\u0007|Z\u0017\b?\u000f Z\u0019>jZ+\u0007"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            if (Boolean.TRUE.equals(alarm.getIsActive()) && (c_fga2 = a2.i.m_slc(alarm.getGroupId())) != null && c_fga2.m_ngc()) {
                c_fga2.m_lqc(alarm);
                return;
            }
        } else {
            b.debug(ConnectionController.m_ck((Object)"3f3\u00041l<m8{G\t4N\u0013F\u000f@\u0013N]h\u0011H\u000fD<M\u0019l\u000bL\u0013]]O\u0012[]H\u0011H\u000fD]`9\u0013]R\u0000"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"\u001c?\u0011>\u0015(jZ\u0011\u0019$\u0013&\u001b$\u0013>\u001dp\u001b<\u001b\"\u0017p\u001d\"\u0015%\np\u0001-Z<\u00153\u001b<\u0016)T"), (Object)a);
            a2.activateAlarmGroupInternal(a);
            return;
        }
        b.debug(ConnectionController.m_ck((Object)"3f3\u00041l<m8{G\t/L\f\\\u0018Z\t@\u0013N]E\u0018H\u0019L\u000f\t\tF]H\u001e]\u0014_\u001c]\u0018\t\u001cE\u001c[\u0010\t\u001a[\u0012\\\r\t\u0006TS"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.l.m_sb(Short.valueOf((short)101), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC activate alarm group " + a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={AlarmDeleteEvent.class})
    public void handleAlarmDeleteEvent(AlarmDeleteEvent a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            Alarm alarm = a.getAlarm();
            b.info(ExceptionDetails.m_ck((Object)"\u001c?\u0011>\u0015(jZ\u0018\u001b>\u001e<\u0013>\u001dp;<\u001b\"\u0017\u0014\u001f<\u001f$\u001f\u0015\f5\u0014$Z6\u0015\"Z1\u00161\b=Z\u0019>jZ+\u0007|Z\u0017\b?\u000f Z\u0019>jZ+\u0007"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_fga c_fga2 = a2.i.m_slc(alarm.getGroupId());
            if (c_fga2 != null && c_fga2.m_ngc()) {
                c_fga2.m_dgc(alarm);
                return;
            }
        } else {
            b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]`\u001aG\u0012[\u0014G\u001a\t<E\u001c[\u0010m\u0018E\u0018]\u0018l\u000bL\u0013]]O\u0012[]H\u0011H\u000fD]`9\u0013]R\u0000"), (Object)a.getAlarm().getId());
        }
    }

    protected Map<Integer, c_iba> getAlarmStatusesInternal(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={AlarmGroupChangeEvent.class})
    public void handleAlarmGroupChangeEvent(AlarmGroupChangeEvent a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.info(ExceptionDetails.m_ck((Object)"6\u0015;\u0014?\u0002@p21\u00144\u00169\u00147Z\u0011\u00161\b==\"\u0015%\n\u0013\u00121\u00147\u001f\u0015\f5\u0014$Z6\u0015\"Z7\b?\u000f Z\u0019>jZ+\u0007"), (Object)a.getAlarmGroup().getId());
            a2.m.lock();
            try {
                Integer n = a.getAlarmGroup().getId();
                if (a2.getAlarmGroupStatusInternal(n) == c_iba.d) {
                    AlarmManager alarmManager = a2;
                    alarmManager.deactivateAlarmGroupInternal(n);
                    alarmManager.activateAlarmGroupInternal(n);
                }
                return;
            }
            finally {
                a2.m.unlock();
            }
        }
        b.debug(ConnectionController.m_ck((Object)"3f3\u00041l<m8{G\t4N\u0013F\u000f@\u0013N]h\u0011H\u000fD:[\u0012\\\rj\u0015H\u0013N\u0018l\u000bL\u0013]]O\u0012[]N\u000fF\bY]`9\u0013]R\u0000"), (Object)a.getAlarmGroup().getId());
    }

    protected void activateAlarmGroupsByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.A.m_la((Integer)((Object)a))) == null || a.isEmpty()) {
            return;
        }
        Iterator iterator = a = a.iterator();
        while (iterator.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            iterator = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @TransactionalEventListener(value={AlarmGroupDeleteEvent.class})
    public void handleAlarmGroupDeleteEvent(AlarmGroupDeleteEvent a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.info(ExceptionDetails.m_ck((Object)"6\u0015;\u0014?\u0002@p21\u00144\u00169\u00147Z\u0011\u00161\b==\"\u0015%\n\u0014\u001f<\u001f$\u001f\u0015\f5\u0014$Z6\u0015\"Z7\b?\u000f Z\u0019>jZ+\u0007"), (Object)a.getAlarmGroup().getId());
            a2.deactivateAlarmGroupInternal(a.getAlarmGroup().getId());
            return;
        }
        b.debug(ConnectionController.m_ck((Object)"3f3\u00041l<m8{G\t4N\u0013F\u000f@\u0013N]h\u0011H\u000fD:[\u0012\\\rm\u0018E\u0018]\u0018l\u000bL\u0013]]O\u0012[]N\u000fF\bY]`9\u0013]R\u0000"), (Object)a.getAlarmGroup().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_iba> getAlarmGroupStatuses(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"\u001c?\u0011>\u0015(jZ\u0017\u001f$\u000e9\u00147Z1\u0016<Z1\u00161\b=Z7\b?\u000f Z#\u000e1\u000e%\t5\tp\u001c?\bp\n\"\u0015:\u001f3\u000ep\u0001-Z<\u00153\u001b<\u0016)T"), (Object)a);
            return a2.getAlarmGroupStatusesByProjectIdInternal(a);
        }
        b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]{\u0018X\bL\u000e]\u0014G\u001a\t\u0011L\u001cM\u0018[]O\u0012[]H\u0011E]H\u0011H\u000fD]N\u000fF\bY]Z\tH\t\\\u000eL\u000e\t\u001bF\u000f\t\r[\u0012C\u0018J\t\t\u0006TS"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (Map)a2.l.m_sb(Short.valueOf((short)106), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get alarm group statuses for project " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_iba getAlarmGroupStatus(Integer a, String a2) {
        AlarmManager a3;
        if ((a = a3.A.m_dg(a, a2)) == null) {
            return c_iba.L;
        }
        return a3.getAlarmGroupStatus(a.getId());
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"6\u0015;\u0014?\u0002@p;3\u000e9\f1\u000e9\u00147Z1\u0016<Z1\u00161\b=Z7\b?\u000f \tp\u001c?\bp\n\"\u0015:\u001f3\u000ep\u0001-Z<\u00153\u001b<\u0016)T"), (Object)a);
            a2.activateAlarmGroupsByProjectIdInternal(a);
            return;
        }
        b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]{\u0018X\bL\u000e]\u0014G\u001a\t\u0011L\u001cM\u0018[]]\u0012\t\u001cJ\t@\u000bH\tL]H\u0011E]H\u0011H\u000fD]N\u000fF\bY\u000e\t\u001bF\u000f\t\r[\u0012C\u0018J\t\t\u0006TS"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.l.m_sb(Short.valueOf((short)108), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC activate alarm groups for project " + a, (Throwable)exception);
        }
    }

    protected c_iba getAlarmStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmStatusInternal(alarmManager.g.m_ya(a));
    }

    protected c_iba getAlarmGroupStatusInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        return alarmManager.getAlarmGroupStatusInternal(alarmManager.A.m_ya(a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<Integer, c_iba> getAlarmStatuses(List<Integer> a) {
        AlarmManager a2;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"6\u0015;\u0014?\u0002@p=5\u000e$\u0013>\u001dp\u001b<\u001b\"\u0017p\t$\u001b$\u000f#\u001f#Z6\u0015\"Z+\u0007p3\u0014\tp\u0016?\u00191\u0016<\u0003jZ+\u0007"), (Object)a.size(), a);
            return a2.getAlarmStatusesInternal(a);
        }
        b.debug(ConnectionController.m_ck((Object)"3f3\u00041l<m8{G\t/L\f\\\u0018Z\t@\u0013N]E\u0018H\u0019L\u000f\t\u001bF\u000f\t\u001cE\u001c[\u0010\t\u000e]\u001c]\bZ\u0018Z]O\u0012[]R\u0000\t4m\u000e\u0013]R\u0000"), (Object)a.size(), a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new ArrayList<Integer>(a);
            return (Map)a2.l.m_sb(Short.valueOf((short)107), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get alarm statuses for IDs " + a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_iba getAlarmStatus(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ExceptionDetails.m_ck((Object)"\u001c?\u0011>\u0015(jZ\u0017\u001f$\u000e9\u00147Z1\u00161\b=Z#\u000e1\u000e%\tp\u001c?\bp\u0001-Z<\u00153\u001b<\u0016)T"), (Object)a);
            return a2.getAlarmStatusInternal(a);
        }
        b.debug(ConnectionController.m_ck((Object)"g2gPe8h9l/\u0013]{\u0018X\bL\u000e]\u0014G\u001a\t\u0011L\u001cM\u0018[]O\u0012[]H\u0011H\u000fD]Z\tH\t\\\u000e\t\u001bF\u000f\t\u0006TS"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_iba)a2.l.m_sb(Short.valueOf((short)103), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get alarm status for " + a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.l.m_sa((ClusterNodeListener)a);
        b.info(ExceptionDetails.m_ck((Object)";<\u001b\"\u0017\u001d\u001b>\u001b7\u001f\"Z9\u00149\u000e9\u001b<\u0013*\u001f4Z1\u00144Z\"\u001f7\u0013#\u000e5\b5\u001ep\u001b#Z\u0013\u0016%\t$\u001f\"4?\u001e569\t$\u001f>\u001f\"T"));
    }

    @TransactionalEventListener(value={AlarmChangeEvent.class})
    public void handleAlarmChangeEvent(AlarmChangeEvent a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            Alarm alarm = a.getAlarm();
            b.info(ConnectionController.m_ck((Object)"e8h9l/\u0013]a\u001cG\u0019E\u0014G\u001a\t<E\u001c[\u0010j\u0015H\u0013N\u0018l\u000bL\u0013]]O\u0012[]H\u0011H\u000fD]`9\u0013]R\u0000\u0005]n\u000fF\bY]`9\u0013]R\u0000"), (Object)alarm.getId(), (Object)alarm.getGroupId());
            c_fga c_fga2 = a2.i.m_slc(alarm.getGroupId());
            if (c_fga2 != null && c_fga2.m_ngc()) {
                if (Boolean.TRUE.equals(alarm.getIsActive())) {
                    c_fga2.m_lqc(alarm);
                    return;
                }
                c_fga2.m_dgc(alarm);
                return;
            }
        } else {
            b.debug(ExceptionDetails.m_ck((Object)"\u001e5\u001eW\u001c?\u0011>\u0015(jZ\u0019\u001d>\u0015\"\u0013>\u001dp;<\u001b\"\u0017\u0013\u00121\u00147\u001f\u0015\f5\u0014$Z6\u0015\"Z1\u00161\b=Z\u0019>jZ+\u0007"), (Object)a.getAlarm().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ConnectionController.m_ck((Object)"e8h9l/\u0013]m\u0018H\u001e]\u0014_\u001c]\u0014G\u001a\t\u001cE\u001c[\u0010\t\u001a[\u0012\\\r\t\u0006T]E\u0012J\u001cE\u0011PS"), (Object)a);
            a2.deactivateAlarmGroupInternal(a);
            return;
        }
        b.debug(ExceptionDetails.m_ck((Object)"4\u001f4}6\u0015;\u0014?\u0002@p(5\u000b%\u001f#\u000e9\u00147Z<\u001f1\u001e5\bp\u000e?Z4\u001f1\u0019$\u0013&\u001b$\u001fp\u001b<\u001b\"\u0017p\u001d\"\u0015%\np\u0001-T"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            a2.l.m_sb(Short.valueOf((short)102), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC deactivate alarm group " + a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        try {
            AlarmManager a;
            Class[] classArray = new Class[1];
            classArray[0] = Integer.class;
            a.l.m_yb((short)101, (Object)a, AlarmManager.class.getDeclaredMethod(ConnectionController.m_ck((Object)"H\u001e]\u0014_\u001c]\u0018h\u0011H\u000fD:[\u0012\\\r`\u0013]\u0018[\u0013H\u0011"), classArray));
            Class[] classArray2 = new Class[1];
            classArray2[0] = Integer.class;
            a.l.m_yb((short)102, (Object)a, AlarmManager.class.getDeclaredMethod(ExceptionDetails.m_ck((Object)"4\u001f1\u0019$\u0013&\u001b$\u001f\u0011\u00161\b==\"\u0015%\n\u0019\u0014$\u001f\"\u00141\u0016"), classArray2));
            Class[] classArray3 = new Class[1];
            classArray3[0] = Integer.class;
            a.l.m_yb((short)103, (Object)a, AlarmManager.class.getDeclaredMethod(ConnectionController.m_ck((Object)"N\u0018]<E\u001c[\u0010z\tH\t\\\u000e`\u0013]\u0018[\u0013H\u0011"), classArray3));
            Class[] classArray4 = new Class[1];
            classArray4[0] = Integer.class;
            a.l.m_yb((short)104, (Object)a, AlarmManager.class.getDeclaredMethod(ExceptionDetails.m_ck((Object)"\u001d5\u000e\u0011\u00161\b==\"\u0015%\n\u0003\u000e1\u000e%\t\u0019\u0014$\u001f\"\u00141\u0016"), classArray4));
            Class[] classArray5 = new Class[1];
            classArray5[0] = Integer.class;
            a.l.m_yb((short)105, (Object)a, AlarmManager.class.getDeclaredMethod(ConnectionController.m_ck((Object)"\u001aL\th\u0011H\u000fD.]\u001c]\bZ\u0018Z?P-[\u0012C\u0018J\t`\u0019`\u0013]\u0018[\u0013H\u0011"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = Integer.class;
            a.l.m_yb((short)106, (Object)a, AlarmManager.class.getDeclaredMethod(ExceptionDetails.m_ck((Object)"7\u001f$;<\u001b\"\u0017\u0017\b?\u000f )$\u001b$\u000f#\u001f#8)*\"\u0015:\u001f3\u000e\u0019\u001e\u0019\u0014$\u001f\"\u00141\u0016"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            a.l.m_yb((short)107, (Object)a, AlarmManager.class.getDeclaredMethod(ConnectionController.m_ck((Object)"N\u0018]<E\u001c[\u0010z\tH\t\\\u000eL\u000e`\u0013]\u0018[\u0013H\u0011"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = Integer.class;
            a.l.m_yb((short)108, (Object)a, AlarmManager.class.getDeclaredMethod(ExceptionDetails.m_ck((Object)"1\u0019$\u0013&\u001b$\u001f\u0011\u00161\b==\"\u0015%\n#8)*\"\u0015:\u001f3\u000e\u0019\u001e\u0019\u0014$\u001f\"\u00141\u0016"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = Integer.class;
            a.l.m_yb((short)109, (Object)a, AlarmManager.class.getDeclaredMethod(ConnectionController.m_ck((Object)"M\u0018H\u001e]\u0014_\u001c]\u0018h\u0011H\u000fD:[\u0012\\\rZ?P-[\u0012C\u0018J\t`\u0019`\u0013]\u0018[\u0013H\u0011"), classArray9));
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(ExceptionDetails.m_ck((Object)"<1\u0013<\u001f4Z$\u0015p\b5\u001d9\t$\u001f\"Z\u0011\u00161\b=71\u00141\u001d5\bp(\u00009p\u00175\u000e8\u00154\t"), noSuchMethodException);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.activateAlarmGroup(alarmManager.A.m_ho(a, a2).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_iba getAlarmGroupStatus(Integer a) {
        AlarmManager a2;
        if (a2.l.m_hb()) {
            b.debug(ConnectionController.m_ck((Object)"e8h9l/\u0013]n\u0018]\t@\u0013N]H\u0011H\u000fD]N\u000fF\bY]Z\tH\t\\\u000e\t\u001bF\u000f\t\u0006T]E\u0012J\u001cE\u0011PS"), (Object)a);
            return a2.getAlarmGroupStatusInternal(a);
        }
        b.debug(ExceptionDetails.m_ck((Object)"\u001e5\u001eW\u001c?\u0011>\u0015(jZ\u0002\u001f!\u000f5\t$\u0013>\u001dp\u00165\u001b4\u001f\"Z6\u0015\"Z1\u00161\b=Z7\b?\u000f Z#\u000e1\u000e%\tp\u001c?\bp\u0001-T"), (Object)a);
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = a;
            return (c_iba)a2.l.m_sb(Short.valueOf((short)104), objectArray);
        }
        catch (Exception exception) {
            throw new c_vha("Failed to RPC get alarm group status for " + a, (Throwable)exception);
        }
    }

    protected c_iba getAlarmGroupStatusInternal(AlarmGroup a) {
        AlarmManager a2;
        if (a == null) {
            return c_iba.L;
        }
        if ((a = a2.i.m_slc(a.getId())) != null && a.m_ngc()) {
            return c_iba.d;
        }
        return c_iba.L;
    }

    protected void activateAlarmGroupInternal(Integer a) {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        alarmManager.activateAlarmGroupInternal(alarmManager.A.m_wj(a));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager a2;
        AlarmManager alarmManager = a2;
        String string = alarmManager.l.m_gb().getNodeId();
        b.info(ConnectionController.m_ck((Object)"h\u0011H\u000fD0H\u0013H\u001aL\u000f\u0013]}\u0015@\u000e\t\u0013F\u0019L]\u0001\u0006TT\t\u0015H\u000e\t\u001fL\u001eF\u0010L]]\u0015L]e8h9l/\u0007]{\u0018Z\tF\u000f@\u0013N]H\u001e]\u0014_\u0018\t\u001cE\u001c[\u0010ZS\u0007S"), (Object)string);
        alarmManager.m.lock();
        try {
            Set set = a2.G.smembers(L).stream().map(Integer::parseInt).collect(Collectors.toSet());
            if (set.isEmpty()) {
                b.info(ExceptionDetails.m_ck((Object)";<\u001b\"\u0017\u001d\u001b>\u001b7\u001f\"Zx65\u001b4\u001f\"Z+\u0007y@p4?Z1\u0019$\u0013&\u001fp\u001b<\u001b\"\u0017p\u001d\"\u0015%\n#Z6\u0015%\u00144Z9\u0014p(5\u001e9\tp\u000e?Z\"\u001f#\u000e?\b5T"), (Object)string);
                return;
            }
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = set.size();
            objectArray[2] = set;
            b.info(ConnectionController.m_ck((Object)"<E\u001c[\u0010d\u001cG\u001cN\u0018[]\u00011L\u001cM\u0018[]R\u0000\u0000G\t;F\bG\u0019\t\u0006T]H\u001e]\u0014_\u0018\t\u001cE\u001c[\u0010\t\u001a[\u0012\\\r\t4m\u000e\t\u0014G]{\u0018M\u0014Z]]\u0012\t\u000fL\u000e]\u0012[\u0018\u0013]R\u0000"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[1];
            stringArray[0] = ExceptionDetails.m_ck((Object)"\u00063\u0015-\u000f;\u001c;\u00027\u000f=\u00025\u0005*");
            c_kka.m_occ(() -> {
                AlarmManager a3;
                arrayList.addAll(a3.A.m_te(set));
            }, (String[])stringArray);
            b.info(ConnectionController.m_ck((Object)"h\u0011H\u000fD0H\u0013H\u001aL\u000f\tUe\u0018H\u0019L\u000f\t\u0006TT\u0013]h\t]\u0018D\r]\u0014G\u001a\t\tF][\u0018Z\tF\u000fL]R\u0000\t\u001cE\u001c[\u0010\t\u001a[\u0012\\\rZS"), (Object)string, (Object)arrayList.size());
            arrayList.forEach(a -> {
                AlarmManager a2;
                AlarmManager alarmManager = a2;
                String[] stringArray = new String[2];
                stringArray[0] = ConnectionController.m_ck((Object)"h>}4\u007f<}8v<e<{0");
                stringArray[1] = ExceptionDetails.m_ck((Object)"\u0014?\u00119\u00043\u0006;\u0004?\u000f;\u001c;\u00027");
                c_kka.m_byb(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1(alarmManager.l.m_gb().getNodeId(), a), (Space)a.getSpace(), (String[])stringArray);
            });
            b.info(ExceptionDetails.m_ck((Object)";<\u001b\"\u0017\u001d\u001b>\u001b7\u001f\"Zx65\u001b4\u001f\"Z+\u0007y@p<9\u00149\t8\u001f4Z1\u00161\b=Z\"\u001f#\u000e?\b1\u000e9\u0015>Z \b?\u00195\t#T"), (Object)string);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[3];
            objectArray[0] = string;
            objectArray[1] = exception.getMessage();
            objectArray[2] = exception;
            b.error(ConnectionController.m_ck((Object)"h\u0011H\u000fD0H\u0013H\u001aL\u000f\tUe\u0018H\u0019L\u000f\t\u0006TT\u0013]l\u000f[\u0012[]M\b[\u0014G\u001a\t\u001cE\u001c[\u0010\t\u000fL\u000e]\u0012[\u001c]\u0014F\u0013\t\r[\u0012J\u0018Z\u000e\u0013]R\u0000"), objectArray);
            return;
        }
        finally {
            a2.m.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(Integer a, String a2) {
        AlarmManager a3;
        AlarmManager alarmManager = a3;
        alarmManager.deactivateAlarmGroup(alarmManager.A.m_ho(a, a2).getId());
    }

    protected Map<Integer, c_iba> getAlarmStatusesByProjectIdInternal(Integer a) {
        AlarmManager a2;
        if ((a = a2.g.m_la((Integer)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Alarm::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }
}

