/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.k.c_iba;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_kfa;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import com.inscada.mono.shared.aspects.SpaceFilterAspect;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/alarms/groups"})
public class AlarmGroupController
extends ProjectBasedImportExportController {
    private final AlarmManager d;
    private final c_kfa g;

    @PostMapping(value={"/deactivate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.d.deactivateAlarmGroup(projectId, a);
    }

    public AlarmGroupController(c_kfa a, AlarmManager a2, c_cd a3, c_ll a4) {
        AlarmGroupController a5;
        AlarmGroupController alarmGroupController = a5;
        super(a3, EnumSet.of(c_ao.H), a4);
        alarmGroupController.g = a;
        alarmGroupController.d = a2;
    }

    @PostMapping(value={"/{groupId}/activate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.d.activateAlarmGroup(a);
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_iba> getAlarmGroupStatuses(@RequestParam(value="projectId") Integer a) {
        return this.d.getAlarmGroupStatuses(a);
    }

    @DeleteMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.g.m_qa(a);
    }

    @DeleteMapping(value={"/multi"}, params={"groupIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmGroupsByIds(@RequestParam(value="groupIds") Integer[] a) {
        this.g.m_xjc(List.of(a));
    }

    @GetMapping(value={"/{groupId}"})
    public AlarmGroup getAlarmGroup(@PathVariable(value="groupId") Integer a) {
        return this.g.m_ya(a);
    }

    @PostMapping(value={"/activate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.d.activateAlarmGroups(a);
    }

    @GetMapping(value={"/{alarmGroupId}/status"})
    public c_iba getAlarmGroupStatus(@PathVariable(value="alarmGroupId") Integer a) {
        return this.d.getAlarmGroupStatus(a);
    }

    @PutMapping(value={"/{groupId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarmGroup(@PathVariable(value="groupId") Integer groupId, @Valid @RequestBody AlarmGroup a) {
        this.g.m_lnc(groupId, a);
    }

    @PostMapping(value={"/deactivate"}, params={"projectId"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroups(@RequestParam(value="projectId") Integer a) {
        this.d.deactivateAlarmGroups(a);
    }

    @GetMapping
    public Collection<AlarmGroup> getAlarmGroups(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_la(a);
    }

    @PostMapping
    public ResponseEntity<AlarmGroup> createAlarmGroup(@Valid @RequestBody AlarmGroup alarmGroup, UriComponentsBuilder a) {
        alarmGroup = this.g.m_rhc(alarmGroup);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarmGroup.getId();
        return ResponseEntity.created((URI)a.path(SpaceFilterAspect.m_ck((Object)":4r=z:e\u0006q2")).buildAndExpand(objectArray).toUri()).body((Object)alarmGroup);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_iba getAlarmGroupStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.d.getAlarmGroupStatus(projectId, a);
    }

    @PostMapping(value={"/{groupId}/deactivate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deactivateAlarmGroup(@PathVariable(value="groupId") Integer a) {
        this.d.deactivateAlarmGroup(a);
    }

    @PostMapping(value={"/activate"}, params={"projectId", "name"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void activateAlarmGroup(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        this.d.activateAlarmGroup(projectId, a);
    }
}

