/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.restcontrollers;

import com.inscada.mono.alarm.k.c_iba;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.alarm.services.AlarmManager;
import com.inscada.mono.alarm.services.c_eea;
import com.inscada.mono.impexp.restcontrollers.ImportExportController;
import com.inscada.mono.impexp.restcontrollers.ProjectBasedImportExportController;
import com.inscada.mono.impexp.t.c_ao;
import com.inscada.mono.impexp.w.c_cd;
import com.inscada.mono.project.k.c_ll;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AlarmController<T extends Alarm>
extends ProjectBasedImportExportController {
    protected final AlarmManager d;
    protected final c_eea<T> g;

    @GetMapping(value={"/{alarmId}/status"})
    public c_iba getAlarmStatus(@PathVariable(value="alarmId") Integer a) {
        return this.d.getAlarmStatus(a);
    }

    @PutMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateAlarm(@PathVariable(value="alarmId") Integer alarmId, @Valid @RequestBody T a) {
        this.g.m_zfc(alarmId, a);
    }

    @DeleteMapping(value={"/{alarmId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarm(@PathVariable(value="alarmId") Integer a) {
        this.g.m_qa(a);
    }

    @PostMapping(value={"/filter/pages"})
    public Page<T> getAlarmsByFilter(@Valid @RequestBody AlarmFilter alarmFilter, Pageable a) {
        return this.g.m_klc(alarmFilter, a);
    }

    @PostMapping
    public ResponseEntity<T> createAlarm(@Valid @RequestBody T alarm, UriComponentsBuilder a) {
        alarm = this.g.m_jgc(alarm);
        Object[] objectArray = new Object[1];
        objectArray[0] = alarm.getId();
        return ResponseEntity.created((URI)a.path(ImportExportController.m_ck((Object)"\u0015e[r[lWW^c")).buildAndExpand(objectArray).toUri()).body(alarm);
    }

    protected AlarmController(c_eea<T> a, AlarmManager a2, c_cd a3, c_ll a4) {
        AlarmController a5;
        AlarmController alarmController = a5;
        super(a3, EnumSet.of(c_ao.E), a4);
        alarmController.g = a;
        alarmController.d = a2;
    }

    @GetMapping(params={"projectId"})
    public Collection<T> getAlarms(@RequestParam(name="projectId", required=false) Integer a) {
        if (a == null) {
            return this.g.m_aa();
        }
        return this.g.m_la(a);
    }

    @GetMapping(value={"/{alarmId}"})
    public T getAlarm(@PathVariable(value="alarmId") Integer a) {
        return (T)this.g.m_ya(a);
    }

    @GetMapping(value={"/status"}, params={"projectId"})
    public Map<Integer, c_iba> getAlarmStatuses(@RequestParam(value="projectId") Integer a) {
        return this.d.getAlarmStatuses(a);
    }

    @GetMapping(value={"/status"}, params={"projectId", "name"})
    public c_iba getAlarmStatus(@RequestParam(value="projectId") Integer projectId, @RequestParam(value="name") String a) {
        return this.d.getAlarmStatus(projectId, a);
    }

    @DeleteMapping(value={"/multi"}, params={"alarmIds"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAlarmsByIds(@RequestParam(value="alarmIds") Integer[] a) {
        this.g.m_oic(List.of(a));
    }

    @GetMapping(value={"/status"}, params={"alarmIds"})
    public Map<Integer, c_iba> getAlarmStatuses(@RequestParam(value="alarmIds") Integer[] a) {
        return this.d.getAlarmStatuses(Arrays.asList(a));
    }

    @GetMapping(value={"/name"})
    public T getAlarmByName(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="alarmName") String a) {
        return (T)this.g.m_ho(projectId, a);
    }

    @GetMapping(value={"/parts"})
    public Collection<String> getPartsByProjectId(@RequestParam(name="projectId") Integer a) {
        return this.g.m_fkc(a);
    }

    @GetMapping(params={"projectId", "groupName"})
    public Collection<T> getAlarmsByGroupId(@RequestParam(name="projectId") Integer projectId, @RequestParam(name="groupName") String a) {
        return this.g.m_kgc(projectId, a);
    }

    @GetMapping(value={"/pages"})
    public Page<T> getAlarmsByProjectId(@RequestParam(name="projectId", required=false) Integer projectId, Pageable a) {
        if (projectId == null) {
            return this.g.m_laa(a);
        }
        return this.g.m_ypa(projectId, a);
    }
}

