/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.repositories;

import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.Collection;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface AlarmRepository<T extends Alarm>
extends BaseJpaRepository<T, Integer> {
    @Query(value="select distinct(a.part) p from inscada.alarm a where a.space_id = ?#{authentication.activeSpace.id} and a.project_id = ?1 and a.part is not null order by p", nativeQuery=true)
    public Collection<String> findDistinctPartsByProjectId(Integer var1);

    public Collection<T> findByGroupIdAndIsActiveTrue(Integer var1);

    public T findOneByProjectIdAndName(Integer var1, String var2);

    public Collection<T> findByProjectIdAndNameIn(Integer var1, Set<String> var2);

    public Collection<T> findByProjectId(Integer var1);

    public Page<T> findByProjectId(Integer var1, Pageable var2);

    @Query(value="select alm from #{#entityName} alm where (alm.projectId = ?#{#alarmFilter.projectId} or ?#{#alarmFilter.projectId} is null) and (alm.groupId = ?#{#alarmFilter.groupId} or ?#{#alarmFilter.groupId} is null) and (alm.part = ?#{#alarmFilter.part} or ?#{#alarmFilter.part} is null or ?#{#alarmFilter.part} = '') and (?#{#alarmFilter.nameIn} is null or ?#{#alarmFilter.nameIn} = '' or upper(alm.name) like %?#{#alarmFilter.nameIn.toUpperCase()}% ) and(?#{#alarmFilter.dscIn} is null or ?#{#alarmFilter.dscIn} = '' or upper(alm.dsc) like %?#{#alarmFilter.dscIn.toUpperCase()}%)")
    public Page<T> findAlarmsByFilter(@Param(value="alarmFilter") AlarmFilter var1, @Param(value="pageable") Pageable var2);

    @Query(value="select a from #{#entityName} a join a.group g where g.name = ?2 and a.projectId = ?1")
    public Collection<T> findByGroupName(Integer var1, String var2);

    public Page<T> findAll(Pageable var1);

    public void deleteByProjectId(Integer var1);
}

