/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="alarm_group")
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class AlarmGroup
extends OwnedSpaceBaseModel {
    @Column(name="off_script_id", insertable=false, updatable=false)
    private Integer offScriptId;
    @Size(max=7)
    @Column(name="off_ack_color")
    private String offAckColor;
    @Size(max=7)
    @Column(name="on_ack_color")
    private String onAckColor;
    @Column(name="ack_script_id", insertable=false, updatable=false)
    private Integer ackScriptId;
    @Column(name="project_id", insertable=false, updatable=false)
    private Integer projectId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Column(name="hidden_on_monitor")
    private Boolean hiddenOnMonitor;
    @NotBlank
    @Size(max=100)
    private String name;
    @Column(name="print_when_off")
    private Boolean printWhenOff;
    @Size(max=15)
    @Column(name="printer_ip")
    private String printerIp;
    @Id
    @Column(name="alarm_group_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="alarmGroupSeq")
    @GenericGenerator(name="alarmGroupSeq", strategy="com.inscada.mono.shared.hibernate.UseExistingOrGenerateIdGenerator", parameters={@Parameter(name="sequence_name", value="alarm_group_seq"), @Parameter(name="increment_size", value="100")})
    private Integer id;
    @Size(max=255)
    private String dsc;
    @JsonIgnore
    @OneToMany(mappedBy="group")
    private Set<Alarm> alarms;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="ack_script_id")
    private RepeatableScript ackScript;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="on_script_id")
    private RepeatableScript onScript;
    @Size(max=7)
    @Column(name="on_no_ack_color")
    private String onNoAckColor;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="off_script_id")
    private RepeatableScript offScript;
    @Column(name="on_script_id", insertable=false, updatable=false)
    private Integer onScriptId;
    @Min(value=0L)
    @Column(name="printer_port")
    private Short printerPort;
    @NotNull
    @Min(value=100L)
    @Column(name="scan_time")
    private Integer scanTimeInMillis;
    @Column(name="print_when_ack")
    private Boolean printWhenAck;
    @Size(max=7)
    @Column(name="off_no_ack_color")
    private String offNoAckColor;
    @Column(name="print_when_on")
    private Boolean printWhenOn;
    @NotNull
    @Max(value=255L)
    @Min(value=1L)
    private Short priority;

    public void setOffNoAckColor(String a) {
        a.offNoAckColor = a;
    }

    public int hashCode() {
        AlarmGroup a;
        Object[] objectArray = new Object[3];
        objectArray[0] = super.hashCode();
        objectArray[1] = a.getProjectId();
        objectArray[2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setAlarms(Set<Alarm> a) {
        a.alarms = a;
    }

    public void setAckScriptId(Integer a) {
        a.ackScriptId = a;
    }

    public Short getPrinterPort() {
        AlarmGroup a;
        return a.printerPort;
    }

    public String getOffAckColor() {
        AlarmGroup a;
        return a.offAckColor;
    }

    public Boolean getPrintWhenOff() {
        AlarmGroup a;
        return a.printWhenOff;
    }

    public String getDsc() {
        AlarmGroup a;
        return a.dsc;
    }

    public void setPrintWhenOn(Boolean a) {
        a.printWhenOn = a;
    }

    public String getOffNoAckColor() {
        AlarmGroup a;
        return a.offNoAckColor;
    }

    public Integer getProjectId() {
        AlarmGroup a;
        return a.projectId;
    }

    public Set<Alarm> getAlarms() {
        AlarmGroup a;
        return a.alarms;
    }

    public void setScanTimeInMillis(Integer a) {
        a.scanTimeInMillis = a;
    }

    public void setHiddenOnMonitor(Boolean a) {
        a.hiddenOnMonitor = a;
    }

    public void setProjectId(Integer a) {
        a.projectId = a;
    }

    public Integer getOnScriptId() {
        AlarmGroup a;
        return a.onScriptId;
    }

    public String getOnAckColor() {
        AlarmGroup a;
        return a.onAckColor;
    }

    public Boolean getPrintWhenOn() {
        AlarmGroup a;
        return a.printWhenOn;
    }

    public AlarmGroup() {
        AlarmGroup a;
    }

    public void setOnNoAckColor(String a) {
        a.onNoAckColor = a;
    }

    public String getPrinterIp() {
        AlarmGroup a;
        return a.printerIp;
    }

    public void setName(String a) {
        a.name = a;
    }

    public void setOffScriptId(Integer a) {
        a.offScriptId = a;
    }

    public void setOnAckColor(String a) {
        a.onAckColor = a;
    }

    public RepeatableScript getOffScript() {
        AlarmGroup a;
        return a.offScript;
    }

    public boolean equals(Object a) {
        AlarmGroup a2;
        if (a2 == a) {
            return true;
        }
        if (!(a instanceof AlarmGroup)) {
            return false;
        }
        if (!super.equals(a)) {
            return false;
        }
        a = (AlarmGroup)a;
        return a2.getProjectId().equals(a.getProjectId()) && a2.getName().equals(a.getName());
    }

    public void setPriority(Short a) {
        a.priority = a;
    }

    public void setPrintWhenOff(Boolean a) {
        a.printWhenOff = a;
    }

    public String getOnNoAckColor() {
        AlarmGroup a;
        return a.onNoAckColor;
    }

    public void setDsc(String a) {
        a.dsc = a;
    }

    public void setPrinterPort(Short a) {
        a.printerPort = a;
    }

    public void setOffAckColor(String a) {
        a.offAckColor = a;
    }

    public Short getPriority() {
        AlarmGroup a;
        return a.priority;
    }

    public void setAckScript(RepeatableScript a) {
        AlarmGroup a2;
        AlarmGroup alarmGroup = a2;
        alarmGroup.ackScript = a;
        alarmGroup.ackScriptId = a != null && a.getId() != null ? a.getId() : null;
    }

    public RepeatableScript getAckScript() {
        AlarmGroup a;
        return a.ackScript;
    }

    public RepeatableScript getOnScript() {
        AlarmGroup a;
        return a.onScript;
    }

    public void setPrintWhenAck(Boolean a) {
        a.printWhenAck = a;
    }

    public void setId(Integer a) {
        a.id = a;
    }

    public Boolean getPrintWhenAck() {
        AlarmGroup a;
        return a.printWhenAck;
    }

    public Boolean getHiddenOnMonitor() {
        AlarmGroup a;
        return a.hiddenOnMonitor;
    }

    public void setOnScriptId(Integer a) {
        a.onScriptId = a;
    }

    public void setOnScript(RepeatableScript a) {
        AlarmGroup a2;
        AlarmGroup alarmGroup = a2;
        alarmGroup.onScript = a;
        alarmGroup.onScriptId = a != null && a.getId() != null ? a.getId() : null;
    }

    public void setProject(Project a) {
        AlarmGroup a2;
        AlarmGroup alarmGroup = a2;
        alarmGroup.project = a;
        alarmGroup.projectId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getId() {
        AlarmGroup a;
        return a.id;
    }

    public Integer getAckScriptId() {
        AlarmGroup a;
        return a.ackScriptId;
    }

    public void setPrinterIp(String a) {
        a.printerIp = a;
    }

    public void setOffScript(RepeatableScript a) {
        AlarmGroup a2;
        AlarmGroup alarmGroup = a2;
        alarmGroup.offScript = a;
        alarmGroup.offScriptId = a != null && a.getId() != null ? a.getId() : null;
    }

    public Integer getOffScriptId() {
        AlarmGroup a;
        return a.offScriptId;
    }

    public Integer getScanTimeInMillis() {
        AlarmGroup a;
        return a.scanTimeInMillis;
    }

    public Project getProject() {
        AlarmGroup a;
        return a.project;
    }

    public String getName() {
        AlarmGroup a;
        return a.name;
    }
}

