CREATE OR REPLACE FUNCTION insert_initial_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
	insert into inscada.mail_settings(smtp_host,smtp_port, protocol, username, password, insert_user, insert_dttm, space_id)
	select 'mail.inscada.com', 25, 'SMTP', 'inscada', '', 'inscada', now(), NEW.space_id;

	insert into inscada.sms_settings(provider, config, default_flag, insert_user, insert_dttm, space_id)
	select 'dataport', '{}', true, 'inscada', now(), NEW.space_id;

	insert into inscada.sms_settings(provider, config, default_flag, insert_user, insert_dttm, space_id)
	select 'twilio', '{}', false, 'inscada', now(), NEW.space_id;

	insert into inscada.broadcast_settings(server_ip_addr, insert_user, insert_dttm, space_id)
	select 'https://www.inscada.com', 'inscada', now(), NEW.space_id;

	insert into inscada.map_settings(map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
	select 'pk.eyJ1IjoieXJ5c2t1bCIsImEiOiJjazc0ZDc0NmswMnlvM2ptdnRqaW4ya3IxIn0.9YN8pWOfuz19ILnJy311ww',
	       'd1a6442a2d89164ee9cc3d3a9c9c7ed3', 'inscada', now(), NEW.space_id;

	insert into inscada.custom_table_settings(url, username, password, insert_user, insert_dttm, space_id)
    select 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(), NEW.space_id;

    INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
        ('fr', 'inSCADA Login', 'Connexion inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Username', 'Nom d utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Password', 'Mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Login', 'Connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Language', 'Langue', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Projects', 'Projets', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'User Menu', 'Menu utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Project Map', 'Carte du projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Devices', 'Dispositifs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animations', 'Animations', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarms', 'Alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Trends', 'Les tendances', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Trend Tags', 'Tags de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Trend Tag', 'Balise de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Scripts', 'Scripts', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Reports', 'Rapports', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Emails', 'E-mails', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Logs', 'Journaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Auth Log', 'Journal d authentification', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Users', 'Utilisateurs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Help', 'Aider', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'About', 'À propos de', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Home', 'Maison', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Connection', 'Connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Trend Graphic', 'Graphique de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Trend Graphics', 'Graphiques de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Connections', 'Connexions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Group', 'Groupe de rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Aggregate', 'Agrégat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Device Templates', 'Modèles d appareils', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Frame Templates', 'Modèles de cadre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable Templates', 'Modèles de variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Search', 'Chercher', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure you want to schedule/unschedule the selected script?', 'Êtes-vous sûr de vouloir planifier / annuler la planification du script sélectionné?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Add New', 'Ajouter nouveau', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Save', 'Sauvegarder', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Delete', 'Effacer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Yes', 'Oui', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'No', 'Non', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Status', 'Statut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Properties', 'Propriétés', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure to continue?', 'Êtes-vous sûr de continuer?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Form data is invalid', 'Les données du formulaire ne sont pas valides', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Visualization', 'Visualisation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Development', 'Développement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Gas Metering', 'Comptage de gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Gas Control', 'Contrôle du gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Control panel', 'Panneau de commande', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group', 'Grouper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Module', 'Module', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Station Adress', 'Adresse de la station', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Protocol', 'Protocole', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On DateTime', 'Le DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Acknowledge DateTime', 'Acquitter DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Settings', 'Réglages', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'General', 'Général', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Start adress', 'Adresse de départ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Scan Time', 'Temps de balayage', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Device Library', 'Bibliothèque de périphériques', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Expressions', 'Expressions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variables', 'Variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Wizard', 'Magicien', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable History', 'Historique des variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Timeout', 'Temps libre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Frames', 'Cadres', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Writeable?', 'Est-il inscriptible?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Readable?', 'Est-ce lisible?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Buffer size', 'Taille du tampon', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print Time', 'Temps d impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print Day', 'Jour d impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print Hour', 'Heure d impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Day', 'Jour du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Time', 'Heure du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Hour', 'Heure du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print?', 'Impression?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Add Descriptions', 'Ajouter des descriptions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Jobs', 'Emplois', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Last Execution Start Time', 'Heure de début de la dernière exécution', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Last Execution Ended Time', 'Heure de fin de la dernière exécution', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Next Execution Time', 'Prochaine heure d exécution', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Executions Count', 'Nombre d exécutions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Project', 'Projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Name', 'Nom', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Description', 'Description', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Start Date', 'Date de début', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'End Date', 'Date de fin', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Active?', 'C est actif?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Location', 'Lieu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Address', 'Adresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Latitude', 'Latitude', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Longitude', 'Longitude', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Contract', 'Contracter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Contract Day', 'Jour du contrat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Contract Hour', 'Heure du contrat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new project added', 'Un nouveau projet ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Project updated successfully', 'Projet mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Project removed', 'Projet supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Value', 'Évaluer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure you want to continue?', 'Es-tu sur de vouloir continuer?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'HPP Unit', 'Unité HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Reload', 'Recharger', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Acknowledge', 'Accuser réception', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Quantity', 'Quantité', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Type', 'Type de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Unit', 'Unité', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Expression Type', 'Type d expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Retain Flag', 'Conserver le drapeau', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Word Swap', 'Échange de mots', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Byte Swap', 'Echange d octets', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Load', 'Charge', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Date Range', 'Plage de dates', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable Picker', 'Sélecteur de variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Last Value', 'Dernière valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'First Value', 'Première valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Min Value', 'Valeur min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Value', 'Valeur max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Sum Value', 'Valeur somme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Count Value', 'Valeur de comptage', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Acknowledge DateTime Filter', 'Acquitter le filtre DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Off DateTime Filter', 'Désactiver le filtre DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On DateTime Filter', 'Sur le filtre DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Search Form', 'Formulaire de recherche', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Interval (Second)', 'Intervalle (seconde)', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On', 'Sur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Off', 'Désactivé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Live', 'Habitent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Preview', 'Aperçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Cancel', 'Annuler', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Schedule', 'Horaire', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Severity', 'Gravité du journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Activity', 'Activité', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Source', 'La source', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Message', 'Un message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Remove', 'Supprimer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'User Roles', 'Rôles des utilisateurs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Role', 'Rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Expression', 'Expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Delay', 'Retard', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Category', 'Catégorie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On Script', 'Sur script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Off Script', 'Hors script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new alarm added', 'Une nouvelle alarme ajoutée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm updated successfully', 'Alarme mise à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm settings is updated', 'Les paramètres d alarme sont mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm removed', 'Alarme supprimée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm History', 'Historique des alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Type', 'Taper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Import', 'Importer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Date', 'Date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure you want to activate/deactivate the selected alarm?', 'Êtes-vous sûr de vouloir activer / désactiver l alarme sélectionnée?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure you want to Start/Stop the selected connection?', 'Êtes-vous sûr de vouloir démarrer / arrêter la connexion sélectionnée?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Code', 'Code', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Priority', 'Priorité', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Period', 'Point final', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log', 'Enregistrer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new script added', 'Un nouveau script ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Script updated successfully', 'Script mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Script removed', 'Script supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Deviation Variable', 'Variable d écart', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Total Variable', 'Variable totale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Calculation Type', 'Type de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Order', 'Commander', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Variables', 'Variables du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Subgroup Order', 'Ordre des sous-groupes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Subgroups', 'Signaler les sous-groupes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group Order', 'Ordre de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation Elements', 'Éléments d animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Parent Animation', 'Animation parentale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Color', 'Couleur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Duration', 'Durée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Play at Main?', 'Jouer à Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SVG Content', 'Contenu SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation Type', 'Type d animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new animation added', 'Une nouvelle animation ajoutée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Only SVG files are allowed', 'Seuls les fichiers SVG sont autorisés', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation updated successfully', 'Animation mise à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation removed', 'Animation supprimée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new animation element added', 'Un nouvel élément d animation ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation element updated successfully', 'Élément d animation mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation element removed', 'Élément d animation supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Min. Scale', 'Échelle min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max. Scale', 'Échelle max.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Thickness', 'Épaisseur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Backup', 'Sauvegarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Restore', 'Restaurer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Save & Continue', 'Enregistrer continuer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable', 'Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Default', 'Défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Add', 'Ajouter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Default value', 'Valeur par défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Text', 'Texte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Title', 'Titre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Size', 'Taille', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Disable', 'Désactiver', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Home View', 'Vue de la maison', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Time', 'Temps', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Second', 'Deuxième', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Last Executed At', 'Dernière exécution à', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please select a master record first', 'Veuillez d abord sélectionner un enregistrement principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Send SMS', 'Envoyer un SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SMS Details', 'Détails SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SMS Service', 'Service SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SMS sended successfully', 'SMS envoyé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SMS Search', 'Recherche SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Content', 'Teneur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SMS Settings', 'Paramètres SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Mail sended successfully', 'Courrier envoyé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'No selected animation', 'Aucune animation sélectionnée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Recipient', 'Destinataire', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Online Help', 'Aide en ligne', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm', 'Alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm Monitor', 'Moniteur d alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Smart Symbol', 'Symbole intelligent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Smart Symbols', 'Symboles intelligents', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable Monitor', 'Moniteur variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm Group', 'Groupe d alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm Groups', 'Groupes d alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On No Ack Color', 'Sur aucune couleur d acquittement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On Ack Color', 'Sur Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print When On?', 'Imprimer quand activé?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print When Off?', 'Imprimer quand désactivé?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print When Ack?', 'Imprimer quand Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation', 'Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Inverse', 'Inverse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Set Type', 'Définir le type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Notify', 'Notifier', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Default Color', 'Couleur par défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Gradient', 'Pente', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group Size', 'Taille de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Decimal', 'Décimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group Seperator', 'Séparateur de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Decimal Seperator', 'Séparateur décimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Leftpad Size', 'Taille du pavé gauche', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Rightpad Size', 'Taille du pavé droit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Character', 'Personnage', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Prefix', 'Préfixe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Suffix', 'Suffixe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'tag', 'étiqueter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Initial Pos', 'Position initiale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Min Pos', 'Pos. Min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'On Drop', 'En dépôt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Join', 'Rejoindre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Template?', 'Est-ce que Template?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation Element', 'Élément d animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Mouse', 'Souris', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'More', 'Suite', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation WebSocket is on', 'L animation WebSocket est activée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation WebSocket is off', 'L animation WebSocket est désactivée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Animation WebSocket error observed', 'Erreur WebSocket d animation observée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Pool Size', 'Taille de la piscine', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Adapter', 'Adaptateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Min Retry Delay', 'Délai minimum de nouvelle tentative', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Retry Delay', 'Délai maximal de nouvelle tentative', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Local Ip', 'IP local', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Local Port', 'Port local', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Cot F. Length', 'Cot F. Longueur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Cot Field Length', 'Longueur du champ du lit bébé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'IOA Field Length', 'Longueur du champ IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Common A. Length', 'Longueur A. commune', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Common Address Field Length', 'Longueur du champ d adresse commune', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'IOA F. Length', 'Longueur IOA F.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Originator Address', 'Adresse de l expéditeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Message F. Timeout', 'Message F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Message Fragment Timeout', 'Délai d expiration du fragment de message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max T.N.A. Recieved', 'Max T.N.A. Reçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Time No Ack Received', 'Temps maximum sans accusé de réception', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max T.N.A. Sent', 'Max T.N.A. Envoyé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Time No Ack Sent', 'Temps maximum sans accusé de réception envoyé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Idle Time', 'Temps d inactivité max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max U. IP Recieved', 'Max U. IP reçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Unconfirmed IPdus Received', 'IPdus max non confirmé reçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Start DT Timeout', 'Démarrer DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Start DT Retries', 'Démarrer les nouvelles tentatives DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Coming Soon...', 'Arrive bientôt...', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Rack', 'Étagère', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Slot', 'Fente', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'No Data Transfer Selected', 'Aucun transfert de données sélectionné', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Destination', 'Destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Detail Form', 'Formulaire de détail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Source Tag', 'Balise source', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Destination Tag', 'Balise de destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Data Transfer', 'Transfert de données', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Detail Transfer', 'Transfert de détails', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Device', 'Dispositif', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Device Picker', 'Sélecteur d appareils', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Import Tmpl', 'Importer Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Start Address', 'Adresse de départ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'General I. Time', 'Général I. Heure', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'General Interrogation Time', 'Heure d interrogation générale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'General Counter Interrogation Time', 'Heure d interrogation générale du compteur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Cnt Point Offset', 'Décalage du point Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Control Point Offset', 'Décalage du point de contrôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'DB Number', 'Numéro DB', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'IEC104 type', 'Type CEI104', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Sender', 'Expéditeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Recepient', 'Recepient', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Subject', 'Sujet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Email View', 'Vue e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'From', 'De', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'To', 'À', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Email Search', 'Recherche par e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Email Service', 'Service de messagerie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Body', 'Corps', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Send Email', 'Envoyer un e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Send', 'Envoyer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'User List', 'Liste d utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Mail send failed', 'L envoi du courrier a échoué', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Email Settings', 'Paramètres de messagerie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Backup/Restore', 'Restauration de sauvegarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Choose', 'Choisir', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Processes', 'Processus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Data Transfers', 'Transferts de données', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Keywords', 'Mots clés', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Roles', 'Rôles', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Templates', 'Modèles', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Key', 'Clé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Active', 'Actif', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Successful ?', 'Est réussi ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Auth Logs', 'Journaux d authentification', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'License', 'Licence', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Machine Id', 'ID de la machine', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Surname', 'Nom de famille', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'User Limit', 'Limite d utilisateurs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Update', 'Mettre à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'License Key', 'Clé de licence', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'License to', 'Licence pour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'License successfully activated', 'Licence activée avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Failed to activate', 'Échec de l activation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm Name', 'Nom de l alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Alarm Dsc', 'Alarme Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Start All', 'Tout démarrer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Stop All', 'Arrête tout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Êtes-vous sûr de vouloir planifier / annuler la planification du transfert de données sélectionné?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Process', 'Traiter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'GRAPHICAL VIEW', 'VUE GRAPHIQUE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'FLOW RATE', 'DÉBIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'METERING', 'MESURE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'ENERGY & OTHER VALUES', 'ÉNERGIE ET ​​AUTRES VALEURS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'IN-USE GAS COMPONENTS', 'COMPOSANTS DE GAZ EN USAGE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'TOTALISORS', 'TOTALISATEURS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'PREVIOUS HOURLY & DAILY VALUES', 'VALEURS HORAIRES ET QUOTIDIENNES PRÉCÉDENTES', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'ALARMS ON', 'ALARMES ACTIVÉES', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'NAME', 'NOM', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'CURRENT', 'ACTUEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'KEY-PAD', 'CLAVIER', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'IN-USE', 'UTILISÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'DOWNLOADED', 'TÉLÉCHARGÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'NORMALIZED', 'NORMALISÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'UNIT', 'UNITÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'PROPERTIES', 'PROPRIÉTÉS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'GC MANAGEMENT', 'GESTION GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SET', 'ENSEMBLE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'STATUS', 'STATUT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'QRCODE Reader', 'Lecteur QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Scanned!', 'Scanné!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'deviceName', 'nom de l appareil', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Failed to load data', 'Échec du chargement des données', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'ANIMATION', 'ANIMATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'GAS METERING', 'MESURE DE GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'GAS PROPERTIES', 'PROPRIÉTÉS DU GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'NETWORK', 'RÉSEAU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Fired Alarm Duration In Days', 'Durée de l alarme déclenchée en jours', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Fired Alarm duration is updated', 'La durée de l alarme déclenchée est mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Acknowledger', 'Accusé de réception', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Duration In Days', 'Durée du journal en jours', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log duration is updated', 'La durée du journal est mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Remove All', 'Enlever tout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Firstly load the datatable', 'Commencez par charger le datatable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Failed to load log data', 'Échec du chargement des données du journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure to remove all logs?', 'Êtes-vous sûr de supprimer tous les journaux?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'All logs removed', 'Tous les journaux supprimés', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'An error occured while removing logs', 'Une erreur s est produite lors de la suppression des journaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Message', 'Message de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Show Weather On Click', 'Afficher la météo au clic', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Updated successfully', 'Mis à jour avec succés', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Removed successfully', 'Supprimé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Map', 'Carte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Weather api', 'API Météo', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Interval', 'Intervalle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Filter', 'Filtre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'SCHEDULED', 'PROGRAMMÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'ON', 'SUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'OFF', 'DÉSACTIVÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Print', 'Impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Failed to load!', 'Échec du chargement!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Choose Trend', 'Choisissez la tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Avg Value', 'Valeur moyenne', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Integral Value', 'Valeur intégrale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Calculation type', 'Type de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Auto Scroll', 'Défilement automatique', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Failed to load trend data', 'Échec du chargement des données de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Select the Trend first', 'Sélectionnez d abord la tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Interval cannot be empty', 'L intervalle ne peut pas être vide', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable Duration In Days', 'Durée variable en jours', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable duration is updated', 'La durée variable est mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Frame', 'Cadre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Usual', 'Habituel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Hourly', 'Toutes les heures', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Daily', 'Quotidien', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'CUSTOM', 'DOUANE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'COLLECTION', 'COLLECTION', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Process Form', 'Formulaire de traitement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Background', 'Fond', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Text Color', 'Couleur du texte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Main Flag', 'Drapeau principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Grid Flag', 'Indicateur de grille', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Inputs', 'Contributions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Choose Default Image', 'Choisir l image par défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'States', 'États', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'State Lists', 'Listes d État', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'New State', 'Nouvel État', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'State name', 'Nom d état', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Attach', 'Attacher', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Library', 'Bibliothèque', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Node updated', 'Nœud mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Property', 'Biens', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Project Property', 'Propriété du projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Project Values', 'Valeurs du projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Stream', 'Flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report', 'Signaler', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please choose a period', 'Veuillez choisir une période', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Name field cannot be empty!', 'Le champ de nom ne peut pas être vide!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please choose a report', 'Veuillez choisir un rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group order cannot be empty!', 'L ordre de groupe ne peut pas être vide!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report group removed', 'Groupe de rapports supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new Report group added', 'Un nouveau groupe de rapports a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report group updated successfully', 'Groupe de rapports mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report updated successfully', 'Rapport mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new report added', 'Un nouveau rapport a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report removed', 'Rapport supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please select group', 'Veuillez sélectionner un groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report subgroup removed', 'Sous-groupe du rapport supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new Report subgroup added', 'Un nouveau sous-groupe de rapport a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report subgroup updated successfully', 'Sous-groupe du rapport mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report Variable', 'Variable de rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Subgroup', 'Sous-groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please choose a subgroup', 'Veuillez choisir un sous-groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable Order', 'Ordre variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Variable order cannot be empty', 'L ordre des variables ne peut pas être vide', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please choose calculation type', 'Veuillez choisir le type de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please choose variable', 'Veuillez choisir la variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Deviation', 'Déviation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please select subgroup', 'Veuillez sélectionner un sous-groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report variable removed', 'Variable de rapport supprimée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new Report variable added', 'Une nouvelle variable de rapport a été ajoutée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Report variable updated successfully', 'La variable du rapport a bien été mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Script Output', 'Sortie de script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Output message', 'Message de sortie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Empty output', 'Sortie vide', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Error in code syntax', 'Erreur dans la syntaxe du code', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group Chat', 'Discussion de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Type message here', 'Tapez le message ici', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Type message', 'Tapez le message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Refresh Periods', 'Périodes de rafraîchissement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Control Panel', 'Panneau de commande', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Gas Properties', 'Propriétés du gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Network', 'Réseau', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Graph Details', 'Détails du graphique', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Check All', 'Vérifie tout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Menus', 'Menus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Permission', 'Autorisation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Permissions', 'Autorisations', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Rolename', 'Nom de rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Role Menus', 'Menus de rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Menus are added', 'Les menus sont ajoutés', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Please select role', 'Veuillez sélectionner le rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', ' is removed', ' est retiré', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Role Permissions', 'Permissions de rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Permissions are added', 'Les autorisations sont ajoutées', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new role added', 'Un nouveau rôle ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Role updated successfully', 'Rôle mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Role is removed', 'Le rôle est supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Reset Password', 'Réinitialiser le mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Password Info', 'Informations sur le mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'New Password', 'Nouveau mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Repeat New Password', 'Répété le nouveau mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Passwords are not the same', 'Les mots de passe ne sont pas les mêmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Email Address', 'Adresse e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'User', 'Utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Password changed successfully', 'Le mot de passe a été changé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Password change failed', 'La modification du mot de passe a échoué', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Enter new value', 'Entrez une nouvelle valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Set Value', 'Définir la valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Increment Value', 'Valeur incrémentale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Send Flags', 'Envoyer des drapeaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'False/True', 'Faux vrai', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Decrement Value', 'Décrémenter la valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Byte Swap?', 'Est-ce que Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Is Word Swap?', 'Est-ce que Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Point Class', 'Classe de points', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Static Variation', 'Variation statique', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Event Variation', 'Variation d événement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Data Type', 'Type de données', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Bit Offset', 'Décalage de bits', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Decimal Point', 'Virgule', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Flags', 'Drapeaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Protocol Properties', 'Propriétés du protocole', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Raw zero scale', 'Échelle zéro brute', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Raw full scale', 'Pleine échelle brute', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Eng zero scale', 'Échelle zéro Eng', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Period', 'Période du journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Threshold', 'Seuil de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Value Expression', 'Expression de valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Log Expression', 'Expression de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Protocol Type', 'Type de protocole', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Protocols', 'Protocoles', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new item added', 'Un nouvel élément ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'A new item detail added', 'Un nouveau détail d article a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Item detail updated', 'Détails de l article mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Item updated', 'Article mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Item removed', 'Élément supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Minutes Offset', 'Décalage des minutes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Local Address', 'Adresse locale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Remote Address', 'Adresse distante', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Unsoliceted Events', 'Événements non sollicités', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Select Timeout', 'Sélectionner le délai', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Confirm Timeout', 'Confirmer le délai', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Retry Timeout', 'Retry Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Response Timeout', 'Délai de réponse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Event Scantime', 'Scantime d événement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Disable Unsolicated', 'Désactiver les non-isolées', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Startup Integrity', 'Intégrité de démarrage', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Integrity Overflow', 'Débordement d intégrité', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Common Address', 'Adresse commune', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Dnp3 type', 'Type DNP3', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Event Buffer Size', 'Taille du tampon d événement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Modbus type', 'Type Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Readable', 'Lisible', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Writeable', 'Inscriptible', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Iec104 type', 'Type Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Back', 'Retour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Next', 'Suivant', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'COMMUNICATION NETWORK', 'RÉSEAU DE COMMUNICATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Finish', 'Finir', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Check connection details', 'Vérifier les détails de connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Connection Details', 'Détails de connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'GAS STATION MODEL', 'MODÈLE DE STATION À GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Device List', 'Liste des périphériques', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Device Form', 'Formulaire de l appareil', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Item', 'Article', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Station Address', 'Adresse de la station', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'PAY', 'PAYER', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'CHECK', 'CHÈQUE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Stream Details', 'Détails du flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'USE GC', 'UTILISER GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Saved!', 'Enregistré!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'DEFINED GAS STATION MODEL', 'MODÈLE DE STATION À GAZ DÉFINI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Capacity', 'Capacité', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Group Name', 'Nom de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'STREAMS', 'RUISSEAUX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Stream Modules List', 'Liste des modules de flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Analyzer', 'Analyseur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Main Station', 'Gare principale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Sub Station', 'Sous-station', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'REPORT', 'RAPPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Generate', 'Produire', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Failed to generate project', 'Impossible de générer le projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Station Details', 'Détails de la station', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'WebSocket is on', 'WebSocket est activé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'WebSocket is off', 'WebSocket est désactivé', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'WebSocket error observed', 'Erreur WebSocket observée', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Clear browser storage', 'Effacer le stockage du navigateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'System statistics', 'Statistiques système', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Chatting', 'Bavardage', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Notifications', 'Notifications', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Sign-out', 'Déconnexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Hide top', 'Cacher le haut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Are you sure you want to clear storage?', 'Êtes-vous sûr de vouloir effacer le stockage?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Press SHIFT+Q to return', 'Appuyez sur SHIFT + Q pour revenir', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Press SHIFT+W to return', 'Appuyez sur SHIFT + W pour revenir', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'You are about to logged out. Are you sure you want to proceed?', 'Vous êtes sur le point de vous déconnecter. Voulez-vous vraiment continuer?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
        ('pl', 'inSCADA Login', 'Logowanie inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Username', 'Nazwa Użytkownika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Password', 'Hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Login', 'Zaloguj sie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Language', 'Język', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Projects', 'Projektowanie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'User Menu', 'Menu użytkownika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Project Map', 'Mapa projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Devices', 'Urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animations', 'Animacje', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarms', 'Alarmy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Trends', 'Trendy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Trend Tags', 'Tagi trendów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Trend Tag', 'Tag trendu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Scripts', 'Skrypty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Reports', 'Raporty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Emails', 'E-maile', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Logs', 'Dzienniki', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Auth Log', 'Dziennik autoryzacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Users', 'Użytkownicy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Help', 'Wsparcie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'About', 'O', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Home', 'Dom', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Connection', 'Połączenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Trend Graphic', 'Grafika trendu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Trend Graphics', 'Grafika trendów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Connections', 'Znajomości', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Group', 'Zgłoś grupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Aggregate', 'Agregat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Device Templates', 'Szablony urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Frame Templates', 'Szablony ramek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable Templates', 'Zmienne szablony', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Search', 'Szukaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure you want to schedule/unschedule the selected script?', 'Czy na pewno chcesz zaplanować / anulować harmonogram wybranego skryptu?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Add New', 'Dodaj nowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Save', 'Zapisać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Delete', 'Kasować', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Yes', 'Tak', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'No', 'Nie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Status', 'Status', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Properties', 'Nieruchomości', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure to continue?', 'Czy na pewno chcesz kontynuować?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Form data is invalid', 'Dane formularza są nieprawidłowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Visualization', 'Wyobrażanie sobie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Development', 'Rozwój', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Gas Metering', 'Pomiar gazu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Gas Control', 'Kontrola gazu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Control panel', 'Panel sterowania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group', 'Grupa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Module', 'Moduł', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Station Adress', 'Adres stacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Protocol', 'Protokół', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Acknowledge DateTime', 'Potwierdź datę i godzinę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Settings', 'Ustawienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'General', 'Generał', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Start adress', 'Adres początkowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Scan Time', 'Czas skanowania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Device Library', 'Biblioteka urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Expressions', 'Wyrażenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variables', 'Zmienne', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Wizard', 'Czarodziej', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable History', 'Historia zmiennej', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Timeout', 'Koniec czasu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Frames', 'Ramki', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Writeable?', 'Czy można zapisywać?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Readable?', 'Czy jest czytelny?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Buffer size', 'Rozmiar bufora', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print Time', 'Czas druku', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print Day', 'Drukuj dzień', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print Hour', 'Drukuj godzinę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Day', 'Dzień raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Time', 'Czas raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Hour', 'Godzina raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print?', 'Wydrukować?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Add Descriptions', 'Dodaj opisy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Jobs', 'Oferty pracy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Last Execution Start Time', 'Czas rozpoczęcia ostatniego wykonania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Last Execution Ended Time', 'Czas zakończenia ostatniego wykonania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Next Execution Time', 'Czas następnego wykonania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Executions Count', 'Liczba egzekucji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Project', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Name', 'Nazwa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Description', 'Opis', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Start Date', 'Data rozpoczęcia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'End Date', 'Data końcowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Active?', 'Jest aktywny?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Location', 'Lokalizacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Address', 'Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Latitude', 'Szerokość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Longitude', 'Długość geograficzna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Contract', 'Kontrakt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Contract Day', 'Dzień kontraktu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Contract Hour', 'Godzina kontraktu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new project added', 'Dodano nowy projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Project updated successfully', 'Projekt został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Project removed', 'Projekt usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Value', 'Wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure you want to continue?', 'Jesteś pewien, że chcesz kontynuować?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'HPP Unit', 'Jednostka HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Reload', 'Przeładować', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Acknowledge', 'Uznać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Quantity', 'Ilość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Type', 'Typ dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Unit', 'Jednostka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Expression Type', 'Typ wyrażenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Retain Flag', 'Zachowaj flagę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Word Swap', 'Zamiana słów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Byte Swap', 'Zamiana bajtów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Load', 'Załaduj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Date Range', 'Zakres dat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable Picker', 'Wybór zmiennej', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Last Value', 'Ostatnia wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'First Value', 'Pierwsza wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Min Value', 'Wartość minimalna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Value', 'Maksymalna wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Sum Value', 'Wartość sumy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Count Value', 'Zlicz wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Acknowledge DateTime Filter', 'Potwierdź filtr daty i godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Off DateTime Filter', 'Wyłączony filtr daty i godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On DateTime Filter', 'Filtr daty i godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Search Form', 'Formularz wyszukiwania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Interval (Second)', 'Interwał (sekunda)', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On', 'Na', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Off', 'Poza', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Live', 'Relacja na żywo', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Preview', 'Zapowiedź', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Cancel', 'Anuluj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Schedule', 'Harmonogram', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Severity', 'Loguj wagę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Activity', 'Czynność', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Source', 'Źródło', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Message', 'Wiadomość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Remove', 'Usunąć', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'User Roles', 'Role użytkowników', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Role', 'Rola', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Expression', 'Wyrażenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Delay', 'Opóźnienie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Category', 'Kategoria', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On Script', 'On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Off Script', 'Poza skryptem', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new alarm added', 'Dodano nowy alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm updated successfully', 'Alarm został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm settings is updated', 'Zaktualizowano ustawienia alarmu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm removed', 'Alarm usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm History', 'Historia alarmów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Type', 'Rodzaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Import', 'Import', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Date', 'Data', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure you want to activate/deactivate the selected alarm?', 'Czy na pewno chcesz włączyć / wyłączyć wybrany alarm?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure you want to Start/Stop the selected connection?', 'Czy na pewno chcesz uruchomić / zatrzymać wybrane połączenie?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Code', 'Kod', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Priority', 'Priorytet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Period', 'Kropka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new script added', 'Dodano nowy skrypt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Script updated successfully', 'Skrypt został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Script removed', 'Usunięto skrypt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Deviation Variable', 'Zmienna odchylenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Total Variable', 'Całkowita zmienna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Calculation Type', 'Typ obliczenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Order', 'Zamówienie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Variables', 'Zmienne raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Subgroup Order', 'Zamówienie podgrupy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Subgroups', 'Podgrupy raportów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group Order', 'Zamówienie grupowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation Elements', 'Elementy animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Parent Animation', 'Animacja rodzica', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Color', 'Kolor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Duration', 'Trwanie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Play at Main?', 'Play at Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SVG Content', 'Zawartość SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation Type', 'Typ animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new animation added', 'Dodano nową animację', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Only SVG files are allowed', 'Dozwolone są tylko pliki SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation updated successfully', 'Animacja została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation removed', 'Animacja usunięta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new animation element added', 'Dodano nowy element animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation element updated successfully', 'Element animacji został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation element removed', 'Usunięto element animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Min. Scale', 'Min. Skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max. Scale', 'Maks. Skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Thickness', 'Grubość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Backup', 'Utworzyć kopię zapasową', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Restore', 'Przywracać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Save & Continue', 'Zapisz Kontynuuj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable', 'Zmienna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Default', 'Domyślna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Add', 'Dodaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Default value', 'Domyślna wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Text', 'Tekst', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Title', 'Tytuł', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Size', 'Rozmiar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Disable', 'Wyłączyć', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Home View', 'Widok główny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Time', 'Czas', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Second', 'Druga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Last Executed At', 'Ostatnio wykonane o', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please select a master record first', 'Najpierw wybierz rekord główny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Send SMS', 'Wyślij SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SMS Details', 'Szczegóły SMS-a', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SMS Service', 'Usługa SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SMS sended successfully', 'SMS wysłany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SMS Search', 'Wyszukiwanie SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Content', 'Zawartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SMS Settings', 'Ustawienia SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Mail sended successfully', 'Poczta została wysłana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'No selected animation', 'Brak wybranej animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Recipient', 'Odbiorca', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Online Help', 'Pomoc online', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm Monitor', 'Monitor alarmu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Smart Symbol', 'Inteligentny symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Smart Symbols', 'Inteligentne symbole', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable Monitor', 'Zmienny monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm Group', 'Grupa alarmowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm Groups', 'Grupy alarmowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On Ack Color', 'Kolor potwierdzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print When On?', 'Drukuj kiedy wł.?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print When Off?', 'Drukuj kiedy wyłączone?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print When Ack?', 'Print When Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation', 'Animacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Inverse', 'Odwrotność', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Set Type', 'Składać czcionki do druku', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Notify', 'Notyfikować', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Default Color', 'Domyślny kolor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group Size', 'Wielkość grupy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Decimal', 'Dziesiętny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group Seperator', 'Separator grupowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Decimal Seperator', 'Separator dziesiętny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Leftpad Size', 'Rozmiar lewej płytki', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Rightpad Size', 'Rozmiar prawej płytki', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Character', 'Postać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Prefix', 'Prefiks', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Suffix', 'Przyrostek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'tag', 'etykietka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Initial Pos', 'Pozycja początkowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Min Pos', 'Min. Poz.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Pos', 'Maksymalna pozycja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Join', 'Przystąp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Template?', 'Czy szablon?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Dom Id', 'Dom ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation Element', 'Element animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Mouse', 'Mysz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'More', 'Jeszcze', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation WebSocket is on', 'Animacja WebSocket jest włączona', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation WebSocket is off', 'Animacja WebSocket jest wyłączona', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Animation WebSocket error observed', 'Zaobserwowano błąd animacji WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Pool Size', 'Rozmiar basenu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Min Retry Delay', 'Min. Opóźnienie ponowienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Retry Delay', 'Maksymalne opóźnienie ponownych prób', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Local Ip', 'Lokalny IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Local Port', 'Port lokalny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Cot F. Length', 'Cot F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Cot Field Length', 'Cot Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'IOA Field Length', 'IOA Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Common A. Length', 'Common A. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Common Address Field Length', 'Common Address Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'IOA F. Length', 'IOA F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Originator Address', 'Adres nadawcy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Message F. Timeout', 'Message F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Message Fragment Timeout', 'Limit czasu fragmentu wiadomości', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max T.N.A. Recieved', 'Max T.N.A. Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Time No Ack Received', 'Max Time No Ack Received', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max T.N.A. Sent', 'Max T.N.A. Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Idle Time', 'Max Idle Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max U. IP Recieved', 'Max U. IP Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Unconfirmed IPdus Received', 'Max Unconfirmed IPdus Received', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Start DT Timeout', 'Start DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Start DT Retries', 'Start DT Retries', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Coming Soon...', 'Wkrótce...', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Rack', 'Stojak', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Slot', 'Otwór', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'No Data Transfer Selected', 'Nie wybrano przenoszenia danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Destination', 'Miejsce docelowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Detail Form', 'Formularz szczegółowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Source Tag', 'Tag źródłowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Destination Tag', 'Tag docelowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Data Transfer', 'Transfer danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Detail Transfer', 'Transfer szczegółów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Device', 'Urządzenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Device Picker', 'Wybór urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Import Tmpl', 'Importuj Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Start Address', 'Adres początkowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'General I. Time', 'General I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'General Interrogation Time', 'Ogólny czas przesłuchania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'General Counter Interrogation Time', 'General Counter Interrogation Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Cnt Point Offset', 'Odsunięcie punktu Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Control Point Offset', 'Odsunięcie punktu kontrolnego', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'DB Number', 'Numer bazy danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'IEC104 type', 'Typ IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Sender', 'Nadawca', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Recepient', 'Odbiorca', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Subject', 'Przedmiot', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Email View', 'Widok e-maila', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'From', 'Od', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'To', 'Do', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Email Search', 'Wyszukiwanie e-mailowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Email Service', 'Usługa poczty e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Body', 'Ciało', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Send Email', 'Wysłać email', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Send', 'Wysłać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'User List', 'Lista użytkowników', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Mail send failed', 'Wysłanie poczty nie powiodło się', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Email Settings', 'Ustawienia poczty e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Backup/Restore', 'Przywracania kopii zapasowej', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Choose', 'Wybierać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Processes', 'Procesy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Data Transfers', 'Przesyłanie danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Keywords', 'Słowa kluczowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Roles', 'Role', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Templates', 'Szablony', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Key', 'Klucz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Active', 'Aktywny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Successful ?', 'Zakończony powodzeniem ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Auth Logs', 'Dzienniki autoryzacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'License', 'Licencja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Machine Id', 'Identyfikator urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Surname', 'Nazwisko', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'User Limit', 'Limit użytkowników', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Update', 'Aktualizacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'License Key', 'Klucz licencyjny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'License to', 'Licencja na', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'License successfully activated', 'Licencja została aktywowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Failed to activate', 'Nie udało się aktywować', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm Name', 'Nazwa alarmu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Start All', 'Rozpocznij wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Stop All', 'Zatrzymać wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Czy na pewno chcesz zaplanować / anulować wybrany transfer danych?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Process', 'Proces', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'GRAPHICAL VIEW', 'WIDOK GRAFICZNY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'FLOW RATE', 'PRZEPŁYW', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'METERING', 'DOZOWANIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'ENERGY & OTHER VALUES', 'ENERGIA I INNE WARTOŚCI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'IN-USE GAS COMPONENTS', 'UŻYWANE SKŁADNIKI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'TOTALISORS', 'SUMAŁY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'PREVIOUS HOURLY & DAILY VALUES', 'POPRZEDNIE WARTOŚCI GODZINOWE I DZIENNE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'ALARMS ON', 'ALARMY WŁĄCZONE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'NAME', 'NAZWA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'CURRENT', 'OBECNY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'IN-USE', 'W UŻYCIU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'DOWNLOADED', 'POBRANE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'NORMALIZED', 'NORMALIZOWANY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'UNIT', 'JEDNOSTKA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'PROPERTIES', 'NIERUCHOMOŚCI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'GC MANAGEMENT', 'ZARZĄDZANIE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SET', 'ZESTAW', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'STATUS', 'STATUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'QRCODE Reader', 'Czytnik QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Scanned!', 'Zeskanowano!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'deviceName', 'Nazwa urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Failed to load data', 'Nie udało się załadować danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'ANIMATION', 'ANIMACJA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'GAS METERING', 'POMIAR GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'GAS PROPERTIES', 'WŁAŚCIWOŚCI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'NETWORK', 'SIEĆ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Fired Alarm Duration In Days', 'Czas trwania alarmu uruchomienia w dniach', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Fired Alarm duration is updated', 'Aktualizacja czasu trwania alarmu pożarowego', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Acknowledger', 'Potwierdzający', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Duration In Days', 'Czas trwania dziennika w dniach', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log duration is updated', 'Czas trwania dziennika jest aktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Remove All', 'Usuń wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Firstly load the datatable', 'Najpierw załaduj dane z możliwością przesyłania danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Failed to load log data', 'Nie udało się załadować danych dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure to remove all logs?', 'Czy na pewno chcesz usunąć wszystkie dzienniki?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'All logs removed', 'Wszystkie dzienniki zostały usunięte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'An error occured while removing logs', 'Wystąpił błąd podczas usuwania dzienników', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Message', 'Komunikat dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Show Weather On Click', 'Pokaż pogodę po kliknięciu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Updated successfully', 'Aktualizacja zakończona sukcesem', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Removed successfully', 'Usunięto pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Map', 'Mapa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Weather api', 'Interfejs API pogody', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Interval', 'Interwał', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Filter', 'Filtr', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'SCHEDULED', 'PLANOWY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'ON', 'NA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'OFF', 'POZA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Print', 'Wydrukować', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Failed to load!', 'Nie udało się załadować!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Choose Trend', 'Wybierz trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Avg Value', 'Średnia wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Integral Value', 'Wartość integralna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Diff Value', 'Maksymalna wartość różnicy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Calculation type', 'Typ obliczenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Auto Scroll', 'Auto Scroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Failed to load trend data', 'Nie udało się załadować danych trendów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Select the Trend first', 'Najpierw wybierz trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Interval cannot be empty', 'Przedział czasu nie może być pusty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable Duration In Days', 'Zmienny czas trwania w dniach', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable duration is updated', 'Zmienny czas trwania jest aktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Frame', 'Rama', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Usual', 'Zwykły', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Hourly', 'Cogodzinny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Daily', 'Codziennie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'CUSTOM', 'ZWYCZAJ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'COLLECTION', 'KOLEKCJA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Process Form', 'Formularz przetwarzania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Background', 'Tło', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Text Color', 'Kolor tekstu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Main Flag', 'Flaga główna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Grid Flag', 'Flaga siatki', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Inputs', 'Wejścia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Choose Default Image', 'Wybierz obraz domyślny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'States', 'Stany', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'State Lists', 'Listy stanów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'New State', 'Nowy stan', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'State name', 'Nazwa stanu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Attach', 'Dołączać', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Library', 'Biblioteka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Node updated', 'Węzeł zaktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Property', 'Własność', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Project Property', 'Właściwość projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Project Values', 'Wartości projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Stream', 'Strumień', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report', 'Raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please choose a period', 'Wybierz okres', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Name field cannot be empty!', 'Pole nazwy nie może być puste!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please choose a report', 'Wybierz raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group order cannot be empty!', 'Zamówienie grupowe nie może być puste!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report group removed', 'Zgłoś grupę usuniętą', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new Report group added', 'Dodano nową grupę raportów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report group updated successfully', 'Grupa raportów została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report updated successfully', 'Raport został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new report added', 'Dodano nowy raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report removed', 'Raport usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please select group', 'Wybierz grupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report subgroup removed', 'Zgłoś podgrupę usuniętą', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new Report subgroup added', 'Dodano nową podgrupę raportów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report subgroup updated successfully', 'Podgrupa raportów została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report Variable', 'Zmienna raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Subgroup', 'Podgrupa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please choose a subgroup', 'Proszę wybrać podgrupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable Order', 'Zmienna kolejność', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Variable order cannot be empty', 'Zamówienie zmienne nie może być puste', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please choose calculation type', 'Proszę wybrać typ obliczenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please choose variable', 'Proszę wybrać zmienną', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Total', 'Całkowity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Deviation', 'Odchylenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please select subgroup', 'Proszę wybrać podgrupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report variable removed', 'Usunięto zmienną raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new Report variable added', 'Dodano nową zmienną raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Report variable updated successfully', 'Zmienna raportu została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Script Output', 'Wyjście skryptu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Output message', 'Komunikat wyjściowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Empty output', 'Puste wyjście', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Error in code syntax', 'Błąd w składni kodu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group Chat', 'Rozmowa grupowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Type message here', 'Tutaj wpisz wiadomość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Type message', 'Wpisz wiadomość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Refresh Periods', 'Okresy odświeżania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Control Panel', 'Panel sterowania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Gas Properties', 'Właściwości gazu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Network', 'Sieć', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Graph Details', 'Szczegóły wykresu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Check All', 'Zaznacz wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Menus', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Permission', 'Pozwolenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Permissions', 'Uprawnienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Rolename', 'Rolename', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Role Menus', 'Menu ról', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Menus are added', 'Menu zostały dodane', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Please select role', 'Proszę wybrać rolę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', ' is removed', ' jest usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Role Permissions', 'Uprawnienia roli', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Permissions are added', 'Uprawnienia są dodawane', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new role added', 'Dodano nową rolę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Role updated successfully', 'Rola została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Role is removed', 'Rola została usunięta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Reset Password', 'Zresetuj hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Password Info', 'Informacje o haśle', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'New Password', 'Nowe hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Repeat New Password', 'Powtórz nowe hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Passwords are not the same', 'Hasła nie są takie same', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Email Address', 'Adres e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'User', 'Użytkownik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Password changed successfully', 'Hasło zostało pomyślnie zmienione', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Password change failed', 'Zmiana hasła nie powiodła się', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Enter new value', 'Wprowadź nową wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Set Value', 'Ustalić wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Increment Value', 'Wartość przyrostu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Send Flags', 'Wyślij flagi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'False/True', 'Fałsz PRAWDA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Decrement Value', 'Zmniejszenie wartości', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Byte Swap?', 'Is Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Is Word Swap?', 'Czy jest zamiana słów?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Point Class', 'Klasa punktów', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Deadband', 'Strefa nieczułości', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Static Variation', 'Odchylenie statyczne', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Event Variation', 'Odmiana wydarzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Data Type', 'Typ danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Bit Offset', 'Przesunięcie w bitach', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Decimal Point', 'Kropka dziesiętna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Flags', 'Flagi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Protocol Properties', 'Właściwości protokołu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Raw zero scale', 'Surowa skala zerowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Raw full scale', 'Surowa, pełna skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Eng zero scale', 'Skala zerowa Eng', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Eng full scale', 'Eng na pełną skalę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Period', 'Okres dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Threshold', 'Próg dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Value Expression', 'Wyrażenie wartości', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Log Expression', 'Wyrażenie dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Protocol Type', 'Typ protokołu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Protocols', 'Protokoły', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new item added', 'Dodano nowy element', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'A new item detail added', 'Dodano nowy szczegół pozycji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Item detail updated', 'Zaktualizowano szczegóły przedmiotu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Item updated', 'Przedmiot zaktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Item removed', 'Usunięto element', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Minutes Offset', 'Minut Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Local Address', 'Lokalny adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Remote Address', 'Adres zdalny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Unsoliceted Events', 'Niezamówione wydarzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Select Timeout', 'Wybierz limit czasu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Confirm Timeout', 'Potwierdź limit czasu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Retry Timeout', 'Limit czasu ponowienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Response Timeout', 'Limit czasu odpowiedzi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Disable Unsolicated', 'Wyłącz niezamówione', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Startup Integrity', 'Integralność uruchamiania', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Integrity Overflow', 'Przepełnienie integralności', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Common Address', 'Wspólny adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Dnp3 type', 'Typ Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Event Buffer Size', 'Rozmiar bufora zdarzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Modbus type', 'Typ Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Readable', 'Czytelny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Writeable', 'Zapisywalny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Iec104 type', 'Typ Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Back', 'Z powrotem', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Next', 'Kolejny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'COMMUNICATION NETWORK', 'SIEĆ KOMUNIKACYJNA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Finish', 'Koniec', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Check connection details', 'Sprawdź szczegóły połączenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Connection Details', 'Szczegóły połączenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'GAS STATION MODEL', 'MODEL STACJI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Device List', 'Lista urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Device Form', 'Formularz urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Item', 'Pozycja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Station Address', 'Adres stacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'PAY', 'ZAPŁACIĆ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'CHECK', 'CZEK', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Stream Details', 'Szczegóły transmisji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'USE GC', 'UŻYJ GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Saved!', 'Uratowany!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'DEFINED GAS STATION MODEL', 'ZDEFINIOWANY MODEL STACJI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Capacity', 'Pojemność', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Group Name', 'Nazwa grupy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Stream Modules List', 'Lista modułów strumienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Analyzer', 'Analizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Main Station', 'Dworzec Główny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Sub Station', 'Podstacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'REPORT', 'RAPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Generate', 'Generować', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Failed to generate project', 'Nie udało się wygenerować projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Station Details', 'Szczegóły stacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'WebSocket is on', 'WebSocket jest włączony', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'WebSocket is off', 'Usługa WebSocket jest wyłączona', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'WebSocket error observed', 'Zaobserwowano błąd WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Clear browser storage', 'Wyczyść pamięć przeglądarki', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'System statistics', 'Statystyki systemu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Chatting', 'Czatowanie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Notifications', 'Powiadomienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Sign-out', 'Wyloguj się', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Hide top', 'Ukryj górę', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Are you sure you want to clear storage?', 'Czy na pewno chcesz wyczyścić pamięć?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Press SHIFT+Q to return', 'Naciśnij klawisze SHIFT + Q, aby powrócić', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Press SHIFT+W to return', 'Naciśnij klawisze SHIFT + W, aby powrócić', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'You are about to logged out. Are you sure you want to proceed?', 'Za chwilę się wylogujesz. Czy na pewno chcesz kontynuować?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
        ('sv', 'inSCADA Login', 'inSCADA-inloggning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Username', 'Användarnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Password', 'Lösenord', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Login', 'Logga in', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Language', 'Språk', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Projects', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'User Menu', 'Användarmeny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Project Map', 'Projektkarta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Devices', 'Enheter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animations', 'Animationer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarms', 'Larm', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Trends', 'Trender', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Trend Tags', 'Trend-taggar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Trend Tag', 'Trend Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Scripts', 'Skript', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Reports', 'Rapporter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Emails', 'E-post', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Logs', 'Loggar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Auth Log', 'Auth-logg', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Users', 'Användare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Help', 'Hjälp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'About', 'Handla om', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Home', 'Hem', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Connection', 'Förbindelse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Trend Graphic', 'Trendgrafik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Trend Graphics', 'Trendgrafik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Connections', 'Anslutningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Group', 'Rapportera grupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Aggregate', 'Aggregerat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Device Templates', 'Enhetsmallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Frame Templates', 'Rammallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable Templates', 'Variabla mallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Search', 'Sök', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure you want to schedule/unschedule the selected script?', 'Är du säker på att du vill schemalägga / avinstallera det valda skriptet?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Add New', 'Lägg till ny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Save', 'Spara', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Delete', 'Radera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Yes', 'Ja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'No', 'Nej', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Status', 'Status', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Properties', 'Egenskaper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure to continue?', 'Är du säker på att fortsätta?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Form data is invalid', 'Formdata är ogiltiga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Visualization', 'Visualisering', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Development', 'Utveckling', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Gas Metering', 'Gasmätning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Gas Control', 'Gaskontroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Control panel', 'Kontrollpanel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group', 'Grupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Module', 'Modul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Station Adress', 'Station Adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Protocol', 'Protokoll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Acknowledge DateTime', 'Bekräfta DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Settings', 'Inställningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'General', 'Allmän', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Start adress', 'Startadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Scan Time', 'Scan Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Device Library', 'Enhetsbibliotek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Expressions', 'Uttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variables', 'Variabler', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Wizard', 'Trollkarl', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable History', 'Variabel historik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Port', 'Hamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Timeout', 'Paus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Frames', 'Ramar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Writeable?', 'Är skrivbar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Readable?', 'Är läsbar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Buffer size', 'Buffertstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print Time', 'Utskriftstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print Day', 'Print Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print Hour', 'Utskriftstimme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Day', 'Rapportdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Time', 'Rapportera tid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Hour', 'Report Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print?', 'Skriva ut?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Add Descriptions', 'Lägg till beskrivningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Jobs', 'Jobb', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Last Execution Start Time', 'Starttid för senaste körningen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Last Execution Ended Time', 'Tid för senast genomförd slut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Next Execution Time', 'Nästa körningstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Executions Count', 'Avrättningar räknar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Project', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Name', 'Namn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Description', 'Beskrivning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Start Date', 'Start datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'End Date', 'Slutdatum', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Active?', 'Är aktiv?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Location', 'Plats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Address', 'Adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Latitude', 'Latitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Longitude', 'Longitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Contract', 'Kontrakt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Contract Day', 'Kontraktsdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Contract Hour', 'Contract Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new project added', 'Ett nytt projekt har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Project updated successfully', 'Projektet uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Project removed', 'Projekt borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Value', 'Värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure you want to continue?', 'Är du säker på att du vill fortsätta?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'HPP Unit', 'HPP-enhet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Reload', 'Ladda om', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Acknowledge', 'Erkänna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Quantity', 'Kvantitet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Type', 'Loggtyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Unit', 'Enhet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Expression Type', 'Uttryckstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Retain Flag', 'Behåll flaggan', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Word Swap', 'Word swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Byte Swap', 'Bytebyte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Load', 'Ladda', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Date Range', 'Datumintervall', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable Picker', 'Variabel plockare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Last Value', 'Senaste värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'First Value', 'Första värdet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Min Value', 'Minvärde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Value', 'Max värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Sum Value', 'Sumvärde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Count Value', 'Räkna värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Acknowledge DateTime Filter', 'Bekräfta DateTime-filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Off DateTime Filter', 'Off DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On DateTime Filter', 'On DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Search Form', 'Sökformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Interval (Second)', 'Intervall (andra)', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On', 'På', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Off', 'Av', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Live', 'Leva', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Preview', 'Förhandsvisning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Cancel', 'Avbryt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Schedule', 'Schema', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Severity', 'Logggrad', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Activity', 'Aktivitet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Source', 'Källa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Message', 'Meddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Remove', 'Ta bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'User Roles', 'Användarroller', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Role', 'Roll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Expression', 'Uttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Delay', 'Dröjsmål', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Category', 'Kategori', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On Script', 'On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new alarm added', 'Ett nytt larm har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm updated successfully', 'Larmet har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm settings is updated', 'Larminställningar har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm removed', 'Larm borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm History', 'Larmhistorik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Type', 'Typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Import', 'Importera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Date', 'Datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure you want to activate/deactivate the selected alarm?', 'Är du säker på att du vill aktivera / avaktivera det valda larmet?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure you want to Start/Stop the selected connection?', 'Är du säker på att du vill starta / stoppa den valda anslutningen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Code', 'Koda', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Priority', 'Prioritet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Period', 'Period', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log', 'Logga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new script added', 'Ett nytt skript har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Script updated successfully', 'Skriptet uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Script removed', 'Skript borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Deviation Variable', 'Avvikelse variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Total Variable', 'Total variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Calculation Type', 'Beräkningstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Order', 'Ordning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Variables', 'Rapportera variabler', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Subgroup Order', 'Undergruppsorder', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Subgroups', 'Rapportera undergrupper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group Order', 'Grupporder', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation Elements', 'Animeringselement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Parent Animation', 'Parent Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Color', 'Färg', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Duration', 'Varaktighet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Play Order', 'Spela order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Play at Main?', 'Spela på Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SVG Content', 'SVG-innehåll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation Type', 'Animationstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new animation added', 'En ny animation har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Only SVG files are allowed', 'Endast SVG-filer är tillåtna', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation updated successfully', 'Animationen har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation removed', 'Animering borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new animation element added', 'Ett nytt animationselement har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation element updated successfully', 'Animeringselement uppdaterat framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation element removed', 'Animeringselement borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Min. Scale', 'Minsta skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max. Scale', 'Max skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Thickness', 'Tjocklek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Backup', 'Säkerhetskopiering', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Restore', 'Återställ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Save & Continue', 'Spara och fortsätt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable', 'Variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Default', 'Standard', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Add', 'Lägg till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Default value', 'Standardvärde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Text', 'Text', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Title', 'Titel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Size', 'Storlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Disable', 'Inaktivera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Home View', 'Hemvy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Time', 'Tid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Second', 'Andra', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Last Executed At', 'Senast utförd kl.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please select a master record first', 'Välj först en huvudpost', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Send SMS', 'Skicka sms', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SMS Details', 'SMS-information', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SMS Service', 'SMS-tjänst', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SMS sended successfully', 'SMS skickat framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SMS Search', 'SMS-sökning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Content', 'Innehåll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SMS Settings', 'SMS-inställningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Mail sended successfully', 'E-post skickad', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'No selected animation', 'Ingen vald animering', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Recipient', 'Mottagare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Online Help', 'Online hjälp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Menu', 'Meny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm', 'Larm', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm Monitor', 'Alarm Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Smart Symbol', 'Smart symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Smart Symbols', 'Smarta symboler', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable Monitor', 'Variabel bildskärm', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm Group', 'Larmgrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm Groups', 'Larmgrupper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print When On?', 'Skriv ut när på?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print When Off?', 'Skriv ut när avstängd?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print When Ack?', 'Skriv ut när Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation', 'Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Inverse', 'Omvänd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Set Type', 'Set Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Notify', 'Meddela', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Default Color', 'Standardfärg', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Gradient', 'Lutning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Format', 'Formatera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group Size', 'Gruppstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Decimal', 'Decimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group Seperator', 'Gruppavskiljare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Decimal Seperator', 'Decimal separator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Leftpad Size', 'Leftpad Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Rightpad Size', 'Högerplattans storlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Character', 'Karaktär', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Prefix', 'Prefix', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Suffix', 'Ändelse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'tag', 'märka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Initial Pos', 'Initial Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Min Pos', 'Min pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Join', 'Ansluta sig', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Template?', 'Är mall?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation Element', 'Animeringselement', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Mouse', 'Mus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'More', 'Mer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation WebSocket is on', 'Animation WebSocket är på', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation WebSocket is off', 'Animation WebSocket är avstängt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Animation WebSocket error observed', 'WebSocket-fel observerades', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Pool Size', 'Poolstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Min Retry Delay', 'Min försök fördröjning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Retry Delay', 'Max försök fördröjning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Local Ip', 'Lokal IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Local Port', 'Lokal hamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Cot F. Length', 'Spjälsäng F. Längd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Cot Field Length', 'Cot Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'IOA Field Length', 'IOA fältlängd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Common A. Length', 'Gemensam A. längd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Common Address Field Length', 'Vanlig adressfältlängd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'IOA F. Length', 'IOA F. Längd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Originator Address', 'Adressadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Message F. Timeout', 'Meddelande F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Message Fragment Timeout', 'Timeout för meddelandefragment', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max T.N.A. Recieved', 'Max T.N.A. mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Time No Ack Received', 'Max tid ingen ack mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max T.N.A. Sent', 'Max T.N.A. Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Idle Time', 'Max tomgångstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max U. IP Recieved', 'Max U. IP mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Unconfirmed IPdus Received', 'Max obekräftad IPdus mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Start DT Timeout', 'Starta DT-timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Start DT Retries', 'Starta DT försöker igen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Coming Soon...', 'Kommer snart...', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Rack', 'Kuggstång', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Slot', 'Spår', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'No Data Transfer Selected', 'Ingen dataöverföring vald', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Destination', 'Destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Detail Form', 'Detaljformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Source Tag', 'Källkod', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Destination Tag', 'Destination Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Data Transfer', 'Dataöverföring', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Detail Transfer', 'Detaljöverföring', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Device', 'Enhet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Device Picker', 'Enhetsväljare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Import Tmpl', 'Importera tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Start Address', 'Startadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'General I. Time', 'Allmänt I. Tid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'General Interrogation Time', 'Allmän förhörstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'General Counter Interrogation Time', 'General Counter Interrogation Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Cnt Point Offset', 'Cnt Point Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Control Point Offset', 'Kontrollpunktsförskjutning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'DB Number', 'DB-nummer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'IEC104 type', 'IEC104-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Sender', 'Avsändare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Recepient', 'Mottagare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Subject', 'Ämne', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Email View', 'E-postvy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'From', 'Från', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'To', 'Till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Email Search', 'Sök via e-post', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Email Service', 'E-posttjänst', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Body', 'Kropp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Send Email', 'Skicka epost', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Send', 'Skicka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'User List', 'Användarlista', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Mail send failed', 'Skicka e-post misslyckades', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Email Settings', 'E-postinställningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Email', 'E-post', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Backup/Restore', 'Säkerhetskopiering / återställning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Choose', 'Välja', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Processes', 'Processer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Data Transfers', 'Dataöverföringar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Keywords', 'Nyckelord', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Roles', 'Roller', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Templates', 'Mallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Key', 'Nyckel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Active', 'Aktiva', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Successful ?', 'Är framgångsrik ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Auth Logs', 'Auth-loggar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'License', 'Licens', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Machine Id', 'Maskin-id', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Surname', 'Efternamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'User Limit', 'Användargräns', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Update', 'Uppdatering', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'License Key', 'Licensnyckel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'License to', 'Licens till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'License successfully activated', 'Licens har aktiverats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Failed to activate', 'Det gick inte att aktivera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm Name', 'Larmnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Start All', 'Starta alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Stop All', 'Stoppa alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Är du säker på att du vill schemalägga / avinstallera den valda dataöverföringen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Process', 'Bearbeta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'GRAPHICAL VIEW', 'GRAFISK UTSIKT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'FLOW RATE', 'FLÖDESHASTIGHET', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'METERING', 'MÄTNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'ENERGY & OTHER VALUES', 'ENERGI & ANDRA VÄRDEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'IN-USE GAS COMPONENTS', 'GASKOMPONENTER I ANVÄNDNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'TOTALISORS', 'TOTALISORS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'PREVIOUS HOURLY & DAILY VALUES', 'FÖREGÅENDE TIDLIGA & DAGLIGA VÄRDEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'ALARMS ON', 'LARM PÅ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'NAME', 'NAMN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'CURRENT', 'NUVARANDE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'IN-USE', 'I ANVÄNDNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'DOWNLOADED', 'NEDLADDAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'NORMALIZED', 'NORMALISERAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'UNIT', 'ENHET', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'PROPERTIES', 'EGENSKAPER', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'GC MANAGEMENT', 'GC-HANTERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SET', 'UPPSÄTTNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'STATUS', 'STATUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Scanned!', 'Skannad!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'deviceName', 'enhetsnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Failed to load data', 'Det gick inte att läsa in data', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'ANIMATION', 'ANIMATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'GAS METERING', 'GASMÄTNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'GAS PROPERTIES', 'GAS EGENSKAPER', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'NETWORK', 'NÄTVERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Fired Alarm Duration In Days', 'Larmets varaktighet i dagar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Fired Alarm duration is updated', 'Larmets varaktighet aktiveras', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Acknowledger', 'Bekräftare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Duration In Days', 'Loggtid i dagar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log duration is updated', 'Loggens varaktighet uppdateras', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Remove All', 'Ta bort alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Firstly load the datatable', 'Ladda först datatabellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Failed to load log data', 'Det gick inte att läsa in loggdata', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure to remove all logs?', 'Är du säker på att du tar bort alla loggar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'All logs removed', 'Alla loggar borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'An error occured while removing logs', 'Ett fel uppstod när loggar togs bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Message', 'Loggmeddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Show Weather On Click', 'Visa väder vid klick', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Updated successfully', 'Uppdateringen lyckades', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Removed successfully', 'Borttagen framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Map', 'Karta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Weather api', 'Weather api', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Interval', 'Intervall', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Filter', 'Filtrera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'SCHEDULED', 'SCHEMA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'ON', 'PÅ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'OFF', 'AV', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Print', 'Skriva ut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Failed to load!', 'Misslyckades att ladda!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Choose Trend', 'Välj trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Avg Value', 'Genomsnittligt värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Integral Value', 'Integrerat värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Calculation type', 'Beräkningstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Auto Scroll', 'Auto-scrolla', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Failed to load trend data', 'Det gick inte att ladda trenddata', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Select the Trend first', 'Välj trend först', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Interval cannot be empty', 'Intervallet kan inte vara tomt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable Duration In Days', 'Variabel varaktighet i dagar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable duration is updated', 'Variabel varaktighet uppdateras', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Frame', 'Ram', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Usual', 'Vanliga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Hourly', 'Varje timme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Daily', 'Dagligen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'CUSTOM', 'BESTÄLLNINGS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'COLLECTION', 'SAMLING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Process Form', 'Processformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Background', 'Bakgrund', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Text Color', 'Text färg', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Main Flag', 'Huvudflagga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Grid Flag', 'Grid Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Inputs', 'Ingångar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Choose Default Image', 'Välj standardbild', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'States', 'Stater', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'State Lists', 'Statliga listor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'New State', 'Ny stat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'State name', 'Statligt namn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Attach', 'Bifoga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Library', 'Bibliotek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Node updated', 'Nod uppdaterad', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Property', 'Fast egendom', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Project Property', 'Projektfastighet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Project Values', 'Projektvärden', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Stream', 'Ström', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report', 'Rapportera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please choose a period', 'Välj en period', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Name field cannot be empty!', 'Namnfältet får inte vara tomt!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please choose a report', 'Välj en rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group order cannot be empty!', 'Grupporder kan inte vara tom!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report group removed', 'Rapportgrupp har tagits bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new Report group added', 'En ny rapportgrupp har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report group updated successfully', 'Rapportgrupp har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report updated successfully', 'Rapporten uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new report added', 'En ny rapport har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report removed', 'Rapport borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please select group', 'Välj grupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report subgroup removed', 'Rapportera undergrupp borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new Report subgroup added', 'En ny rapportgrupp har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report subgroup updated successfully', 'Rapportera undergrupp har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report Variable', 'Rapportvariabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Subgroup', 'Undergrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please choose a subgroup', 'Välj en undergrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable Order', 'Variabel ordning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Variable order cannot be empty', 'Variabel ordning kan inte vara tom', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please choose calculation type', 'Välj beräkningstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please choose variable', 'Välj variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Deviation', 'Avvikelse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please select subgroup', 'Välj undergrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report variable removed', 'Rapportvariabel borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new Report variable added', 'En ny rapportvariabel har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Report variable updated successfully', 'Rapportvariabel uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Script Output', 'Skriptutmatning', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Output message', 'Output meddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Empty output', 'Tom utdata', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Error in code syntax', 'Fel i kodsyntax', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group Chat', 'Gruppchatt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Type message here', 'Skriv meddelande här', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Type message', 'Skriv meddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Refresh Periods', 'Uppdatera perioder', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Control Panel', 'Kontrollpanel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Gas Properties', 'Gasegenskaper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Network', 'Nätverk', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Graph Details', 'Grafinformation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Check All', 'Markera alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Menus', 'Menyer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Permission', 'Lov', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Permissions', 'Behörigheter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Rolename', 'Rollnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Role Menus', 'Rollmenyer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Menus are added', 'Menyer läggs till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Please select role', 'Vänligen välj roll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', ' is removed', ' är borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Role Permissions', 'Rolltillstånd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Permissions are added', 'Behörigheter läggs till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new role added', 'En ny roll tillagd', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Role updated successfully', 'Roll uppdaterad', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Role is removed', 'Roll har tagits bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Reset Password', 'Återställ lösenord', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Password Info', 'Lösenordsinfo', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'New Password', 'Nytt lösenord', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Repeat New Password', 'Upprepa nya lösenordet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Passwords are not the same', 'Lösenorden är inte samma', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Email Address', 'E-postadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'User', 'Användare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Password changed successfully', 'Lösenordet har ändrats', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Password change failed', 'Ändring av lösenord misslyckades', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Enter new value', 'Ange nytt värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Set Value', 'Satt värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Increment Value', 'Öka värdet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Send Flags', 'Skicka flaggor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'False/True', 'Falsk sann', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Decrement Value', 'Minska värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Byte Swap?', 'Är bytebyte?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Is Word Swap?', 'Är ordbyte?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Point Class', 'Point Class', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Static Variation', 'Statisk variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Event Variation', 'Event Variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Data Type', 'Data typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Bit Offset', 'Bit Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Decimal Point', 'Decimalpunkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Flags', 'Flaggor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Protocol Properties', 'Protokollegenskaper', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Raw zero scale', 'Rå nollskala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Raw full scale', 'Rå fullskala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Eng zero scale', 'Eng noll skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Eng full scale', 'Eng full skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Period', 'Loggperiod', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Threshold', 'Loggräns', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Value Expression', 'Värdeuttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Log Expression', 'Logguttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Protocol Type', 'Protokolltyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Protocols', 'Protokoll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new item added', 'Ett nytt objekt har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'A new item detail added', 'En ny artikel har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Item detail updated', 'Uppdaterad artikeldetalj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Item updated', 'Uppdaterad artikel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Item removed', 'Objekt borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Minutes Offset', 'Minute Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Local Address', 'Lokal adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Remote Address', 'Fjärradress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Unsoliceted Events', 'Oönskade händelser', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Max Controls', 'Max kontroller', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Select Timeout', 'Välj timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Confirm Timeout', 'Bekräfta timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Retry Timeout', 'Försök timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Response Timeout', 'Timeout för svar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Disable Unsolicated', 'Inaktivera olösta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Startup Integrity', 'Startup Integrity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Integrity Overflow', 'Överflöd av integritet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Common Address', 'Gemensam adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Dnp3 type', 'Dnp3-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Event Buffer Size', 'Händelsebuffertstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Modbus type', 'Modbus-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Readable', 'Läsbar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Writeable', 'Skrivbar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Iec104 type', 'Iec104-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Back', 'Tillbaka', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Next', 'Nästa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'COMMUNICATION NETWORK', 'KOMMUNIKATIONSNÄTVERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Finish', 'Avsluta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Check connection details', 'Kontrollera anslutningsinformation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Connection Details', 'Anslutningsdetaljer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'GAS STATION MODEL', 'GAS STATION MODEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Device List', 'Enhetslista', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Device Form', 'Enhetsformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Item', 'Artikel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Station Address', 'Station Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'PAY', 'BETALA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'CHECK', 'KOLLA UPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Stream Details', 'Strömdetaljer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'USE GC', 'ANVÄND GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Saved!', 'Sparat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'DEFINED GAS STATION MODEL', 'DEFINERAD BENSINSTATIONSMODELL', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Capacity', 'Kapacitet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Group Name', 'Grupp namn', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Stream Modules List', 'Stream Modules List', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Analyzer', 'Analysator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Main Station', 'Huvudstation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Sub Station', 'Substation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'REPORT', 'RAPPORTERA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Generate', 'Generera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Failed to generate project', 'Det gick inte att generera projektet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Station Details', 'Stationinformation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'WebSocket is on', 'WebSocket är på', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'WebSocket is off', 'WebSocket är avstängt', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'WebSocket error observed', 'WebSocket-fel observerat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Clear browser storage', 'Rensa webbläsarlagring', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'System statistics', 'Systemstatistik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Chatting', 'Chattar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Notifications', 'Meddelanden', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Sign-out', 'Logga ut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Hide top', 'Göm topp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Are you sure you want to clear storage?', 'Är du säker på att du vill rensa lagring?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Press SHIFT+Q to return', 'Tryck på SKIFT + Q för att återvända', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Press SHIFT+W to return', 'Tryck på SKIFT + W för att återvända', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'You are about to logged out. Are you sure you want to proceed?', 'Du håller på att logga ut. Är du säker på att du vill fortsätta?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'inSCADA Login', 'Conectare inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Username', 'Nume de utilizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Password', 'Parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Login', 'Logare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Language', 'Limba', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Projects', 'Proiecte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'User Menu', 'Meniul utilizatorului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Project Map', 'Harta proiectului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Devices', 'Dispozitive', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animations', 'Animații', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarms', 'Alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Trends', 'Tendințe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Trend Tags', 'Etichete de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Trend Tag', 'Etichetă de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Scripts', 'Scripturi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Reports', 'Rapoarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Emails', 'E-mailuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Logs', 'Jurnale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Auth Log', 'Jurnal de autentificare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Users', 'Utilizatori', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Help', 'Ajutor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'About', 'Despre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Home', 'Acasă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Connection', 'Conexiune', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Trend Graphic', 'Grafic de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Trend Graphics', 'Grafică de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Connections', 'Conexiuni', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Group', 'Grup de raportare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Aggregate', 'Agregat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Device Templates', 'Șabloane de dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Frame Templates', 'Șabloane de cadre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable Templates', 'Șabloane variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Search', 'Căutare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure you want to schedule/unschedule the selected script?', 'Sigur doriți să programați / să nu programați scriptul selectat?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Add New', 'Adăuga nou', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Save', 'Salvați', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Delete', 'Șterge', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Yes', 'Da', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'No', 'Nu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Status', 'Stare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Properties', 'Proprietăți', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure to continue?', 'Ești sigur că vei continua?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Form data is invalid', 'Datele formularului sunt nevalide', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Visualization', 'Vizualizare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Development', 'Dezvoltare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Gas Metering', 'Măsurare gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Gas Control', 'Control gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Control panel', 'Panou de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group', 'Grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Module', 'Modul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Station Adress', 'Adresa stației', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Protocol', 'Protocol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On DateTime', 'La ora dată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Acknowledge DateTime', 'Confirmați data și ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Settings', 'Setări', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'General', 'General', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Start adress', 'Începeți adresa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Scan Time', 'Scan Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Device Library', 'Biblioteca de dispozitive', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Expressions', 'Expresii', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variables', 'Variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Wizard', 'Vrăjitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable History', 'Istoria variabilă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Timeout', 'Pauză', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Frames', 'Rame', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Writeable?', 'Este scris?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Readable?', 'Este de citit?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Buffer size', 'Dimensiunea memoriei tampon', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print Time', 'Timp de imprimare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print Day', 'Ziua tipăririi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print Hour', 'Ora de tipărire', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Day', 'Ziua raportului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Time', 'Ora raportului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Hour', 'Raportați ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print?', 'Imprimare?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Add Descriptions', 'Adăugați descrieri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Jobs', 'Locuri de munca', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Last Execution Start Time', 'Ora de începere a ultimei execuții', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Last Execution Ended Time', 'Ultima perioadă de executare încheiată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Next Execution Time', 'Următorul timp de execuție', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Executions Count', 'Execuțiile contează', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Project', 'Proiect', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Name', 'Nume', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Description', 'Descriere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Start Date', 'Data de început', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'End Date', 'Data de încheiere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Active?', 'Este activ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Location', 'Locație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Address', 'Abordare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Latitude', 'Latitudine', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Longitude', 'Longitudine', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Contract', 'Contracta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Contract Day', 'Ziua contractului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Contract Hour', 'Ora contractului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new project added', 'A fost adăugat un nou proiect', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Project updated successfully', 'Proiectul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Project removed', 'Proiect eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Value', 'Valoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure you want to continue?', 'Esti sigur ca vrei sa continui?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'HPP Unit', 'Unitate HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Reload', 'Reîncarcă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Acknowledge', 'Recunoaște', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Quantity', 'Cantitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Type', 'Tip jurnal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Unit', 'Unitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Expression Type', 'Tip de expresie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Retain Flag', 'Păstrați steagul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Word Swap', 'Schimb de cuvinte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Byte Swap', 'Schimb de octeți', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Load', 'Sarcină', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Date Range', 'Interval de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable Picker', 'Selector variabil', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Last Value', 'Ultima valoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'First Value', 'Prima valoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Min Value', 'Valoare min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Value', 'Valoare maximă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Sum Value', 'Valoare sumă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Count Value', 'Valoare de numărare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Acknowledge DateTime Filter', 'Confirmați filtrul de dată și oră', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Off DateTime Filter', 'Filtru Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On DateTime Filter', 'La data și ora filtrului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Search Form', 'Formular de căutare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Interval (Second)', 'Interval (al doilea)', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On', 'Pe', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Off', 'Dezactivat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Live', 'Trăi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Preview', 'Previzualizare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Cancel', 'Anulare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Schedule', 'Programa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Severity', 'Severitatea jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Activity', 'Activitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Source', 'Sursă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Message', 'Mesaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Remove', 'Elimina', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'User Roles', 'Roluri utilizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Role', 'Rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Expression', 'Expresie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Delay', 'Întârziere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Category', 'Categorie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On Script', 'Pe script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new alarm added', 'A adăugat o nouă alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm updated successfully', 'Alarma actualizată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm settings is updated', 'Setările de alarmă sunt actualizate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm removed', 'Alarma eliminată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm History', 'Istoricul alarmelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Type', 'Tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Import', 'Import', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Date', 'Data', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure you want to activate/deactivate the selected alarm?', 'Sigur doriți să activați / dezactivați alarma selectată?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure you want to Start/Stop the selected connection?', 'Sigur doriți să porniți / opriți conexiunea selectată?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Code', 'Cod', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Priority', 'Prioritate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Period', 'Perioadă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log', 'Buturuga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new script added', 'A fost adăugat un nou script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Script updated successfully', 'Scriptul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Script removed', 'Script eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Deviation Variable', 'Variabilă de deviere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Total Variable', 'Variabilă totală', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Calculation Type', 'Tipul de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Order', 'Ordin', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Variables', 'Raportați variabilele', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Subgroup Order', 'Comandă subgrup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Subgroups', 'Raportați subgrupuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group Order', 'Comandă de grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation Elements', 'Elemente de animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Parent Animation', 'Animație părinte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Color', 'Culoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Duration', 'Durată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Play at Main?', 'Joacă la Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SVG Content', 'Conținut SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation Type', 'Tipul animației', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new animation added', 'A fost adăugată o nouă animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Only SVG files are allowed', 'Doar fișierele SVG sunt permise', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation updated successfully', 'Animația a fost actualizată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation removed', 'Animație eliminată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new animation element added', 'A fost adăugat un nou element de animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation element updated successfully', 'Element de animație actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation element removed', 'Element de animație eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Min. Scale', 'Scală min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max. Scale', 'Scală maximă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Thickness', 'Grosime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Backup', 'Backup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Restore', 'Restabili', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Save & Continue', 'Salvați și continuați', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable', 'Variabil', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Default', 'Mod implicit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Add', 'Adăuga', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Default value', 'Valoare implicită', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Text', 'Text', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Title', 'Titlu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Size', 'Mărimea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Disable', 'Dezactivează', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Home View', 'Vizualizare la domiciliu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Time', 'Timp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Second', 'Al doilea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Last Executed At', 'Ultima executare la', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please select a master record first', 'Vă rugăm să selectați mai întâi o înregistrare principală', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Send SMS', 'Trimite SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SMS Details', 'Detalii SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SMS Service', 'Serviciu SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SMS sended successfully', 'SMS trimis cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SMS Search', 'Căutare SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Content', 'Conţinut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SMS Settings', 'Setări SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Mail sended successfully', 'E-mail trimis cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'No selected animation', 'Fără animație selectată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Recipient', 'Destinatar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Online Help', 'Ajutor online', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Menu', 'Meniul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm', 'Alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm Monitor', 'Monitor alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Smart Symbol', 'Simbol inteligent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Smart Symbols', 'Simboluri inteligente', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable Monitor', 'Monitor variabil', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm Group', 'Grup de alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm Groups', 'Grupuri de alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On No Ack Color', 'Fără culoare Ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On Ack Color', 'Pe Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print When On?', 'Imprimați când este activat?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print When Off?', 'Imprimați când este oprit?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print When Ack?', 'Imprimați când Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation', 'Animaţie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Inverse', 'Invers', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Set Type', 'Set Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Notify', 'Notificați', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Default Color', 'Culoare implicită', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group Size', 'Dimensiunea grupului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Decimal', 'Zecimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group Seperator', 'Separator de grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Decimal Seperator', 'Seperator zecimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Leftpad Size', 'Dimensiunea panoului stâng', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Rightpad Size', 'Dimensiunea tastaturii dreapta', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Character', 'Caracter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Prefix', 'Prefix', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Suffix', 'Sufix', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'tag', 'etichetă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Initial Pos', 'Poziție inițială', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Min Pos', 'Min Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'On Drop', 'La picătură', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Join', 'A te alatura', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Template?', 'Șablonul este?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation Element', 'Element de animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Mouse', 'Mouse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'More', 'Mai mult', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation WebSocket is on', 'Animation WebSocket este activat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation WebSocket is off', 'Animation WebSocket este dezactivat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Animation WebSocket error observed', 'Eroare WebSocket de animație observată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Pool Size', 'Dimensiunea piscinei', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Adapter', 'Adaptor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Min Retry Delay', 'Întârziere reîncercare minimă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Retry Delay', 'Întârziere reîncercare maximă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Local Ip', 'Ip local', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Local Port', 'Port local', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Cot F. Length', 'Pat F. Lungime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Cot Field Length', 'Lungimea câmpului pătuțului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'IOA Field Length', 'Lungimea câmpului IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Common A. Length', 'Lungime comună A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Common Address Field Length', 'Lungimea câmpului de adresă comună', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'IOA F. Length', 'IOA F. Lungime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Originator Address', 'Adresa inițiatorului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Message F. Timeout', 'Mesaj F. Expirare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Message Fragment Timeout', 'Expirarea fragmentului mesajului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max T.N.A. Recieved', 'Max T.N.A. primit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Time No Ack Received', 'Timp maxim fără recepție primită', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max T.N.A. Sent', 'Max T.N.A. Trimis', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Idle Time', 'Timp maxim de inactivitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max U. IP Recieved', 'IP maxim U. primit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Unconfirmed IPdus Received', 'IPdus maxim neconfirmat primit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Start DT Timeout', 'Start DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Start DT Retries', 'Porniți reîncercări DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Coming Soon...', 'In curand...', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Rack', 'Rack', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Slot', 'Slot', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'No Data Transfer Selected', 'Nu a fost selectat niciun transfer de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Destination', 'Destinaţie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Detail Form', 'Formular de detalii', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Source Tag', 'Etichetă sursă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Destination Tag', 'Etichetă de destinație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Data Transfer', 'Transfer de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Detail Transfer', 'Transfer detaliu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Device', 'Dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Device Picker', 'Selector de dispozitive', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Import Tmpl', 'Import Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Start Address', 'Adresa de început', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'General I. Time', 'Generalul I. Timpul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'General Interrogation Time', 'Timpul general de interogare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'General Counter Interrogation Time', 'Timpul general de interogare a contracarării', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Cnt Point Offset', 'Offset Cnt Point', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Control Point Offset', 'Offset punct de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'DB Number', 'Număr DB', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'IEC104 type', 'Tip IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Sender', 'Expeditor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Recepient', 'Receptor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Subject', 'Subiect', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Email View', 'Vizualizare e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'From', 'Din', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'To', 'La', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Email Search', 'Căutare prin e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Email Service', 'Serviciu de e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Body', 'Corp', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Send Email', 'Trimite email', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Send', 'Trimite', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'User List', 'Lista de utilizatori', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Mail send failed', 'Trimiterea e-mailului a eșuat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Email Settings', 'Setări e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Backup/Restore', 'Backup / Restore', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Choose', 'Alege', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Processes', 'Procese', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Data Transfers', 'Transferuri de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Keywords', 'Cuvinte cheie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Roles', 'Roluri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Templates', 'Șabloane', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Key', 'Cheie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Active', 'Activ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Successful ?', 'Este de succes ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Auth Logs', 'Jurnaluri de autentificare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'License', 'Licență', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Machine Id', 'ID mașină', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Surname', 'Nume de familie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'User Limit', 'Limita utilizatorului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Update', 'Actualizați', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'License Key', 'Cheie de licență', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'License to', 'Licență pentru', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'License successfully activated', 'Licența a fost activată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Failed to activate', 'Activarea nu a reușit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm Name', 'Nume alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Start All', 'Începeți totul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Stop All', 'Oprește-le pe toate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Sigur doriți să programați / să nu programați transferul de date selectat?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Process', 'Proces', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'GRAPHICAL VIEW', 'VEDERE GRAFICĂ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'FLOW RATE', 'VITEZA DE DEBIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'METERING', 'MĂSURARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'ENERGY & OTHER VALUES', 'ENERGIE ȘI ALTE VALORI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'IN-USE GAS COMPONENTS', 'COMPONENTE GAZE IN UTILIZARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'TOTALISORS', 'TOTALIZATORI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'PREVIOUS HOURLY & DAILY VALUES', 'VALORI ORARE ȘI ZILNICE ANTERIOARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'ALARMS ON', 'ALARME ACTIVE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'NAME', 'NUME', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'CURRENT', 'ACTUAL', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'IN-USE', 'IN FOLOSINTA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'DOWNLOADED', 'DESCĂRCAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'NORMALIZED', 'NORMALIZAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'UNIT', 'UNITATE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'PROPERTIES', 'PROPRIETĂȚI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'GC MANAGEMENT', 'GC MANAGEMENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SET', 'A STABILIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'STATUS', 'STARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Scanned!', 'Scanat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'deviceName', 'Nume dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Failed to load data', 'Nu s-au putut încărca datele', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'ANIMATION', 'ANIMAŢIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'GAS METERING', 'MĂSURAREA GAZELOR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'GAS PROPERTIES', 'PROPRIETĂȚI CU GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'NETWORK', 'REŢEA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Fired Alarm Duration In Days', 'Durată alarmă declanșată în zile', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Fired Alarm duration is updated', 'Durata alarmei lansate este actualizată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Acknowledger', 'Recunoscător', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Duration In Days', 'Durata jurnalului în zile', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log duration is updated', 'Durata jurnalului este actualizată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Remove All', 'Inlătură tot', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Firstly load the datatable', 'În primul rând încărcați baza de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Failed to load log data', 'Nu s-au putut încărca datele jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure to remove all logs?', 'Sigur eliminați toate jurnalele?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'All logs removed', 'Toate jurnalele au fost eliminate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'An error occured while removing logs', 'A apărut o eroare la eliminarea jurnalelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Message', 'Mesaj jurnal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Show Weather On Click', 'Afișați vremea la clic', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Updated successfully', 'Actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Removed successfully', 'Eliminat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Map', 'Hartă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Map api', 'Harta API', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Weather api', 'Api meteo', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Interval', 'Interval', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Filter', 'Filtru', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'SCHEDULED', 'PROGRAMAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'ON', 'PE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'OFF', 'OFF', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Print', 'Imprimare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Failed to load!', 'Incarcarea a esuat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Choose Trend', 'Alegeți tendința', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Avg Value', 'Valoare medie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Integral Value', 'Valoare integrală', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Diff Value', 'Valoare maximă a diferenței', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Calculation type', 'Tipul de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Auto Scroll', 'Derulare automată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Failed to load trend data', 'Nu s-au putut încărca datele de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Select the Trend first', 'Selectați mai întâi tendința', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Interval cannot be empty', 'Intervalul nu poate fi gol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable Duration In Days', 'Durata variabilă în zile', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable duration is updated', 'Durata variabilei este actualizată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Frame', 'Cadru', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Usual', 'Ca de obicei', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Hourly', 'Orar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Daily', 'Zilnic', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'CUSTOM', 'PERSONALIZAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'COLLECTION', 'COLECTIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Process Form', 'Formular de proces', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Background', 'Fundal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Text Color', 'Culoarea textului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Main Flag', 'Steagul principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Grid Flag', 'Grid Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Inputs', 'Intrări', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Choose Default Image', 'Alegeți imaginea implicită', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'States', 'State', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'State Lists', 'Liste de stat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'New State', 'Stat nou', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'State name', 'Numele statului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Attach', 'Atașează', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Library', 'Bibliotecă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Node updated', 'Nod actualizat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Property', 'Proprietate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Project Property', 'Proprietatea proiectului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Project Values', 'Valorile proiectului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Stream', 'Curent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report', 'Raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please choose a period', 'Vă rugăm să alegeți o perioadă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Name field cannot be empty!', 'Câmpul de nume nu poate fi gol!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please choose a report', 'Vă rugăm să alegeți un raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group order cannot be empty!', 'Comanda de grup nu poate fi goală!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report group removed', 'Grupul de raportare a fost eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new Report group added', 'A fost adăugat un nou grup de rapoarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report group updated successfully', 'Grupul de rapoarte a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report updated successfully', 'Raportul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new report added', 'A fost adăugat un nou raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report removed', 'Raport eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please select group', 'Vă rugăm să selectați grupul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report subgroup removed', 'Raportați subgrupul eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new Report subgroup added', 'A fost adăugat un nou subgrup de rapoarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report subgroup updated successfully', 'Raportați subgrupul actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report Variable', 'Variabilă de raportare', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Subgroup', 'Subgrup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please choose a subgroup', 'Vă rugăm să alegeți un subgrup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable Order', 'Comandă variabilă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Variable order cannot be empty', 'Comanda variabilă nu poate fi goală', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please choose calculation type', 'Vă rugăm să alegeți tipul de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please choose variable', 'Vă rugăm să alegeți variabila', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Deviation', 'Deviere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please select subgroup', 'Vă rugăm să selectați subgrupul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report variable removed', 'Raport variabilă eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new Report variable added', 'A fost adăugată o nouă variabilă de raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Report variable updated successfully', 'Raport variabilă actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Script Output', 'Ieșire script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Output message', 'Mesaj de ieșire', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Empty output', 'Ieșire goală', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Error in code syntax', 'Eroare în sintaxa codului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group Chat', 'Chat de grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Type message here', 'Introduceți mesajul aici', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Type message', 'Tastați mesajul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Refresh Periods', 'Actualizați perioadele', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Control Panel', 'Panou de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Gas Properties', 'Proprietăți de gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Network', 'Reţea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Graph Details', 'Detalii grafic', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Check All', 'Selectați toate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Menus', 'Meniuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Permission', 'Permisiune', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Permissions', 'Permisiuni', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Rolename', 'Nume rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Role Menus', 'Meniuri de rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Menus are added', 'Meniurile sunt adăugate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Please select role', 'Vă rugăm să selectați rolul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', ' is removed', ' este eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Role Permissions', 'Permisiuni de rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Permissions are added', 'Permisiunile sunt adăugate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new role added', 'A fost adăugat un nou rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Role updated successfully', 'Rolul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Role is removed', 'Rolul este eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Reset Password', 'Reseteaza parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Password Info', 'Informații despre parolă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'New Password', 'Parolă Nouă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Repeat New Password', 'Repeta noua parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Passwords are not the same', 'Parolele nu sunt la fel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Email Address', 'Adresa de email', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'User', 'Utilizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Password changed successfully', 'Parola a fost schimbată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Password change failed', 'Schimbarea parolei a eșuat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Enter new value', 'Introduceți o valoare nouă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Set Value', 'Setați valoarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Increment Value', 'Valoare de creștere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Send Flags', 'Trimiteți steaguri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'False/True', 'Fals adevarat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Decrement Value', 'Decrementează valoarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Byte Swap?', 'Este Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Is Word Swap?', 'Este Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Point Class', 'Clasa punctelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Static Variation', 'Variație statică', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Event Variation', 'Variația evenimentului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Data Type', 'Tipul de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Bit Offset', 'Bit Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Decimal Point', 'Punct zecimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Flags', 'Steaguri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Protocol Properties', 'Proprietăți protocol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Raw zero scale', 'Scală zero brută', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Raw full scale', 'Raw full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Eng zero scale', 'Eng zero scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Period', 'Perioada jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Threshold', 'Prag jurnal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Value Expression', 'Expresia valorii', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Log Expression', 'Expresia jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Protocol Type', 'Tipul protocolului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Protocols', 'Protocoale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new item added', 'A fost adăugat un nou articol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'A new item detail added', 'A fost adăugat un nou detaliu de articol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Item detail updated', 'Detaliile articolului au fost actualizate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Item updated', 'Element actualizat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Item removed', 'Element eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Minutes Offset', 'Minute Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Local Address', 'Adresă locală', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Remote Address', 'Adresă la distanță', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Unsoliceted Events', 'Evenimente nesolicitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Select Timeout', 'Selectați expirarea timpului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Confirm Timeout', 'Confirmați expirarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Retry Timeout', 'Expirarea din nou a încercării', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Response Timeout', 'Expirarea răspunsului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Disable Unsolicated', 'Dezactivează nesolicitat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Startup Integrity', 'Integritate la pornire', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Integrity Overflow', 'Depășirea integrității', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Common Address', 'Adresă comună', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Dnp3 type', 'Tip Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Event Buffer Size', 'Dimensiunea bufferului pentru evenimente', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Modbus type', 'Tip Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Readable', 'Citibil', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Writeable', 'Scriere', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Iec104 type', 'Tip Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Back', 'Înapoi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Next', 'Următorul', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'COMMUNICATION NETWORK', 'REȚEA DE COMUNICARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Finish', 'Finalizarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Check connection details', 'Verificați detaliile conexiunii', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Connection Details', 'Detalii conexiune', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'GAS STATION MODEL', 'MODELUL GAZEI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Device List', 'Lista dispozitivelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Device Form', 'Formular dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Item', 'Articol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Station Address', 'Adresa stației', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'PAY', 'A PLATI', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'CHECK', 'VERIFICA', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Stream Details', 'Detalii flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'USE GC', 'USE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Saved!', 'Salvat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'DEFINED GAS STATION MODEL', 'MODEL DE GAZE DEFINIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Capacity', 'Capacitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Group Name', 'Numele Grupului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Stream Modules List', 'Lista modulelor de flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Analyzer', 'Analizor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Main Station', 'Statie principala', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Sub Station', 'Stație de metrou', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'REPORT', 'RAPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Generate', 'Genera', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Failed to generate project', 'Generarea proiectului nu a reușit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Station Details', 'Detalii stație', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'WebSocket is on', 'WebSocket este activat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'WebSocket is off', 'WebSocket este dezactivat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'WebSocket error observed', 'Eroare WebSocket observată', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Clear browser storage', 'Ștergeți spațiul de stocare al browserului', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'System statistics', 'Statistici de sistem', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Chatting', 'Chat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Notifications', 'Notificări', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Sign-out', 'Sign out', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Hide top', 'Ascundeți partea de sus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Are you sure you want to clear storage?', 'Sigur doriți să ștergeți spațiul de stocare?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Press SHIFT+Q to return', 'Apăsați SHIFT + Q pentru a reveni', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Press SHIFT+W to return', 'Apăsați SHIFT + W pentru a reveni', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'You are about to logged out. Are you sure you want to proceed?', 'Sunteți pe cale să vă deconectați. Sigur doriți să continuați?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
        ('fr', 'January', 'Janvier', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'February', 'Février', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'March', 'Mars', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'April', 'Avril', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'May', 'Peut', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'June', 'Juin', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'July', 'Juillet', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'August', 'Août', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'September', 'Septembre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'October', 'Octobre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'November', 'Novembre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'December', 'Décembre', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Sunday', 'Dimanche', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Monday', 'Lundi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Tuesday', 'Mardi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Wednesday', 'Mercredi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Thursday', 'Jeudi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Friday', 'Vendredi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Saturday', 'Samedi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Today', 'Aujourd hui', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Clear', 'Dégager', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Hours', 'Les heures', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Minutes', 'Minutes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('fr', 'Done', 'Fait', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'January', 'Styczeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'February', 'Luty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'March', 'Marsz', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'April', 'Kwiecień', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'May', 'Może', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'June', 'Czerwiec', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'July', 'Lipiec', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'August', 'Sierpień', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'September', 'Wrzesień', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'October', 'Październik', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'November', 'Listopad', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'December', 'Grudzień', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Sunday', 'Niedziela', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Monday', 'Poniedziałek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Tuesday', 'Wtorek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Wednesday', 'Środa', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Thursday', 'Czwartek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Friday', 'Piątek', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Saturday', 'Sobota', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Today', 'Dzisiaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Clear', 'Jasny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Hours', 'Godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Minutes', 'Minuty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('pl', 'Done', 'Gotowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'January', 'Januari', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'February', 'Februari', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'March', 'Mars', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'April', 'April', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'May', 'Maj', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'June', 'Juni', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'July', 'Juli', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'August', 'Augusti', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'September', 'September', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'October', 'Oktober', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'November', 'November', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'December', 'December', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Sunday', 'Söndag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Monday', 'Måndag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Tuesday', 'Tisdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Wednesday', 'Onsdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Thursday', 'Torsdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Friday', 'Fredag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Saturday', 'Lördag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Today', 'I dag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Clear', 'Klar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Hours', 'Timmar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Minutes', 'Minuter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('sv', 'Done', 'Gjort', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'January', 'Ianuarie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'February', 'Februarie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'March', 'Martie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'April', 'Aprilie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'May', 'Mai', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'June', 'Iunie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'July', 'Iulie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'August', 'August', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'September', 'Septembrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'October', 'Octombrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'November', 'Noiembrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'December', 'Decembrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Sunday', 'Duminică', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Monday', 'Luni', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Tuesday', 'Marţi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Wednesday', 'Miercuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Thursday', 'Joi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Friday', 'Vineri', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Saturday', 'Sâmbătă', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Today', 'Astăzi', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Clear', 'Clar', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Hours', 'Ore', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Minutes', 'Minute', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ro', 'Done', 'Terminat', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
        ('ps', 'inSCADA Login', 'inSCADA ننوتل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Username', 'کارن نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Password', 'رمز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Login', 'د ننه کیدل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Language', 'ژبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Projects', 'پروژې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'User Menu', ' د کارونکي غورنۍ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Project Map', 'د پروژې نقشه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Devices', 'وسیلې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animations', 'حرکتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarms', 'الارم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Trends', 'رجحانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Trend Tags', 'ټریګ ټاګز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Trend Tag', 'رجحان ټاګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Scripts', 'سکریپټونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Reports', 'راپورونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Emails', 'بریښنالیکونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Logs', 'لاګز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Auth Log', 'آته لوګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Users', 'کارونکي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Help', 'مرسته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'About', 'په اړه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Home', 'کور', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Connection', 'پیوستون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Trend Graphic', 'ترافیک ګرافیک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Trend Graphics', 'ترافیک ګرافیک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Connections', 'اړیکې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Group', 'راپور ګروپ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Aggregate', 'جمع', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Device Templates', 'د وسیلې ټیمپلیټونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Frame Templates', 'چوکاټ ټیمپلیټونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable Templates', 'تغیر لرونکي ټیمپلیټونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Search', 'لټون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure you want to schedule/unschedule the selected script?', 'ایا ته باوري یې چې ټاکل شوې سکرېپټ مهالویش / بې تنظیمول غواړې؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Add New', 'نوی اضافه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Save', 'خوندي کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Delete', 'ړنګول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Yes', 'هو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'No', 'نه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Status', 'حالت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Properties', 'ملکیتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure to continue?', 'ایا ته باوري یې چې دوام لري؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Form data is invalid', 'د فارم ډاټا غیرقانوني ده', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Visualization', 'لید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Development', 'پراختیا', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Gas Metering', ' د ګاز اندازه کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Gas Control', 'د ګاز کنټرول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Control panel', 'د تضمین اداره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group', 'ډله', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Module', 'انډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Station Adress', 'د سټیشن ادریس', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Protocol', 'پروتوکول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On DateTime', 'په نیټه ټایم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Acknowledge DateTime', 'د نیټې وخت ومنل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Settings', 'تنظیمات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'General', 'عمومي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Start adress', ' پته پیل کړه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Scan Time', 'سکین وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Device Library', 'د وسیلې کتابتون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Expressions', 'څرګندونې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variables', 'تغیرات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Wizard', 'وزرډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable History', 'متغیر تاریخ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Port', 'پورټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Timeout', 'وخت خلاص شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Frames', 'چوکاټونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Writeable?', 'ایا د لیکلو وړ دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Readable?', 'ایا د لوستلو وړ دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Buffer size', 'د بفر اندازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print Time', 'د چاپ وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print Day', 'د چاپ ورځ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print Hour', 'د چاپ وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Day', 'د راپور ورځ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Time', ' د راپور وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Hour', 'راپور راپور ساعت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print?', 'چاپ؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Add Descriptions', 'توضیحات اضافه کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Jobs', 'دندې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Last Execution Start Time', 'د اعدام کولو وروستی وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Last Execution Ended Time', 'د اعدام پای پای', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Next Execution Time', 'د اعدام کولو بل وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Executions Count', 'د اعدامونو شمیره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Project', 'پروژه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Name', 'نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Description', 'سپړنه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Start Date', 'پیل نېټه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'End Date', 'پای نیټه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Active?', 'ایا فعاله ده؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Location', 'ځای', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Address', 'پته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Latitude', 'عرض البلد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Longitude', 'عرض البلد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Contract', 'تړون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Contract Day', 'د تړون ورځ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Contract Hour', 'د تړون وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new project added', 'یوه نوې پروژه اضافه شوه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Project updated successfully', 'پروژه په بریالیتوب سره تازه شوې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Project removed', 'پروژه لرې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Value', 'ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure you want to continue?', 'ایا ته باوري یې چې دوام ورکول غواړې؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'HPP Unit', 'د HPP واحد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Reload', 'بیا ولولئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Acknowledge', 'منل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Quantity', 'مقدار', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Type', ' د خبرال ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Unit', 'واحد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Expression Type', 'د بیان ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Retain Flag', 'بیرغ ساتل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Word Swap', 'ټکی بدلول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Byte Swap', 'بایټ سویپ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Load', 'بار', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Date Range', 'د نیټې لړۍ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable Picker', 'تغیر کونکی انتخابونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Last Value', 'وروستی ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'First Value', 'لومړی ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Min Value', 'لږ ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Value', 'اعظمي ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Sum Value', ' دارزښت ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Count Value', ' د ارزښت ارزښت ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Acknowledge DateTime Filter', 'د نیټې وخت فلټر ومنئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Off DateTime Filter', ' د نیټې وخت فلټر بندول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On DateTime Filter', 'د نیټې وخت فلټر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Search Form', 'د لټون فورمه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Off DateTime', 'د نیټې وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Interval (Second)', 'وقفه (دوهم)', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On', 'پر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Off', 'بند', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Live', 'ژوندی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Preview', 'مخلید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Cancel', 'لغوه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Schedule', 'مهالویش', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Severity', 'د لوګ شدت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Activity', 'فعالیت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Source', 'سرچینه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Message', 'پیغام', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Remove', 'لرې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'User Roles', ' د کارونکي ونډې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Role', 'رول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Expression', 'اظهار', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Delay', 'ځنډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Category', 'کټګورۍ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On Script', ' په سکریپټ کې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Off Script', ' سکریپټ بند', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Ack Script', 'اک سکریپټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new alarm added', 'یو نوی الارم شامل شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm updated successfully', 'الارم په بریالیتوب سره تازه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm settings is updated', 'د الارم تنظیمات نوي شوي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm removed', 'الارم لرې شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm History', 'د الارم تاریخ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Type', 'ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Import', 'واردول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Date', 'نیټه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure you want to activate/deactivate the selected alarm?', 'ایا ته باوري یې چې غواړې ټاکل شوی الارم فعال / غیرفعال کول غواړې؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure you want to Start/Stop the selected connection?', 'ایا ته باوري یې چې ټاکل شوې اړیکه پیل کول / بندول غواړې؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Code', 'کوډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Priority', 'لومړیتوب', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Period', 'دوره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log', 'لوګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new script added', 'یو نوی سکریپټ اضافه شوې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Script updated successfully', 'سکریپټ په بریالیتوب سره تازه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Script removed', 'سکریپټ لرې شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Deviation Variable', 'انحراف بدلیدونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Total Variable', 'بشپړ تغیر ورکوونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Calculation Type', 'د محاسبې ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Order', 'امر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Variables', 'تغیرات راپور کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Subgroup Order', 'فرعي ګروپ امر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Subgroups', 'فرعي ډلې راپور کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group Order', 'د ګروپ امر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation Elements', 'د حرکت برخه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Parent Animation', 'اصلي انیمیشن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Color', 'رنګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Duration', 'موده', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Play Order', 'د لوبو امر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Play at Main?', 'په ماین لوبول؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SVG Content', 'SVG مینځپانګه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation Type', 'د انیمیشن ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new animation added', 'نوی انیمیشن شامل شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Only SVG files are allowed', 'یوازې د SVG فایلونه اجازه لري', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation updated successfully', 'انیمیشن په بریالیتوب سره تازه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation removed', 'انیمیشن لرې شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new animation element added', 'د حرکت حرکت نوی عنصر اضافه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation element updated successfully', 'د حرکت عنصر په بریالیتوب سره تازه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation element removed', 'د حرکت عنصر لرې شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Min. Scale', 'دقیقې اندازه.', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max. Scale', 'میکس. سکیل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Thickness', 'ضخامت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Backup', 'بیک اپ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Restore', 'بحال', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Save & Continue', 'خوندي کول او ادامه ورکړه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable', 'تغیر وړ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Default', 'اصلي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Add', 'اضافه کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Default value', 'اصلي ټاکي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Text', 'متن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Title', 'سرلیک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Size', 'اندازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Disable', 'ناتوان', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Home View', 'د کور لید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Time', 'وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Second', 'دوهم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Last Executed At', 'وروستی اعدام شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please select a master record first', 'مهرباني وکړئ لومړی د ماسټر ریکارډ غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Send SMS', 'پیغام واستوئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SMS Details', 'د لیکلو معلومات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SMS Service', 'د SMS خدمت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SMS sended successfully', 'لیکلي پیغامونه په بریالیتوب سره استول شوي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SMS Search', 'د SMS لټون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Content', 'مینځپانګه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SMS Settings', 'د SMS امستنې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Mail sended successfully', 'میل بریالی لیږل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'No selected animation', 'ټاکل شوی حرکت نه دی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Recipient', 'ترلاسه کوونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Online Help', 'آنلاین مرسته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Menu', 'مینو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm', 'الارم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm Monitor', 'د الارم څارونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Smart Symbol', 'سمارټ سمبول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Smart Symbols', 'سمارټ سمبولونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable Monitor', 'متغیر څارونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm Group', 'د الارم ګروپ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm Groups', 'د الارم ډلې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On No Ack Color', 'په نه اک رنګ باندې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On Ack Color', 'په اک رنګ کې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Off No Ack Color', 'د نه اک رنګ نه بهر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Off Ack Color', 'د اک رنګ نه بهر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print When On?', 'کله کله چاپ کړه؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print When Off?', 'کله بند دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print When Ack?', 'کله چې چاپ شو؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation', 'حرکت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Inverse', 'معکوس', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Set Type', 'ډول ټاکل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Notify', 'خبرداری', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Default Color', 'اصلي رنګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Gradient', 'ګراډینټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Min', 'من', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max', 'میکس', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Format', 'ب .ه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group Size', 'د ډلې کچه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Decimal', 'لسم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group Seperator', 'ګروپ سیپریټر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Decimal Seperator', 'لسیزې سیپریټر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Leftpad Size', 'کیftټایپ اندازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Rightpad Size', 'د ښی پا Sizeې اندازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Character', ' لوښه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Prefix', 'مختاړی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Suffix', 'سوفکس', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'tag', 'ټاګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Initial Pos', 'لومړنی پوسټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Min Pos', 'من پوز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Pos', 'میکس پوز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'On Drop', 'غورځول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Join', 'ګډون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Template?', 'ټیمپلیټ دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Dom Id', 'ډوم ایډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation Element', 'د حرکت برخه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Mouse', 'موږک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'More', 'نور', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation WebSocket is on', 'د حرکت متحرک ویب پاocketه روانه ده', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation WebSocket is off', 'د حرکت حرکت ویب پاocketه بنده ده', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Animation WebSocket error observed', 'د متحرک ویب ساکټ تېروتنه مشاهده شوه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Pool Size', 'د حوض اندازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Adapter', 'اډاپټر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Min Retry Delay', 'د لږترلږه هڅه کولو ځنډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Retry Delay', 'د میکس بیا ځنډ ځنډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Local Ip', 'ځایی آی پی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Local Port', 'ځایی بندر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Cot F. Length', 'کاټ ایف اوږدوالی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Cot Field Length', 'د کټ د ساحې اوږدوالی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'IOA Field Length', 'د IOA ساحې اوږدوالی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Common A. Length', 'عام الف اوږدوالی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Common Address Field Length', 'د پته د ساحې اوږدوالی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'IOA F. Length', 'IOA F. اوږدوالی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Originator Address', ' د ابتکار پته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Message F. Timeout', 'پیغام F. مهال ویش', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Message Fragment Timeout', 'د پیغام د لنډ مهال وېش', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max T.N.A. Recieved', 'میکس ټی این اے ترلاسه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Time No Ack Received', 'اعظمي وخت نه ترلاسه کیږي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max T.N.A. Sent', 'مکس T.N.A لیږل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Time No Ack Sent', 'اعظمي وخت ندی لیږل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Idle Time', 'د اعظمي بیکار وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max U. IP Recieved', 'اعظمي U. IP ترلاسه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Unconfirmed IPdus Received', 'میکس نا تایید شوی IPdus ترلاسه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Start DT Timeout', 'د ډي ټي وخت ختم کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Start DT Retries', 'د ټیټي بیا هڅه کول پیل کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Coming Soon...', 'ډېر ژر...', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Rack', 'ریک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Slot', 'سلاټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'No Data Transfer Selected', 'د معلوماتو لیږد نه دی ټاکل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Destination', 'منزل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Detail Form', ' د جزئیاتو فورمه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Source Tag', 'سرچینه ټاګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Destination Tag', 'منزل مقصود', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Data Transfer', 'د معلوماتو لیږد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Detail Transfer', 'د لیږد لیږد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Device', 'وسیله', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Device Picker', 'وسیله غوره کونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Import Tmpl', 'ټیمپل واردول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Start Address', ' پته پیل ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'General I. Time', 'عمومي I. وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'General Interrogation Time', 'د عمومي پوښتنې وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'General C.I. Time', 'عمومي سي. آی. وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'General Counter Interrogation Time', 'د مخنیوي عمومي مخنیوی وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Cnt Point Offset', 'د سینټ پوینټ آفسټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Control Point Offset', ' د کنټرول نقطه اداره ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'DB Number', 'DB شمیره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'IEC104 type', 'IEC104 ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Sender', 'لیږونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Recepient', 'رضا', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Subject', 'موضوع', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Email View', ' د بریښنالیک لید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'From', 'څخه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'To', 'ته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Email Search', ' د بریښنالیک لټون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Email Service', 'بریښنالیک خدمت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Body', 'بدن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Send Email', 'برېښنا لیک ولېږه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Send', 'استول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'User List', 'د کارونکي لیست', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Mail send failed', 'بریښنالیک لیږل ناکام شول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Email Settings', ' د بریښنالیک تنظیمات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Email', 'بریښنالیک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Backup/Restore', 'بیک اپ / بحال کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Choose', 'غوره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Processes', 'پروسې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Data Transfers', 'د معلوماتو لیږد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Keywords', 'ټکي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Roles', 'نقش', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Templates', 'کينډۍ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Key', 'کیلي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Active', 'فعال', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Successful ?', 'ایا بریالی دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Auth Logs', 'د ایتو ویسز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'License', 'جواز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Machine Id', 'ماشین ایډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Surname', 'تخلص', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'User Limit', 'د کارونکي حد', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Update', 'تازه کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'License Key', ' د جواز کیلي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'License to', 'ته جواز', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'License successfully activated', 'جواز په بریالیتوب سره فعال شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Failed to activate', 'فعالولو کې پاتې راغلل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm Name', 'د الارم نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Alarm Dsc', 'الارم Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Start All', 'ټول پیل کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Stop All', 'ټول ودروئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'ایا تاسو باوري یاست چې د ټاکل شوي ډاټا لېږد مهالویش / بې مهال ویش غواړئ؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Process', 'پروسه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'GRAPHICAL VIEW', 'ګرافیکي لید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'FLOW RATE', 'د بهېدنې کچه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'METERING', 'موندل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'ENERGY & OTHER VALUES', 'انرژي او نور ارزښتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'IN-USE GAS COMPONENTS', 'د ګاز کارول په دننه کې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'TOTALISORS', 'ټولپوښتنې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'PREVIOUS HOURLY & DAILY VALUES', 'د ماښام مخکې او ورځني ارزښتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'ALARMS ON', 'پر الارمونو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'NAME', 'نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'CURRENT', 'اوسني', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'C.HOUR', 'سي. ایچور', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'C.DAY', 'سي ډي ډي ای', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'KEY-PAD', 'کیی پیډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'IN-USE', 'IN-USE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'DOWNLOADED', ' ډاونلوډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'NORMALIZED', 'نورمال شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'UNIT', 'UNIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'PROPERTIES', 'ګټې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'GC MANAGEMENT', 'د GC اداره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SET', 'SET', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'STATUS', 'دریځ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'QRCODE Reader', 'د QRCODE لوستونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Scanned!', 'سکین شوی!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'deviceName', 'د آلې نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Failed to load data', 'د معلوماتو په پورته کولو کې پاتې راغلل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'ANIMATION', 'متحرک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'GAS METERING', 'د ګاس څارنه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'GAS PROPERTIES', 'د ګازو خصوصيات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'NETWORK', 'شبکه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Fired Alarm Duration In Days', 'د ورځو وختونو کې د الارم وخت -', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Fired Alarm duration is updated', 'د الارم شوي الارم موده تازه شوې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Acknowledger', 'منل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Duration In Days', 'په ورځو کې د ونې دوره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log duration is updated', 'د ونې موده تازه کیږي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Remove All', 'ټول لرې کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Firstly load the datatable', 'لومړی لومړی ډاټا ایبل کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Failed to load log data', 'د خبرونې اوسمهالونو په پورته کولو کې پاتې راغی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure to remove all logs?', 'ایا ته باوري یې چې ټول لوګونه لرې کوي؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'All logs removed', 'ټول خبرونه لرې شوي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'An error occured while removing logs', 'د خبرالونو لرې کولو پر مهال یوه ستونزه رامنځته شوه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Message', ' د لوګ پیغام ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Show Weather On Click', 'په کلیک باندې هوا وښایاست', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Updated successfully', 'په بریالیتوب سره تازه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Removed successfully', 'په بریالیتوب سره لرې شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Map', 'نقشه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Map api', 'میپ اپی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Weather api', 'موسمی اپی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Interval', 'وقفه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Filter', 'چاter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'SCHEDULED', 'ښوونځی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'ON', 'آن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'OFF', 'بند', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Print', 'چاپ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Failed to load!', 'پورته کولو کې پاتې راغلل!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Choose Trend', 'تمرین غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Avg Value', ' د اوسط ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Integral Value', 'بشپړ ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Diff Value', 'د مکس توپیر ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Calculation type', ' د محاسبې ډول ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Auto Scroll', 'اتومات سکرول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Failed to load trend data', 'د رجحان ډیټا په پورته کولو کې ناکام شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Select the Trend first', 'لومړی تمرین غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Interval cannot be empty', 'وقایه خالي نشی کیدی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable Duration In Days', 'په ورځو کې تغیر موندونکی وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable duration is updated', 'تغیر دوره نوي کیږي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Frame', 'چوکاټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Usual', 'معمول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Hourly', 'ساعتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Daily', 'ورځنۍ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'CUSTOM', 'ګمرک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'COLLECTION', 'ټولګه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Process Form', ' د پروسې فورمه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Background', 'شالید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Text Color', 'متن رنګ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Main Flag', 'اصلي بیرغ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Grid Flag', 'د گرډ بیرغ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Inputs', 'معلومات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Choose Default Image', 'ډیفالټ انځور غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'States', 'ایالتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'State Lists', 'دولتي لیستونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'New State', 'نوی ریاست', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'State name', 'د دولت نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Attach', 'ضمیمه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Library', 'کتابتون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Node updated', 'نوډ تازه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Property', 'ملکیت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Project Property', 'د پروژې ملکیت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Project Values', 'د پروژې ارزښتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Stream', 'جریان', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report', 'راپور', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please choose a period', 'مهرباني وکړئ یوه موده وټاکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Name field cannot be empty!', 'د نوم ساحه خالي نشي!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please choose a report', 'مهرباني وکړئ یو راپور غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group order cannot be empty!', 'د ګروپ امر خالي نشی کیدی!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report group removed', 'د راپور ګروپ حذف شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new Report group added', 'د راپور یوه نوې ډله اضافه شوه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report group updated successfully', 'د راپور ګروپ په بریالیتوب سره تازه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report updated successfully', 'راپور په بریالیتوب سره تازه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new report added', 'یو نوی راپور اضافه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report removed', 'راپور لرې شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please select group', 'مهرباني وکړئ ډله وټاکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report subgroup removed', 'د راپور ګروپ ویستل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new Report subgroup added', 'د نوي راپور فرعي ګروپ اضافه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report subgroup updated successfully', 'راپور راپور ګروپ په بریالیتوب سره تازه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report Variable', 'راپور تغیر وړ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Subgroup', 'فرعي ډلې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please choose a subgroup', 'مهرباني وکړئ یوه ټولګه وټاکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable Order', 'تغیر شوی امر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Variable order cannot be empty', 'تغیر شوی امر خالي نشی کیدی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please choose calculation type', 'مهرباني وکړئ د حساب ډول غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please choose variable', 'مهرباني وکړئ بدلون غوره کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Total', 'ټول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Deviation', 'انحراف', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please select subgroup', 'مهرباني وکړئ فرعي ډله وټاکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report variable removed', 'راپور متغیر لرې شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new Report variable added', 'د راپور نوی متغیر اضافه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Report variable updated successfully', 'راپور متغیر په بریالیتوب سره تازه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Script Output', 'سکریپټ وتنه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Output message', ' د وتلو پیغام ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Empty output', 'خالي تولید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Error in code syntax', 'د کوډ ترکیب کې تېروتنه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group Chat', 'ګروپ چیټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Type message here', 'دلته پیغام ولیکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Type message', 'پیغام ولیکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Refresh Periods', 'وختونه تازه کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Control Panel', 'د تضمین اداره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Gas Properties', ' د ګازو ملکیتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Network', ' شبکه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Graph Details', 'د ګراف توضیحات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Check All', 'ټول وګوره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Menus', 'مینو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Permission', 'اجازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Permissions', 'اجازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Rolename', 'رولینام', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Role Menus', 'د رول مینو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Menus are added', 'مینو اضافه شوې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Please select role', 'مهرباني وکړئ رول وټاکئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', ' is removed', 'لرې شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Role Permissions', 'د نقش اجازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Permissions are added', 'اجازه لیکونه اضافه شوي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new role added', 'یو نوی رول اضافه شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Role updated successfully', 'رول په بریالیتوب سره تازه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Role is removed', 'رول لیرې شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Reset Password', 'رمز له سره تنظیم کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Password Info', ' د پټنوم معلومات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'New Password', 'نوئ پټ نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Repeat New Password', 'نوی پټنوم تکرار کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Passwords are not the same', 'پاسورډونه ورته نه دي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Email Address', 'بریښنالیک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'User', 'کارن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Password changed successfully', 'رمز په بریالیتوب سره بدل شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Password change failed', 'د شفر بدلول ناکام شول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Enter new value', 'نوي ارزښت داخل کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Set Value', 'ارزښت ټاکل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Increment Value', 'د زیاتوالي ارزښت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Send Flags', 'بیرغونه واستوئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'False/True', 'غلط / ریښتینی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Decrement Value', 'د ارزښت کمول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Byte Swap?', 'ایا بایټ سویپ دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Is Word Swap?', 'ایا د الفاظ بدل دی؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Point Class', ' د ټکي ټولګي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Deadband', 'ډډ بانډ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Static Variation', 'جامد تغیرات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Event Variation', 'د پیښې بدلون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Data Type', 'د معلوماتو ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Bit Offset', 'بټ آفسیټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Decimal Point', 'لسیال ټکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Flags', 'بيرغونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Protocol Properties', ' د پروتوکول ملکیتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Raw zero scale', 'خام صفر پیمانه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Raw full scale', 'خام بشپړ پیمانه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Eng zero scale', 'انجلر صفر سکیل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Eng full scale', 'انجلی بشپړ پیمانه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Period', ' د ونې دوره', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Threshold', ' د لاګ درشل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Value Expression', 'ارزښت څرګندونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Log Expression', 'د رسنې څرګندول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Protocol Type', ' د پروټوکول ډول ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Protocols', ' پروتوکولونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new item added', 'یو نوی توکی شامل شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'A new item detail added', 'د نوي توکي توضیحات اضافه شول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Item detail updated', ' د توکي توضیحات نوي شوي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Item updated', 'توکي تازه شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Item removed', 'توکي ړنګ شو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Minutes Offset', 'دقیقې وړاندې کیږي', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'MinuteOffset', 'دقیقې آفسیټ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Local Address', 'ځایی پته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Remote Address', 'ریموٹ پته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Integrity Scantime', 'د بشپړتیا سکین وخت', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Unsoliceted Events', 'نه خپریدونکې پیښې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Max Controls', 'میکس کنټرولونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Select Timeout', 'وخت ټاکل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Confirm Timeout', ' د مهال ویش تصدیق کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Retry Timeout', ' د مهال ویش بیا هڅه وکړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Response Timeout', 'د ځواب وخت ټاکل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Event Scantime', 'د پیښې سکینټیم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Disable Unsolicated', 'نه منل شوی غیر فعال کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Startup Integrity', 'د پیل بشپړتیا', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Integrity Overflow', 'د رو Inteتیا ډیرول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Common Address', 'عام پته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Dnp3 type', 'Dnp3 ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Event Buffer Size', 'د پیښې بفر اندازه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Modbus type', 'د Modbus ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Readable', ' د لوستلو وړ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Writeable', 'د لیکلو وړ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Iec104 type', 'Iec104 ډول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Back', 'شاته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Next', 'بل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'COMMUNICATION NETWORK', 'د مخابراتو شبکه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Finish', 'پای', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Check connection details', 'د پیوستون توضیحات وګورئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Connection Details', 'د پیوستون جزئیات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'GAS STATION MODEL', 'د ګاز سټیشن موډل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Device List', 'د وسیلې لیست', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Device Form', 'د وسیلې فورمه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Item', 'توکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Station Address', ' د سټیشن پته', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'PAY', 'PAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'CHECK', 'چیک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Stream Details', 'د جریان جزیات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'USE GC', 'USC GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Saved!', 'خوندي شوی!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'DEFINED GAS STATION MODEL', 'د ګاز سټیشن موډل ټاکل شوی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Capacity', 'وړتیا', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Group Name', 'د ډلې نوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'STREAMS', 'هلې ځلې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Stream Modules List', 'د جریان انډول لیست', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Analyzer', 'تحلیل کونکی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Main Station', 'اصلي سټیشن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Sub Station', 'سب سټیشن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'REPORT', 'راپور', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Generate', 'تولید', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Failed to generate project', 'پروژه تولید نشو', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Station Details', 'د سټیشن توضیحات', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'WebSocket is on', 'ویب ساکټ فعال دی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'WebSocket is off', 'ویب ساکټ بند دی', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'WebSocket error observed', 'د ویب ساکټ تېروتنه مشاهده شوه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Clear browser storage', ' د براوزر زېرمه پاکول ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'System statistics', 'سیسټم احصایې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Chatting', 'چیټ کول', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Notifications', 'خبرتیاوې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Sign-out', 'وتون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Hide top', 'پټول پټ کړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Are you sure you want to clear storage?', 'ایا تاسو باوري یاست چې غواړئ ذخیره پاکه کړئ؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Press SHIFT+Q to return', 'بیرته ستنیدو لپاره SHIFT + Q فشار ورکړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Press SHIFT+W to return', 'بیرته راستنیدو لپاره SHIFT + W فشار ورکړئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'You are about to logged out. Are you sure you want to proceed?', 'تاسو د لاگ آؤټ کولو په لاره کې یاست. ایا تاسو باوري یاست چې پرمختګ غواړئ؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'January', 'جنوري', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'February', 'فبروري', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'March', 'مارچ', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'April', 'اپریل', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'May', 'می', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'June', 'جون', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'July', 'جولای', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'August', 'اګست', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'September', 'سپتمبر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'October', 'اکتوبر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'November', 'نومبر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'December', 'دسمبر', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Sunday', 'یک شنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Monday', 'دوشنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Tuesday', 'سه شنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Wednesday', 'چهارشنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Thursday', 'پنجشنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Friday', 'جمعه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Saturday', 'شنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Today', 'نن', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Clear', 'پاک', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Hours', 'ساعتونه', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Minutes', 'دقیقې', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('ps', 'Done', 'وشو', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
        ('en', 'inSCADA Login', 'inSCADA Login', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Username', 'Username', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Password', 'Password', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Login', 'Login', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Language', 'Language', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Projects', 'Projects', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'User Menu', 'User Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project Map', 'Project Map', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Devices', 'Devices', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animations', 'Animations', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarms', 'Alarms', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Trends', 'Trends', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Trend Tags', 'Trend Tags', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Trend Tag', 'Trend Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Scripts', 'Scripts', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Reports', 'Reports', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Emails', 'Emails', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Logs', 'Logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Auth Log', 'Auth Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Users', 'Users', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Help', 'Help', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'About', 'About', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Home', 'Home', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Connection', 'Connection', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Trend Graphic', 'Trend Graphic', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Trend Graphics', 'Trend Graphics', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Connections', 'Connections', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Group', 'Report Group', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Aggregate', 'Aggregate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Device Templates', 'Device Templates', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Frame Templates', 'Frame Templates', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable Templates', 'Variable Templates', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Search', 'Search', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure you want to schedule/unschedule the selected script?', 'Are you sure you want to schedule/unschedule the selected script?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Add New', 'Add New', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Save', 'Save', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Delete', 'Delete', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Yes', 'Yes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'No', 'No', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Status', 'Status', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Properties', 'Properties', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure to continue?', 'Are you sure to continue?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Form data is invalid', 'Form data is invalid', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Visualization', 'Visualization', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Development', 'Development', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Gas Metering', 'Gas Metering', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Gas Control', 'Gas Control', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Control panel', 'Control panel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group', 'Group', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Module', 'Module', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Station Adress', 'Station Adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Protocol', 'Protocol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Acknowledge DateTime', 'Acknowledge DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Settings', 'Settings', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'General', 'General', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Start adress', 'Start adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Scan Time', 'Scan Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Device Library', 'Device Library', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Expressions', 'Expressions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variables', 'Variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Wizard', 'Wizard', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable History', 'Variable History', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Timeout', 'Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Frames', 'Frames', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Writeable?', 'Is Writeable?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Readable?', 'Is Readable?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Buffer size', 'Buffer size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print Time', 'Print Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print Day', 'Print Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print Hour', 'Print Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Day', 'Report Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Time', 'Report Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Hour', 'Report Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print?', 'Print?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Add Descriptions', 'Add Descriptions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Jobs', 'Jobs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Last Execution Start Time', 'Last Execution Start Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Last Execution Ended Time', 'Last Execution Ended Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Next Execution Time', 'Next Execution Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Executions Count', 'Executions Count', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project', 'Project', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Name', 'Name', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Description', 'Description', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Start Date', 'Start Date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'End Date', 'End Date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Active?', 'Is Active?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Location', 'Location', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Address', 'Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Latitude', 'Latitude', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Longitude', 'Longitude', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Contract', 'Contract', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Contract Day', 'Contract Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Contract Hour', 'Contract Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new project added', 'A new project added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project updated successfully', 'Project updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project removed', 'Project removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Value', 'Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure you want to continue?', 'Are you sure you want to continue?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'HPP Unit', 'HPP Unit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Reload', 'Reload', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Acknowledge', 'Acknowledge', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Quantity', 'Quantity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Type', 'Log Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Unit', 'Unit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Expression Type', 'Expression Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Retain Flag', 'Retain Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Word Swap', 'Word Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Byte Swap', 'Byte Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Load', 'Load', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Date Range', 'Date Range', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable Picker', 'Variable Picker', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Last Value', 'Last Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'First Value', 'First Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Min Value', 'Min Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Value', 'Max Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Sum Value', 'Sum Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Count Value', 'Count Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Acknowledge DateTime Filter', 'Acknowledge DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Off DateTime Filter', 'Off DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On DateTime Filter', 'On DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Search Form', 'Search Form', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Interval (Second)', 'Interval (Second)', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On', 'On', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Off', 'Off', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Live', 'Live', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Preview', 'Preview', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Cancel', 'Cancel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Schedule', 'Schedule', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Severity', 'Log Severity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Activity', 'Activity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Source', 'Source', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Message', 'Message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Remove', 'Remove', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'User Roles', 'User Roles', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Role', 'Role', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Expression', 'Expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Delay', 'Delay', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Category', 'Category', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On Script', 'On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new alarm added', 'A new alarm added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm updated successfully', 'Alarm updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm settings is updated', 'Alarm settings is updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm removed', 'Alarm removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm History', 'Alarm History', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Type', 'Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Import', 'Import', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Date', 'Date', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure you want to activate/deactivate the selected alarm?', 'Are you sure you want to activate/deactivate the selected alarm?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure you want to Start/Stop the selected connection?', 'Are you sure you want to Start/Stop the selected connection?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Code', 'Code', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Priority', 'Priority', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Period', 'Period', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new script added', 'A new script added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Script updated successfully', 'Script updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Script removed', 'Script removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Deviation Variable', 'Deviation Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Total Variable', 'Total Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Calculation Type', 'Calculation Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Order', 'Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Variables', 'Report Variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Subgroup Order', 'Subgroup Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Subgroups', 'Report Subgroups', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group Order', 'Group Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation Elements', 'Animation Elements', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Parent Animation', 'Parent Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Color', 'Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Duration', 'Duration', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Play at Main?', 'Play at Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SVG Content', 'SVG Content', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation Type', 'Animation Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new animation added', 'A new animation added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Only SVG files are allowed', 'Only SVG files are allowed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation updated successfully', 'Animation updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation removed', 'Animation removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new animation element added', 'A new animation element added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation element updated successfully', 'Animation element updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation element removed', 'Animation element removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Min. Scale', 'Min. Scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max. Scale', 'Max. Scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Thickness', 'Thickness', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Backup', 'Backup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Restore', 'Restore', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Save & Continue', 'Save & Continue', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable', 'Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Default', 'Default', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Add', 'Add', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Default value', 'Default value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Text', 'Text', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Title', 'Title', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Size', 'Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Disable', 'Disable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Home View', 'Home View', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Time', 'Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Second', 'Second', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Last Executed At', 'Last Executed At', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please select a master record first', 'Please select a master record first', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Text:', 'Text:', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Send SMS', 'Send SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SMS Details', 'SMS Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SMS Service', 'SMS Service', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SMS sended successfully', 'SMS sended successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SMS Search', 'SMS Search', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Content', 'Content', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SMS Settings', 'SMS Settings', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Mail sended successfully', 'Mail sended successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'No selected animation', 'No selected animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Recipient', 'Recipient', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Online Help', 'Online Help', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm Monitor', 'Alarm Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Smart Symbol', 'Smart Symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Smart Symbols', 'Smart Symbols', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable Monitor', 'Variable Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm Group', 'Alarm Group', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm Groups', 'Alarm Groups', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print When On?', 'Print When On?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print When Off?', 'Print When Off?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print When Ack?', 'Print When Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation', 'Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Inverse', 'Inverse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Set Type', 'Set Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Notify', 'Notify', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Default Color', 'Default Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group Size', 'Group Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Decimal', 'Decimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group Seperator', 'Group Seperator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Decimal Seperator', 'Decimal Seperator', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Leftpad Size', 'Leftpad Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Rightpad Size', 'Rightpad Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Character', 'Character', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Prefix', 'Prefix', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Suffix', 'Suffix', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'tag', 'tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Initial Pos', 'Initial Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Min Pos', 'Min Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Join', 'Join', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Template?', 'Is Template?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation Element', 'Animation Element', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project:', 'Project:', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation:', 'Animation:', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Mouse', 'Mouse', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'More', 'More', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation WebSocket is on', 'Animation WebSocket is on', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation WebSocket is off', 'Animation WebSocket is off', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Animation WebSocket error observed', 'Animation WebSocket error observed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Pool Size', 'Pool Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Min Retry Delay', 'Min Retry Delay', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Retry Delay', 'Max Retry Delay', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Local Ip', 'Local Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Local Port', 'Local Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Cot F. Length', 'Cot F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Cot Field Length', 'Cot Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'IOA Field Length', 'IOA Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Common A. Length', 'Common A. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Common Address Field Length', 'Common Address Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'IOA F. Length', 'IOA F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Originator Address', 'Originator Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Message F. Timeout', 'Message F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Message Fragment Timeout', 'Message Fragment Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max T.N.A. Recieved', 'Max T.N.A. Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Time No Ack Received', 'Max Time No Ack Received', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max T.N.A. Sent', 'Max T.N.A. Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Idle Time', 'Max Idle Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max U. IP Recieved', 'Max U. IP Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Unconfirmed IPdus Received', 'Max Unconfirmed IPdus Received', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Start DT Timeout', 'Start DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Start DT Retries', 'Start DT Retries', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Coming Soon...', 'Coming Soon...', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Rack', 'Rack', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Slot', 'Slot', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'No Data Transfer Selected', 'No Data Transfer Selected', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Destination', 'Destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Detail Form', 'Detail Form', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Source Tag', 'Source Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Destination Tag', 'Destination Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Data Transfer', 'Data Transfer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Detail Transfer', 'Detail Transfer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Device', 'Device', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Device Picker', 'Device Picker', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Import Tmpl', 'Import Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Start Address', 'Start Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'General I. Time', 'General I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'General Interrogation Time', 'General Interrogation Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'General Counter Interrogation Time', 'General Counter Interrogation Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Cnt Point Offset', 'Cnt Point Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Control Point Offset', 'Control Point Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'DB Number', 'DB Number', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'IEC104 type', 'IEC104 type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Sender', 'Sender', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Recepient', 'Recepient', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Subject', 'Subject', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Email View', 'Email View', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'From', 'From', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'To', 'To', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Email Search', 'Email Search', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Email Service', 'Email Service', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Body', 'Body', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Send Email', 'Send Email', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Send', 'Send', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'User List', 'User List', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Mail send failed', 'Mail send failed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Email Settings', 'Email Settings', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Email', 'Email', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Backup/Restore', 'Backup/Restore', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Choose', 'Choose', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Processes', 'Processes', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Data Transfers', 'Data Transfers', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Keywords', 'Keywords', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Roles', 'Roles', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Templates', 'Templates', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Key', 'Key', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Active', 'Active', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Successful ?', 'Is Successful ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Auth Logs', 'Auth Logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'License', 'License', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Machine Id', 'Machine Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Surname', 'Surname', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'User Limit', 'User Limit', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Update', 'Update', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'License Key', 'License Key', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'License to', 'License to', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'License successfully activated', 'License successfully activated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Failed to activate', 'Failed to activate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm Name', 'Alarm Name', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Start All', 'Start All', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Stop All', 'Stop All', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Are you sure you want to schedule/unschedule the selected data transfer?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Process', 'Process', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'GRAPHICAL VIEW', 'GRAPHICAL VIEW', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'FLOW RATE', 'FLOW RATE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'METERING', 'METERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'ENERGY & OTHER VALUES', 'ENERGY & OTHER VALUES', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'IN-USE GAS COMPONENTS', 'IN-USE GAS COMPONENTS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'TOTALISORS', 'TOTALISORS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'PREVIOUS HOURLY & DAILY VALUES', 'PREVIOUS HOURLY & DAILY VALUES', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'ALARMS ON', 'ALARMS ON', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'NAME', 'NAME', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'CURRENT', 'CURRENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'IN-USE', 'IN-USE', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'DOWNLOADED', 'DOWNLOADED', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'NORMALIZED', 'NORMALIZED', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'UNIT', 'UNIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'PROPERTIES', 'PROPERTIES', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'GC MANAGEMENT', 'GC MANAGEMENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SET', 'SET', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'STATUS', 'STATUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Scanned!', 'Scanned!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'deviceName', 'deviceName', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Failed to load data', 'Failed to load data', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'ANIMATION', 'ANIMATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'GAS METERING', 'GAS METERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'GAS PROPERTIES', 'GAS PROPERTIES', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'NETWORK', 'NETWORK', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Fired Alarm Duration In Days', 'Fired Alarm Duration In Days', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Fired Alarm duration is updated', 'Fired Alarm duration is updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Acknowledger', 'Acknowledger', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Duration In Days', 'Log Duration In Days', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log duration is updated', 'Log duration is updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Remove All', 'Remove All', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Firstly load the datatable', 'Firstly load the datatable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Failed to load log data', 'Failed to load log data', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure to remove all logs?', 'Are you sure to remove all logs?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'All logs removed', 'All logs removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'An error occured while removing logs', 'An error occured while removing logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Message', 'Log Message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Show Weather On Click', 'Show Weather On Click', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Updated successfully', 'Updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Removed successfully', 'Removed successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Map', 'Map', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Weather api', 'Weather api', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Interval', 'Interval', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Filter', 'Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'SCHEDULED', 'SCHEDULED', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'ON', 'ON', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'OFF', 'OFF', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Print', 'Print', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Failed to load!', 'Failed to load!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Choose Trend', 'Choose Trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Avg Value', 'Avg Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Integral Value', 'Integral Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Calculation type', 'Calculation type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Auto Scroll', 'Auto Scroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Failed to load trend data', 'Failed to load trend data', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Select the Trend first', 'Select the Trend first', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Interval cannot be empty', 'Interval cannot be empty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable Duration In Days', 'Variable Duration In Days', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable duration is updated', 'Variable duration is updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Frame', 'Frame', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Usual', 'Usual', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Hourly', 'Hourly', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Daily', 'Daily', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'CUSTOM', 'CUSTOM', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'COLLECTION', 'COLLECTION', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Process Form', 'Process Form', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Background', 'Background', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Text Color', 'Text Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Main Flag', 'Main Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Grid Flag', 'Grid Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Inputs', 'Inputs', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Choose Default Image', 'Choose Default Image', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'States', 'States', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'State Lists', 'State Lists', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'New State', 'New State', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'State name', 'State name', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Attach', 'Attach', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Library', 'Library', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Node updated', 'Node updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Property', 'Property', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project Property', 'Project Property', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Project Values', 'Project Values', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Stream', 'Stream', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report', 'Report', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'No:', 'No:', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please, choose a period', 'Please, choose a period', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Name field cannot be empty!', 'Name field cannot be empty!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please choose a report', 'Please choose a report', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group order cannot be empty!', 'Group order cannot be empty!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report group removed', 'Report group removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new Report group added', 'A new Report group added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report group updated successfully', 'Report group updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report updated successfully', 'Report updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new report added', 'A new report added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report removed', 'Report removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please, select group', 'Please, select group', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report subgroup removed', 'Report subgroup removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new Report subgroup added', 'A new Report subgroup added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report subgroup updated successfully', 'Report subgroup updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report Variable', 'Report Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Subgroup', 'Subgroup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please choose a subgroup', 'Please choose a subgroup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable Order', 'Variable Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Variable order cannot be empty', 'Variable order cannot be empty', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please, choose calculation type', 'Please, choose calculation type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please, choose variable', 'Please, choose variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Deviation', 'Deviation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please, select subgroup', 'Please, select subgroup', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report variable removed', 'Report variable removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new Report variable added', 'A new Report variable added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Report variable updated successfully', 'Report variable updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Script Output', 'Script Output', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Output message', 'Output message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Empty output', 'Empty output', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Error in code syntax', 'Error in code syntax', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group Chat', 'Group Chat', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Type message here', 'Type message here', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Type message', 'Type message', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Refresh Periods', 'Refresh Periods', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Control Panel', 'Control Panel', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Gas Properties', 'Gas Properties', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Network', 'Network', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Graph Details', 'Graph Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Check All', 'Check All', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Menus', 'Menus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Permission', 'Permission', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Permissions', 'Permissions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Rolename', 'Rolename', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Role Menus', 'Role Menus', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Menus are added', 'Menus are added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Please, select role', 'Please, select role', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', ' is removed', ' is removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Role Permissions', 'Role Permissions', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Permissions are added', 'Permissions are added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new role added', 'A new role added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Role updated successfully', 'Role updated successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Role is removed', 'Role is removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Reset Password', 'Reset Password', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Password Info', 'Password Info', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'New Password', 'New Password', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Repeat New Password', 'Repeat New Password', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Passwords are not the same', 'Passwords are not the same', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Email Address', 'Email Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'User', 'User', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Password changed successfully', 'Password changed successfully', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Password change failed', 'Password change failed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Enter new value', 'Enter new value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Set Value', 'Set Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Increment Value', 'Increment Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Send Flags', 'Send Flags', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'False/True', 'False/True', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Decrement Value', 'Decrement Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Byte Swap?', 'Is Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Is Word Swap?', 'Is Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Point Class', 'Point Class', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Static Variation', 'Static Variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Event Variation', 'Event Variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Data Type', 'Data Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Bit Offset', 'Bit Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Decimal Point', 'Decimal Point', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Flags', 'Flags', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Protocol Properties', 'Protocol Properties', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Raw zero scale', 'Raw zero scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Raw full scale', 'Raw full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Eng zero scale', 'Eng zero scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Period', 'Log Period', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Threshold', 'Log Threshold', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Value Expression', 'Value Expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Log Expression', 'Log Expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Protocol Type', 'Protocol Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Protocols', 'Protocols', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new item added', 'A new item added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'A new item detail added', 'A new item detail added', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Item detail updated', 'Item detail updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Item updated', 'Item updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Item removed', 'Item removed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Minutes Offset', 'Minutes Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Local Address', 'Local Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Remote Address', 'Remote Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Unsoliceted Events', 'Unsoliceted Events', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Select Timeout', 'Select Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Confirm Timeout', 'Confirm Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Retry Timeout', 'Retry Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Response Timeout', 'Response Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Disable Unsolicated', 'Disable Unsolicated', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Startup Integrity', 'Startup Integrity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Integrity Overflow', 'Integrity Overflow', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Common Address', 'Common Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Dnp3 type', 'Dnp3 type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Event Buffer Size', 'Event Buffer Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Modbus type', 'Modbus type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Readable', 'Readable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Writeable', 'Writeable', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Iec104 type', 'Iec104 type', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Back', 'Back', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Next', 'Next', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'COMMUNICATION NETWORK', 'COMMUNICATION NETWORK', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Finish', 'Finish', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Check connection details', 'Check connection details', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Connection Details', 'Connection Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'GAS STATION MODEL', 'GAS STATION MODEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Device List', 'Device List', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Device Form', 'Device Form', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Item', 'Item', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Station Address', 'Station Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'PAY', 'PAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'CHECK', 'CHECK', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Stream Details', 'Stream Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'USE GC', 'USE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Saved!', 'Saved!', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'DEFINED GAS STATION MODEL', 'DEFINED GAS STATION MODEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Capacity', 'Capacity', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Group Name', 'Group Name', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Stream Modules List', 'Stream Modules List', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Analyzer', 'Analyzer', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'RTU/PLC', 'RTU/PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Main Station', 'Main Station', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Sub Station', 'Sub Station', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'REPORT', 'REPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Generate', 'Generate', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Failed to generate project', 'Failed to generate project', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Station Details', 'Station Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'WebSocket is on', 'WebSocket is on', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'WebSocket is off', 'WebSocket is off', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'WebSocket error observed', 'WebSocket error observed', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Clear browser storage', 'Clear browser storage', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'System statistics', 'System statistics', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Chatting', 'Chatting', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Notifications', 'Notifications', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Sign-out', 'Sign-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Hide top', 'Hide top', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Are you sure you want to clear storage?', 'Are you sure you want to clear storage?', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Press SHIFT+Q to return', 'Press SHIFT+Q to return', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'Press SHIFT+W to return', 'Press SHIFT+W to return', NEW.space_id, 'system_update', now(), 'system_update', now()),
        ('en', 'You are about to logged out. Are you sure you want to proceed?', 'You are about to logged out. Are you sure you want to proceed?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('tr', 'inSCADA Login', 'inSCADA Giriş', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Username', 'Kullanıcı Adı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Password', 'Şifre', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Login', 'Giriş', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Language', 'Dil', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Projects', 'Projeler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'User Menu', 'Kullanıcı Menüsü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project Map', 'Proje Haritası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Devices', 'Cihazlar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animations', 'Animasyonlar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarms', 'Alarmlar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Trends', 'Trendler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Trend Tags', 'Trend Tags/Variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Trend Tag', 'Trend Tag/Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Scripts', 'Scriptler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Reports', 'Raporlar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Emails', 'E-Postalar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Logs', 'Logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Auth Log', 'Auth Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Users', 'Kullanıcılar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Help', 'Yardım', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'About', 'Hakkında', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Home', 'Anasayfa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Connection', 'Bağlantı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Trend Graphic', 'Trend Grafik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Trend Graphics', 'Trend Grafikleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Connections', 'Bağlantılar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Group', 'Rapor Grubu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Groups', 'Rapor Grupları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Aggregate', 'Toplam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Device Templates', 'Cihaz Şablonları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Frame Templates', 'Veri Bloğu Şablonları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable Templates', 'Tag/Variable Şablonları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Search', 'Arama', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure you want to schedule/unschedule the selected script?', 'Seçili scripti zamanlamak/zamanlamamak istediğinize emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Add New', 'Ekle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Save', 'Kaydet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Delete', 'Sil', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Yes', 'Evet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'No', 'Hayır', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Status', 'Durum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Properties', 'Özellikler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure to continue?', 'Devam etmek istediğinizden emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Form data is invalid', 'Form verileri eksik veya hatalı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Visualization', 'Görselleştirme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Development', 'Geliştirme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Gas Metering', 'Gaz Ölçüm', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Gas Control', 'Gaz Kontrol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Control panel', 'Kontrol Panel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group', 'Grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Module', 'Modül', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Station Adress', 'İstasyon Adresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Protocol', 'Protokol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Acknowledge DateTime', 'Ack. DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Settings', 'Ayarlar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'General', 'Genel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Start adress', 'Başlangıç Adresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Scan Time', 'Tarama Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Device Library', 'Cihaz Kütüphanesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Expressions', 'İfadeler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variables', 'Değişkenler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Wizard', 'Sihirbaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable History', 'Değişken Geçmişi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Timeout', 'Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Frames', 'Veri Blokları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Writeable?', 'Yazılabilir mi?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Readable?', 'Okunabilir mi?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Buffer size', 'Buffer Boyutu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Print Time', 'Baskı Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Print Day', 'Baskı Günü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Print Hour', 'Baskı Saati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Day', 'Rapor Günü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Time', 'Rapor Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Hour', 'Rapor Saati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Print?', 'Baskı?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Add Descriptions', 'Açıklama Ekle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Jobs', 'Jobs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Last Execution Start Time', 'Son Çalışma Baş. Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Last Execution Ended Time', 'Son Çalışma Bit. Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Next Execution Time', 'Sonraki Çalışma Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Executions Count', 'Çalışma Sayısı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project', 'Proje', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Name', 'Ad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Description', 'Açıklama', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Start Date', 'Başlangıç Tarihi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'End Date', 'Bitiş Tarihi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Active?', 'Aktif mi?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Location', 'Lokasyon', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Address', 'Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Latitude', 'Enlem', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Longitude', 'Boylam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Contract', 'Sözleşme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Contract Day', 'Sözleşme Günü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Contract Hour', 'Sözleşme Saati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new project added', 'Yeni proje eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project updated successfully', 'Proje başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project removed', 'Proje silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Value', 'Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure you want to continue?', 'Devam etmek istediğinize emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'HPP Unit', 'HES Ünitesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Reload', 'Yeniden Yükle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Acknowledge', 'Kabul', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Quantity', 'Miktar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Type', 'Log Türü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Unit', 'Birim', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Expression Type', 'İfade Türü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Retain Flag', 'Bellekte Tutulsun', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Word Swap', 'Word Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Byte Swap', 'Byte Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Load', 'Yükle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Date Range', 'Tarih Aralığı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable Picker', 'Variable/Tag Seçici', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Last Value', 'Son Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'First Value', 'İlk Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Min Value', 'Min. Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Value', 'Max. Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Sum Value', 'Toplam Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Count Value', 'Değer Sayısı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Acknowledge DateTime Filter', 'Ack. DateTime Göre Filtrele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Off DateTime Filter', 'Off DateTime Göre Filtrele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'On DateTime Filter', 'On DateTime Göre Filtrele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Search Form', 'Arama Formu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Interval (Second)', 'Aralık (Saniye)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'On', 'On', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Off', 'Off', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Live', 'Canlı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Preview', 'Önizleme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Cancel', 'İptal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Schedule', 'Zamanlama', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Severity', 'Log Severity', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Activity', 'Aktivite', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Source', 'Kaynak', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Remove', 'Sil', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'User Roles', 'Kullanıcı Rolleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Role', 'Rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Expression', 'İfade', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Delay', 'Bekleme Süresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Category', 'Kategori', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'On Script', 'Alarm On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Off Script', 'Alarm Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Ack Script', 'Alarm Ack. Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new alarm added', 'Yeni alarm eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm updated successfully', 'Alarm başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm settings is updated', 'Alarm ayarları güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm removed', 'Alarm silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm History', 'Alarm Geçmişi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Type', 'Tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Import', 'İçe Aktar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Date', 'Tarih', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure you want to activate/deactivate the selected alarm?', 'Seçili alarmı aktifleştirmek/aktifleştirmemek istediğinizden emin misinz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure you want to Start/Stop the selected connection?', 'Seçili bağlantıyı başlatmak/durdurmak istediğinizden emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Code', 'Kod', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Priority', 'Öncelik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Period', 'Periyot', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new script added', 'Yeni script eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Script updated successfully', 'Script başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Script removed', 'Script silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Deviation Variable', 'Sapma Değişkeni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Total Variable', 'Toplam Değişken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Calculation Type', 'Hesaplama Tipi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Order', 'Sıra', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Variables', 'Rapor Değişkenleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Subgroup Order', 'Alt Grup Sırası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Subgroups', 'Rapor Alt Grupları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group Order', 'Grup Sırası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation Elements', 'Animasyon Elemanları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Parent Animation', 'Üst Animasyon', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Color', 'Renk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Duration', 'Süre', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Play Order', 'Ana Menü Sırası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Play at Main?', 'Başlangıçta Görülsün mü?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SVG Content', 'SVG İçeriği', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation Type', 'Animasyon Tipi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new animation added', 'Yeni animasyon eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Only SVG files are allowed', 'Yalnızca SVG dosyaları desteklenir', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation updated successfully', 'Animasyon başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation removed', 'Animasyon silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new animation element added', 'Yeni animasyon elemanı eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation element updated successfully', 'Animasyon elemanı başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation element removed', 'Animasyon elemanı silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Min. Scale', 'Min. Ölçek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max. Scale', 'Max. Ölçek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Thickness', 'Kalınlık', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Backup', 'Yedekle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Restore', 'İçe Aktar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Save & Continue', 'Kaydet ve Devam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable', 'Değişken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Default', 'Varsayılan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Add', 'Ekle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Default value', 'Varsayılan Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Default Value', 'Varsayılan Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Text', 'Metin', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Title', 'Başlık', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Size', 'Boyut', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Disable', 'Devre Dışı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Home View', 'Anasayfa Görünümü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Time', 'Zaman', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Second', 'Saniye', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Last Executed At', 'Son Çalıştırılma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please select a master record first', 'Lütfen önce bir kayıt seçin!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Text:', 'Metin:', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Send SMS', 'SMS Gönder', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SMS Details', 'SMS Detayları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Message', 'Mesaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SMS Service', 'SMS Servisi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SMS sended successfully', 'Mesaj başarıyla gönderildi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SMS Search', 'SMS Ara', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Content', 'İçerik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SMS Settings', 'SMS Ayarları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Mail sended successfully', 'E-posta başarıyla gönderildi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'No selected animation', 'Seçili animasyon yok', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Recipient', 'Alıcı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Online Help', 'Online Yardım', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm Monitor', 'Alarm Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Smart Symbol', 'Smart Symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Smart Symbols', 'Smart Symbols', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable Monitor', 'Variable Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm Group', 'Alarm Grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm Groups', 'Alarm Grupları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation', 'Animasyon', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Inverse', 'Tersle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Set Type', 'Tip Belirle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Notify', 'Bildir', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Default Color', 'Varsayılan Renk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Format', 'Biçim', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group Size', 'Grup Boyutu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Decimal', 'Ondalık', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group Seperator', 'Grup Ayırıcı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Decimal Seperator', 'Ondalık Ayırıcı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Leftpad Size', 'Sola Dayalı Hane', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Rightpad Size', 'Sağa Dayalı Hane', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Character', 'Karakter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Prefix', 'Önek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Suffix', 'Sonek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'tag', 'tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Initial Pos', 'Başlangıç Poz.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Min Pos', 'Min. Poz.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Pos', 'Max. Poz.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'On Drop', 'Bırakıldığında', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Join', 'Katıl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Template?', 'Şablon Mu?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation Element', 'Animasyon Elemanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project:', 'Proje:', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation:', 'Animasyon:', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'More', 'Daha Fazla', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation WebSocket is on', 'Animasyon WebSocket Açık', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation WebSocket is off', 'Animasyon WebSocket Kapalı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Animation WebSocket error observed', 'Animasyon WebSocket Hatası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Pool Size', 'Havuz Büyüklüğü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Adapter', 'Adaptör', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Min Retry Delay', 'Min Deneme Gecikmesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Retry Delay', 'Max Deneme Gecikmesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Local Ip', 'Yerel Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Local Port', 'Yerel Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Cot F. Length', 'Cot A. Uzunluk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Cot Field Length', 'Cot Alan Uzunluğu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'IOA F. Length', 'IOA A. Uzunluk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'IOA Field Length', 'IOA Alan Uzunluğu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Common A. Length', 'Ortak Adr. Uzunluk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Common Address Field Length', 'Ortak Adres Alan Uzunluğu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Originator Address', 'Gönderen Adresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Message F. Timeout', 'Mesaj F. Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Message Fragment Timeout', 'Mesaj Fragment Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max T.N.A. Recieved', 'Max Alınan T.N.A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Time No Ack Received', 'Max Alınan Time No Ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max T.N.A. Sent', 'Max Gönderilen T.N.A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Time No Ack Sent', 'Max Gönderilen Time No Ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Idle Time', 'Max Boşta Kalma Süresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max U. IP Recieved', 'Max Alınan O. IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Unconfirmed IPdus Received', 'Max Alınan Onaylanmamış IPdus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Start DT Timeout', 'DT Zaman Aşımı Başlat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Start DT Retries', 'DT Denemelerini Başlat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Coming Soon...', 'Çok Yakında...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Rack', 'Rack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Slot', 'Slot', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'No Data Transfer Selected', 'Data Trasfer Seçilmedi!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Destination', 'Hedef', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Detail Form', 'Detay Formu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Source Tag', 'Kaynak Variable/Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Destination Tag', 'Hedef Variable/Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Data Transfer', 'Veri Transferi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Detail Transfer', 'Transfer Detayı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Device', 'Cihaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Device Picker', 'Cihaz Seçici', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Import Tmpl', 'Şablonu İçe Aktar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Start Address', 'Başlangıç Adresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'General I. Time', 'General I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'General Interrogation Time', 'Genel Sorgu Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'General Counter Interrogation Time', 'Genel Karşı Sorgu Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Cnt Point Offset', 'Knt Noktası Ofset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Control Point Offset', 'Kontrol Noktası Ofset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'DB Number', 'DB Numarası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'IEC104 type', 'IEC104 tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Sender', 'Gönderen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Recepient', 'Alıcı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Subject', 'Konu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Email View', 'E-Posta Ekranı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'From', 'Kimden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'To', 'Kime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Email Search', 'E-Posta Ara', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Email Service', 'E-Posta Servisi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Body', 'Metin', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Send Email', 'E-Posta Gönder', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Send', 'Gönder', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'User List', 'Kullanıcı Listesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Mail send failed', 'E-Posta Gönderilemedi!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Email Settings', 'E-Posta Ayarları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Email', 'E-Posta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Backup/Restore', 'Yedekle/İçe Aktar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Choose', 'Seç', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Processes', 'Süreçler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Data Transfers', 'Veri Transferleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Keywords', 'Anahtar Kelimeler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Roles', 'Roller', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Templates', 'Şablonlar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Key', 'Anahtar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Active', 'Aktif', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Successful ?', 'Başarılı mı ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Auth Logs', 'Auth Logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'License', 'Lisans', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Machine Id', 'Makine Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Surname', 'Soyad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'User Limit', 'Kullanıcı Limit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Update', 'Güncelle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'License Key', 'Lisans Anahtarı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'License to', 'Lisansla', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'License successfully activated', 'Lisans başarıyla aktifleştirildi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Failed to activate', 'Aktivasyon hatası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm Name', 'Alarm Adı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Alarm Dsc', 'Alarm Açıklaması', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Start All', 'Hepsini Başlat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Stop All', 'Hepsini Durdur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Seçili veri transferini zamanlamak/zamanlamamak istediğinize emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Process', 'Süreç', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'GRAPHICAL VIEW', 'GRAFİKSEL GÖRÜNÜM', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'FLOW RATE', 'AKIŞ HIZI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'METERING', 'ÖLÇÜM', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'ENERGY & OTHER VALUES', 'ENERJİ & DİĞER DEĞERLER', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'IN-USE GAS COMPONENTS', 'KULLANIMDA OLAN GAZ BİLEŞENLERİ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'TOTALISORS', 'TOPLAYICILAR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'PREVIOUS HOURLY & DAILY VALUES', 'SAATLİK & GÜNLÜK DEĞERLER', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'ALARMS ON', 'ALARMS ON', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'NAME', 'NAME', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'CURRENT', 'ANLIK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'C.HOUR', 'SAATLİK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'P.HOUR', 'GEÇEN SAAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'C.DAY', 'BUGÜN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'P.DAY', 'DÜN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'IN-USE', 'IN-USE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'DOWNLOADED', 'DOWNLOADED', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'NORMALIZED', 'NORMALIZED', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'UNIT', 'BİRİM', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'PROPERTIES', 'ÖZELLİKLER', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'GC MANAGEMENT', 'GC YÖNETİMİ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SET', 'AYAR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'STATUS', 'DURUM', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'QRCODE Reader', 'QRKOD Okuyucu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Scanned!', 'Tarandı!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'deviceName', 'cihazAdı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Failed to load data', 'Veri yüklenirken hata oluştu!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'ANIMATION', 'ANİMASYON', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'GAS METERING', 'GAZ ÖLÇÜM', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'GAS PROPERTIES', 'GAZ ÖZELLİKLERİ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'NETWORK', 'AĞ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Fired Alarm Duration In Days', 'Fired Alarm Duration In Days', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Fired Alarm duration is updated', 'Fired Alarm duration is updated', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Acknowledger', 'Onaylayan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Dsc', 'Açıklama', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Duration In Days', 'Log Süresi (Gün)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log duration is updated', 'Log süresi güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Remove All', 'Hepsini Sil', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Firstly load the datatable', 'Önce veri tablosu yüklenmeli!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Failed to load log data', 'Log verileri yüklenemedi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure to remove all logs?', 'Bütün logları silmek istediğinize emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'All logs removed', 'Bütün loglar silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'An error occured while removing logs', 'Logları silerken bir hata meydana geldi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Message', 'Log Mesajı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Show Weather On Click', 'Tıklandığında Hava Durumunu Göster', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Updated successfully', 'Başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Removed successfully', 'Başarıyla silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Map', 'Harita', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Map api', 'Harita api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Weather api', 'Hava Durumu api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Interval', 'Aralık', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Filter', 'Filtre', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'SCHEDULED', 'ZAMANLANDI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'ON', 'ON', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'OFF', 'OFF', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Print', 'Yazdır', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Failed to load!', 'Yükleme başarısız!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Choose Trend', 'Trend Seç', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Avg Value', 'Ortalama Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Integral Value', 'Integral', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Diff Value', 'Max Fark Değer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Calculation type', 'Hesaplama Tipi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Auto Scroll', 'Otomatik Kaydırma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Failed to load trend data', 'Trend verisi yüklenemedi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Select the Trend first', 'Önce Trend seçilmeli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Interval cannot be empty', 'Aralık değeri boş bırakılamaz!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable Duration In Days', 'Değişken Süresi (Gün)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable duration is updated', 'Değişken süresi güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Frame', 'Veri Bloğu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Usual', 'Klasik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Hourly', 'Saatlik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Daily', 'Günlük', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'CUSTOM', 'ÖZEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'COLLECTION', 'KOLEKSİYON', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Process Form', 'Süreç Formu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Background', 'Arka plan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Text Color', 'Yazı Rengi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Main Flag', 'Ana Bayrak', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Grid Flag', 'Grid Bayrağı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Inputs', 'Girişler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Choose Default Image', 'Varsayılan Resim Seçimi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'States', 'Koşullar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'State Lists', 'Koşul Listesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'New State', 'Yeni Koşul', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'State name', 'Koşul Adı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Attach', 'Ekle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Library', 'Kütüphane', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Node updated', 'Node güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Property', 'Özellik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project Property', 'Proje Özelliği', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Project Values', 'Proje Değerleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Stream', 'Akış', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report', 'Rapor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'No:', 'No:', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please, choose a period', 'Lütfen bir periyot seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Name field cannot be empty!', 'Ad alanı boş bırakılamaz!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please choose a report', 'Lütfen bir rapor seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group order cannot be empty!', 'Grup sırası boş bırakılamaz!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report group removed', 'Rapor grubu silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new Report group added', 'Yeni rapor grubu eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report group updated successfully', 'Rapor grubu başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report updated successfully', 'Rapor başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new report added', 'Yeni rapor eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report removed', 'Rapor silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please, select group', 'Lütfen bir grup seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report subgroup removed', 'Rapor alt grubu silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new Report subgroup added', 'Yeni rapor alt grubu eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report subgroup updated successfully', 'Rapor alt grubu başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report Variable', 'Rapor Değişkeni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Subgroup', 'Alt Grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please choose a subgroup', 'Lütfen bir alt grup seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable Order', 'Değişken Sırası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Variable order cannot be empty', 'Değişken Sırası boş bırakılamaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please, choose calculation type', 'Lütfen hesaplama tipini seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please, choose variable', 'Lütfen değişken seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Total', 'Toplam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Deviation', 'Sapma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please, select subgroup', 'Lütfen alt grup seçiniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report variable removed', 'Rapor değişkeni silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new Report variable added', 'Yeni rapor değişkeni eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Report variable updated successfully', 'Rapor değişkeni başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Script Output', 'Script Çıktısı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Output message', 'Çıktı Mesajı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Empty output', 'Boş Çıktı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Error in code syntax', 'Kod yazımında hata var', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group Chat', 'Grup Sohbeti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Type message here', 'Mesajınızı buraya yazınız', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Type message', 'Mesaj giriniz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Refresh Periods', 'Periyotları Yenile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Control Panel', 'Kontrol Panel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Gas Properties', 'Gaz Özellikleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Network', 'Ağ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Graph Details', 'Grafik Detayları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Check All', 'Hepsini Seç', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Menus', 'Menüler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Permission', 'Yetki', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Permissions', 'Yetkiler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Rolename', 'Rol Adı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Role Menus', 'Rol Menüleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Menus are added', 'Menüler eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Please, select role', 'Lütfen bir rol seçin', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', ' is removed', ' silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Role Permissions', 'Rol Yetkileri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Permissions are added', 'Yetkiler eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new role added', 'Yeni rol eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Role updated successfully', 'Rol başarıyla güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Role is removed', 'Rol silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Reset Password', 'Parola Sıfırla', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Password Info', 'Parola Bilgisi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'New Password', 'Yeni Parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Repeat New Password', 'Tekrar Yeni Parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Passwords are not the same', 'Parolalar aynı değil', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Email Address', 'E-Posta Adresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'User', 'Kullanıcı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Password changed successfully', 'Parola başarıyla değiştirildi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Password change failed', 'Parola değiştirilemedi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Enter new value', 'Yeni değer girin', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Set Value', 'Değer Ata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Increment Value', 'Artış Değeri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Send Flags', 'Bayrakları Gönder', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'False/True', 'Yanlış/Doğru', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Decrement Value', 'Azalma Değeri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Byte Swap?', 'Byte takas edilsin mi?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Is Word Swap?', 'Word takas edilsin mi?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Point Class', 'Nokta Sınıfı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Deadband', 'Ölü Bant', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Static Variation', 'Statik Varyasyon', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Event Variation', 'Olay Varyasyonu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Data Type', 'Veri Tipi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Bit Offset', 'Bit Ofset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Decimal Point', 'Ondalık Nokta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Flags', 'Bayraklar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Protocol Properties', 'Protokol Özellikleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Scale', 'Ölçek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Raw zero scale', 'Ham Sıfır Ölçeği', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Raw full scale', 'Ham Tam Ölçek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Eng zero scale', 'Eng Sıfır Ölçeği', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Eng full scale', 'Eng Tam Ölçek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Period', 'Log Periyodu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Threshold', 'Log Eşiği', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Value Expression', 'Değer İfadesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Log Expression', 'Log İfadesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Protocol Type', 'Protokol Tipi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Protocols', 'Protokoller', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new item added', 'Yeni nesne eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'A new item detail added', 'Yeni nesne detayı eklendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Item detail updated', 'Nesne detayı güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Item updated', 'Nesne güncellendi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Item removed', 'Nesne silindi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Minutes Offset', 'Ofset(Dakika)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'MinuteOffset', 'Ofset(Dakika)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Local Address', 'Yerel Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Remote Address', 'Uzak Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Integrity Scantime', 'Tarama Sür. Bütünlüğü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Unsoliceted Events', 'İstenmeyen Olaylar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Max Controls', 'Max. Kontrol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Select Timeout', 'Seçim Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Confirm Timeout', 'Onaylama Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Retry Timeout', 'Deneme Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Response Timeout', 'Yanıt Zaman Aşımı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Event Scantime', 'Olay Tarama Zamanı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Disable Unsolicated', 'İstenmeyen Olayları Devre Dışı Bırak', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Startup Integrity', 'Başlangıç Bütünlüğü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Integrity Overflow', 'Bütünlük Taşması', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Common Address', 'Ortak Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Dnp3 type', 'Dnp3 tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Event Buffer Size', 'Event Buffer Boyutu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Modbus type', 'Modbus tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Readable', 'Okunabilir', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Writeable', 'Yazılabilir', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Iec104 type', 'Iec104 tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Back', 'Geri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Next', 'İleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'COMMUNICATION NETWORK', 'İLETİŞİM AĞI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Finish', 'Bitti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Check connection details', 'Bağlantı detaylarını kontrol edin', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Connection Details', 'Bağlantı Detayları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'GAS STATION MODEL', 'GAZ İSTASYON MODELİ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Device List', 'Cihaz Listesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Device Form', 'Cihaz Formu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Item', 'Nesne', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Station Address', 'İstasyon Adresi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'PAY', 'PAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'CHECK', 'CHECK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Stream Details', 'Akış Detayları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'USE GC', 'USE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Saved!', 'Kaydedildi!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'DEFINED GAS STATION MODEL', 'TANIMLANMIŞ GAZ İSTASYON MODELİ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Capacity', 'Kapasite', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Group Name', 'Grup Adı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'STREAMS', 'AKIŞLAR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Stream Modules List', 'Akış Modül Listesi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Analyzer', 'Analizör', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'RTU/PLC', 'RTU/PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Main Station', 'Ana İstasyon', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Sub Station', 'Alt İstasyon', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'REPORT', 'RAPOR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Generate', 'Oluştur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Failed to generate project', 'Proje oluşturulamadı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Station Details', 'İstasyon Detayları', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'WebSocket is on', 'WebSocket Açık', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'WebSocket is off', 'WebSocket Kapalı', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'WebSocket error observed', 'WebSocket Hatası', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Clear browser storage', 'Tarayıcı hafızasını temizle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'System statistics', 'Sistem istatistikleri', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Chatting', 'Sohbet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Notifications', 'Bildirimler', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Sign-out', 'Oturumu Kapat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Hide top', 'Gizle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Are you sure you want to clear storage?', 'Hafızayı temizlemek istediğinize emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Press SHIFT+Q to return', 'Dönmek için SHIFT+Q ya basın', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'Press SHIFT+W to return', 'Dönmek için SHIFT+W ya basın', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('tr', 'You are about to logged out. Are you sure you want to proceed?', 'Çıkış yapmak üzeresiniz. Devam etmek istediğinizden emin misiniz?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('es', 'inSCADA Login', 'Inicio de sesión inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Username', 'Nombre de usuario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Password', 'Contraseña', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Login', 'Iniciar sesión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Language', 'Idioma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Projects', 'Proyectos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'User Menu', 'Menú del Usuario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Project Map', 'Mapa del proyecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Devices', 'Dispositivos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animations', 'Animaciones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarms', 'Alarmas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Trends', 'Tendencias', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Trend Tags', 'Etiquetas de tendencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Trend Tag', 'Etiqueta de tendencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Scripts', 'Guiones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Reports', 'Informes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Emails', 'Correos electrónicos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Logs', 'Registros', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Auth Log', 'Registro de autenticación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Users', 'Usuarios', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Help', 'Ayuda', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'About', 'Acerca de', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Home', 'Casa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Connection', 'Conexión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Trend Graphic', 'Gráfico de tendencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Trend Graphics', 'Gráficos de tendencias', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Connections', 'Conexiones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Group', 'Grupo de informes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Aggregate', 'Agregar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Device Templates', 'Plantillas de dispositivos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Frame Templates', 'Plantillas de marcos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable Templates', 'Plantillas variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Search', 'Buscar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure you want to schedule/unschedule the selected script?', '¿Está seguro de que desea programar / anular la programación del guión seleccionado?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Add New', 'Agregar nuevo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Save', 'Salvar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Delete', 'Eliminar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Yes', 'Si', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'No', 'No', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Status', 'Estado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Properties', 'Propiedades', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure to continue?', '¿Estás seguro de continuar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Form data is invalid', 'Los datos del formulario no son válidos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Visualization', 'Visualización', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Development', 'Desarrollo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Gas Metering', 'Medición de gas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Gas Control', 'Control de gas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Control panel', 'Panel de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group', 'Grupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Module', 'Módulo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Station Adress', 'Dirección de la estación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Protocol', 'Protocolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On DateTime', 'En DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Acknowledge DateTime', 'Reconocer fecha y hora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Settings', 'Configuración', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'General', 'General', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Start adress', 'Dirección de inicio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Scan Time', 'Tiempo de escaneo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Device Library', 'Biblioteca de dispositivos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Expressions', 'Expresiones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variables', 'Variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Wizard', 'Mago', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable History', 'Historial de variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Port', 'Puerto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Timeout', 'Se acabó el tiempo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Frames', 'Marcos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Writeable?', '¿Se puede escribir?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Readable?', '¿Es legible?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Buffer size', 'Tamaño del búfer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print Time', 'Tiempo de impresión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print Day', 'Día de impresión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print Hour', 'Hora de impresión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Day', 'Día del informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Time', 'Hora del informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Hour', 'Hora del informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print?', '¿Impresión?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Add Descriptions', 'Agregar descripciones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Jobs', 'Trabajos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Last Execution Start Time', 'Hora de inicio de la última ejecución', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Last Execution Ended Time', 'Hora de finalización de la última ejecución', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Next Execution Time', 'Próxima hora de ejecución', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Executions Count', 'Las ejecuciones cuentan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Project', 'Proyecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Name', 'Nombre', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Description', 'Descripción', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Start Date', 'Fecha de inicio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'End Date', 'Fecha final', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Active?', '¿Está activo?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Location', 'Ubicación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Address', 'Habla a', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Latitude', 'Latitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Longitude', 'Longitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Contract', 'Contrato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Contract Day', 'Día del contrato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Contract Hour', 'Hora del contrato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new project added', 'Un nuevo proyecto agregado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Project updated successfully', 'Proyecto actualizado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Project removed', 'Proyecto eliminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Value', 'Valor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure you want to continue?', '¿Estás seguro de que quieres continuar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'HPP Unit', 'Unidad HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Reload', 'Recargar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Acknowledge', 'Reconocer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Quantity', 'Cantidad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Type', 'Tipo de registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Unit', 'Unidad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Expression Type', 'Tipo de expresión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Retain Flag', 'Conservar la bandera', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Word Swap', 'Intercambio de palabras', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Byte Swap', 'Intercambio de bytes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Load', 'Carga', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Date Range', 'Rango de fechas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable Picker', 'Selector de variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Last Value', 'Último valor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'First Value', 'Primer valor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Min Value', 'Valor mínimo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Value', 'Valor máximo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Sum Value', 'Valor de suma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Count Value', 'Valor de recuento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Acknowledge DateTime Filter', 'Confirmar filtro de fecha y hora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Off DateTime Filter', 'Filtro de fecha y hora desactivado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On DateTime Filter', 'En filtro de fecha y hora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Search Form', 'Formulario de búsqueda', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Interval (Second)', 'Intervalo (segundo)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On', 'En', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Off', 'Apagado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Live', 'En Vivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Preview', 'Avance', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Cancel', 'Cancelar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Schedule', 'Calendario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Severity', 'Gravedad del registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Activity', 'Actividad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Source', 'Fuente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Message', 'Mensaje', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Remove', 'Eliminar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'User Roles', 'Roles del usuario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Role', 'Papel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Expression', 'Expresión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Delay', 'Retrasar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Category', 'Categoría', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On Script', 'En el guión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Off Script', 'Fuera de secuencia de comandos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new alarm added', 'Se agregó una nueva alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm updated successfully', 'Alarma actualizada correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm settings is updated', 'Se actualizó la configuración de alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm removed', 'Alarma eliminada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm History', 'Historial de alarmas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Type', 'Tipo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Import', 'Importar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Date', 'Fecha', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure you want to activate/deactivate the selected alarm?', '¿Está seguro de que desea activar / desactivar la alarma seleccionada?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure you want to Start/Stop the selected connection?', '¿Está seguro de que desea iniciar / detener la conexión seleccionada?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Code', 'Código', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Priority', 'Prioridad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Period', 'Período', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log', 'Iniciar sesión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new script added', 'Se agregó un nuevo guión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Script updated successfully', 'Secuencia de comandos actualizada correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Script removed', 'Secuencia de comandos eliminada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Deviation Variable', 'Variable de desviación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Total Variable', 'Variable total', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Calculation Type', 'Tipo de cálculo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Order', 'Orden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Variables', 'Variables de informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Subgroup Order', 'Orden de subgrupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Subgroups', 'Subgrupos de informes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group Order', 'Orden de grupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation Elements', 'Elementos de animación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Parent Animation', 'Animación para padres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Color', 'Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Duration', 'Duración', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Play Order', 'Orden de reproducción', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Play at Main?', '¿Jugar en Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SVG Content', 'Contenido SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation Type', 'Tipo de animación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new animation added', 'Se agregó una nueva animación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Only SVG files are allowed', 'Solo se permiten archivos SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation updated successfully', 'Animación actualizada correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation removed', 'Animación eliminada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new animation element added', 'Se agregó un nuevo elemento de animación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation element updated successfully', 'Elemento de animación actualizado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation element removed', 'Elemento de animación eliminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Min. Scale', 'Escala mínima', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max. Scale', 'Escala máx.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Thickness', 'Grosor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Backup', 'Apoyo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Restore', 'Restaurar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Save & Continue', 'Guardar Continuar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable', 'Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Default', 'Defecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Add', 'Añadir', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Default value', 'Valor por defecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Text', 'Texto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Title', 'Título', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Size', 'Talla', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Disable', 'Inhabilitar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Home View', 'Vista de inicio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Time', 'Hora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Second', 'Segundo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Last Executed At', 'Último ejecutado en', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please select a master record first', 'Seleccione primero un registro maestro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Send SMS', 'Enviar SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SMS Details', 'Detalles de SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SMS Service', 'Servicio SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SMS sended successfully', 'SMS enviado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SMS Search', 'Búsqueda por SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Content', 'Contenido', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SMS Settings', 'Configuración de SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Mail sended successfully', 'Correo enviado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'No selected animation', 'No hay animación seleccionada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Recipient', 'Recipiente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Online Help', 'Ayuda en linea', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Menu', 'Menú', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm', 'Alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm Monitor', 'Monitor de alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Smart Symbol', 'Símbolo inteligente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Smart Symbols', 'Símbolos inteligentes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable Monitor', 'Monitor variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm Group', 'Grupo de alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm Groups', 'Grupos de alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On No Ack Color', 'En color sin reconocimiento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print When On?', '¿Imprimir cuando está activado?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print When Off?', '¿Imprimir cuando está desactivado?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print When Ack?', 'Imprimir cuando Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation', 'Animación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Inverse', 'Inverso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Set Type', 'Establecer tipo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Notify', 'Notificar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Default Color', 'Color predeterminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Gradient', 'Degradado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Format', 'Formato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group Size', 'Tamaño del grupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Decimal', 'Decimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group Seperator', 'Separador de grupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Decimal Seperator', 'Separador decimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Leftpad Size', 'Tamaño del panel izquierdo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Rightpad Size', 'Tamaño del panel derecho', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Character', 'Personaje', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Prefix', 'Prefijo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Suffix', 'Sufijo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'tag', 'etiqueta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Initial Pos', 'Posición inicial', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Min Pos', 'Posición mínima', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Pos', 'Pos. Máx.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Join', 'Unirse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Template?', '¿Es Template?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation Element', 'Elemento de animación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Mouse', 'Ratón', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'More', 'Más', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation WebSocket is on', 'La animación WebSocket está activada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation WebSocket is off', 'La animación WebSocket está desactivada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Animation WebSocket error observed', 'Error de animación de WebSocket observado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Pool Size', 'Tamaño de la piscina', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Adapter', 'Adaptador', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Min Retry Delay', 'Retraso mínimo de reintento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Retry Delay', 'Retraso máximo de reintento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Local Ip', 'IP local', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Local Port', 'Puerto local', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Cot F. Length', 'Cuna F. Longitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Cot Field Length', 'Longitud del campo de la cuna', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'IOA Field Length', 'Longitud del campo IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Common A. Length', 'Longitud común A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Common Address Field Length', 'Longitud del campo de dirección común', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'IOA F. Length', 'IOA F. Longitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Originator Address', 'Dirección del remitente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Message F. Timeout', 'Mensaje F. Tiempo de espera', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Message Fragment Timeout', 'Tiempo de espera del fragmento de mensaje', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max T.N.A. Recieved', 'Max T.N.A. Recibido', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Time No Ack Received', 'Tiempo máximo sin reconocimiento recibido', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max T.N.A. Sent', 'Max T.N.A. enviado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Time No Ack Sent', 'Tiempo máximo sin confirmación de envío', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Idle Time', 'Max Idle Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max U. IP Recieved', 'IP U. máx. Recibida', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Unconfirmed IPdus Received', 'Máximo de IPdus no confirmados recibidos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Start DT Timeout', 'Iniciar tiempo de espera de DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Start DT Retries', 'Iniciar reintentos de DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Coming Soon...', 'Próximamente...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Rack', 'Estante', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Slot', 'Espacio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'No Data Transfer Selected', 'Sin transferencia de datos seleccionada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Destination', 'Destino', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Detail Form', 'Formulario de detalles', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Source Tag', 'Etiqueta de origen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Destination Tag', 'Etiqueta de destino', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Data Transfer', 'Transferencia de datos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Detail Transfer', 'Transferencia de detalles', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Device', 'Dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Device Picker', 'Selector de dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Import Tmpl', 'Importar Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Start Address', 'Dirección de inicio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'General I. Time', 'General I. Tiempo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'General Interrogation Time', 'Tiempo de interrogatorio general', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'General Counter Interrogation Time', 'Tiempo de interrogación del contador general', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Cnt Point Offset', 'Desplazamiento del punto Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Control Point Offset', 'Desplazamiento del punto de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'DB Number', 'Número de base de datos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'IEC104 type', 'Tipo IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Sender', 'Remitente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Recepient', 'Receptor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Subject', 'Tema', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Email View', 'Vista de correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'From', 'Desde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'To', 'A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Email Search', 'Búsqueda de correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Email Service', 'Servicio de correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Body', 'Cuerpo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Send Email', 'Enviar correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Send', 'Enviar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'User List', 'Lista de usuarios', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Mail send failed', 'Error al enviar correo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Email Settings', 'Ajustes del correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Email', 'Correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Backup/Restore', 'Copia de seguridad de restauracion', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Choose', 'Escoger', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Processes', 'Procesos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Data Transfers', 'Transferencias de datos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Keywords', 'Palabras clave', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Roles', 'Roles', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Templates', 'Plantillas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Key', 'Llave', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Active', 'Activo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Successful ?', 'Es exitoso ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Auth Logs', 'Registros de autenticación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'License', 'Licencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Machine Id', 'Identificador de máquina', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Surname', 'Apellido', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'User Limit', 'Límite de usuarios', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Update', 'Actualizar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'License Key', 'Clave de licencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'License to', 'Licencia para', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'License successfully activated', 'Licencia activada con éxito', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Failed to activate', 'No se pudo activar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm Name', 'Nombre de alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Start All', 'Iniciar todo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Stop All', 'Para todo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure you want to schedule/unschedule the selected data transfer?', '¿Está seguro de que desea programar / anular la programación de la transferencia de datos seleccionada?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Process', 'Proceso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'GRAPHICAL VIEW', 'VISTA GRÁFICA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'FLOW RATE', 'TASA DE FLUJO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'METERING', 'MEDIDA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'ENERGY & OTHER VALUES', 'ENERGÍA Y OTROS VALORES', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'IN-USE GAS COMPONENTS', 'COMPONENTES DE GAS EN USO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'TOTALISORS', 'TOTALISORES', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'PREVIOUS HOURLY & DAILY VALUES', 'VALORES HORARIOS Y DIARIOS ANTERIORES', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'ALARMS ON', 'ALARMAS ACTIVADAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'NAME', 'NOMBRE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'CURRENT', 'ACTUAL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'C.HOUR', 'C.HORA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'KEY-PAD', 'TECLADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'IN-USE', 'EN USO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'DOWNLOADED', 'DESCARGADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'NORMALIZED', 'NORMALIZADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'UNIT', 'UNIDAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'PROPERTIES', 'PROPIEDADES', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'GC MANAGEMENT', 'GESTIÓN DE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SET', 'CONJUNTO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'STATUS', 'ESTADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'QRCODE Reader', 'Lector QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Scanned!', '¡Escaneado!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'deviceName', 'nombre del dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Failed to load data', 'No se pudieron cargar los datos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'ANIMATION', 'ANIMACIÓN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'GAS METERING', 'MEDICIÓN DE GAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'GAS PROPERTIES', 'PROPIEDADES DEL GAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'NETWORK', 'RED', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Fired Alarm Duration In Days', 'Duración de la alarma activada en días', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Fired Alarm duration is updated', 'Se actualizó la duración de la alarma disparada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Acknowledger', 'Reconocimiento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Duration In Days', 'Duración del registro en días', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log duration is updated', 'Se actualizó la duración del registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Remove All', 'Eliminar todo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Firstly load the datatable', 'Primero cargue la tabla de datos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Failed to load log data', 'No se pudieron cargar los datos de registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure to remove all logs?', '¿Estás seguro de eliminar todos los registros?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'All logs removed', 'Todos los registros eliminados', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'An error occured while removing logs', 'Se produjo un error al eliminar los registros', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Message', 'Mensaje de registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Show Weather On Click', 'Mostrar el tiempo al hacer clic', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Updated successfully', 'Actualizado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Removed successfully', 'Eliminado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Map', 'Mapa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Weather api', 'API del tiempo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Interval', 'Intervalo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Filter', 'Filtrar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'SCHEDULED', 'PROGRAMADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'ON', 'EN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'OFF', 'APAGADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Print', 'Impresión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Failed to load!', '¡Falló al cargar!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Choose Trend', 'Elegir tendencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Avg Value', 'Valor medio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Integral Value', 'Valor integral', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Diff Value', 'Valor máximo de diferencia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Calculation type', 'Tipo de cálculo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Auto Scroll', 'Desplazamiento automático', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Failed to load trend data', 'No se pudieron cargar los datos de tendencias', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Select the Trend first', 'Seleccione la tendencia primero', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Interval cannot be empty', 'El intervalo no puede estar vacío', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable Duration In Days', 'Duración variable en días', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable duration is updated', 'Se actualiza la duración variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Frame', 'Cuadro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Usual', 'Usual', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Hourly', 'Cada hora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Daily', 'Diario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'CUSTOM', 'PERSONALIZADO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'COLLECTION', 'COLECCIÓN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Process Form', 'Formulario de proceso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Background', 'Antecedentes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Text Color', 'Color de texto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Main Flag', 'Bandera principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Grid Flag', 'Bandera de cuadrícula', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Inputs', 'Entradas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Choose Default Image', 'Elegir imagen predeterminada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'States', 'Estados', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'State Lists', 'Listas de estado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'New State', 'Nuevo estado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'State name', 'Nombre del Estado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Attach', 'Adjuntar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Library', 'Biblioteca', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Node updated', 'Nodo actualizado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Property', 'Propiedad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Project Property', 'Propiedad del proyecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Project Values', 'Valores del proyecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Stream', 'Corriente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report', 'Reporte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please, choose a period', 'Por favor, elija un punto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Name field cannot be empty!', '¡El campo de nombre no puede estar vacío!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please choose a report', 'Elija un informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group order cannot be empty!', '¡El pedido de grupo no puede estar vacío!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report group removed', 'Grupo de informes eliminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new Report group added', 'Se agregó un nuevo grupo de informes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report group updated successfully', 'Grupo de informes actualizado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report updated successfully', 'Informe actualizado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new report added', 'Se agregó un nuevo informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report removed', 'Informe eliminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please, select group', 'Por favor, seleccione grupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report subgroup removed', 'Informe de subgrupo eliminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new Report subgroup added', 'Se agregó un nuevo subgrupo de informes', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report subgroup updated successfully', 'Subgrupo de informes actualizado correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report Variable', 'Variable de informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Subgroup', 'Subgrupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please choose a subgroup', 'Elija un subgrupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable Order', 'Orden variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Variable order cannot be empty', 'El orden de las variables no puede estar vacío', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please, choose calculation type', 'Por favor, elija el tipo de cálculo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please, choose variable', 'Por favor, elija variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Deviation', 'Desviación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please, select subgroup', 'Por favor, seleccione subgrupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report variable removed', 'Variable de informe eliminada', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new Report variable added', 'Se agregó una nueva variable de informe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Report variable updated successfully', 'Variable de informe actualizada correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Script Output', 'Salida de secuencia de comandos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Output message', 'Mensaje de salida', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Empty output', 'Salida vacía', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Error in code syntax', 'Error en la sintaxis del código', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group Chat', 'Grupo de chat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Type message here', 'Escriba el mensaje aquí', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Type message', 'Escribir mensaje', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Refresh Periods', 'Actualizar períodos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Control Panel', 'Panel de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Gas Properties', 'Propiedades del gas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Network', 'Red', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Graph Details', 'Detalles del gráfico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Check All', 'Comprobar todo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Menus', 'Menús', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Permission', 'Permiso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Permissions', 'Permisos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Rolename', 'Nombre de rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Role Menus', 'Menús de funciones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Menus are added', 'Se añaden menús', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Please, select role', 'Por favor, seleccione función', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', ' is removed', ' es removido', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Role Permissions', 'Permisos de funciones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Permissions are added', 'Se agregan permisos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new role added', 'Se agregó un nuevo rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Role updated successfully', 'Función actualizada correctamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Role is removed', 'Se quitó el rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Reset Password', 'Restablecer la contraseña', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Password Info', 'Información de contraseña', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'New Password', 'Nueva contraseña', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Repeat New Password', 'Repita la nueva contraseña', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Passwords are not the same', 'Las contraseñas no son similares', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Email Address', 'Dirección de correo electrónico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'User', 'Usuario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Password changed successfully', 'Contraseña cambiada con éxito', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Password change failed', 'Cambio de contraseña falló', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Enter new value', 'Ingrese nuevo valor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Set Value', 'Valor ajustado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Increment Value', 'Valor de incremento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Send Flags', 'Enviar banderas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'False/True', 'Falso verdadero', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Decrement Value', 'Disminuir valor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Byte Swap?', '¿Es Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Is Word Swap?', '¿Es Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Point Class', 'Clase de puntos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Deadband', 'Banda muerta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Static Variation', 'Variación estática', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Event Variation', 'Variación del evento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Data Type', 'Tipo de datos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Bit Offset', 'Desplazamiento de bits', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Decimal Point', 'Punto decimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Flags', 'Banderas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Protocol Properties', 'Propiedades del protocolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Raw zero scale', 'Escala cero sin procesar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Raw full scale', 'Escala completa sin procesar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Eng zero scale', 'Ing escala cero', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Eng full scale', 'Ing. Escala completa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Period', 'Período de registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Threshold', 'Umbral de registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Value Expression', 'Expresión de valor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Log Expression', 'Expresión de registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Protocol Type', 'Tipo de protocolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Protocols', 'Protocolos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new item added', 'Se agregó un nuevo elemento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'A new item detail added', 'Se agregó un nuevo detalle de artículo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Item detail updated', 'Detalles del artículo actualizados', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Item updated', 'Elemento actualizado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Item removed', 'Elemento eliminado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Minutes Offset', 'Desplazamiento de minutos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Local Address', 'Dirección local', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Remote Address', 'Dirección remota', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Unsoliceted Events', 'Eventos no autorizados', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Max Controls', 'Controles máximos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Select Timeout', 'Seleccionar tiempo de espera', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Confirm Timeout', 'Confirmar tiempo de espera', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Retry Timeout', 'Tiempo de espera de reintento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Response Timeout', 'Tiempo de espera de respuesta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Disable Unsolicated', 'Desactivar sin soldar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Startup Integrity', 'Integridad de inicio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Integrity Overflow', 'Desbordamiento de integridad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Common Address', 'Dirección común', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Dnp3 type', 'Tipo Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Event Buffer Size', 'Tamaño del búfer de eventos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Modbus type', 'Tipo Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Readable', 'Legible', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Writeable', 'Escribible', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Iec104 type', 'Tipo iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Back', 'Atrás', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Next', 'Próximo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'COMMUNICATION NETWORK', 'RED DE COMUNICACION', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Finish', 'Terminar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Check connection details', 'Verifique los detalles de la conexión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Connection Details', 'Detalles de la conexión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'GAS STATION MODEL', 'MODELO DE ESTACIÓN DE GAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Device List', 'Lista de dispositivos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Device Form', 'Formulario de dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Item', 'Articulo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Station Address', 'Dirección de la estación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'PAY', 'PAGAR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'CHECK', 'CHEQUE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Stream Details', 'Detalles de la transmisión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'USE GC', 'USAR GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Saved!', '¡Salvado!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'DEFINED GAS STATION MODEL', 'MODELO DE ESTACIÓN DE GAS DEFINIDO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Capacity', 'Capacidad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Group Name', 'Nombre del grupo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Stream Modules List', 'Lista de módulos de transmisión', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Analyzer', 'Analizador', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Main Station', 'Estación principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Sub Station', 'Subestación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'REPORT', 'REPORTE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Generate', 'Generar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Failed to generate project', 'No se pudo generar el proyecto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Station Details', 'Detalles de la estación', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'WebSocket is on', 'WebSocket está activado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'WebSocket is off', 'WebSocket está desactivado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'WebSocket error observed', 'Error de WebSocket observado', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Clear browser storage', 'Limpiar el almacenamiento del navegador', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'System statistics', 'Estadísticas del sistema', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Chatting', 'Charlando', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Notifications', 'Notificaciones', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Sign-out', 'Desconectar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Hide top', 'Ocultar la parte superior', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Are you sure you want to clear storage?', '¿Estás seguro de que quieres borrar el almacenamiento?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Press SHIFT+Q to return', 'Presione SHIFT + Q para regresar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'Press SHIFT+W to return', 'Presione MAYÚS + W para regresar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('es', 'You are about to logged out. Are you sure you want to proceed?', 'Está a punto de cerrar la sesión. ¿Está seguro de que desea continuar?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('it', 'inSCADA Login', 'Accesso inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Username', 'Nome utente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Password', 'Parola d ordine', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Login', 'Accesso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Language', 'Linguaggio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Projects', 'Progetti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'User Menu', 'Menu utente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Project Map', 'Mappa del progetto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Devices', 'Dispositivi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animations', 'Animazioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarms', 'Allarmi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Trends', 'Tendenze', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Trend Tags', 'Tag di tendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Trend Tag', 'Tag di tendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Scripts', 'Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Reports', 'Rapporti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Emails', 'Email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Logs', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Auth Log', 'Registro di autenticazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Users', 'Utenti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Help', 'Aiuto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'About', 'Di', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Home', 'Casa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Connection', 'Connessione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Trend Graphic', 'Grafico di tendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Trend Graphics', 'Grafica di tendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Connections', 'Connessioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Group', 'Gruppo di rapporti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Aggregate', 'Aggregato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Device Templates', 'Modelli di dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Frame Templates', 'Modelli di frame', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable Templates', 'Modelli variabili', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Search', 'Ricerca', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure you want to schedule/unschedule the selected script?', 'Sei sicuro di voler pianificare / annullare la pianificazione dello script selezionato?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Add New', 'Aggiungere nuova', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Save', 'Salva', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Delete', 'Elimina', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Yes', 'Sì', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'No', 'No', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Status', 'Stato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Properties', 'Proprietà', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure to continue?', 'Sei sicuro di continuare?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Form data is invalid', 'I dati del modulo non sono validi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Visualization', 'Visualizzazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Development', 'Sviluppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Gas Metering', 'Misurazione del gas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Gas Control', 'Controllo del gas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Control panel', 'Pannello di controllo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group', 'Gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Module', 'Modulo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Station Adress', 'Station Adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Protocol', 'Protocollo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On DateTime', 'In data e ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Acknowledge DateTime', 'Riconoscimento data e ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Settings', 'Impostazioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'General', 'Generale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Start adress', 'Indirizzo iniziale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Scan Time', 'Tempo di scansione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Device Library', 'Libreria dispositivi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Expressions', 'Espressioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variables', 'Variabili', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Wizard', 'Procedura guidata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable History', 'Cronologia variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Port', 'Porta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Timeout', 'Tempo scaduto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Frames', 'Frame', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Writeable?', 'È scrivibile?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Readable?', 'È leggibile?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Buffer size', 'Dimensione buffer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print Time', 'Tempo di stampa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print Day', 'Print Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print Hour', 'Print Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Day', 'Report Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Time', 'Report Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Hour', 'Ora rapporto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print?', 'Stampa?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Add Descriptions', 'Aggiungi descrizioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Jobs', 'Lavori', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Last Execution Start Time', 'Ora di inizio ultima esecuzione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Last Execution Ended Time', 'Ora di fine ultima esecuzione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Next Execution Time', 'Ora di esecuzione successiva', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Executions Count', 'Conteggio esecuzioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Project', 'Progetto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Name', 'Nome', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Description', 'Descrizione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Start Date', 'Data d inizio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'End Date', 'Data di fine', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Active?', 'È attivo?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Location', 'Posizione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Address', 'Indirizzo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Latitude', 'Latitudine', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Longitude', 'Longitudine', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Contract', 'Contrarre', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Contract Day', 'Giorno del contratto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Contract Hour', 'Ora contratto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new project added', 'Un nuovo progetto aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Project updated successfully', 'Progetto aggiornato con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Project removed', 'Progetto rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Value', 'Valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure you want to continue?', 'Sei sicuro di voler continuare?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'HPP Unit', 'Unità HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Reload', 'Ricaricare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Acknowledge', 'Riconoscere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Quantity', 'Quantità', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Type', 'Tipo di registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Unit', 'Unità', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Expression Type', 'Tipo di espressione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Retain Flag', 'Mantieni bandiera', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Word Swap', 'Scambio di parole', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Byte Swap', 'Byte Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Load', 'Caricare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Date Range', 'Intervallo di date', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable Picker', 'Selettore di variabili', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Last Value', 'Ultimo valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'First Value', 'Primo valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Min Value', 'Valore minimo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Value', 'Valore massimo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Sum Value', 'Valore somma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Count Value', 'Conteggio valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Acknowledge DateTime Filter', 'Riconoscimento filtro data e ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Off DateTime Filter', 'Filtro data e ora disattivato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On DateTime Filter', 'Filtro data e ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Search Form', 'Modulo di ricerca', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Interval (Second)', 'Intervallo (secondo)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On', 'Su', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Off', 'Off', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Live', 'Vivere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Preview', 'Anteprima', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Cancel', 'Annulla', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Schedule', 'Programma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Severity', 'Gravità registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Activity', 'Attività', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Source', 'Fonte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Message', 'Messaggio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Remove', 'Rimuovere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'User Roles', 'Ruoli utente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Role', 'Ruolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Expression', 'Espressione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Delay', 'Ritardo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Category', 'Categoria', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On Script', 'Sullo script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Off Script', 'Fuori copione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new alarm added', 'Un nuovo allarme aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm updated successfully', 'Allarme aggiornato con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm settings is updated', 'Le impostazioni della sveglia sono aggiornate', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm removed', 'Allarme rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm History', 'Cronologia allarmi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Type', 'Genere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Import', 'Importare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Date', 'Data', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure you want to activate/deactivate the selected alarm?', 'Sei sicuro di voler attivare / disattivare la sveglia selezionata?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure you want to Start/Stop the selected connection?', 'Sei sicuro di voler avviare / interrompere la connessione selezionata?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Code', 'Codice', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Priority', 'Priorità', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Period', 'Periodo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new script added', 'Un nuovo script aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Script updated successfully', 'Script aggiornato correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Script removed', 'Script rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Deviation Variable', 'Variabile di deviazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Total Variable', 'Variabile totale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Calculation Type', 'Tipo di calcolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Order', 'Ordine', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Variables', 'Variabili del rapporto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Subgroup Order', 'Ordine sottogruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Subgroups', 'Segnala sottogruppi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group Order', 'Ordine di gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation Elements', 'Elementi di animazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Parent Animation', 'Animazione genitore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Color', 'Colore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Duration', 'Durata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Play at Main?', 'Suona al Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SVG Content', 'Contenuto SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation Type', 'Tipo di animazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new animation added', 'Una nuova animazione aggiunta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Only SVG files are allowed', 'Sono consentiti solo file SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation updated successfully', 'Animazione aggiornata correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation removed', 'Animazione rimossa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new animation element added', 'Aggiunto un nuovo elemento di animazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation element updated successfully', 'Elemento di animazione aggiornato correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation element removed', 'Elemento di animazione rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Min. Scale', 'Scala min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max. Scale', 'Max. Scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Thickness', 'Spessore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Backup', 'Backup', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Restore', 'Ristabilire', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Save & Continue', 'Salva e continua', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable', 'Variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Default', 'Predefinito', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Add', 'Inserisci', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Default value', 'Valore di default', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Text', 'Testo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Title', 'Titolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Size', 'Taglia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Disable', 'Disattivare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Home View', 'Vista Home', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Time', 'Tempo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Second', 'Secondo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Last Executed At', 'Ultimo eseguito alle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please select a master record first', 'Seleziona prima un record principale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Send SMS', 'Inviare SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SMS Details', 'Dettagli SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SMS Service', 'Servizio SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SMS sended successfully', 'SMS inviato con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SMS Search', 'Ricerca SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Content', 'Soddisfare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SMS Settings', 'Impostazioni SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Mail sended successfully', 'Posta inviata con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'No selected animation', 'Nessuna animazione selezionata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Recipient', 'Destinatario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Online Help', 'Aiuto online', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Menu', 'Menù', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm', 'Allarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm Monitor', 'Monitor di allarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Smart Symbol', 'Simbolo intelligente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Smart Symbols', 'Simboli intelligenti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable Monitor', 'Monitor variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm Group', 'Gruppo di allarmi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm Groups', 'Gruppi di allarmi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On No Ack Color', 'In nessun colore ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print When On?', 'Stampa quando attivo?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print When Off?', 'Stampa quando disattivato?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print When Ack?', 'Print When Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation', 'Animazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Inverse', 'Inverso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Set Type', 'Imposta tipo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Notify', 'Notificare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Default Color', 'Colore predefinito', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Gradient', 'Pendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Format', 'Formato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group Size', 'Dimensione del gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Decimal', 'Decimale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group Seperator', 'Separatore di gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Decimal Seperator', 'Separatore decimale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Leftpad Size', 'Dimensioni pad sinistro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Rightpad Size', 'Dimensioni Rightpad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Character', 'Carattere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Prefix', 'Prefisso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Suffix', 'Suffisso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'tag', 'etichetta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Initial Pos', 'Posizione iniziale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Min Pos', 'Pos min', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Join', 'Aderire', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Template?', 'È Template?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation Element', 'Elemento di animazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Mouse', 'Topo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'More', 'Di Più', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation WebSocket is on', 'Animation WebSocket è attivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation WebSocket is off', 'Animation WebSocket is off', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Animation WebSocket error observed', 'Errore WebSocket dell animazione osservato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Pool Size', 'Dimensioni piscina', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Adapter', 'Adattatore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Min Retry Delay', 'Ritardo minimo tentativi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Retry Delay', 'Max Retry Delay', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Local Ip', 'IP locale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Local Port', 'Porta locale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Cot F. Length', 'Culla F. Lunghezza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Cot Field Length', 'Lunghezza campo culla', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'IOA Field Length', 'Lunghezza campo IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Common A. Length', 'Lunghezza A. comune', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Common Address Field Length', 'Lunghezza campo indirizzo comune', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'IOA F. Length', 'IOA F. Lunghezza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Originator Address', 'Indirizzo del mittente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Message F. Timeout', 'Messaggio F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Message Fragment Timeout', 'Timeout frammento messaggio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max T.N.A. Recieved', 'Max T.N.A. Ricevuto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Time No Ack Received', 'Tempo massimo per mancata ricezione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max T.N.A. Sent', 'Max T.N.A. Inviato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Idle Time', 'Max Idle Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max U. IP Recieved', 'Max U. IP ricevuto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Unconfirmed IPdus Received', 'Numero massimo di IPdus non confermati ricevuti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Start DT Timeout', 'Avvia DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Start DT Retries', 'Avvia tentativi DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Coming Soon...', 'Prossimamente...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Rack', 'Rack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Slot', 'Fessura', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'No Data Transfer Selected', 'Nessun trasferimento dati selezionato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Destination', 'Destinazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Detail Form', 'Modulo dettagli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Source Tag', 'Tag sorgente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Destination Tag', 'Tag di destinazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Data Transfer', 'Trasferimento dati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Detail Transfer', 'Trasferimento dettagli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Device', 'Dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Device Picker', 'Selettore dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Import Tmpl', 'Importa Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Start Address', 'Indirizzo iniziale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'General I. Time', 'Generale I. Ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'General Interrogation Time', 'Tempo di interrogazione generale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'General Counter Interrogation Time', 'Tempo di interrogazione generale del contatore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Cnt Point Offset', 'Offset punto Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Control Point Offset', 'Scostamento punto di controllo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'DB Number', 'Numero DB', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'IEC104 type', 'Tipo IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Sender', 'Mittente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Recepient', 'Destinatario', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Subject', 'Soggetto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Email View', 'Visualizzazione email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'From', 'A partire dal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'To', 'Per', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Email Search', 'Ricerca email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Email Service', 'Servizio di posta elettronica', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Body', 'Corpo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Send Email', 'Invia una email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Send', 'Spedire', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'User List', 'Lista degli utenti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Mail send failed', 'Invio posta non riuscito', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Email Settings', 'Impostazioni dell email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Backup/Restore', 'Ripristinare il backup', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Choose', 'Scegliere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Processes', 'Processi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Data Transfers', 'Trasferimento di dati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Keywords', 'Parole chiave', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Roles', 'Ruoli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Templates', 'Modelli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Key', 'Chiave', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Active', 'Attivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Successful ?', 'Ha successo?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Auth Logs', 'Registri di autenticazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'License', 'Licenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Machine Id', 'ID macchina', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Surname', 'Cognome', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'User Limit', 'Limite utente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Update', 'Aggiornare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'License Key', 'Chiave di licenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'License to', 'Licenza di', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'License successfully activated', 'Licenza attivata con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Failed to activate', 'Impossibile attivare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm Name', 'Nome allarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Alarm Dsc', 'Allarme Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Start All', 'Avvia tutto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Stop All', 'Ferma tutto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Sei sicuro di voler pianificare / annullare la pianificazione del trasferimento dati selezionato?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Process', 'Processi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'GRAPHICAL VIEW', 'VISTA GRAFICA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'FLOW RATE', 'PORTATA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'METERING', 'METERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'ENERGY & OTHER VALUES', 'ENERGIA E ALTRI VALORI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'IN-USE GAS COMPONENTS', 'COMPONENTI DEL GAS IN USO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'TOTALISORS', 'TOTALIZZATORI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'PREVIOUS HOURLY & DAILY VALUES', 'VALORI ORARI E GIORNALIERI PRECEDENTI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'ALARMS ON', 'ALLARMI ATTIVI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'NAME', 'NOME', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'CURRENT', 'ATTUALE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'IN-USE', 'IN USO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'DOWNLOADED', 'SCARICATO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'NORMALIZED', 'NORMALIZZATO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'UNIT', 'UNITÀ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'PROPERTIES', 'PROPRIETÀ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'GC MANAGEMENT', 'GESTIONE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SET', 'IMPOSTATO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'STATUS', 'STATO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Scanned!', 'Scansionato!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'deviceName', 'nome del dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Failed to load data', 'Impossibile caricare i dati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'ANIMATION', 'ANIMAZIONE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'GAS METERING', 'MISURAZIONE GAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'GAS PROPERTIES', 'PROPRIETÀ DEL GAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'NETWORK', 'RETE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Fired Alarm Duration In Days', 'Durata allarme attivato in giorni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Fired Alarm duration is updated', 'La durata dell allarme attivato è stata aggiornata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Acknowledger', 'Riconoscimento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Duration In Days', 'Durata registro in giorni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log duration is updated', 'La durata del registro viene aggiornata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Remove All', 'Rimuovi tutto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Firstly load the datatable', 'Innanzitutto carica il datatable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Failed to load log data', 'Impossibile caricare i dati di log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure to remove all logs?', 'Sei sicuro di rimuovere tutti i log?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'All logs removed', 'Tutti i log rimossi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'An error occured while removing logs', 'Si è verificato un errore durante la rimozione dei log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Message', 'Messaggio di registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Show Weather On Click', 'Mostra meteo al clic', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Updated successfully', 'Aggiornato con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Removed successfully', 'Rimosso con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Map', 'Carta geografica', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Weather api', 'Weather api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Interval', 'Intervallo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Filter', 'Filtro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'SCHEDULED', 'SCHEDULED', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'ON', 'SU', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'OFF', 'OFF', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Print', 'Stampa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Failed to load!', 'Caricamento fallito!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Choose Trend', 'Scegli tendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Avg Value', 'Valore medio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Integral Value', 'Valore integrale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Calculation type', 'Tipo di calcolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Auto Scroll', 'Scorrimento automatico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Failed to load trend data', 'Impossibile caricare i dati di tendenza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Select the Trend first', 'Seleziona prima il trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Interval cannot be empty', 'L intervallo non può essere vuoto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable Duration In Days', 'Durata variabile in giorni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable duration is updated', 'La durata variabile viene aggiornata', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Frame', 'Telaio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Usual', 'Solito', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Hourly', 'Ogni ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Daily', 'Quotidiano', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'CUSTOM', 'PERSONALIZZATO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'COLLECTION', 'COLLEZIONE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Process Form', 'Modulo di processo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Background', 'Sfondo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Text Color', 'Colore del testo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Main Flag', 'Bandiera principale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Grid Flag', 'Flag di griglia', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Inputs', 'Input', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Choose Default Image', 'Scegli immagine predefinita', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'States', 'Stati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'State Lists', 'Elenchi di stato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'New State', 'Nuovo stato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'State name', 'Nome dello stato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Attach', 'Allega', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Library', 'Biblioteca', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Node updated', 'Nodo aggiornato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Property', 'Proprietà', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Project Property', 'Proprietà del progetto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Project Values', 'Valori del progetto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Stream', 'Stream', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report', 'Rapporto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please, choose a period', 'Per favore, scegli un periodo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Name field cannot be empty!', 'Il campo del nome non può essere vuoto!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please choose a report', 'Scegli un rapporto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group order cannot be empty!', 'L ordine di gruppo non può essere vuoto!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report group removed', 'Gruppo di rapporti rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new Report group added', 'Aggiunto un nuovo gruppo di rapporti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report group updated successfully', 'Gruppo di rapporti aggiornato correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report updated successfully', 'Rapporto aggiornato correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new report added', 'Un nuovo rapporto aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report removed', 'Rapporto rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please, select group', 'Per favore, seleziona il gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report subgroup removed', 'Segnala sottogruppo rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new Report subgroup added', 'Aggiunto un nuovo sottogruppo di rapporti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report subgroup updated successfully', 'Rapporto sottogruppo aggiornato correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report Variable', 'Variabile report', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Subgroup', 'Sottogruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please choose a subgroup', 'Scegli un sottogruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable Order', 'Ordine variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Variable order cannot be empty', 'L ordine delle variabili non può essere vuoto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please, choose calculation type', 'Per favore, scegli il tipo di calcolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please, choose variable', 'Per favore, scegli la variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Total', 'Totale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Deviation', 'Deviazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please, select subgroup', 'Per favore, seleziona il sottogruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report variable removed', 'Variabile del rapporto rimossa', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new Report variable added', 'Aggiunta una nuova variabile del report', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Report variable updated successfully', 'Variabile del rapporto aggiornata correttamente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Script Output', 'Output script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Output message', 'Messaggio di output', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Empty output', 'Output vuoto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Error in code syntax', 'Errore nella sintassi del codice', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group Chat', 'Chat di gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Type message here', 'Digita il messaggio qui', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Type message', 'Digita messaggio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Refresh Periods', 'Aggiorna periodi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Control Panel', 'Pannello di controllo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Gas Properties', 'Proprietà del gas', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Network', 'Rete', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Graph Details', 'Dettagli grafico', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Check All', 'Seleziona tutto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Menus', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Permission', 'Autorizzazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Permissions', 'Autorizzazioni', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Rolename', 'Rolename', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Role Menus', 'Menu dei ruoli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Menus are added', 'Menu aggiunti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Please, select role', 'Per favore, seleziona un ruolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', ' is removed', ' è rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Role Permissions', 'Autorizzazioni ruolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Permissions are added', 'Le autorizzazioni vengono aggiunte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new role added', 'Un nuovo ruolo aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Role updated successfully', 'Ruolo aggiornato con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Role is removed', 'Il ruolo è stato rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Reset Password', 'Resetta la password', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Password Info', 'Informazioni sulla password', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'New Password', 'Nuova password', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Repeat New Password', 'Ripetere la nuova password', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Passwords are not the same', 'Le password non sono le stesse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Email Address', 'Indirizzo email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'User', 'Utente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Password changed successfully', 'Password cambiata con successo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Password change failed', 'Modifica della password non riuscita', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Enter new value', 'Inserisci nuovo valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Set Value', 'Valore impostato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Increment Value', 'Incrementa valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Send Flags', 'Invia flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'False/True', 'Falsa verità', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Decrement Value', 'Decrementa valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Byte Swap?', 'Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Is Word Swap?', 'È lo scambio di parole?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Point Class', 'Point Class', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Deadband', 'Banda morta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Static Variation', 'Variazione statica', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Event Variation', 'Variazione evento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Data Type', 'Tipo di dati', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Bit Offset', 'Bit Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Decimal Point', 'Punto decimale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Flags', 'Bandiere', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Protocol Properties', 'Proprietà protocollo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Raw zero scale', 'Scala zero grezza', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Raw full scale', 'Raw full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Eng zero scale', 'Eng zero scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Period', 'Periodo registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Threshold', 'Soglia registro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Value Expression', 'Espressione di valore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Log Expression', 'Espressione log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Protocol Type', 'Tipo di protocollo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Protocols', 'Protocolli', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new item added', 'Un nuovo elemento aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'A new item detail added', 'Un nuovo dettaglio elemento aggiunto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Item detail updated', 'Dettaglio articolo aggiornato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Item updated', 'Articolo aggiornato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Item removed', 'Articolo rimosso', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Minutes Offset', 'Minuti Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Local Address', 'Indirizzo locale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Remote Address', 'Indirizzo remoto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Unsoliceted Events', 'Eventi non richiesti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Select Timeout', 'Seleziona timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Confirm Timeout', 'Conferma timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Retry Timeout', 'Riprova timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Response Timeout', 'Timeout risposta', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Event Scantime', 'Evento Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Disable Unsolicated', 'Disabilita non richiesti', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Startup Integrity', 'Integrità all avvio', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Integrity Overflow', 'Integrity Overflow', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Common Address', 'Indirizzo comune', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Dnp3 type', 'Tipo Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Event Buffer Size', 'Dimensione buffer evento', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Modbus type', 'Tipo Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Readable', 'Leggibile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Writeable', 'Scrivibile', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Iec104 type', 'Tipo Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Back', 'Indietro', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Next', 'Il prossimo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'COMMUNICATION NETWORK', 'RETE DI COMUNICAZIONE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Finish', 'Finire', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Check connection details', 'Controlla i dettagli della connessione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Connection Details', 'Dettagli connessione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'GAS STATION MODEL', 'MODELLO STAZIONE DI GAS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Device List', 'Elenco dispositivi', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Device Form', 'Modulo dispositivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Item', 'Articolo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Station Address', 'Indirizzo stazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'PAY', 'PAGARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'CHECK', 'DAI UN OCCHIATA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Stream Details', 'Dettagli stream', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'USE GC', 'USA GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Saved!', 'Salvato!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'DEFINED GAS STATION MODEL', 'MODELLO DI STAZIONE DI GAS DEFINITO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Capacity', 'Capacità', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Group Name', 'Nome del gruppo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'STREAMS', 'FLUSSI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Stream Modules List', 'Elenco dei moduli di streaming', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Analyzer', 'Analizzatore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Main Station', 'Stazione principale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Sub Station', 'Stazione secondaria', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'REPORT', 'RAPPORTO', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Generate', 'Creare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Failed to generate project', 'Impossibile generare il progetto', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Station Details', 'Dettagli stazione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'WebSocket is on', 'WebSocket è attivo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'WebSocket is off', 'WebSocket è disattivato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'WebSocket error observed', 'Errore WebSocket osservato', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Clear browser storage', 'Cancella memoria browser', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'System statistics', 'Statistiche di sistema', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Chatting', 'Chattare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Notifications', 'Notifiche', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Sign-out', 'Disconnessione', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Hide top', 'Nascondi parte superiore', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Are you sure you want to clear storage?', 'Sei sicuro di voler svuotare lo spazio di archiviazione?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Press SHIFT+Q to return', 'Premi MAIUSC + Q per tornare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'Press SHIFT+W to return', 'Premi MAIUSC + W per tornare', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('it', 'You are about to logged out. Are you sure you want to proceed?', 'Stai per disconnetterti. Sei sicuro di voler procedere?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('de', 'inSCADA Login', 'inSCADA Login', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Username', 'Nutzername', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Password', 'Passwort', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Login', 'Einloggen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Language', 'Sprache', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Projects', 'Projekte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'User Menu', 'Benutzermenü', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Project Map', 'Projektkarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Devices', 'Geräte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animations', 'Animationen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarms', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Trends', 'Trends', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Trend Tags', 'Trend Tags', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Trend Tag', 'Trend Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Scripts', 'Skripte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Reports', 'Berichte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Emails', 'E-Mails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Logs', 'Protokolle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Auth Log', 'Auth Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Users', 'Benutzer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Help', 'Hilfe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'About', 'Über', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Home', 'Zuhause', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Connection', 'Verbindung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Trend Graphic', 'Trendgrafik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Trend Graphics', 'Trendgrafiken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Connections', 'Verbindungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Group', 'Berichtsgruppe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Aggregate', 'Aggregat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Device Templates', 'Gerätevorlagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Frame Templates', 'Rahmenvorlagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable Templates', 'Variable Vorlagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Search', 'Suche', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure you want to schedule/unschedule the selected script?', 'Sind Sie sicher, dass Sie das ausgewählte Skript planen / aufheben möchten?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Add New', 'Neue hinzufügen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Save', 'Speichern', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Delete', 'Löschen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Yes', 'Ja', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'No', 'Nein', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Status', 'Status', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Properties', 'Eigenschaften', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure to continue?', 'Bist du sicher weiterzumachen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Form data is invalid', 'Formulardaten sind ungültig', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Visualization', 'Visualisierung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Development', 'Entwicklung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Gas Metering', 'Gasmessung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Gas Control', 'Gassteuerung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Control panel', 'Schalttafel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group', 'Gruppe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Module', 'Modul', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Station Adress', 'Stationsadresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Protocol', 'Protokoll', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Acknowledge DateTime', 'DateTime bestätigen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Settings', 'Die Einstellungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'General', 'Allgemeines', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Start adress', 'Adresse starten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Scan Time', 'Scan Zeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Device Library', 'Gerätebibliothek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Expressions', 'Ausdrücke', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variables', 'Variablen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Wizard', 'Magier', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable History', 'Variablenverlauf', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Port', 'Hafen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Timeout', 'Auszeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Frames', 'Frames', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Writeable?', 'Ist beschreibbar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Readable?', 'Ist lesbar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Buffer size', 'Puffergröße', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print Time', 'Druckzeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print Day', 'Drucktag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print Hour', 'Druckstunde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Day', 'Berichtstag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Time', 'Berichtszeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Hour', 'Report Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print?', 'Drucken?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Add Descriptions', 'Beschreibungen hinzufügen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Jobs', 'Arbeitsplätze', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Last Execution Start Time', 'Startzeit der letzten Ausführung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Last Execution Ended Time', 'Letzte Ausführung beendet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Next Execution Time', 'Nächste Ausführungszeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Executions Count', 'Anzahl der Ausführungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Project', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Name', 'Name', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Description', 'Beschreibung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Start Date', 'Anfangsdatum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'End Date', 'Endtermin', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Active?', 'Ist aktiv?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Location', 'Ort', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Address', 'Adresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Latitude', 'Breite', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Longitude', 'Längengrad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Contract', 'Vertrag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Contract Day', 'Vertragstag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Contract Hour', 'Vertragsstunde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new project added', 'Ein neues Projekt hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Project updated successfully', 'Projekt erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Project removed', 'Projekt entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Value', 'Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure you want to continue?', 'Bist du dir sicher, dass du weitermachen willst?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'HPP Unit', 'HPP-Einheit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Reload', 'Neu laden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Acknowledge', 'Bestätigen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Quantity', 'Menge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Type', 'Protokolltyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Unit', 'Einheit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Expression Type', 'Ausdruckstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Retain Flag', 'Flagge behalten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Word Swap', 'Word Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Byte Swap', 'Byte Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Load', 'Belastung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Date Range', 'Datumsbereich', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable Picker', 'Variable Picker', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Last Value', 'Letzter Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'First Value', 'Erster Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Min Value', 'Min. Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Value', 'Maximaler Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Sum Value', 'Summenwert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Count Value', 'Count Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Acknowledge DateTime Filter', 'DateTime-Filter bestätigen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Off DateTime Filter', 'Off DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On DateTime Filter', 'On DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Search Form', 'Suchformular', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Interval (Second)', 'Intervall (Sekunde)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On', 'Auf', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Off', 'Aus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Live', 'Wohnen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Preview', 'Vorschau', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Cancel', 'Stornieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Schedule', 'Zeitplan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Severity', 'Protokollschweregrad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Activity', 'Aktivität', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Source', 'Quelle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Message', 'Botschaft', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Remove', 'Entfernen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'User Roles', 'Benutzerregeln', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Role', 'Rolle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Expression', 'Ausdruck', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Delay', 'Verzögern', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Category', 'Kategorie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On Script', 'On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new alarm added', 'Ein neuer Alarm hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm updated successfully', 'Alarm erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm settings is updated', 'Alarmeinstellungen werden aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm removed', 'Alarm entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm History', 'Alarmverlauf', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Type', 'Art', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Import', 'Importieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Date', 'Datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure you want to activate/deactivate the selected alarm?', 'Möchten Sie den ausgewählten Alarm wirklich aktivieren / deaktivieren?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure you want to Start/Stop the selected connection?', 'Möchten Sie die ausgewählte Verbindung wirklich starten / stoppen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Code', 'Code', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Priority', 'Priorität', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Period', 'Zeitraum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new script added', 'Ein neues Skript hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Script updated successfully', 'Skript erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Script removed', 'Skript entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Deviation Variable', 'Abweichungsvariable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Total Variable', 'Gesamtvariable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Calculation Type', 'Berechnungstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Order', 'Bestellung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Variables', 'Berichtsvariablen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Subgroup Order', 'Untergruppenreihenfolge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Subgroups', 'Untergruppen melden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group Order', 'Gruppenreihenfolge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation Elements', 'Animationselemente', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Parent Animation', 'Elternanimation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Color', 'Farbe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Duration', 'Dauer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Play Order', 'Spielreihenfolge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Play at Main?', 'Am Main spielen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SVG Content', 'SVG-Inhalt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation Type', 'Animationstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new animation added', 'Eine neue Animation hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Only SVG files are allowed', 'Nur SVG-Dateien sind erlaubt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation updated successfully', 'Animation erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation removed', 'Animation entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new animation element added', 'Ein neues Animationselement hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation element updated successfully', 'Animationselement erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation element removed', 'Animationselement entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Min. Scale', 'Min. Skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max. Scale', 'Max. Skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Thickness', 'Dicke', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Backup', 'Backup', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Restore', 'Wiederherstellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Save & Continue', 'Speichern fortsetzen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable', 'Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Default', 'Standard', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Add', 'Hinzufügen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Default value', 'Standardwert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Text', 'Text', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Title', 'Titel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Size', 'Größe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Disable', 'Deaktivieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Home View', 'Home View', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Time', 'Zeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Second', 'Zweite', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Last Executed At', 'Zuletzt ausgeführt um', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please select a master record first', 'Bitte wählen Sie zuerst einen Stammsatz aus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Send SMS', 'SMS senden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SMS Details', 'SMS Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SMS Service', 'SMS Service', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SMS sended successfully', 'SMS erfolgreich gesendet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SMS Search', 'SMS-Suche', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Content', 'Inhalt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SMS Settings', 'SMS-Einstellungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Mail sended successfully', 'Mail erfolgreich gesendet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'No selected animation', 'Keine ausgewählte Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Recipient', 'Empfänger', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Online Help', 'Onlinehilfe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Menu', 'Speisekarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm Monitor', 'Alarm Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Smart Symbol', 'Intelligentes Symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Smart Symbols', 'Intelligente Symbole', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable Monitor', 'Variablenmonitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm Group', 'Alarmgruppe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm Groups', 'Alarmgruppen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print When On?', 'Drucken wenn eingeschaltet?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print When Off?', 'Drucken, wenn ausgeschaltet?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print When Ack?', 'Drucken, wenn bestätigt?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation', 'Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Inverse', 'Invers', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Set Type', 'Typ einstellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Notify', 'Benachrichtigen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Default Color', 'Standardfarbe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Min', 'Mindest', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group Size', 'Gruppengröße', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Decimal', 'Dezimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group Seperator', 'Gruppentrenner', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Decimal Seperator', 'Dezimaltrenner', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Leftpad Size', 'Leftpad Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Rightpad Size', 'Rightpad-Größe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Character', 'Charakter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Prefix', 'Präfix', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Suffix', 'Suffix', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'tag', 'Etikett', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Initial Pos', 'Initial Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Min Pos', 'Min Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Join', 'Beitreten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Template?', 'Ist Vorlage?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation Element', 'Animationselement', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Mouse', 'Maus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'More', 'Mehr', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation WebSocket is on', 'Animation WebSocket ist aktiviert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation WebSocket is off', 'Animation WebSocket ist ausgeschaltet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Animation WebSocket error observed', 'Animation WebSocket-Fehler beobachtet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Pool Size', 'Pool Größe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Min Retry Delay', 'Min. Wiederholungsverzögerung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Retry Delay', 'Maximale Wiederholungsverzögerung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Local Ip', 'Lokale IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Local Port', 'Lokaler Hafen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Cot F. Length', 'Kinderbett F. Länge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Cot Field Length', 'Feldlänge des Kinderbetts', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'IOA Field Length', 'IOA-Feldlänge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Common A. Length', 'Gemeinsame A. Länge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Common Address Field Length', 'Gemeinsame Adressfeldlänge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'IOA F. Length', 'IOA F. Länge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Originator Address', 'Absenderadresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Message F. Timeout', 'Nachricht F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Message Fragment Timeout', 'Zeitüberschreitung bei Nachrichtenfragmenten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max T.N.A. Recieved', 'Max T.N.A. erhalten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Time No Ack Received', 'Maximale Zeit ohne Bestätigung erhalten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max T.N.A. Sent', 'Max T.N.A. Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Idle Time', 'Maximale Leerlaufzeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max U. IP Recieved', 'Max U. IP erhalten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Unconfirmed IPdus Received', 'Max. Nicht bestätigter IPdus empfangen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Start DT Timeout', 'DT Timeout starten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Start DT Retries', 'DT-Wiederholungen starten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Coming Soon...', 'Demnächst...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Rack', 'Gestell', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Slot', 'Slot', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'No Data Transfer Selected', 'Keine Datenübertragung ausgewählt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Destination', 'Ziel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Detail Form', 'Detailformular', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Source Tag', 'Quell-Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Destination Tag', 'Ziel-Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Data Transfer', 'Datentransfer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Detail Transfer', 'Detailübertragung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Device', 'Gerät', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Device Picker', 'Geräteauswahl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Import Tmpl', 'Import Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Start Address', 'Startadresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'General I. Time', 'General I. Zeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'General Interrogation Time', 'Allgemeine Befragungszeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'General C.I. Time', 'Allgemeine C. I. Zeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'General Counter Interrogation Time', 'Allgemeine Gegenabfragezeit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Cnt Point Offset', 'Cnt-Punktversatz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Control Point Offset', 'Kontrollpunktversatz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'DB Number', 'DB-Nummer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'IEC104 type', 'IEC104 Typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Sender', 'Absender', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Recepient', 'Empfänger', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Subject', 'Gegenstand', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Email View', 'E-Mail-Ansicht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'From', 'Von', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'To', 'Zu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Email Search', 'E-Mail-Suche', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Email Service', 'E-Mail-Service', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Body', 'Körper', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Send Email', 'E-Mail senden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Send', 'Senden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'User List', 'Benutzerliste', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Mail send failed', 'Mailversand fehlgeschlagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Email Settings', 'Email Einstellungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Email', 'Email', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Backup/Restore', 'Backup wiederherstellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Choose', 'Wählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Processes', 'Prozesse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Data Transfers', 'Datenübertragungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Keywords', 'Schlüsselwörter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Roles', 'Rollen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Templates', 'Vorlagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Key', 'Schlüssel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Active', 'Aktiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Successful ?', 'Ist erfolgreich ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Auth Logs', 'Auth Logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'License', 'Lizenz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Machine Id', 'Maschinen ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Surname', 'Nachname', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'User Limit', 'Benutzerlimit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Update', 'Aktualisieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'License Key', 'Lizenzschlüssel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'License to', 'Lizenz an', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'License successfully activated', 'Lizenz erfolgreich aktiviert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Failed to activate', 'Fehler beim Aktivieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm Name', 'Alarmname', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Start All', 'Alle starten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Stop All', 'Stop All', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Sind Sie sicher, dass Sie die ausgewählte Datenübertragung planen / aufheben möchten?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Process', 'Prozess', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'GRAPHICAL VIEW', 'GRAFISCHE ANSICHT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'FLOW RATE', 'FLIESSRATE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'METERING', 'METERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'ENERGY & OTHER VALUES', 'ENERGIE & ANDERE WERTE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'IN-USE GAS COMPONENTS', 'GASKOMPONENTEN IN VERWENDUNG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'TOTALISORS', 'TOTALISOREN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'PREVIOUS HOURLY & DAILY VALUES', 'VORHERIGE STUNDEN- UND TÄGLICHE WERTE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'ALARMS ON', 'ALARME EIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'NAME', 'NAME', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'CURRENT', 'AKTUELL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'IN-USE', 'IN-USE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'MIN', 'MINDEST', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'DOWNLOADED', 'HERUNTERGELADEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'NORMALIZED', 'NORMALISIERT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'UNIT', 'EINHEIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'PROPERTIES', 'EIGENSCHAFTEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'GC MANAGEMENT', 'GC MANAGEMENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SET', 'EINSTELLEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'STATUS', 'STATUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Scanned!', 'Gescannt!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'deviceName', 'Gerätename', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Failed to load data', 'Daten konnten nicht geladen werden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'ANIMATION', 'ANIMATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'GAS METERING', 'GASMESSUNG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'GAS PROPERTIES', 'GAS EIGENSCHAFTEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'NETWORK', 'NETZWERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Fired Alarm Duration In Days', 'Dauer des abgefeuerten Alarms in Tagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Fired Alarm duration is updated', 'Dauer des abgefeuerten Alarms wird aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Acknowledger', 'Acknowledger', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Duration In Days', 'Protokolldauer in Tagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log duration is updated', 'Protokolldauer wird aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Remove All', 'Alles entfernen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Firstly load the datatable', 'Laden Sie zuerst die Datentabelle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Failed to load log data', 'Protokolldaten konnten nicht geladen werden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure to remove all logs?', 'Sind Sie sicher, alle Protokolle zu entfernen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'All logs removed', 'Alle Protokolle entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'An error occured while removing logs', 'Beim Entfernen von Protokollen ist ein Fehler aufgetreten.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Message', 'Protokollnachricht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Show Weather On Click', 'Wetter beim Klicken anzeigen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Updated successfully', 'Erfolgreich geupdated', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Removed successfully', 'Erfolgreich entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Map', 'Karte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Weather api', 'Wetter-API', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Interval', 'Intervall', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Filter', 'Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'SCHEDULED', 'GEPLANT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'ON', 'AUF', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'OFF', 'AUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Print', 'Drucken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Failed to load!', 'Laden fehlgeschlagen!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Choose Trend', 'Trend wählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Avg Value', 'Durchschnittlicher Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Integral Value', 'Integraler Wert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Calculation type', 'Berechnungstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Auto Scroll', 'Auto Scroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Failed to load trend data', 'Fehler beim Laden der Trenddaten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Select the Trend first', 'Wählen Sie zuerst den Trend aus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Interval cannot be empty', 'Intervall darf nicht leer sein', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable Duration In Days', 'Variable Dauer in Tagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable duration is updated', 'Variable Dauer wird aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Frame', 'Rahmen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Usual', 'Gewöhnlich', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Hourly', 'Stündlich', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Daily', 'Täglich', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'CUSTOM', 'BENUTZERDEFINIERT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'COLLECTION', 'SAMMLUNG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Process Form', 'Prozessformular', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Background', 'Hintergrund', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Text Color', 'Textfarbe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Main Flag', 'Hauptflagge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Grid Flag', 'Gitterfahne', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Inputs', 'Eingänge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Choose Default Image', 'Standardbild auswählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'States', 'Zustände', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'State Lists', 'Staatslisten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'New State', 'Neuer Staat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'State name', 'Staatsname', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Attach', 'Anfügen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Library', 'Bibliothek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Node updated', 'Knoten aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Property', 'Eigentum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Project Property', 'Projekteigenschaft', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Project Values', 'Projektwerte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Stream', 'Strom', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report', 'Bericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please, choose a period', 'Bitte wählen Sie einen Zeitraum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Name field cannot be empty!', 'Namensfeld darf nicht leer sein!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please choose a report', 'Bitte wählen Sie einen Bericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group order cannot be empty!', 'Gruppenreihenfolge darf nicht leer sein!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report group removed', 'Berichtsgruppe entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new Report group added', 'Eine neue Berichtsgruppe hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report group updated successfully', 'Berichtsgruppe erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report updated successfully', 'Bericht erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new report added', 'Ein neuer Bericht hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report removed', 'Bericht entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please, select group', 'Bitte Gruppe auswählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report subgroup removed', 'Berichtsuntergruppe entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new Report subgroup added', 'Eine neue Berichtsuntergruppe hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report subgroup updated successfully', 'Berichtsuntergruppe erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report Variable', 'Berichtsvariable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Subgroup', 'Untergruppe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please choose a subgroup', 'Bitte wählen Sie eine Untergruppe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable Order', 'Variable Reihenfolge', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Variable order cannot be empty', 'Variable Reihenfolge darf nicht leer sein', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please, choose calculation type', 'Bitte Berechnungsart wählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please, choose variable', 'Bitte Variable auswählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Total', 'Gesamt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Deviation', 'Abweichung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please, select subgroup', 'Bitte Untergruppe auswählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report variable removed', 'Berichtsvariable entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new Report variable added', 'Eine neue Berichtsvariable hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Report variable updated successfully', 'Berichtsvariable erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Script Output', 'Skriptausgabe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Output message', 'Nachricht ausgeben', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Empty output', 'Leere Ausgabe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Error in code syntax', 'Fehler in der Codesyntax', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group Chat', 'Gruppenchat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Type message here', 'Nachricht hier eingeben', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Type message', 'Nachricht eingeben', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Refresh Periods', 'Aktualisierungsperioden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Control Panel', 'Schalttafel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Gas Properties', 'Gaseigenschaften', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Network', 'Netzwerk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Graph Details', 'Grafikdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Check All', 'Alles überprüfen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Menus', 'Menüs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Permission', 'Genehmigung', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Permissions', 'Berechtigungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Rolename', 'Rollenname', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Role Menus', 'Rollenmenüs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Menus are added', 'Menüs werden hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Please, select role', 'Bitte Rolle auswählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', ' is removed', ' ist entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Role Permissions', 'Rollenberechtigungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Permissions are added', 'Berechtigungen werden hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new role added', 'Eine neue Rolle hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Role updated successfully', 'Rolle erfolgreich aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Role is removed', 'Rolle wird entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Reset Password', 'Passwort zurücksetzen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Password Info', 'Passwortinfo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'New Password', 'Neues Kennwort', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Repeat New Password', 'Wiederhole das neue Passwort', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Passwords are not the same', 'Passwörter sind nicht gleich', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Email Address', 'E-Mail-Addresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'User', 'Nutzer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Password changed successfully', 'Das Passwort wurde erfolgreich geändert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Password change failed', 'Passwortänderung gescheitert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Enter new value', 'Neuen Wert eingeben', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Set Value', 'Wert einstellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Increment Value', 'Inkrementwert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Send Flags', 'Flaggen senden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'False/True', 'Falsch Richtig', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Decrement Value', 'Wert verringern', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Byte Swap?', 'Ist Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Is Word Swap?', 'Ist Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Point Class', 'Punktklasse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Static Variation', 'Statische Variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Event Variation', 'Event Variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Data Type', 'Datentyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Bit Offset', 'Bitversatz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Decimal Point', 'Komma', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Flags', 'Flaggen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Protocol Properties', 'Protokolleigenschaften', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Raw zero scale', 'Rohe Nullskala', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Raw full scale', 'Raw full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Eng zero scale', 'Eng Nullskala', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Period', 'Protokollzeitraum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Threshold', 'Protokollschwelle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Value Expression', 'Werteausdruck', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Log Expression', 'Protokollausdruck', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Protocol Type', 'Protokolltyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Protocols', 'Protokolle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new item added', 'Ein neuer Artikel hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'A new item detail added', 'Ein neues Artikeldetail hinzugefügt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Item detail updated', 'Artikeldetail aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Item updated', 'Artikel aktualisiert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Item removed', 'Gegenstand entfernt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Minutes Offset', 'Minutenversatz', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Local Address', 'Lokale Adresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Remote Address', 'Remote-Adresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Unsoliceted Events', 'Unaufgeforderte Ereignisse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Select Timeout', 'Timeout auswählen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Confirm Timeout', 'Timeout bestätigen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Retry Timeout', 'Wiederholungszeitlimit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Response Timeout', 'Antwortzeitlimit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Disable Unsolicated', 'Unsolicated deaktivieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Startup Integrity', 'Startup Integrity', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Integrity Overflow', 'Integritätsüberlauf', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Common Address', 'Gemeinsame Adresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Dnp3 type', 'Dnp3-Typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Event Buffer Size', 'Ereignispuffergröße', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Modbus type', 'Modbus-Typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Readable', 'Lesbar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Writeable', 'Beschreibbar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Iec104 type', 'Iec104 Typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Back', 'Zurück', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Next', 'Nächster', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'COMMUNICATION NETWORK', 'KOMMUNIKATIONSNETZWERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Finish', 'Fertig', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Check connection details', 'Verbindungsdetails überprüfen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Connection Details', 'Verbindungsdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'GAS STATION MODEL', 'GASSTATIONSMODELL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Device List', 'Geräteliste', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Device Form', 'Geräteformular', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Item', 'Artikel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Station Address', 'Stationsadresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'PAY', 'ZAHLEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'CHECK', 'PRÜFEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Stream Details', 'Stream Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'USE GC', 'USE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Saved!', 'Gerettet!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'DEFINED GAS STATION MODEL', 'DEFINIERTES GASSTATIONSMODELL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Capacity', 'Kapazität', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Group Name', 'Gruppenname', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Stream Modules List', 'Liste der Stream-Module', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Analyzer', 'Analysator', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Main Station', 'Hauptstation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Sub Station', 'Unterstation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'REPORT', 'BERICHT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Generate', 'Generieren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Failed to generate project', 'Projekt konnte nicht generiert werden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Station Details', 'Stationsdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'WebSocket is on', 'WebSocket ist aktiviert', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'WebSocket is off', 'WebSocket ist ausgeschaltet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'WebSocket error observed', 'WebSocket-Fehler beobachtet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Clear browser storage', 'Browser-Speicher löschen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'System statistics', 'Systemstatistik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Chatting', 'Chatten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Notifications', 'Benachrichtigungen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Sign-out', 'Ausloggen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Hide top', 'Versteck oben', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Are you sure you want to clear storage?', 'Sind Sie sicher, dass Sie den Speicher löschen möchten?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Press SHIFT+Q to return', 'Drücken Sie UMSCHALT + Q, um zurückzukehren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'Press SHIFT+W to return', 'Drücken Sie UMSCHALT + W, um zurückzukehren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('de', 'You are about to logged out. Are you sure you want to proceed?', 'Sie sind im Begriff, sich abzumelden. Sind Sie sicher, dass Sie fortfahren möchten?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('ar', 'inSCADA Login', 'تسجيل الدخول إلى inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Username', 'اسم المستخدم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Password', 'كلمه السر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Login', 'تسجيل الدخول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Language', 'لغة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Projects', 'المشاريع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'User Menu', 'قائمة المستخدم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Project Map', 'خريطة المشروع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Devices', 'الأجهزة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animations', 'الرسوم المتحركة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarms', 'إنذار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Trends', 'اتجاهات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Trend Tags', 'علامات الاتجاه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Trend Tag', 'علامة الاتجاه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Scripts', 'نصوص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Reports', 'التقارير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Emails', 'رسائل البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Logs', 'السجلات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Auth Log', 'سجل المصادقة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Users', 'المستخدمون', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Help', 'مساعدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'About', 'حول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Home', 'الصفحة الرئيسية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Connection', 'الإتصال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Trend Graphic', 'رسم الاتجاه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Trend Graphics', 'رسومات الاتجاه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Connections', 'روابط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Group', 'مجموعة التقارير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Aggregate', 'مجموع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Device Templates', 'قوالب الجهاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Frame Templates', 'قوالب الإطار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable Templates', 'قوالب متغيرة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Search', 'بحث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure you want to schedule/unschedule the selected script?', 'هل أنت متأكد أنك تريد جدولة / إلغاء جدولة البرنامج النصي المحدد؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Add New', 'اضف جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Save', 'حفظ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Delete', 'حذف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Yes', 'نعم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'No', 'لا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Status', 'الحالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Properties', 'الخصائص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure to continue?', 'هل أنت متأكد من الاستمرار؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Form data is invalid', 'بيانات النموذج غير صالحة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Visualization', 'التصور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Development', 'تطوير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Gas Metering', 'قياس الغاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Gas Control', 'التحكم في الغاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Control panel', 'لوحة التحكم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group', 'مجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Module', 'وحدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Station Adress', 'عنوان المحطة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Protocol', 'بروتوكول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On DateTime', 'في DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Acknowledge DateTime', 'إقرار التاريخ والوقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Settings', 'إعدادات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'General', 'جنرال لواء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Start adress', 'بدء العنوان', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Scan Time', 'وقت الفحص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Device Library', 'مكتبة الأجهزة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Expressions', 'التعبيرات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variables', 'المتغيرات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Wizard', 'ساحر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable History', 'تاريخ متغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Ip', 'ايب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Port', 'ميناء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Timeout', 'نفذ الوقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Frames', 'إطارات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Writeable?', 'هل يمكن الكتابة؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Readable?', 'هل يمكن قراءته؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Buffer size', 'حجم المخزن المؤقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print Time', 'وقت الطباعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print Day', 'يوم الطباعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print Hour', 'ساعة الطباعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Day', 'يوم التقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Time', 'وقت التقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Hour', 'ساعة التقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print?', 'طباعة؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Add Descriptions', 'إضافة الأوصاف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Jobs', 'وظائف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Last Execution Start Time', 'وقت بدء التنفيذ الأخير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Last Execution Ended Time', 'وقت انتهاء آخر تنفيذ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Next Execution Time', 'وقت التنفيذ التالي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Executions Count', 'عدد عمليات الإعدام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Project', 'مشروع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Name', 'اسم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Description', 'وصف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Start Date', 'تاريخ البدء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'End Date', 'تاريخ الانتهاء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Active?', 'نشط؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Location', 'موقعك', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Address', 'عنوان', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Latitude', 'خط العرض', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Longitude', 'خط الطول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Contract', 'عقد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Contract Day', 'يوم العقد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Contract Hour', 'ساعة العقد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new project added', 'تمت إضافة مشروع جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Project updated successfully', 'تم تحديث المشروع بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Project removed', 'تمت إزالة المشروع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Value', 'القيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure you want to continue?', 'هل أنت متأكد أنك تريد المتابعة؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'HPP Unit', 'وحدة HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Reload', 'إعادة تحميل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Acknowledge', 'الإقرار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Quantity', 'كمية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Type', 'نوع السجل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Unit', 'وحدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Expression Type', 'نوع التعبير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Retain Flag', 'الاحتفاظ بالعلامة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Word Swap', 'تبادل الكلمات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Byte Swap', 'مقايضة البايت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Load', 'حمل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Date Range', 'نطاق الموعد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable Picker', 'منتقي متغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Last Value', 'آخر قيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'First Value', 'القيمة الأولى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Min Value', 'الحد الأدنى للقيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Value', 'قيمة الحد الأقصى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Sum Value', 'مجموع القيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Count Value', 'قيمة العدد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Acknowledge DateTime Filter', 'التعرف على عامل تصفية التاريخ والوقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Off DateTime Filter', 'إيقاف عامل تصفية التاريخ والوقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On DateTime Filter', 'عامل تصفية التاريخ والوقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Search Form', 'نموذج بحث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Interval (Second)', 'الفاصل الزمني (ثانية)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On', 'على', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Off', 'إيقاف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Live', 'حي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Preview', 'معاينة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Cancel', 'إلغاء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Schedule', 'جدول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Severity', 'خطورة السجل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Activity', 'نشاط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Source', 'مصدر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Message', 'رسالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Remove', 'إزالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'User Roles', 'أدوار المستخدمين', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Role', 'وظيفة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Expression', 'التعبير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Delay', 'تأخير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Category', 'الفئة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On Script', 'في البرنامج النصي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Off Script', 'خارج البرنامج النصي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Ack Script', 'برنامج نصي Ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new alarm added', 'تمت إضافة منبه جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm updated successfully', 'تم تحديث المنبه بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm settings is updated', 'تم تحديث إعدادات المنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm removed', 'تمت إزالة المنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm History', 'تاريخ الإنذار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Type', 'نوع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Import', 'استيراد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Date', 'تاريخ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure you want to activate/deactivate the selected alarm?', 'هل أنت متأكد أنك تريد تنشيط / إلغاء تنشيط المنبه المحدد؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure you want to Start/Stop the selected connection?', 'هل أنت متأكد أنك تريد بدء / إيقاف الاتصال المحدد؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Code', 'الشفرة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Priority', 'أفضلية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Period', 'فترة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log', 'سجل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new script added', 'تمت إضافة نص جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Script updated successfully', 'تم تحديث البرنامج النصي بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Script removed', 'تمت إزالة النص البرمجي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Deviation Variable', 'متغير الانحراف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Total Variable', 'إجمالي المتغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Calculation Type', 'نوع الحساب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Order', 'طلب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Variables', 'متغيرات التقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Subgroup Order', 'ترتيب المجموعة الفرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Subgroups', 'تقرير المجموعات الفرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group Order', 'ترتيب المجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation Elements', 'عناصر الرسوم المتحركة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Parent Animation', 'الرسوم المتحركة للوالدين', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Color', 'اللون', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Duration', 'المدة الزمنية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Play Order', 'ترتيب اللعب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Play at Main?', 'تشغيل في الرئيسي؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SVG Content', 'محتوى SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation Type', 'نوع الحركة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new animation added', 'تمت إضافة رسم متحرك جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Only SVG files are allowed', 'مسموح فقط بملفات SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation updated successfully', 'تم تحديث الرسوم المتحركة بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation removed', 'تمت إزالة الرسوم المتحركة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new animation element added', 'تمت إضافة عنصر حركة جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation element updated successfully', 'تم تحديث عنصر الرسوم المتحركة بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation element removed', 'تمت إزالة عنصر الرسوم المتحركة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Min. Scale', 'الحد الأدنى للمقياس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max. Scale', 'ماكس. مقياس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Thickness', 'سماكة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Backup', 'دعم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Restore', 'استعادة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Save & Continue', 'حفظ ومتابعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable', 'متغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Default', 'إفتراضي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Add', 'إضافة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Default value', 'القيمة الافتراضية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Text', 'نص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Title', 'عنوان', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Size', 'بحجم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Disable', 'تعطيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Home View', 'عرض الصفحة الرئيسية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Time', 'زمن', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Second', 'ثانيا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Last Executed At', 'آخر تنفيذ في', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please select a master record first', 'الرجاء تحديد سجل رئيسي أولاً', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Send SMS', 'أرسل رسالة نصية قصيرة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SMS Details', 'تفاصيل الرسائل القصيرة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SMS Service', 'خدمة الرسائل القصيرة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SMS sended successfully', 'تم إرسال SMS بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SMS Search', 'بحث الرسائل القصيرة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Content', 'المحتوى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SMS Settings', 'إعدادات SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Mail sended successfully', 'تم إرسال البريد بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'No selected animation', 'لا توجد رسوم متحركة محددة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Recipient', 'مستلم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Online Help', 'مساعدة على الانترنت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm', 'إنذار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm Monitor', 'مراقب الإنذار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Smart Symbol', 'الرمز الذكي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Smart Sybols', 'الرموز الذكية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable Monitor', 'مراقب متغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Menu', 'قائمة طعام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm Group', 'مجموعة التنبيه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm Groups', 'مجموعات التنبيه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On No Ack Color', 'بدون لون Ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print When On?', 'طباعة عند تشغيل؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print When Off?', 'طباعة عند الإيقاف؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print When Ack?', 'طباعة متى Ack؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation', 'حيوية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Inverse', 'معكوس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Set Type', 'تعيين النوع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Notify', 'إعلام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Default Color', 'اللون الافتراضي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Gradient', 'الانحدار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Min', 'مين', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max', 'ماكس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Format', 'شكل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group Size', 'حجم المجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Decimal', 'عدد عشري', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group Seperator', 'فاصل المجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Decimal Seperator', 'فاصل عشري', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Leftpad Size', 'حجم لوحة اليسار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Rightpad Size', 'حجم اللوحة اليمنى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Character', 'حرف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Prefix', 'اختصار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Suffix', 'لاحقة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'tag', 'بطاقة شعار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Initial Pos', 'الموضع الأولي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Min Pos', 'Min Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'On Drop', 'عند الإسقاط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Join', 'انضم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Template?', 'هل القالب؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Dom Id', 'معرف دوم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation Element', 'عنصر الرسوم المتحركة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Mouse', 'الفأر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'More', 'أكثر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation WebSocket is on', 'مقبس ويب الرسوم المتحركة قيد التشغيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation WebSocket is off', 'مقبس ويب الرسوم المتحركة متوقف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Animation WebSocket error observed', 'لوحظ خطأ متحرك WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Pool Size', 'حجم تجمع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Adapter', 'مشترك كهربائي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Min Retry Delay', 'Min Retry Delay', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Retry Delay', 'Max Retry Delay', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Local Ip', 'عنوان IP المحلي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Local Port', 'ميناء محلي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Cot F. Length', 'طول السرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Cot Field Length', 'طول حقل سرير الأطفال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'IOA Field Length', 'طول حقل IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Common A. Length', 'الطول المشترك', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Common Address Field Length', 'طول حقل العنوان المشترك', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'IOA F. Length', 'IOA F. الطول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Originator Address', 'عنوان المنشئ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Message F. Timeout', 'الرسالة F. المهلة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Message Fragment Timeout', 'مهلة جزء الرسالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max T.N.A. Recieved', 'تم استلام Max T.N.A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Time No Ack Received', 'أقصى وقت لم يتم تلقي Ack فيه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max T.N.A. Sent', 'تم إرسال ماكس T.N.A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Time No Ack Sent', 'أقصى وقت لم يتم إرساله', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Idle Time', 'ماكس وقت الخمول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max U. IP Recieved', 'Max U. IP Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Unconfirmed IPdus Received', 'تم استلام Max Unconfirmed IPdus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Start DT Timeout', 'بدء مهلة DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Start DT Retries', 'بدء إعادة محاولات DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Coming Soon...', 'قريبا...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Rack', 'رف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Slot', 'فتحة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'No Data Transfer Selected', 'لم يتم تحديد نقل البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Destination', 'المكان المقصود', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Detail Form', 'نموذج التفاصيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Source Tag', 'علامة المصدر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Destination Tag', 'علامة الوجهة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Data Transfer', 'نقل البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Detail Transfer', 'نقل التفاصيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Device', 'جهاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Device Picker', 'منتقي الجهاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Import Tmpl', 'استيراد Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Start Address', 'عنوان البدء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'General I. Time', 'معلومات عامة. الوقت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'General Interrogation Time', 'وقت الاستجواب العام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'General C.I. Time', 'General CI Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'General Counter Interrogation Time', 'وقت الاستجواب المضاد العام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Cnt Point Offset', 'إزاحة نقطة Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Control Point Offset', 'إزاحة نقطة التحكم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'DB Number', 'رقم قاعدة البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'IEC104 type', 'نوع IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Sender', 'مرسل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Recepient', 'المستلم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Subject', 'موضوع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Email View', 'عرض البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'From', 'من عند', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'To', 'إلى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Email Search', 'بحث البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Email Service', 'خدمة البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Body', 'الجسم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Send Email', 'ارسل بريد الكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Send', 'إرسال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'User List', 'قائمة المستخدم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Mail send failed', 'فشل إرسال البريد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Email Settings', 'إعدادات البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Email', 'البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Backup/Restore', 'اسنرجاع البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Choose', 'أختر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Processes', 'العمليات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Data Transfers', 'عمليات نقل البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Keywords', 'الكلمات الدالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Roles', 'الأدوار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Templates', 'قوالب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Key', 'مفتاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Active', 'نشيط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Successful ?', 'ناجح ؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Auth Logs', 'سجلات المصادقة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'License', 'رخصة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Machine Id', 'هوية الماكنة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Surname', 'لقب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'User Limit', 'حد المستخدم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Update', 'تحديث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'License Key', 'مفتاح الترخيص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'License to', 'ترخيص لـ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'License successfully activated', 'تم تفعيل الترخيص بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Failed to activate', 'فشل التنشيط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm Name', 'اسم المنبه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Alarm Dsc', 'إنذار Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Start All', 'بدء الكل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Stop All', 'توقفو جميعا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'هل أنت متأكد أنك تريد جدولة / إلغاء جدولة نقل البيانات المحدد؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Process', 'معالجة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'GRAPHICAL VIEW', 'عرض رسومي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'FLOW RATE', 'معدل المد و الجزر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'METERING', 'قياس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'ENERGY & OTHER VALUES', 'الطاقة والقيم الأخرى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'IN-USE GAS COMPONENTS', 'مكونات الغاز أثناء الاستخدام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'TOTALISORS', 'TOTALISORS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'PREVIOUS HOURLY & DAILY VALUES', 'القيم اليومية والساعة السابقة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'ALARMS ON', 'التنبيهات على', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'NAME', 'اسم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'CURRENT', 'تيار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'C.HOUR', 'جيم ساعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'C.DAY', 'يوم جيم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'G.C.B', 'جي سي بي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'IN-USE', 'في الاستخدام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'MAX', 'ماكس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'DOWNLOADED', 'تم التنزيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'NORMALIZED', 'تطبيع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'UNIT', 'وحدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'PROPERTIES', 'الخصائص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'GC MANAGEMENT', 'GC MANAGEMENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SET', 'جلس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'STATUS', 'الحالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'QRCODE Reader', 'قارئ QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Scanned!', 'تم الفحص!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'deviceName', 'اسم الجهاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Failed to load data', 'فشل تحميل البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'ANIMATION', 'حيوية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'GAS METERING', 'قياس الغاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'GAS PROPERTIES', 'خصائص الغاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'NETWORK', 'شبكة الاتصال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Fired Alarm Duration In Days', 'تم إطلاق مدة الإنذار بالأيام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Fired Alarm duration is updated', 'تم تحديث مدة التنبيه المنفذة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Acknowledger', 'شكر وتقدير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Dsc', 'دسك', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Duration In Days', 'مدة التسجيل بالأيام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log duration is updated', 'تم تحديث مدة السجل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Remove All', 'حذف الكل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Firstly load the datatable', 'قم أولاً بتحميل جدول البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Failed to load log data', 'فشل تحميل بيانات السجل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure to remove all logs?', 'هل أنت متأكد من إزالة كافة السجلات؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'All logs removed', 'تمت إزالة كافة السجلات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'An error occured while removing logs', 'حدث خطأ أثناء إزالة السجلات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Message', 'رسالة تسجيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Show Weather On Click', 'إظهار الطقس عند النقر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Updated successfully', 'تم التحديث بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Removed successfully', 'تمت الإزالة بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Map', 'خريطة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Map api', 'خريطة api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Weather api', 'واجهة برمجة تطبيقات الطقس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Interval', 'فترة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Filter', 'منقي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'SCHEDULED', 'المقرر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'ON', 'على', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'OFF', 'إيقاف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Print', 'طباعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Failed to load!', 'فشل في التحميل!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Choose Trend', 'اختر الاتجاه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Avg Value', 'متوسط ​​القيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Integral Value', 'قيمة متكاملة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Diff Value', 'قيمة الفرق القصوى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Calculation type', 'نوع الحساب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Auto Scroll', 'لف تلقائي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Failed to load trend data', 'فشل تحميل بيانات الاتجاه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Select the Trend first', 'حدد الاتجاه أولاً', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Interval cannot be empty', 'لا يمكن أن يكون الفاصل الزمني فارغًا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable Duration In Days', 'المدة المتغيرة بالأيام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable duration is updated', 'تم تحديث مدة المتغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Frame', 'الإطار', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Usual', 'معتاد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Hourly', 'ساعيا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Daily', 'اليومي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'CUSTOM', 'مخصص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'COLLECTION', 'مجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Process Form', 'نموذج العملية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Background', 'خلفية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Text Color', 'لون الخط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Main Flag', 'العلم الرئيسي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Grid Flag', 'علامة الشبكة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Inputs', 'المدخلات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Choose Default Image', 'اختر الصورة الافتراضية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'States', 'تنص على', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'State Lists', 'قوائم الحالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'New State', 'دولة جديدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'State name', 'اسم الولاية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Attach', 'يربط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Library', 'مكتبة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Node updated', 'تم تحديث العقدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Property', 'خاصية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Project Property', 'ملكية المشروع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Project Values', 'قيم المشروع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Stream', 'مجرى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report', 'نقل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please, choose a period', 'من فضلك ، اختر فترة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Name field cannot be empty!', 'حقل الاسم لا يمكن أن يكون فارغا!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please choose a report', 'الرجاء اختيار تقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group order cannot be empty!', 'لا يمكن أن يكون ترتيب المجموعة فارغًا!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report group removed', 'تمت إزالة مجموعة التقارير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new Report group added', 'تمت إضافة مجموعة تقارير جديدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report group updated successfully', 'تم تحديث مجموعة التقارير بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report updated successfully', 'تم تحديث التقرير بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new report added', 'تمت إضافة تقرير جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report removed', 'تمت إزالة التقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please, select group', 'من فضلك ، حدد مجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report subgroup removed', 'تقرير إزالة المجموعة الفرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new Report subgroup added', 'تمت إضافة مجموعة فرعية تقرير جديدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report subgroup updated successfully', 'تم تحديث المجموعة الفرعية للإبلاغ بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report Variable', 'تقرير المتغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Subgroup', 'المجموعة الفرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please choose a subgroup', 'الرجاء اختيار مجموعة فرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable Order', 'ترتيب متغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Variable order cannot be empty', 'لا يمكن ترك الأمر المتغير فارغًا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please, choose calculation type', 'من فضلك ، اختر نوع الحساب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please, choose variable', 'من فضلك ، اختر متغير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Total', 'مجموع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Deviation', 'الانحراف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please, select subgroup', 'من فضلك ، حدد مجموعة فرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report variable removed', 'تمت إزالة متغير التقرير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new Report variable added', 'تمت إضافة متغير تقرير جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Report variable updated successfully', 'تم تحديث متغير التقرير بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Script Output', 'إخراج البرنامج النصي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Output message', 'رسالة الإخراج', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Empty output', 'إخراج فارغ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Error in code syntax', 'خطأ في بناء جملة الرمز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group Chat', 'مجموعة محادثة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Type message here', 'اكتب الرسالة هنا', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Type message', 'اكتب رسالة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Refresh Periods', 'فترات التحديث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Control Panel', 'لوحة التحكم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Gas Properties', 'خصائص الغاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Network', 'شبكة الاتصال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Graph Details', 'تفاصيل الرسم البياني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Check All', 'تحقق من الكل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Menus', 'القوائم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Permission', 'الإذن', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Permissions', 'أذونات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Rolename', 'اسم الدور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Role Menus', 'قوائم الدور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Menus are added', 'تم إضافة القوائم', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Please, select role', 'الرجاء تحديد الدور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', ' is removed', ' تم حذفه', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Role Permissions', 'أذونات الدور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Permissions are added', 'تمت إضافة الأذونات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new role added', 'تمت إضافة دور جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Role updated successfully', 'تم تحديث الدور بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Role is removed', 'تمت إزالة الدور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Reset Password', 'إعادة تعيين كلمة المرور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Password Info', 'معلومات كلمة المرور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'New Password', 'كلمة مرور جديدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Repeat New Password', 'كرر كلمة المرور الجديدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Passwords are not the same', 'كلمة السر غير متطابقة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Email Address', 'عنوان البريد الإلكتروني', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'User', 'المستعمل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Password changed successfully', 'تم تغيير الرقم السري بنجاح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Password change failed', 'فشل تغيير كلمة المرور', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Enter new value', 'أدخل قيمة جديدة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Set Value', 'تعيين القيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Increment Value', 'زيادة القيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Send Flags', 'إرسال الإشارات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'False/True', 'خطأ / صحيح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Decrement Value', 'قيمة التناقص', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Byte Swap?', 'هل يتم تبديل البايت؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Is Word Swap?', 'هل Word Swap؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Point Class', 'فئة النقطة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Static Variation', 'التباين الثابت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Event Variation', 'صيغة الحدث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Data Type', 'نوع البيانات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Bit Offset', 'إزاحة البت', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Decimal Point', 'العلامة العشرية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Flags', 'أعلام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Protocol Properties', 'خصائص البروتوكول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Raw zero scale', 'مقياس الصفر الخام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Raw full scale', 'الحجم الكامل الخام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Eng zero scale', 'مقياس الصفر المهندس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Period', 'فترة التسجيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Threshold', 'عتبة السجل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Value Expression', 'التعبير عن القيمة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Log Expression', 'تسجيل التعبير', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Protocol Type', 'نوع البروتوكول', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Protocols', 'بروتوكولات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new item added', 'تمت إضافة عنصر جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'A new item detail added', 'تمت إضافة تفاصيل عنصر جديد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Item detail updated', 'تم تحديث تفاصيل العنصر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Item updated', 'تم تحديث العنصر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Item removed', 'تمت إزالة العنصر', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Minutes Offset', 'دقيقة تعويض', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Local Address', 'العنوان المحلي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Remote Address', 'عنوان بعيد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Integrity Scantime', 'وقت النزاهة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Unsoliceted Events', 'أحداث غير مرغوب فيها', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Max Controls', 'ماكس الضوابط', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Select Timeout', 'حدد المهلة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Confirm Timeout', 'تأكيد المهلة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Retry Timeout', 'مهلة إعادة المحاولة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Response Timeout', 'مهلة الاستجابة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Event Scantime', 'وقت الحدث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Disable Unsolicated', 'تعطيل غير مطلوب', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Startup Integrity', 'سلامة بدء التشغيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Integrity Overflow', 'تجاوز النزاهة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Common Address', 'عنوان مشترك', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Dnp3 type', 'نوع Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Event Buffer Size', 'حجم المخزن المؤقت للحدث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Modbus type', 'نوع مودبوس', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Readable', 'مقروء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Writeable', 'قابل للكتابة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Iec104 type', 'نوع Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Back', 'عودة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Next', 'التالى', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'COMMUNICATION NETWORK', 'شبكة اتصال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Finish', 'إنهاء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Check connection details', 'التحقق من تفاصيل الاتصال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Connection Details', 'تفاصيل الاتصال', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'GAS STATION MODEL', 'نموذج محطة الغاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Device List', 'قائمة الأجهزة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Device Form', 'نموذج الجهاز', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Item', 'بند', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Station Address', 'عنوان المحطة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'PAY', 'دفع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'CHECK', 'التحقق من', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Stream Details', 'تفاصيل البث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'USE GC', 'استخدام GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Saved!', 'تم الحفظ!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'DEFINED GAS STATION MODEL', 'نموذج محطة الغاز المحدد', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Capacity', 'سعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Group Name', 'أسم المجموعة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Stream Modules List', 'قائمة وحدات البث', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Analyzer', 'محلل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Main Station', 'المحطة الرئيسية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Sub Station', 'المحطة الفرعية', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'REPORT', 'نقل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Generate', 'انشاء', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Failed to generate project', 'فشل إنشاء المشروع', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Station Details', 'تفاصيل المحطة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'WebSocket is on', 'WebSocket قيد التشغيل', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'WebSocket is off', 'WebSocket قيد الإيقاف', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'WebSocket error observed', 'تم ملاحظة خطأ WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Clear browser storage', 'مسح تخزين المتصفح', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'System statistics', 'إحصاءات النظام', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Chatting', 'الدردشة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Notifications', 'إشعارات', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Sign-out', 'خروج', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Hide top', 'إخفاء الجزء العلوي', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Are you sure you want to clear storage?', 'هل أنت متأكد أنك تريد مسح مساحة التخزين؟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Press SHIFT+Q to return', 'اضغط على SHIFT + Q للعودة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'Press SHIFT+W to return', 'اضغط على SHIFT + W للعودة', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ar', 'You are about to logged out. Are you sure you want to proceed?', 'أنت على وشك تسجيل الخروج. هل أنت متأكد أنك تريد المتابعة؟', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('ja', 'inSCADA Login', 'inSCADAログイン', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Username', 'ユーザー名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Password', 'パスワード', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Login', 'ログインする', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Language', '言語', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Projects', 'プロジェクト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'User Menu', 'ユーザーメニュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Project Map', 'プロジェクトマップ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Devices', 'デバイス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animations', 'アニメーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarms', 'アラーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Trends', 'トレンド', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Trend Tags', 'トレンドタグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Trend Tag', 'トレンドタグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Scripts', 'スクリプト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Reports', 'レポート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Emails', 'メール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Logs', 'ログ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Auth Log', '認証ログ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Users', 'ユーザー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Help', '助けて', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'About', '約', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Home', 'ホーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Connection', '接続', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Trend Graphic', 'トレンドグラフィック', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Trend Graphics', 'トレンドグラフィックス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Connections', '接続', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Group', '報告グループ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Aggregate', '集計', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Device Templates', 'デバイステンプレート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Frame Templates', 'フレームテンプレート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable Templates', '変数テンプレート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Search', '探す', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure you want to schedule/unschedule the selected script?', '選択したスクリプトをスケジュール/スケジュール解除してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Add New', '新しく追加する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Save', '保存する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Delete', '削除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Yes', 'はい', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'No', '番号', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Status', '状態', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Properties', 'プロパティ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure to continue?', '続行してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Form data is invalid', 'フォームデータが無効です', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Visualization', '視覚化', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Development', '開発', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Gas Metering', 'ガスメータリング', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Gas Control', 'ガス制御', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Control panel', 'コントロールパネル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group', 'グループ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Module', 'モジュール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Station Adress', 'ステーションアドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Protocol', 'プロトコル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On DateTime', '日時に', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Acknowledge DateTime', '日時を確認する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Settings', '設定', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'General', '一般的な', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Start adress', '住所を開始', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Scan Time', 'スキャン時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Device Library', 'デバイスライブラリ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Expressions', '式', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variables', '変数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Wizard', 'ウィザード', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable History', '可変履歴', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Ip', 'IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Port', 'ポート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Timeout', 'タイムアウト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Frames', 'フレーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Writeable?', '書き込み可能ですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Readable?', '読みやすいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Buffer size', 'バッファサイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print Time', '印刷時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print Day', '印刷日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print Hour', '印刷時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Day', 'レポートデー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Time', 'レポート時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Hour', 'レポート時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print?', '印刷しますか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Add Descriptions', '説明を追加', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Jobs', 'ジョブズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Last Execution Start Time', '最終実行開始時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Last Execution Ended Time', '最終実行終了時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Next Execution Time', '次の実行時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Executions Count', '実行数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Project', '事業', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Name', '名前', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Description', '説明文', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Start Date', '開始日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'End Date', '終了日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Active?', 'アクティブです？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Location', 'ロケーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Address', '住所', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Latitude', '緯度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Longitude', '経度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Contract', '契約する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Contract Day', '契約日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Contract Hour', '契約時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new project added', '新しいプロジェクトが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Project updated successfully', 'プロジェクトが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Project removed', 'プロジェクトが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Value', '値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure you want to continue?', '続行してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'HPP Unit', 'HPPユニット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Reload', 'リロード', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Acknowledge', '認める', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Quantity', '量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Type', 'ログタイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Unit', '単位', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Expression Type', '式の種類', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Retain Flag', 'フラグを保持', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Word Swap', 'ワードスワップ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Byte Swap', 'バイトスワップ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Load', '負荷', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Date Range', '日付範囲', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable Picker', '可変ピッカー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Last Value', '最後の値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'First Value', '最初の値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Min Value', '最小値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Value', '最大値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Sum Value', '合計値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Count Value', 'カウント値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Acknowledge DateTime Filter', '日時フィルターを確認する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Off DateTime Filter', 'オフ日時フィルター', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On DateTime Filter', '日時フィルターについて', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Search Form', '検索フォーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Off DateTime', 'オフ日時', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Interval (Second)', '間隔（秒）', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On', 'オン', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Off', 'オフ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Live', '住む', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Preview', 'プレビュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Cancel', 'キャンセル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Schedule', 'スケジュール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Severity', 'ログの重大度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Activity', 'アクティビティ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Source', 'ソース', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Message', 'メッセージ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Remove', '削除する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'User Roles', 'ユーザーの役割', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Role', '役割', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Expression', '表現', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Delay', 'ディレイ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Category', 'カテゴリー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On Script', 'スクリプト上', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Off Script', 'オフスクリプト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Ack Script', 'Ackスクリプト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new alarm added', '新しいアラームが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm updated successfully', 'アラームが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm settings is updated', 'アラーム設定が更新されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm removed', 'アラームが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm History', 'アラーム履歴', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Type', 'タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Import', 'インポート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Date', '日付', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure you want to activate/deactivate the selected alarm?', '選択したアラームをアクティブ化/非アクティブ化してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure you want to Start/Stop the selected connection?', '選択した接続を開始/停止してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Code', 'コード', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Priority', '優先', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Period', '限目', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log', 'ログ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new script added', '新しいスクリプトが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Script updated successfully', 'スクリプトが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Script removed', 'スクリプトが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Deviation Variable', '偏差変数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Total Variable', '合計変数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Calculation Type', '計算タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Order', '注文', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Variables', 'レポート変数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Subgroup Order', 'サブグループの順序', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Subgroups', 'レポートサブグループ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group Order', 'グループ注文', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation Elements', 'アニメーション要素', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Parent Animation', '親アニメーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Color', '色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Duration', '期間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Play Order', '注文を再生', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Play at Main?', 'メインでプレイしますか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SVG Content', 'SVGコンテンツ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation Type', 'アニメーションタイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new animation added', '新しいアニメーションが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Only SVG files are allowed', 'SVGファイルのみが許可されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation updated successfully', 'アニメーションが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation removed', 'アニメーションが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new animation element added', '新しいアニメーション要素が追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation element updated successfully', 'アニメーション要素が正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation element removed', 'アニメーション要素が削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Min. Scale', '最小規模', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max. Scale', '最大規模', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Thickness', '厚さ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Backup', 'バックアップ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Restore', '戻す', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Save & Continue', '保存して続行', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable', '変数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Default', 'デフォルト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Add', '追加', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Default value', 'デフォルト値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Text', 'テキスト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Title', '題名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Size', 'サイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Disable', '無効にする', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Home View', 'ホームビュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Time', '時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Second', '2番目', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Last Executed At', '最終実行日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please select a master record first', '最初にマスターレコードを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Send SMS', 'SMSを送信', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SMS Details', 'SMSの詳細', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SMS Service', 'SMSサービス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SMS sended successfully', 'SMSが正常に送信されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SMS Search', 'SMS検索', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Content', 'コンテンツ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SMS Settings', 'SMS設定', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Mail sended successfully', 'メールは正常に送信されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'No selected animation', 'アニメーションが選択されていません', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Recipient', '受信者', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Online Help', 'オンラインヘルプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Menu', 'メニュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm', '警報', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm Monitor', 'アラームモニター', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Smart Symbol', 'スマートシンボル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Smart Symbols', 'スマートシンボル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable Monitor', '可変モニター', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm Group', 'アラームグループ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm Groups', 'アラームグループ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On No Ack Color', 'アックカラーなし', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On Ack Color', 'Ackカラーについて', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Off No Ack Color', 'オフノーアックカラー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Off Ack Color', 'オフアックカラー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print When On?', 'オンのときに印刷しますか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print When Off?', 'オフのときに印刷しますか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print When Ack?', '確認したら印刷しますか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation', 'アニメーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Inverse', '逆', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Set Type', 'セットタイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Notify', '通知する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Default Color', 'デフォルトの色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Gradient', '勾配', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Min', '最小', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max', 'マックス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Format', 'フォーマット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group Size', 'グループサイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Decimal', '10進数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group Seperator', 'グループセパレーター', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Decimal Seperator', '小数点', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Leftpad Size', '左パッドサイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Rightpad Size', '右パッドサイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Character', 'キャラクター', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Prefix', 'プレフィックス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Suffix', 'サフィックス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'tag', '鬼ごっこ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Initial Pos', '初期位置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Min Pos', '最小位置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Pos', '最大位置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'On Drop', 'ドロップ時', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Join', '参加する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Template?', 'テンプレートですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Dom Id', 'ドムID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation Element', 'アニメーション要素', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Mouse', 'マウス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'More', 'もっと', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation WebSocket is on', 'アニメーションWebSocketがオンになっています', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation WebSocket is off', 'アニメーションWebSocketがオフになっています', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Animation WebSocket error observed', 'アニメーションWebSocketエラーが観察されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Pool Size', 'プールサイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Adapter', 'アダプタ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Min Retry Delay', '最小再試行遅延', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Retry Delay', '最大再試行遅延', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Local Ip', 'ローカルIP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Local Port', 'ローカルポート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Cot F. Length', 'ベビーベッドF.長さ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Cot Field Length', 'ベビーベッドのフィールドの長さ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'IOA Field Length', 'IOAフィールド長', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Common A. Length', '共通A.長さ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Common Address Field Length', '共通アドレスフィールドの長さ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'IOA F. Length', 'IOAF。長さ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Originator Address', '発信者アドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Message F. Timeout', 'メッセージF.タイムアウト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Message Fragment Timeout', 'メッセージフラグメントのタイムアウト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max T.N.A. Recieved', 'マックスT.N.A.受け取りました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Time No Ack Received', '確認応答が受信されなかった最大時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max T.N.A. Sent', 'マックスT.N.A.送信済み', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Time No Ack Sent', '最大送信時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Idle Time', '最大アイドル時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max U. IP Recieved', '最大U.IP受信', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Unconfirmed IPdus Received', '受信した未確認のIPduの最大数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Start DT Timeout', 'DTタイムアウトの開始', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Start DT Retries', 'DT再試行を開始します', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Coming Soon...', '近日公開...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Rack', 'ラック', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Slot', 'スロット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'No Data Transfer Selected', 'データ転送が選択されていません', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Destination', '先', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Detail Form', '詳細フォーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Source Tag', 'ソースタグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Destination Tag', '宛先タグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Data Transfer', 'データ転送', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Detail Transfer', '詳細転送', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Device', '端末', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Device Picker', 'デバイスピッカー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Import Tmpl', 'Tmplのインポート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Start Address', '開始アドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'General I. Time', '一般的なI.時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'General Interrogation Time', '一般的な尋問時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'General C.I. Time', '一般的なC.I.時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'General Counter Interrogation Time', '一般的なカウンター尋問時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Cnt Point Offset', 'Cntポイントオフセット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Control Point Offset', 'コントロールポイントオフセット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'DB Number', 'DB番号', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'IEC104 type', 'IEC104タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Sender', '送信者', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Recepient', '受信者', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Subject', '件名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Email View', 'メールビュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'From', 'から', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'To', 'に', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Email Search', 'メール検索', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Email Service', 'メールサービス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Body', '体', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Send Email', 'メールを送る', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Send', '送信', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'User List', 'ユーザーリスト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Mail send failed', 'メール送信に失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Email Settings', 'メール設定', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Email', 'Eメール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Backup/Restore', '復元する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Choose', '選択', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Processes', 'プロセス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Data Transfers', 'データ転送', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Keywords', 'キーワード', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Roles', '役割', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Templates', 'テンプレート', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Key', 'キー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Active', 'アクティブ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Successful ?', '成功していますか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Auth Logs', '認証ログ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'License', 'ライセンス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Machine Id', 'マシンID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Surname', '姓', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'User Limit', 'ユーザー制限', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Update', '更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'License Key', 'ライセンスキー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'License to', 'にライセンス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'License successfully activated', 'ライセンスが正常にアクティブ化されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Failed to activate', 'アクティベートに失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm Name', 'アラーム名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Alarm Dsc', 'アラームDSC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Start All', 'すべて開始', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Stop All', 'すべて停止', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure you want to schedule/unschedule the selected data transfer?', '選択したデータ転送をスケジュール/スケジュール解除してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Process', '処理する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'GRAPHICAL VIEW', 'グラフィカルビュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'FLOW RATE', '流量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'METERING', '計測', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'ENERGY & OTHER VALUES', 'エネルギーとその他の価値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'IN-USE GAS COMPONENTS', '使用中のガスコンポーネント', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'TOTALISORS', '合計', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'PREVIOUS HOURLY & DAILY VALUES', '以前の1時間ごとおよび1日ごとの値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'ALARMS ON', 'ALARMSON', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'NAME', '名前', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'CURRENT', '電流', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'KEY-PAD', 'キーパッド', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'IN-USE', '使用中で', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'DOWNLOADED', 'ダウンロード済み', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'NORMALIZED', '正規化', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'UNIT', '単位', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'PROPERTIES', 'プロパティ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'GC MANAGEMENT', 'GC管理', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'INUSE GC', 'INUSEGC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SET', 'セットする', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'STATUS', '状態', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'QRCODE Reader', 'QRCODEリーダー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Scanned!', 'スキャンしました！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'deviceName', '装置名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Failed to load data', 'データのロードに失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'ANIMATION', 'アニメーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'GAS METERING', 'ガスメータリング', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'GAS PROPERTIES', 'ガス特性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'NETWORK', '通信網', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Fired Alarm Duration In Days', '日単位の発火アラーム持続時間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Fired Alarm duration is updated', '発火アラームの持続時間が更新されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Acknowledger', 'アクノレッジャー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Duration In Days', 'ログ期間（日数）', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log duration is updated', 'ログ期間が更新されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Remove All', 'すべて削除する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Firstly load the datatable', 'まず、データテーブルをロードします', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Failed to load log data', 'ログデータの読み込みに失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure to remove all logs?', 'すべてのログを削除してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'All logs removed', 'すべてのログが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'An error occured while removing logs', 'ログの削除中にエラーが発生しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Message', 'ログメッセージ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Show Weather On Click', 'クリック時に天気を表示', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Updated successfully', '更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Removed successfully', '正常に削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Map', '地図', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Map api', 'マップAPI', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Weather api', '天気API', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Interval', '間隔', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Filter', 'フィルタ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'SCHEDULED', 'スケジュール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'ON', 'オン', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'OFF', 'オフ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Print', '印刷', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Failed to load!', '読み込みに失敗しました！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Choose Trend', 'トレンドを選択', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Avg Value', '平均値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Integral Value', '積分値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Diff Value', '最大差分値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Calculation type', '計算タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Auto Scroll', '自動スクロール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Failed to load trend data', 'トレンドデータの読み込みに失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Select the Trend first', '最初にトレンドを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Interval cannot be empty', '間隔を空にすることはできません', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable Duration In Days', '日単位の可変期間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable duration is updated', '可変期間が更新されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Frame', 'フレーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Usual', '通常', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Hourly', '毎時', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Daily', '毎日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'CUSTOM', 'カスタム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'COLLECTION', 'コレクション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Process Form', 'プロセスフォーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Background', 'バックグラウンド', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Text Color', 'テキストの色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Main Flag', 'メインフラグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Grid Flag', 'グリッドフラグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Inputs', '入力', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Choose Default Image', 'デフォルトの画像を選択', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'States', '州', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'State Lists', '状態リスト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'New State', '新しい状態', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'State name', '州名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Attach', '添付', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Library', '図書館', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Node updated', 'ノードが更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Property', '物件', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Project Property', 'プロジェクトプロパティ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Project Values', 'プロジェクトの価値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Stream', 'ストリーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report', '報告書', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please, choose a period', '期間を選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Name field cannot be empty!', '名前フィールドを空にすることはできません！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please choose a report', 'レポートを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group order cannot be empty!', 'グループの注文を空にすることはできません。', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report group removed', 'レポートグループが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new Report group added', '新しいレポートグループが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report group updated successfully', 'レポートグループが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report updated successfully', 'レポートが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new report added', '新しいレポートが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report removed', 'レポートが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please, select group', 'グループを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report subgroup removed', 'レポートサブグループが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new Report subgroup added', '新しいレポートサブグループが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report subgroup updated successfully', 'レポートサブグループが正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report Variable', 'レポート変数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Subgroup', 'サブグループ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please choose a subgroup', 'サブグループを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable Order', '可変順序', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Variable order cannot be empty', '変数の順序を空にすることはできません', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please, choose calculation type', '計算タイプを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please, choose variable', '変数を選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Total', '合計', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Deviation', '偏差', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please, select subgroup', 'サブグループを選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report variable removed', 'レポート変数が削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new Report variable added', '新しいレポート変数が追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Report variable updated successfully', 'レポート変数が正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Script Output', 'スクリプト出力', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Output message', '出力メッセージ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Empty output', '空の出力', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Error in code syntax', 'コード構文のエラー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group Chat', 'グループチャット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Type message here', 'ここにメッセージを入力してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Type message', 'メッセージを入力します', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Refresh Periods', '更新期間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Control Panel', 'コントロールパネル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Gas Properties', 'ガス特性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Network', '通信網', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Graph Details', 'グラフの詳細', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Check All', 'すべてチェック', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Menus', 'メニュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Permission', '許可', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Permissions', '権限', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Rolename', 'ロール名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Role Menus', '役割メニュー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Menus are added', 'メニューが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Please, select role', '役割を選択してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', ' is removed', '削除されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Role Permissions', '役割の権限', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Permissions are added', '権限が追加されます', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new role added', '新しい役割が追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Role updated successfully', '役割が正常に更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Role is removed', '役割が削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Reset Password', 'パスワードを再設定する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Password Info', 'パスワード情報', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'New Password', '新しいパスワード', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Repeat New Password', '新しいパスワードを繰り返す', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Passwords are not the same', 'パスワードは同じではありません', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Email Address', '電子メールアドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'User', 'ユーザー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Password changed successfully', 'パスワードは正常に変更されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Password change failed', 'パスワードの変更に失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Enter new value', '新しい値を入力してください', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Set Value', '設定値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Increment Value', 'インクリメント値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Send Flags', 'フラグを送信する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'False/True', '真偽', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Decrement Value', '値のデクリメント', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Byte Swap?', 'バイトスワップですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Is Word Swap?', 'ワードスワップですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Point Class', 'ポイントクラス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Deadband', 'デッドバンド', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Static Variation', '静的変動', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Event Variation', 'イベントバリエーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Data Type', 'データ・タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Bit Offset', 'ビットオフセット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Decimal Point', '小数点', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Flags', 'フラグ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Protocol Properties', 'プロトコルプロパティ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Raw zero scale', '生のゼロスケール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Raw full scale', '生の実物大', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Eng zero scale', 'Engゼロスケール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Eng full scale', '本格的なエンジニアリング', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Period', 'ログ期間', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Threshold', 'ログのしきい値', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Value Expression', '値式', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Log Expression', 'ログ式', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Protocol Type', 'プロトコルタイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Protocols', 'プロトコル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new item added', '新しいアイテムが追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'A new item detail added', '新しいアイテムの詳細が追加されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Item detail updated', 'アイテムの詳細が更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Item updated', 'アイテムが更新されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Item removed', 'アイテムが削除されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Minutes Offset', '分オフセット', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Local Address', 'ローカルアドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Remote Address', 'リモートアドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Integrity Scantime', '整合性スキャンタイム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Unsoliceted Events', '未承諾のイベント', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Max Controls', '最大コントロール', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Select Timeout', 'タイムアウトを選択', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Confirm Timeout', 'タイムアウトの確認', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Retry Timeout', '再試行タイムアウト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Response Timeout', '応答タイムアウト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Event Scantime', 'イベントスキャンタイム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Disable Unsolicated', '未承諾を無効にする', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Startup Integrity', 'スタートアップの完全性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Integrity Overflow', '整合性のオーバーフロー', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Common Address', '共通アドレス', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Dnp3 type', 'Dnp3タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Event Buffer Size', 'イベントバッファサイズ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Modbus type', 'Modbusタイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Readable', '読みやすい', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Writeable', '書き込み可能', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Iec104 type', 'Iec104タイプ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Back', 'バック', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Next', '次', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'COMMUNICATION NETWORK', '通信ネットワーク', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Finish', '終了', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Check connection details', '接続の詳細を確認する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Connection Details', '接続の詳細', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'GAS STATION MODEL', 'ガソリンスタンドモデル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Device List', 'デバイスリスト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Device Form', 'デバイスフォーム', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Item', '項目', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Station Address', '駅の住所', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'PAY', '支払う', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'CHECK', '小切手', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Stream Details', 'ストリームの詳細', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'USE GC', 'GCを使用する', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Saved!', '保存しました！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'DEFINED GAS STATION MODEL', '定義されたガソリンスタンドモデル', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Capacity', '容量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Group Name', 'グループ名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Stream Modules List', 'ストリームモジュールリスト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Analyzer', 'アナライザ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'RTU/PLC', 'RTU/PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Main Station', '中央駅', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Sub Station', 'サブステーション', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'REPORT', '報告書', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Generate', '生む', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Failed to generate project', 'プロジェクトの生成に失敗しました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Station Details', 'ステーションの詳細', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'WebSocket is on', 'WebSocketがオンになっています', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'WebSocket is off', 'WebSocketがオフになっています', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'WebSocket error observed', 'WebSocketエラーが観察されました', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Clear browser storage', 'ブラウザストレージをクリアする', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'System statistics', 'システム統計', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Chatting', 'おしゃべり', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Notifications', '通知', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Sign-out', 'サインアウト', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Hide top', 'トップを隠す', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Are you sure you want to clear storage?', 'ストレージをクリアしてもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Press SHIFT+Q to return', 'SHIFT+Qを押して戻ります', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'Press SHIFT+W to return', 'SHIFT+Wを押して戻ります', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ja', 'You are about to logged out. Are you sure you want to proceed?', 'ログアウトしようとしています。続行してもよろしいですか？', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('nl', 'inSCADA Login', 'inSCADA Login', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Username', 'Gebruikersnaam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Password', 'Wachtwoord', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Login', 'Log in', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Language', 'Taal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Projects', 'Projecten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'User Menu', 'Gebruikersmenu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Project Map', 'Projectkaart', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Devices', 'Apparaten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animations', 'Animaties', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarms', 'Wekkers', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Trends', 'Trends', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Trend Tags', 'Trendtags', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Trend Tag', 'Trendtag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Scripts', 'Scripts', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Reports', 'Rapporten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Emails', 'E-mails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Logs', 'Logboeken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Auth Log', 'Auth Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Users', 'Gebruikers', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Help', 'Helpen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'About', 'Over', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Home', 'Huis', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Connection', 'Verbinding', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Trend Graphic', 'Trendafbeelding', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Trend Graphics', 'Trendafbeeldingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Connections', 'Verbindingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Group', 'Rapportgroep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Aggregate', 'Aggregaat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Device Templates', 'Apparaatsjablonen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Frame Templates', 'Framesjablonen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable Templates', 'Variabele sjablonen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Search', 'Zoeken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure you want to schedule/unschedule the selected script?', 'Weet u zeker dat u het geselecteerde script wilt plannen / verwijderen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Add New', 'Nieuwe toevoegen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Save', 'Opslaan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Delete', 'Verwijderen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Yes', 'Ja', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'No', 'Nee', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Status', 'Toestand', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Properties', 'Eigendommen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure to continue?', 'Weet u zeker dat u door wilt gaan?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Form data is invalid', 'Formuliergegevens zijn ongeldig', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Visualization', 'Visualisatie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Development', 'Ontwikkeling', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Gas Metering', 'Gasmeting', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Gas Control', 'Gas Controle', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Control panel', 'Controlepaneel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group', 'Groep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Module', 'Module', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Station Adress', 'Station adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Protocol', 'Protocol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On DateTime', 'Op DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Acknowledge DateTime', 'Bevestig DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Settings', 'Instellingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'General', 'Algemeen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Start adress', 'Start adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Scan Time', 'Scan tijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Device Library', 'Apparaatbibliotheek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Expressions', 'Uitdrukkingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variables', 'Variabelen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Wizard', 'Tovenaar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable History', 'Variabele geschiedenis', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Ip', 'Ik p', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Port', 'Haven', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Timeout', 'Time-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Frames', 'Frames', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Writeable?', 'Is beschrijfbaar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Readable?', 'Is leesbaar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Buffer size', 'Buffer grootte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print Time', 'Afdruktijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print Day', 'Afdrukdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print Hour', 'Afdrukuur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Day', 'Rapportdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Time', 'Rapporttijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Hour', 'Rapportuur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print?', 'Afdrukken?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Add Descriptions', 'Voeg beschrijvingen toe', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Jobs', 'Jobs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Last Execution Start Time', 'Starttijd laatste uitvoering', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Last Execution Ended Time', 'Tijd laatste uitvoering beëindigd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Next Execution Time', 'Volgende uitvoeringstijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Executions Count', 'Executies tellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Project', 'Project', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Name', 'Naam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Description', 'Omschrijving', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Start Date', 'Begin datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'End Date', 'Einddatum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Active?', 'Is actief?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Location', 'Plaats', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Address', 'Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Latitude', 'Breedtegraad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Longitude', 'Lengtegraad', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Contract', 'Contract', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Contract Day', 'Contractdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Contract Hour', 'Contractuur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new project added', 'Een nieuw project toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Project updated successfully', 'Project succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Project removed', 'Project verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Value', 'Waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure you want to continue?', 'Weet je zeker dat je door wilt gaan?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'HPP Unit', 'HPP-eenheid', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Reload', 'Opnieuw laden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Acknowledge', 'Erkennen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Quantity', 'Aantal stuks', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Type', 'Logboektype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Unit', 'Eenheid', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Expression Type', 'Uitdrukkingstype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Retain Flag', 'Vlag behouden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Word Swap', 'Woordwisseling', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Byte Swap', 'Byte Swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Load', 'Laden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Date Range', 'Datumbereik', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable Picker', 'Variabele kiezer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Last Value', 'Laatste waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'First Value', 'Eerste waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Min Value', 'Min. Waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Value', 'Maximum waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Sum Value', 'Somwaarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Count Value', 'Telwaarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Acknowledge DateTime Filter', 'Bevestig datum / tijd-filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Off DateTime Filter', 'Off DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On DateTime Filter', 'Op DateTime-filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Search Form', 'Zoekformulier', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Interval (Second)', 'Interval (tweede)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On', 'Aan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Off', 'Uit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Live', 'Leven', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Preview', 'Voorbeeld', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Cancel', 'Annuleren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Schedule', 'Schema', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Severity', 'Ernst van logboek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Activity', 'Werkzaamheid', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Source', 'Bron', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Message', 'Bericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Remove', 'Verwijderen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'User Roles', 'Gebruikersrollen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Role', 'Rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Expression', 'Uitdrukking', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Delay', 'Vertraging', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Category', 'Categorie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On Script', 'Op script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new alarm added', 'Een nieuw alarm toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm updated successfully', 'Alarm succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm settings is updated', 'Alarminstellingen zijn bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm removed', 'Alarm verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm History', 'Alarmgeschiedenis', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Type', 'Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Import', 'Importeren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Date', 'Datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure you want to activate/deactivate the selected alarm?', 'Weet u zeker dat u het geselecteerde alarm wilt activeren / deactiveren?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure you want to Start/Stop the selected connection?', 'Weet u zeker dat u de geselecteerde verbinding wilt starten / stoppen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Code', 'Code', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Priority', 'Prioriteit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Period', 'Periode', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log', 'Logboek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new script added', 'Een nieuw script toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Script updated successfully', 'Script succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Script removed', 'Script verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Deviation Variable', 'Afwijkingsvariabele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Total Variable', 'Totale variabele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Calculation Type', 'Berekeningstype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Order', 'Bestellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Variables', 'Rapportvariabelen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Subgroup Order', 'Subgroepvolgorde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Subgroups', 'Rapporteer subgroepen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group Order', 'Groepsorder', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation Elements', 'Animatie-elementen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Parent Animation', 'Ouderanimatie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Color', 'Kleur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Duration', 'Looptijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Play Order', 'Speelvolgorde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Play at Main?', 'Spelen bij Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SVG Content', 'SVG-inhoud', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation Type', 'Animatietype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new animation added', 'Een nieuwe animatie toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Only SVG files are allowed', 'Alleen SVG-bestanden zijn toegestaan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation updated successfully', 'Animatie succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation removed', 'Animatie verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new animation element added', 'Een nieuw animatie-element toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation element updated successfully', 'Animatie-element is geüpdatet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation element removed', 'Animatie-element verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Min. Scale', 'Min. Schaal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max. Scale', 'Max. Schaal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Thickness', 'Dikte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Backup', 'Back-up', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Restore', 'Herstellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Save & Continue', 'Opslaan doorgaan', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable', 'Variabele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Default', 'Standaard', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Add', 'Toevoegen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Default value', 'Standaardwaarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Text', 'Tekst', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Title', 'Titel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Size', 'Grootte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Disable', 'Uitschakelen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Home View', 'Home View', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Time', 'Tijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Second', 'Tweede', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Last Executed At', 'Laatst uitgevoerd om', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please select a master record first', 'Selecteer eerst een masterrecord', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Send SMS', 'Verstuur sms', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SMS Details', 'Sms-details', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SMS Service', 'SMS-service', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SMS sended successfully', 'Sms succesvol verzonden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SMS Search', 'SMS zoeken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Content', 'Inhoud', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SMS Settings', 'SMS-instellingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Mail sended successfully', 'E-mail succesvol verzonden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'No selected animation', 'Geen geselecteerde animatie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Recipient', 'Ontvanger', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Online Help', 'Online hulp', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm Monitor', 'Alarmmonitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Smart Symbol', 'Slim symbool', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Smart Symbols', 'Slimme symbolen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable Monitor', 'Variabele monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm Group', 'Alarmgroep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm Groups', 'Alarmgroepen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print When On?', 'Afdrukken wanneer aan?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print When Off?', 'Afdrukken indien uitgeschakeld?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print When Ack?', 'Afdrukken bij ontvangst?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation', 'Animatie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Inverse', 'Inverse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Set Type', 'Type instellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Notify', 'Melden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Default Color', 'Standaardkleur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Gradient', 'Verloop', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Format', 'Formaat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group Size', 'Groepsgrootte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Decimal', 'Decimale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group Seperator', 'Groepseparator', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Decimal Seperator', 'Decimale scheidingsteken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Leftpad Size', 'Leftpad Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Rightpad Size', 'Grootte rechterkussen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Character', 'Karakter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Prefix', 'Voorvoegsel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Suffix', 'Achtervoegsel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'tag', 'label', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Initial Pos', 'Initial Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Min Pos', 'Min Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Join', 'Meedoen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Template?', 'Is sjabloon?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Dom Id', 'Dom-ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation Element', 'Animatie-element', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Mouse', 'Muis', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'More', 'Meer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation WebSocket is on', 'Animation WebSocket is ingeschakeld', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation WebSocket is off', 'Animation WebSocket is uitgeschakeld', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Animation WebSocket error observed', 'Animation WebSocket-fout waargenomen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Pool Size', 'Zwembad grootte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Min Retry Delay', 'Min. Opnieuw proberen vertraging', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Retry Delay', 'Max. Vertraging opnieuw proberen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Local Ip', 'Lokale Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Local Port', 'Lokale poort', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Cot F. Length', 'Cot F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Cot Field Length', 'Lengte veldbed', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'IOA Field Length', 'IOA-veldlengte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Common A. Length', 'Common A. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Common Address Field Length', 'Lengte gemeenschappelijk adresveld', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'IOA F. Length', 'IOA F. Lengte', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Originator Address', 'Originator Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Message F. Timeout', 'Bericht F. Time-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Message Fragment Timeout', 'Time-out berichtfragment', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max T.N.A. Recieved', 'Max T.N.A. ontvangen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Time No Ack Received', 'Max. Tijd geen ontvangst ontvangen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max T.N.A. Sent', 'Max T.N.A. verzonden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Time No Ack Sent', 'Max. Tijd niet verzonden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Idle Time', 'Max Idle Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max U. IP Recieved', 'Max. U. IP ontvangen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Unconfirmed IPdus Received', 'Max. Onbevestigde IPdus ontvangen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Start DT Timeout', 'Start DT time-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Start DT Retries', 'Start DT nieuwe pogingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Coming Soon...', 'Komt binnenkort...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Rack', 'Rek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Slot', 'Sleuf', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'No Data Transfer Selected', 'Geen gegevensoverdracht geselecteerd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Destination', 'Bestemming', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Detail Form', 'Detailformulier', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Source Tag', 'Brontag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Destination Tag', 'Destination Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Data Transfer', 'Data overdracht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Detail Transfer', 'Detailoverdracht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Device', 'Apparaat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Device Picker', 'Apparaatkiezer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Import Tmpl', 'Tmpl importeren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Start Address', 'Startadres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'General I. Time', 'Generaal I. Tijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'General Interrogation Time', 'Algemene ondervragingstijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'General Counter Interrogation Time', 'Algemene teller ondervragingstijd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Cnt Point Offset', 'Cnt Point Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Control Point Offset', 'Controlepunt-offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'DB Number', 'DB-nummer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'IEC104 type', 'IEC104-type', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Sender', 'Afzender', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Recepient', 'Ontvanger', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Subject', 'Onderwerpen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Email View', 'E-mailweergave', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'From', 'Van', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'To', 'Naar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Email Search', 'E-mail zoeken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Email Service', 'E-mailservice', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Body', 'Lichaam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Send Email', 'E-mail verzenden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Send', 'Sturen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'User List', 'Gebruikers lijst', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Mail send failed', 'E-mail verzenden mislukt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Email Settings', 'Email instellingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Backup/Restore', 'Back-up herstellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Choose', 'Kiezen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Processes', 'Processen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Data Transfers', 'Gegevensoverdrachten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Keywords', 'Zoekwoorden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Roles', 'Rollen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Templates', 'Sjablonen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Key', 'Sleutel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Active', 'Actief', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Successful ?', 'Is succesvol ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Auth Logs', 'Auth Logs', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'License', 'Licentie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Machine Id', 'Machine ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Surname', 'Achternaam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'User Limit', 'Gebruikerslimiet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Update', 'Bijwerken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'License Key', 'Licentiesleutel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'License to', 'Licentie voor', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'License successfully activated', 'Licentie succesvol geactiveerd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Failed to activate', 'Kan niet activeren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm Name', 'Alarmnaam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Start All', 'Alles starten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Stop All', 'Stop alles', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Weet u zeker dat u de geselecteerde gegevensoverdracht wilt plannen / annuleren?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Process', 'Werkwijze', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'GRAPHICAL VIEW', 'GRAFISCH WEERGAVE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'FLOW RATE', 'STROOMSNELHEID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'METERING', 'METERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'ENERGY & OTHER VALUES', 'ENERGIE EN ANDERE WAARDEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'IN-USE GAS COMPONENTS', 'IN GEBRUIK GASCOMPONENTEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'TOTALISORS', 'TOTALISORS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'PREVIOUS HOURLY & DAILY VALUES', 'VORIGE UURLIJKSE EN DAGELIJKSE WAARDEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'ALARMS ON', 'ALARMEN AAN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'NAME', 'NAAM', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'CURRENT', 'ACTUEEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'IN-USE', 'IN GEBRUIK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'DOWNLOADED', 'GEDOWNLOAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'NORMALIZED', 'GENORMALISEERD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'UNIT', 'EENHEID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'PROPERTIES', 'EIGENDOMMEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'GC MANAGEMENT', 'GC-MANAGEMENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SET', 'INSTELLEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'STATUS', 'TOESTAND', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'QRCODE Reader', 'QRCODE-lezer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Scanned!', 'Gescand!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'deviceName', 'toestelnaam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Failed to load data', 'Kan gegevens niet laden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'ANIMATION', 'ANIMATIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'GAS METERING', 'GASMETING', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'GAS PROPERTIES', 'GAS EIGENSCHAPPEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'NETWORK', 'NETWERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Fired Alarm Duration In Days', 'Duur alarm geactiveerd in dagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Fired Alarm duration is updated', 'Duur alarm geactiveerd is bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Acknowledger', 'Bevestiging', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Duration In Days', 'Logduur in dagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log duration is updated', 'Logduur is bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Remove All', 'Verwijder alles', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Firstly load the datatable', 'Laad eerst de datatabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Failed to load log data', 'Kan logboekgegevens niet laden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure to remove all logs?', 'Weet u zeker dat u alle logboeken wilt verwijderen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'All logs removed', 'Alle logboeken verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'An error occured while removing logs', 'Er is een fout opgetreden bij het verwijderen van logboeken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Message', 'Logbericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Show Weather On Click', 'Weer weergeven bij klikken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Updated successfully', 'Succesvol geupdatet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Removed successfully', 'Succesvol verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Map', 'Kaart', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Map api', 'Map API', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Weather api', 'Weer-api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Interval', 'Interval', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Filter', 'Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'SCHEDULED', 'GEPLAND', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'ON', 'AAN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'OFF', 'UIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Print', 'Afdrukken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Failed to load!', 'Laden mislukt!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Choose Trend', 'Kies trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Avg Value', 'Gem. Waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Integral Value', 'Integrale waarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Diff Value', 'Max. Verschilwaarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Calculation type', 'Berekeningstype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Auto Scroll', 'Auto Scroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Failed to load trend data', 'Kan trendgegevens niet laden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Select the Trend first', 'Selecteer eerst de trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Interval cannot be empty', 'Interval mag niet leeg zijn', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable Duration In Days', 'Variabele duur in dagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable duration is updated', 'Variabele duur is bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Frame', 'Kader', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Usual', 'Gebruikelijk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Hourly', 'Per uur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Daily', 'Dagelijks', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'CUSTOM', 'OP MAAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'COLLECTION', 'VERZAMELING', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Process Form', 'Procesformulier', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Background', 'Achtergrond', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Text Color', 'Tekst kleur', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Main Flag', 'Hoofdvlag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Grid Flag', 'Grid Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Inputs', 'Ingangen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Choose Default Image', 'Kies standaardafbeelding', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'States', 'Staten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'State Lists', 'Staatslijsten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'New State', 'Nieuwe staat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'State name', 'Staat naam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Attach', 'Vastmaken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Library', 'Bibliotheek', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Node updated', 'Knooppunt geüpdatet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Property', 'Eigendom', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Project Property', 'Projecteigendom', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Project Values', 'Projectwaarden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Stream', 'Stroom', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report', 'Verslag doen van', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please, choose a period', 'Kies alstublieft een punt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Name field cannot be empty!', 'Naamveld mag niet leeg zijn!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please choose a report', 'Kies een rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group order cannot be empty!', 'Groepsbestelling mag niet leeg zijn!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report group removed', 'Rapportgroep verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new Report group added', 'Een nieuwe rapportgroep toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report group updated successfully', 'Rapportgroep succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report updated successfully', 'Rapport succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new report added', 'Een nieuw rapport toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report removed', 'Rapport verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please, select group', 'Selecteer een groep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report subgroup removed', 'Rapport subgroep verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new Report subgroup added', 'Een nieuwe rapportsubgroep toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report subgroup updated successfully', 'Rapport subgroep succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report Variable', 'Rapportvariabele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Subgroup', 'Subgroep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please choose a subgroup', 'Kies een subgroep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable Order', 'Variabele volgorde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Variable order cannot be empty', 'Variabele volgorde mag niet leeg zijn', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please, choose calculation type', 'Kies een berekeningstype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please, choose variable', 'Kies een variabele', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Total', 'Totaal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Deviation', 'Afwijking', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please, select subgroup', 'Selecteer een subgroep', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report variable removed', 'Rapportvariabele verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new Report variable added', 'Een nieuwe rapportvariabele toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Report variable updated successfully', 'Rapportvariabele geüpdatet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Script Output', 'Scriptuitvoer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Output message', 'Uitvoerbericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Empty output', 'Lege uitvoer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Error in code syntax', 'Fout in codesyntaxis', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group Chat', 'Groeps chat', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Type message here', 'Typ hier een bericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Type message', 'Typ bericht', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Refresh Periods', 'Vernieuwingsperioden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Control Panel', 'Controlepaneel', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Gas Properties', 'Gaseigenschappen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Network', 'Netwerk', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Graph Details', 'Grafiekdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Check All', 'Alles controleren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Menus', 'Menus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Permission', 'Toestemming', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Permissions', 'Rechten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Rolename', 'Rol naam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Role Menus', 'Rolmenus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Menus are added', 'Menus zijn toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Please, select role', 'Selecteer rol alstublieft', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', ' is removed', ' is verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Role Permissions', 'Rolrechten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Permissions are added', 'Rechten zijn toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new role added', 'Een nieuwe rol toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Role updated successfully', 'Rol succesvol bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Role is removed', 'Rol is verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Reset Password', 'Wachtwoord opnieuw instellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Password Info', 'Wachtwoordinfo', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'New Password', 'Nieuw paswoord', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Repeat New Password', 'Herhaal nieuw wachtwoord', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Passwords are not the same', 'Wachtwoorden zijn niet hetzelfde', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Email Address', 'E-mailadres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'User', 'Gebruiker', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Password changed successfully', 'Wachtwoord succesvol veranderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Password change failed', 'Veranderen van wachtwoord mislukt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Enter new value', 'Voer nieuwe waarde in', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Set Value', 'Waarde instellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Increment Value', 'Waarde verhogen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Send Flags', 'Stuur vlaggen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'False/True', 'False / True', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Decrement Value', 'Waarde verlagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Byte Swap?', 'Is Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Is Word Swap?', 'Is Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Point Class', 'Puntklasse', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Deadband', 'Dode band', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Static Variation', 'Statische variatie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Event Variation', 'Evenementvariatie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Data Type', 'Data type', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Bit Offset', 'Bit-offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Decimal Point', 'Decimale punt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Flags', 'Vlaggen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Protocol Properties', 'Protocoleigenschappen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Raw zero scale', 'Onbewerkte nulschaal', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Raw full scale', 'Raw full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Eng zero scale', 'Eng zero scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Period', 'Logperiode', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Threshold', 'Log Threshold', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Value Expression', 'Waarde-expressie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Log Expression', 'Log-expressie', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Protocol Type', 'Protocoltype', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Protocols', 'Protocollen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new item added', 'Een nieuw item toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'A new item detail added', 'Een nieuw itemdetail toegevoegd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Item detail updated', 'Artikeldetails bijgewerkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Item updated', 'Item geüpdatet', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Item removed', 'Item verwijderd', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Minutes Offset', 'Minuten offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Local Address', 'Lokaal adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Remote Address', 'Extern adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Integrity Scantime', 'Integriteit Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Unsoliceted Events', 'Ongevraagde evenementen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Max Controls', 'Max. Bedieningselementen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Select Timeout', 'Selecteer time-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Confirm Timeout', 'Bevestig time-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Retry Timeout', 'Time-out opnieuw proberen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Response Timeout', 'Reactietime-out', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Disable Unsolicated', 'Schakel ongevraagd uit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Startup Integrity', 'Opstartintegriteit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Integrity Overflow', 'Integriteitsoverloop', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Common Address', 'Algemeen adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Dnp3 type', 'Dnp3-type', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Event Buffer Size', 'Grootte gebeurtenisbuffer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Modbus type', 'Modbus-type', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Readable', 'Leesbaar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Writeable', 'Beschrijfbaar', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Iec104 type', 'Iec104-type', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Back', 'Terug', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Next', 'De volgende', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'COMMUNICATION NETWORK', 'COMMUNICATIE NETWERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Finish', 'Af hebben', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Check connection details', 'Controleer verbindingsdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Connection Details', 'Verbindingsdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'GAS STATION MODEL', 'GAS STATION MODEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Device List', 'Lijst met apparaten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Device Form', 'Apparaatformulier', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Item', 'Item', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Station Address', 'Station Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'PAY', 'BETALEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'CHECK', 'CONTROLEREN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Stream Details', 'Streamdetails', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'USE GC', 'GEBRUIK GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Saved!', 'Opgeslagen!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'DEFINED GAS STATION MODEL', 'GEDEFINIEERD GASSTATION-MODEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Capacity', 'Capaciteit', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Group Name', 'Groepsnaam', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Stream Modules List', 'Stream Modules List', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Analyzer', 'Analyzer', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Main Station', 'Hoofdstation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Sub Station', 'Substation', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'REPORT', 'VERSLAG DOEN VAN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Generate', 'Genereren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Failed to generate project', 'Kan project niet genereren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Station Details', 'Station Details', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'WebSocket is on', 'WebSocket is ingeschakeld', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'WebSocket is off', 'WebSocket is uitgeschakeld', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'WebSocket error observed', 'WebSocket-fout waargenomen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Clear browser storage', 'Browseropslag wissen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'System statistics', 'Systeemstatistieken', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Chatting', 'Chatten', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Notifications', 'Meldingen', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Sign-out', 'Afmelden', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Hide top', 'Verberg top', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Are you sure you want to clear storage?', 'Weet u zeker dat u de opslag wilt wissen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Press SHIFT+Q to return', 'Druk op SHIFT + Q om terug te keren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'Press SHIFT+W to return', 'Druk op SHIFT + W om terug te keren', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('nl', 'You are about to logged out. Are you sure you want to proceed?', 'U staat op het punt om uit te loggen. Weet u zeker dat u wilt doorgaan?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('ru', 'inSCADA Login', 'Вход в SCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Username', 'Имя пользователя', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Password', 'пароль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Login', 'Авторизоваться', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Language', 'Язык', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Projects', 'Проекты', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'User Menu', 'Меню пользователя', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Project Map', 'Карта проекта', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Devices', 'Устройства', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animations', 'Анимации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarms', 'Будильники', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Trends', 'Тенденции', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Trend Tags', 'Теги тренда', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Trend Tag', 'Тег тренда', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Scripts', 'Скрипты', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Reports', 'Отчеты', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Emails', 'Электронные письма', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Logs', 'Журналы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Auth Log', 'Журнал аутентификации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Users', 'Пользователи', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Help', 'Помогите', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'About', 'Около', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Home', 'Главная', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Connection', 'Подключение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Trend Graphic', 'Графика трендов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Trend Graphics', 'Графика трендов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Connections', 'Подключения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Group', 'Группа отчетов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Aggregate', 'Совокупный', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Device Templates', 'Шаблоны устройств', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Frame Templates', 'Шаблоны кадров', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable Templates', 'Шаблоны переменных', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Search', 'Поиск', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure you want to schedule/unschedule the selected script?', 'Вы уверены, что хотите запланировать / отменить расписание выбранного сценария?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Add New', 'Добавить новое', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Save', 'Сохранить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Delete', 'удалять', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Yes', 'да', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'No', 'Нет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Status', 'Статус', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Properties', 'Свойства', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure to continue?', 'Вы уверены, что продолжите?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Form data is invalid', 'Данные формы недействительны', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Visualization', 'Визуализация', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Development', 'Развитие', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Gas Metering', 'Учет газа', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Gas Control', 'Газовый контроль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Control panel', 'Панель управления', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group', 'Группа', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Module', 'Модуль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Station Adress', 'Адрес станции', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Protocol', 'Протокол', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On DateTime', 'В DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Acknowledge DateTime', 'Подтвердить DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Settings', 'Настройки', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'General', 'Общее', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Start adress', 'Начальный адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Scan Time', 'Время сканирования', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Device Library', 'Библиотека устройств', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Expressions', 'Выражения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variables', 'Переменные', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Wizard', 'Волшебник', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable History', 'История переменных', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Ip', 'IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Port', 'Порт', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Timeout', 'Тайм-аут', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Frames', 'Кадры', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Writeable?', 'Возможность записи?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Readable?', 'Читается?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Buffer size', 'Размер буфера', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print Time', 'Время печати', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print Day', 'День печати', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print Hour', 'Время печати', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Day', 'Отчетный день', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Time', 'Время отчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Hour', 'Сообщить час', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print?', 'Распечатать?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Add Descriptions', 'Добавить описания', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Jobs', 'Вакансии', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Last Execution Start Time', 'Время начала последнего выполнения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Last Execution Ended Time', 'Время окончания последнего выполнения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Next Execution Time', 'Время следующего выполнения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Executions Count', 'Количество казней', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Project', 'Проект', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Name', 'имя', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Description', 'Описание', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Start Date', 'Дата начала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'End Date', 'Дата окончания', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Active?', 'Активен?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Location', 'Место расположения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Address', 'Адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Latitude', 'Широта', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Longitude', 'Долгота', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Contract', 'Договор', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Contract Day', 'Контрактный день', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Contract Hour', 'Контрактный час', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new project added', 'Добавлен новый проект', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Project updated successfully', 'Проект успешно обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Project removed', 'Проект удален', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Value', 'Ценность', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure you want to continue?', 'Вы уверены что хотите продолжить?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'HPP Unit', 'Блок ГЭС', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Reload', 'Перезагрузить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Acknowledge', 'Признать', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Quantity', 'Количество', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Type', 'Тип журнала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Unit', 'Единица измерения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Expression Type', 'Тип выражения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Retain Flag', 'Сохранить флаг', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Word Swap', 'Замена слов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Byte Swap', 'Обмен байтами', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Load', 'Загрузить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Date Range', 'Диапазон дат', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable Picker', 'Выбор переменных', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Last Value', 'Последнее значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'First Value', 'Первое значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Min Value', 'Мин. Значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Value', 'Максимальное значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Sum Value', 'Сумма стоимости', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Count Value', 'Значение счета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Acknowledge DateTime Filter', 'Подтвердить фильтр даты и времени', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Off DateTime Filter', 'Off DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On DateTime Filter', 'В фильтре DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Search Form', 'Форма поиска', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Off DateTime', 'Дата выключения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Interval (Second)', 'Интервал (секунды)', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On', 'На', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Off', 'Выключено', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Live', 'Жить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Preview', 'Предварительный просмотр', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Cancel', 'Отмена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Schedule', 'График', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Severity', 'Важность журнала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Activity', 'Деятельность', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Source', 'Источник', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Message', 'Сообщение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Remove', 'Удалить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'User Roles', 'Роли пользователей', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Role', 'Роль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Expression', 'Выражение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Delay', 'Задержка', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Category', 'Категория', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On Script', 'По сценарию', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Ack Script', 'Скрипт подтверждения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new alarm added', 'Добавлен новый будильник', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm updated successfully', 'Будильник успешно обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm settings is updated', 'Настройки будильника обновлены', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm removed', 'Сигнализация удалена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm History', 'История тревог', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Type', 'Тип', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Import', 'импорт', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Date', 'Дата', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure you want to activate/deactivate the selected alarm?', 'Вы уверены, что хотите активировать / деактивировать выбранный будильник?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure you want to Start/Stop the selected connection?', 'Вы уверены, что хотите запустить / остановить выбранное соединение?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Code', 'Код', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Priority', 'Приоритет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Period', 'Период', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log', 'Журнал', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new script added', 'Добавлен новый скрипт', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Script updated successfully', 'Скрипт успешно обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Script removed', 'Скрипт удален', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Deviation Variable', 'Переменная отклонения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Total Variable', 'Общая переменная', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Calculation Type', 'Тип расчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Order', 'порядок', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Variables', 'Переменные отчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Subgroup Order', 'Порядок подгруппы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Subgroups', 'Подгруппы отчетов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group Order', 'Групповой заказ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation Elements', 'Элементы анимации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Parent Animation', 'Родительская анимация', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Color', 'цвет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Duration', 'Продолжительность', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Play Order', 'Порядок воспроизведения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Play at Main?', 'Играть на Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SVG Content', 'SVG-контент', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation Type', 'Тип анимации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new animation added', 'Добавлена ​​новая анимация', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Only SVG files are allowed', 'Разрешены только файлы SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation updated successfully', 'Анимация успешно обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation removed', 'Анимация удалена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new animation element added', 'Добавлен новый элемент анимации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation element updated successfully', 'Элемент анимации успешно обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation element removed', 'Элемент анимации удален', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Min. Scale', 'Мин. Шкала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max. Scale', 'Максимум. Шкала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Thickness', 'Толщина', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Backup', 'Резервное копирование', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Restore', 'Восстановить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Save & Continue', 'Сохранить и продолжить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable', 'Переменная', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Default', 'По умолчанию', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Add', 'добавлять', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Default value', 'Значение по умолчанию', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Text', 'Текст', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Title', 'заглавие', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Size', 'Размер', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Disable', 'Отключить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Home View', 'Домашний вид', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Time', 'Время', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Second', 'Второй', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Last Executed At', 'Последний раз казнен в', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please select a master record first', 'Пожалуйста, сначала выберите основную запись', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Send SMS', 'Отправить смс', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SMS Details', 'СМС подробности', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SMS Service', 'SMS сервис', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SMS sended successfully', 'SMS отправлено успешно', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SMS Search', 'SMS поиск', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Content', 'Содержание', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SMS Settings', 'Настройки SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Mail sended successfully', 'Письмо успешно отправлено', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'No selected animation', 'Нет выбранной анимации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Recipient', 'Получатель', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Online Help', 'Онлайн помощь', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Menu', 'Меню', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm', 'Тревога', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm Monitor', 'Монитор тревог', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Smart Symbol', 'Умный символ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Smart Symbols', 'Умные символы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable Monitor', 'Монитор переменных', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm Group', 'Группа аварийных сигналов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm Groups', 'Группы тревог', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On No Ack Color', 'Цвет без подтверждения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On Ack Color', 'На Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Off No Ack Color', 'Выкл. Нет подтверждения Цвет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print When On?', 'Печатать, когда включено?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print When Off?', 'Печатать, когда выключено?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print When Ack?', 'Печать при подтверждении?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation', 'Анимация', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Inverse', 'Обратный', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Set Type', 'Установить Тип', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Notify', 'Уведомлять', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Default Color', 'Цвет по умолчанию', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Gradient', 'Градиент', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Min', 'Мин.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max', 'Максимум', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Format', 'Формат', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group Size', 'Размер группы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Decimal', 'Десятичный', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group Seperator', 'Разделитель групп', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Decimal Seperator', 'Десятичный разделитель', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Leftpad Size', 'Размер левой панели', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Rightpad Size', 'Размер правой панели', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Character', 'символ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Prefix', 'Префикс', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Suffix', 'Суффикс', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'tag', 'тег', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Initial Pos', 'Начальная позиция', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Min Pos', 'Мин. Позиция', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Pos', 'Макс. Позиция', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'On Drop', 'При падении', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Join', 'Присоединиться', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Template?', 'Есть шаблон?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation Element', 'Элемент анимации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Mouse', 'Мышь', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'More', 'Больше', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation WebSocket is on', 'Анимация WebSocket включена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation WebSocket is off', 'Анимация WebSocket выключена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Animation WebSocket error observed', 'Обнаружена ошибка анимации WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Pool Size', 'Размер бассейна', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Adapter', 'Адаптер', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Min Retry Delay', 'Мин. Задержка повтора', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Retry Delay', 'Максимальная задержка повтора', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Local Ip', 'Местный IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Local Port', 'Местный порт', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Cot F. Length', 'Детская кроватка F. Длина', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Cot Field Length', 'Детская кроватка Длина поля', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'IOA Field Length', 'Длина поля IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Common A. Length', 'Обычная A. Длина', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Common Address Field Length', 'Общая длина поля адреса', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'IOA F. Length', 'IOA F. Длина', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Originator Address', 'Адрес отправителя', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Message F. Timeout', 'Сообщение F. Тайм-аут', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Message Fragment Timeout', 'Тайм-аут фрагмента сообщения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max T.N.A. Recieved', 'Макс Т.Н.А. Получено', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Time No Ack Received', 'Максимальное время отсутствия подтверждения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max T.N.A. Sent', 'Макс Т.Н.А. Отправлено', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Time No Ack Sent', 'Максимальное время, в течение которого не было отправлено подтверждение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Idle Time', 'Максимальное время простоя', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max U. IP Recieved', 'Максимальное количество полученных IP-адресов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Unconfirmed IPdus Received', 'Максимальное количество полученных неподтвержденных IPdus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Start DT Timeout', 'Начать тайм-аут DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Start DT Retries', 'Начать повторные попытки DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Coming Soon...', 'Скоро будет...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Rack', 'Стойка', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Slot', 'Слот', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'No Data Transfer Selected', 'Передача данных не выбрана', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Destination', 'Пункт назначения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Detail Form', 'Подробная форма', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Source Tag', 'Исходный тег', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Destination Tag', 'Целевой тег', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Data Transfer', 'Обмен данными', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Detail Transfer', 'Детальный перевод', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Device', 'Устройство', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Device Picker', 'Средство выбора устройства', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Import Tmpl', 'Импорт Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Start Address', 'Начальный адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'General I. Time', 'Генерал I. Время', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'General Interrogation Time', 'Общее время допроса', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'General C.I. Time', 'Генерал К.И. Время', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'General Counter Interrogation Time', 'Время опроса общего счетчика', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Cnt Point Offset', 'Смещение точки Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Control Point Offset', 'Смещение контрольной точки', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'DB Number', 'Номер БД', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'IEC104 type', 'Тип IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Sender', 'Отправитель', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Recepient', 'Получатель', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Subject', 'Предмет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Email View', 'Электронная почта Просмотр', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'From', 'От', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'To', 'Чтобы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Email Search', 'Электронный поиск', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Email Service', 'Электронная почта', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Body', 'Тело', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Send Email', 'Отправить электронное письмо', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Send', 'послать', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'User List', 'Список пользователей', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Mail send failed', 'Не удалось отправить почту', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Email Settings', 'Настройки электронной почты', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Email', 'Эл. адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Backup/Restore', 'Восстановления резервной копии', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Choose', 'выберите', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Processes', 'Процессы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Data Transfers', 'Передача данных', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Keywords', 'Ключевые слова', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Roles', 'Роли', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Templates', 'Шаблоны', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Key', 'Ключ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Active', 'Активный', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Successful ?', 'Успешно?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Auth Logs', 'Журналы аутентификации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'License', 'Лицензия', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Machine Id', 'Идентификатор машины', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Surname', 'Фамилия', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'User Limit', 'Лимит пользователей', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Update', 'Обновить', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'License Key', 'Лицензионный ключ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'License to', 'Лицензия на', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'License successfully activated', 'Лицензия успешно активирована', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Failed to activate', 'Не удалось активировать', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm Name', 'Название сигнала тревоги', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Alarm Dsc', 'Сигнализация Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Start All', 'Начать все', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Stop All', 'Остановить все', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Вы действительно хотите запланировать / отменить график выбранной передачи данных?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Process', 'Процесс', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'GRAPHICAL VIEW', 'ГРАФИЧЕСКИЙ ВИД', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'FLOW RATE', 'РАСХОД', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'METERING', 'ИЗМЕРЕНИЕ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'ENERGY & OTHER VALUES', 'ЭНЕРГИЯ И ДРУГИЕ ЦЕННОСТИ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'IN-USE GAS COMPONENTS', 'ИСПОЛЬЗУЕМЫЕ ГАЗОВЫЕ КОМПОНЕНТЫ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'TOTALISORS', 'ТОТАЛИСОРЫ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'PREVIOUS HOURLY & DAILY VALUES', 'ПРЕДЫДУЩИЕ ПОЧАСОВЫЕ И ЕЖЕДНЕВНЫЕ ЗНАЧЕНИЯ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'ALARMS ON', 'БУДИЛЬНИКИ ВКЛЮЧЕНЫ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'NAME', 'ИМЯ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'CURRENT', 'ТЕКУЩИЙ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'C.DAY', 'C. ДЕНЬ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'IN-USE', 'IN-USE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'MAX', 'МАКСИМУМ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'DOWNLOADED', 'СКАЧАЛИ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'NORMALIZED', 'НОРМАЛИЗОВАННЫЙ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'UNIT', 'ЕДИНИЦА ИЗМЕРЕНИЯ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'PROPERTIES', 'СВОЙСТВА', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'GC MANAGEMENT', 'УПРАВЛЕНИЕ ГК', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SET', 'УСТАНОВЛЕН', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'STATUS', 'СТАТУС', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'QRCODE Reader', 'Считыватель QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Scanned!', 'Отсканировано!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'deviceName', 'имя устройства', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Failed to load data', 'Не удалось загрузить данные', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'ANIMATION', 'АНИМАЦИЯ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'GAS METERING', 'УЧЕТ ГАЗА', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'GAS PROPERTIES', 'ГАЗОВЫЕ СВОЙСТВА', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'NETWORK', 'СЕТЬ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Fired Alarm Duration In Days', 'Продолжительность срабатывания сигнализации в днях', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Fired Alarm duration is updated', 'Продолжительность сработавшего сигнала тревоги обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Acknowledger', 'Подтверждающий', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Duration In Days', 'Продолжительность журнала в днях', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log duration is updated', 'Продолжительность журнала обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Remove All', 'Убрать все', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Firstly load the datatable', 'Сначала загрузите datatable', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Failed to load log data', 'Не удалось загрузить данные журнала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure to remove all logs?', 'Вы уверены, что удалите все журналы?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'All logs removed', 'Все журналы удалены', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'An error occured while removing logs', 'Произошла ошибка при удалении журналов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Message', 'Сообщение журнала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Show Weather On Click', 'Показывать погоду при нажатии', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Updated successfully', 'Успешно Обновлено', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Removed successfully', 'Удалено успешно', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Map', 'карта', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Map api', 'API карты', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Weather api', 'Погода api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Interval', 'Интервал', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Filter', 'Фильтр', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'SCHEDULED', 'ПО РАСПИСАНИЮ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'ON', 'НА', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'OFF', 'ВЫКЛ.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Print', 'Распечатать', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Failed to load!', 'Ошибка загрузки!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Choose Trend', 'Выберите тренд', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Avg Value', 'Среднее значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Integral Value', 'Интегральное значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Diff Value', 'Максимальное значение различия', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Calculation type', 'Тип расчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Auto Scroll', 'Автопрокрутка', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Failed to load trend data', 'Не удалось загрузить данные тренда', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Select the Trend first', 'Сначала выберите тренд', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Interval cannot be empty', 'Интервал не может быть пустым', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable Duration In Days', 'Переменная продолжительность в днях', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable duration is updated', 'Изменяемая продолжительность обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Frame', 'Рамка', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Usual', 'Обычный', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Hourly', 'Ежечасно', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Daily', 'Повседневная', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'CUSTOM', 'ТАМОЖЕННЫЙ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'COLLECTION', 'КОЛЛЕКЦИЯ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Process Form', 'Форма процесса', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Background', 'Задний план', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Text Color', 'Цвет текста', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Main Flag', 'Главный флаг', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Grid Flag', 'Флаг сетки', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Inputs', 'Входы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Choose Default Image', 'Выбрать изображение по умолчанию', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'States', 'состояния', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'State Lists', 'Государственные списки', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'New State', 'Новое государство', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'State name', 'Название штата', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Attach', 'Прикреплять', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Library', 'Библиотека', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Node updated', 'Узел обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Property', 'Свойство', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Project Property', 'Недвижимость проекта', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Project Values', 'Ценности проекта', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Stream', 'Поток', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report', 'Отчет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please, choose a period', 'Пожалуйста, выберите период', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Name field cannot be empty!', 'Поле имени не может быть пустым!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please choose a report', 'Пожалуйста, выберите отчет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group order cannot be empty!', 'Групповой заказ не может быть пустым!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report group removed', 'Группа отчетов удалена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new Report group added', 'Добавлена ​​новая группа отчетов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report group updated successfully', 'Группа отчетов успешно обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report updated successfully', 'Отчет успешно обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new report added', 'Добавлен новый отчет', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report removed', 'Отчет удален', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please, select group', 'Пожалуйста, выберите группу', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report subgroup removed', 'Подгруппа отчета удалена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new Report subgroup added', 'Добавлена ​​новая подгруппа отчетов', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report subgroup updated successfully', 'Подгруппа отчета успешно обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report Variable', 'Переменная отчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Subgroup', 'Подгруппа', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please choose a subgroup', 'Пожалуйста, выберите подгруппу', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable Order', 'Переменный порядок', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Variable order cannot be empty', 'Переменный порядок не может быть пустым', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please, choose calculation type', 'Пожалуйста, выберите тип расчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please, choose variable', 'Пожалуйста, выберите переменную', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Total', 'Всего', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Deviation', 'Отклонение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please, select subgroup', 'Пожалуйста, выберите подгруппу', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report variable removed', 'Переменная отчета удалена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new Report variable added', 'Добавлена ​​новая переменная отчета', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Report variable updated successfully', 'Переменная отчета успешно обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Script Output', 'Вывод сценария', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Output message', 'Выходное сообщение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Empty output', 'Пустой вывод', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Error in code syntax', 'Ошибка в синтаксисе кода', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group Chat', 'Групповой чат', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Type message here', 'Напишите здесь сообщение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Type message', 'Введите сообщение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Refresh Periods', 'Периоды обновления', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Control Panel', 'Панель управления', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Gas Properties', 'Свойства газа', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Network', 'Сеть', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Graph Details', 'Детали графика', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Check All', 'Отметить все', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Menus', 'Меню', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Permission', 'Разрешение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Permissions', 'Разрешения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Rolename', 'Rolename', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Role Menus', 'Ролевые меню', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Menus are added', 'Добавлены меню', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Please, select role', 'Пожалуйста, выберите роль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', ' is removed', ' устранен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Role Permissions', 'Разрешения на роль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Permissions are added', 'Добавлены разрешения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new role added', 'Добавлена ​​новая роль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Role updated successfully', 'Роль успешно обновлена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Role is removed', 'Роль удалена', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Reset Password', 'Сброс пароля', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Password Info', 'Информация о пароле', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'New Password', 'Новый пароль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Repeat New Password', 'Повторите новый пароль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Passwords are not the same', 'пароли не совпадают', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Email Address', 'Адрес электронной почты', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'User', 'Пользователь', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Password changed successfully', 'Пароль успешно изменен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Password change failed', 'Не удалось изменить пароль', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Enter new value', 'Введите новое значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Set Value', 'Установить значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Increment Value', 'Приращение стоимости', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Send Flags', 'Отправить флаги', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'False/True', 'Ложь Правда', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Decrement Value', 'Уменьшить значение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Byte Swap?', 'Обмен байтами?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Is Word Swap?', 'Замена слов?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Point Class', 'Класс точки', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Deadband', 'Зона нечувствительности', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Static Variation', 'Статическая вариация', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Event Variation', 'Вариация события', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Data Type', 'Тип данных', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Bit Offset', 'Битовое смещение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Decimal Point', 'Десятичная точка', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Flags', 'Флаги', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Protocol Properties', 'Свойства протокола', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Raw zero scale', 'Необработанная нулевая шкала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Raw full scale', 'Необработанная полная шкала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Eng zero scale', 'Eng нулевая шкала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Eng full scale', 'Eng полная шкала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Period', 'Период регистрации', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Threshold', 'Порог журнала', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Value Expression', 'Выражение ценности', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Log Expression', 'Лог-выражение', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Protocol Type', 'Тип протокола', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Protocols', 'Протоколы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new item added', 'Добавлен новый элемент', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'A new item detail added', 'Добавлена ​​новая информация об элементе', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Item detail updated', 'Сведения об элементе обновлены', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Item updated', 'Товар обновлен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Item removed', 'Товар удален', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Minutes Offset', 'Смещение в минутах', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Local Address', 'Местный адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Remote Address', 'Удаленный адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Integrity Scantime', 'Время сканирования целостности', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Unsoliceted Events', 'Незащищенные события', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Max Controls', 'Максимальное количество элементов управления', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Select Timeout', 'Выберите Тайм-аут', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Confirm Timeout', 'Подтвердить тайм-аут', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Retry Timeout', 'Время ожидания повторной попытки', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Response Timeout', 'Время ожидания ответа', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Event Scantime', 'Время сканирования события', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Disable Unsolicated', 'Отключить Unsolicated', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Startup Integrity', 'Целостность запуска', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Integrity Overflow', 'Переполнение целостности', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Common Address', 'Общий адрес', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Dnp3 type', 'Тип днп3', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Event Buffer Size', 'Размер буфера событий', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Modbus type', 'Тип Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Readable', 'Удобочитаемый', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Writeable', 'Записываемый', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Iec104 type', 'Тип IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Back', 'Назад', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Next', 'следующий', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'COMMUNICATION NETWORK', 'КОММУНИКАЦИОННАЯ СЕТЬ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Finish', 'Конец', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Check connection details', 'Проверить детали подключения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Connection Details', 'Детали подключения', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'GAS STATION MODEL', 'МОДЕЛЬ АЗС', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Device List', 'Список устройств', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Device Form', 'Форма устройства', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Item', 'Пункт', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Station Address', 'Адрес станции', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'PAY', 'ОПЛАТИТЬ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'CHECK', 'ПРОВЕРИТЬ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Stream Details', 'Детали потока', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'USE GC', 'ИСПОЛЬЗОВАТЬ GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Saved!', 'Сохранено!', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'DEFINED GAS STATION MODEL', 'ОПРЕДЕЛЕННАЯ МОДЕЛЬ АЗС', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Capacity', 'Вместимость', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Group Name', 'Имя группы', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'STREAMS', 'ПОТОКИ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Stream Modules List', 'Список потоковых модулей', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Analyzer', 'Анализатор', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Main Station', 'Главная станция', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Sub Station', 'Подстанция', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'REPORT', 'ОТЧЕТ', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Generate', 'Генерировать', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Failed to generate project', 'Не удалось создать проект', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Station Details', 'Детали станции', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'WebSocket is on', 'WebSocket включен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'WebSocket is off', 'WebSocket выключен', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'WebSocket error observed', 'Обнаружена ошибка WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Clear browser storage', 'Очистить хранилище браузера', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'System statistics', 'Системная статистика', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Chatting', 'В чате', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Notifications', 'Уведомления', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Sign-out', 'Выход', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Hide top', 'Скрыть верх', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Are you sure you want to clear storage?', 'Вы уверены, что хотите очистить хранилище?', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Press SHIFT+Q to return', 'Нажмите SHIFT + Q, чтобы вернуться', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'Press SHIFT+W to return', 'Нажмите SHIFT + W, чтобы вернуться', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('ru', 'You are about to logged out. Are you sure you want to proceed?', 'Вы собираетесь выйти из системы. Вы уверены, что хотите продолжить?', NEW.space_id, 'system_update', now(), 'system_update', now());

INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
		('zh', 'inSCADA Login', ' inSCADA登录', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Username', '用户名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Password', '密码', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Login', '登录', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Language', '语言', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Projects', '项目', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'User Menu', '用户菜单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Project Map', '项目图', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Devices', '设备', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animations', '动画', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarms', '警报', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Trends', '趋势', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Trend Tags', '趋势标签', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Trend Tag', '趋势标签', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Scripts', '脚本', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Reports', '报告', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Emails', '电子邮件', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Logs', '日志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Auth Log', '验证日志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Users', '用户', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Help', '帮帮我', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'About', '关于', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Home', '家', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Connection', '连接', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Trend Graphic', '趋势图形', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Trend Graphics', '趋势图形', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Connections', '连接', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Group', '报告团', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Aggregate', '骨料', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Device Templates', '设备模板', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Frame Templates', '框架模板', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable Templates', '可变模板', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Search', '搜索', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure you want to schedule/unschedule the selected script?', '确定要计划/取消计划所选脚本吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Add New', '添新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Save', '救', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Delete', '删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Yes', '是', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'No', '没有', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Status', '状态', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Properties', '财产', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure to continue?', '您确定要继续吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Form data is invalid', '表格数据无效', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Visualization', '可视化', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Development', '发展', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Gas Metering', '气体计量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Gas Control', '气体控制', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Control panel', '控制面板', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Group', '组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Module', '模块', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Station Adress', '车站地址', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Protocol', '协议', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On DateTime', '在日期时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Acknowledge DateTime', '确认日期时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Settings', '设置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'General', '一般', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Start adress', '开始地址', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Scan Time', '扫描时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Device Library', '设备库', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Expressions', '表情', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variables', '变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Wizard', '向导', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable History', '可变历史', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Ip', '叶', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Port', '港口', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Timeout', '超时', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Frames', '框架', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Writeable?', '可写吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Readable?', '可读吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Buffer size', '缓冲区大小', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print Time', '打印时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print Day', '印刷日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print Hour', '打印时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Day', '报告日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Time', '报告时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Hour', '报告时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print?', '打印？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Add Descriptions', '添加说明', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Jobs', '工作', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Last Execution Start Time', '上次执行开始时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Last Execution Ended Time', '上次执行结束时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Next Execution Time', '下一次执行时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Executions Count', '执行计数', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Project', '项目', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Name', '名称', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Description', '描述', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Start Date', '开始日期', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'End Date', '结束日期', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Active?', '活跃？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Location', '位置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Address', '地址', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Latitude', '纬度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Longitude', '经度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Contract', '合同', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Contract Day', '合同日', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Contract Hour', '合同时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new project added', '添加了一个新项目', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Project updated successfully', '项目更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Project removed', '项目已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Value', '值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure you want to continue?', '你确定你要继续吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'HPP Unit', ' HPP单位', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Reload', '重新加载', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Acknowledge', '确认', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Quantity', '数量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Log Type', '日志类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Unit', '单元', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Expression Type', '表达类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Retain Flag', '保留标志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Word Swap', '词交换', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Byte Swap', '字节交换', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Load', '加载', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Date Range', '日期范围', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable Picker', '可变选择器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Last Value', '最高价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'First Value', '第一价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Min Value', '最小值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Value', '最大值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Sum Value', '总价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Count Value', '计数值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Acknowledge DateTime Filter', '确认日期时间过滤器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Off DateTime Filter', '关闭DateTime过滤器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On DateTime Filter', '在DateTime过滤器上', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Search Form', '搜索表', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Off DateTime', '关闭日期时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Interval (Second)', '间隔（第二）', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On', '上', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Off', '关闭', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Live', '生活', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Preview', '预习', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Cancel', '取消', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Schedule', '时间表', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Log Severity', '日志严重性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Activity', '活动', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Source', '资源', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Message', '信息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Remove', '去掉', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'User Roles', '用户角色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Role', '角色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Expression', '表达', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Delay', '延迟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Category', '类别', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On Script', '脚本上', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Off Script', '关闭脚本', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Ack Script', '确认脚本', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new alarm added', '添加了新警报', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm updated successfully', '警报已成功更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm settings is updated', '警报设置已更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm removed', '警报已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm History', '报警记录', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Type', '类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Import', '进口', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Date', '日期', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure you want to activate/deactivate the selected alarm?', '确定要激活/禁用选定的警报吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure you want to Start/Stop the selected connection?', '确定要启动/停止所选连接吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Code', '码', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Priority', '优先', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Period', '期', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Log', '日志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new script added', '添加了新脚本', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Script updated successfully', '脚本更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Script removed', '脚本已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Deviation Variable', '偏差变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Total Variable', '总变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Calculation Type', '计算类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Order', '订购', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Variables', '报告变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Subgroup Order', '分组顺序', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Subgroups', '报告子组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Group Order', '团体订单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation Elements', '动画元素', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Parent Animation', '家长动画', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Color', '颜色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Duration', '持续时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Play Order', '播放顺序', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Play at Main?', '在主打？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SVG Content', ' SVG内容', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation Type', '动画类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new animation added', '添加了新动画', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Only SVG files are allowed', '仅允许使用SVG文件', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation updated successfully', '动画更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation removed', '动画已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new animation element added', '添加了新的动画元素', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation element updated successfully', '动画元素已成功更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation element removed', '动画元素已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Min. Scale', '最小比例', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max. Scale', '最大比例', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Thickness', '厚度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Backup', '备份', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Restore', '恢复', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Save & Continue', '保存并继续', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable', '变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Default', '默认', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Add', '加', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Default value', '默认值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Text', '文本', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Title', '标题', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Size', '尺寸', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Disable', '禁用', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Home View', '首页视图', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Time', '时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Second', '第二', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Last Executed At', '最后执行时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please select a master record first', '请先选择一个主记录', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Send SMS', '发送短信', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SMS Details', ' SMS详细信息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SMS Service', '短信服务', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SMS sended successfully', '短信发送成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SMS Search', '短信搜索', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Content', '内容', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SMS Settings', '短信设置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Mail sended successfully', '邮件发送成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'No selected animation', '未选择动画', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Recipient', '接受者', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Online Help', '网上帮助', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Menu', '菜单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm', '报警', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm Monitor', '警报监视器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Smart Symbol', '智能符号', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Smart Symbols', '智能符号', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable Monitor', '可变监视器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm Group', '警报组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm Groups', '警报组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On No Ack Color', '在没有Ack颜色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On Ack Color', '在Ack颜色上', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Off No Ack Color', '关闭无确认颜色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Off Ack Color', ' Off Ack颜色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print When On?', '何时打印？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print When Off?', '关闭时打印？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print When Ack?', '打印何时确认？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation', '动画', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Inverse', '逆', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Set Type', '设置类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Notify', '通知', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Default Color', '默认颜色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Gradient', '梯度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Min', '最小', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max', '最大', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Format', '格式', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Group Size', '组大小', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Decimal', '十进制', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Group Seperator', '组分隔符', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Decimal Seperator', '十进制分隔符', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Leftpad Size', '左键盘尺寸', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Rightpad Size', '右垫尺寸', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Character', '字符', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Prefix', '字首', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Suffix', '后缀', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'tag', '标签', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Initial Pos', '初始位置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Min Pos', '最小位置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Pos', '最大Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'On Drop', '放下', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Join', '加入', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Template?', '模板吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Dom Id', ' Dom ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation Element', '动画元素', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Mouse', '老鼠', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'More', '更多', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation WebSocket is on', '动画WebSocket已打开', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation WebSocket is off', '动画WebSocket已关闭', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Animation WebSocket error observed', '观察到动画WebSocket错误', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Pool Size', '泳池大小', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Adapter', '适配器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Min Retry Delay', '最小重试延迟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Retry Delay', '最大重试延迟', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Local Ip', '本地IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Local Port', '本地端口', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Cot F. Length', ' Cot F.长度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Cot Field Length', '字段长度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'IOA Field Length', ' IOA字段长度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Common A. Length', '通用A.长度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Common Address Field Length', '公共地址字段长度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'IOA F. Length', ' IOA F.长度', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Originator Address', '发件人地址', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Message F. Timeout', '消息F.超时', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Message Fragment Timeout', '消息片段超时', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max T.N.A. Recieved', '已收到最高T.N.A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Time No Ack Received', '没有收到确认的最长时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max T.N.A. Sent', '发送的最高T.N.A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Time No Ack Sent', '没有发送确认的最长时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Idle Time', '最大空闲时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max U. IP Recieved', '已接收的最大U IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Unconfirmed IPdus Received', '收到的最大未确认IPdus', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Start DT Timeout', '开始DT超时', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Start DT Retries', '开始DT重试', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Coming Soon...', '快来了...', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Rack', '架', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Slot', '广告位', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'No Data Transfer Selected', '未选择数据传输', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Destination', '目的地', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Detail Form', '详细表格', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Source Tag', '源标签', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Destination Tag', '目的地标签', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Data Transfer', '数据传输', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Detail Transfer', '详细信息传递', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Device', '设备', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Device Picker', '设备选择器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Import Tmpl', '导入Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Start Address', '起始地址', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'General I. Time', '我将军时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'General Interrogation Time', '一般审讯时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'General C.I. Time', '一般C.I.时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'General Counter Interrogation Time', '一般柜台讯问时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Cnt Point Offset', '点偏移', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Control Point Offset', '控制点偏移', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'DB Number', '数据库编号', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'IEC104 type', ' IEC104型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Sender', '发件人', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Recepient', '收货人', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Subject', '学科', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Email View', '电子邮件视图', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'From', '从', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'To', '至', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Email Search', '电子邮件搜索', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Email Service', '电子邮件服务', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Body', '身体', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Send Email', '发送电子邮件', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Send', '发送', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'User List', '用户列表', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Mail send failed', '邮件发送失败', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Email Settings', '电子邮件设置', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Email', '电子邮件', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Backup/Restore', '备份/还原', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Choose', '选择', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Processes', '过程', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Data Transfers', '数据传输', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Keywords', '关键字', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Roles', '角色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Templates', '模板', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Key', '键', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Active', '活性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Successful ?', '成功了吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Auth Logs', '验证日志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'License', '执照', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Machine Id', '机器ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Surname', '姓', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'User Limit', '用户限制', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Update', '更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'License Key', '注册码', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'License to', '许可', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'License successfully activated', '许可证已成功激活', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Failed to activate', '无法激活', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm Name', '警报名称', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Alarm Dsc', '警报Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Start All', '全部开始', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Stop All', '全部停止', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure you want to schedule/unschedule the selected data transfer?', '您确定要计划/取消计划所选的数据传输吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Process', '处理', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'GRAPHICAL VIEW', '图形视图', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'FLOW RATE', '流量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'METERING', '计量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'ENERGY & OTHER VALUES', '能源和其他价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'IN-USE GAS COMPONENTS', '使用中的气体成分', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'TOTALISORS', '总计', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'PREVIOUS HOURLY & DAILY VALUES', '小时和每日价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'ALARMS ON', '警报开启', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'NAME', '名称', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'CURRENT', '当前', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'C.HOUR', ' C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'P.HOUR', ' P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'C.DAY', ' C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'P.DAY', ' P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'G.C.A', ' G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'G.C.B', ' G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'KEY-PAD', '键盘', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'IN-USE', '正在使用', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'MAX', ' MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'DOWNLOADED', '已下载', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'NORMALIZED', '规范化', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'UNIT', '单元', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'PROPERTIES', '财产', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'GC MANAGEMENT', ' GC管理', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'INUSE GC', ' INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SET', '组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'STATUS', '状态', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'QRCODE Reader', ' QRCODE阅读器', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Scanned!', '扫描！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'deviceName', '设备名称', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Failed to load data', '无法加载数据', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'ANIMATION', '动画', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'GAS METERING', '气体计量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'GAS PROPERTIES', '气体特性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'NETWORK', '网络', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Fired Alarm Duration In Days', '天数触发警报持续时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Fired Alarm duration is updated', '触发警报的持续时间已更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Acknowledger', '确认者', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Dsc', ' Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Log Duration In Days', '以天为单位的日志持续时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Log duration is updated', '日志持续时间已更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Remove All', '移除所有', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Firstly load the datatable', '首先加载数据表', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Failed to load log data', '无法加载日志数据', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Are you sure to remove all logs?', '您确定要删除所有日志吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'All logs removed', '删除所有日志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'An error occured while removing logs', '删除日志时发生错误', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Log Message', '日志消息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Show Weather On Click', '显示点击时的天气', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Updated successfully', '更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Removed successfully', '成功删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Map', '地图', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Map api', '地图API', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Weather api', '天气api', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Interval', '间隔', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Filter', '过滤', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'SCHEDULED', '预定', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'ON', '上', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'OFF', '关闭', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Print', '打印', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Failed to load!', '无法加载！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Choose Trend', '选择趋势', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Avg Value', '平均价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Integral Value', '积分值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Max Diff Value', '最大差异值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Calculation type', '计算类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Auto Scroll', '自动滚屏', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Failed to load trend data', '无法加载趋势数据', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Select the Trend first', '先选择趋势', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Interval cannot be empty', '间隔不能为空', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable Duration In Days', '以天为单位的可变持续时间', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable duration is updated', '变量持续时间已更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Frame', '帧', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Usual', '通常', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Hourly', '小时', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Daily', '日常', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'CUSTOM', '自定义', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'COLLECTION', '采集', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Process Form', '流程表', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Background', '背景', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Text Color', '文字颜色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Main Flag', '主旗', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Grid Flag', '网格标志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Inputs', '输入', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Choose Default Image', '选择默认图像', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'States', '状态', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'State Lists', '状态列表', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'New State', '新状态', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'State name', '州名', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Attach', '连接', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Library', '图书馆', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Node updated', '节点已更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Property', '属性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Project Property', '项目财产', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Project Values', '项目价值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Stream', '流', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report', '报告', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please, choose a period', '请选择一个时期', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Name field cannot be empty!', '名称字段不能为空！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please choose a report', '请选择报告', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Group order cannot be empty!', '团体订单不能为空！', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report group removed', '报告组已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new Report group added', '添加了一个新的报告组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report group updated successfully', '报告组更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report updated successfully', '报告已成功更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new report added', '添加了新报告', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report removed', '报告已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please, select group', '请选择组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report subgroup removed', '报告子组已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new Report subgroup added', '添加了一个新的报告子组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report subgroup updated successfully', '报告子组已成功更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report Variable', '报告变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Subgroup', '子组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please choose a subgroup', '请选择一个子组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable Order', '可变订单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Variable order cannot be empty', '可变订单不能为空', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please, choose calculation type', '请选择计算类型', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please, choose variable', '请选择变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Total', '总', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Deviation', '偏差', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please, select subgroup', '请选择子组', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report variable removed', '报表变量已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new Report variable added', '添加了新的报表变量', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Report variable updated successfully', '报告变量已成功更新', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Script Output', '脚本输出', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Output message', '输出消息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Empty output', '空输出', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Error in code syntax', '代码语法错误', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Group Chat', '群聊', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Type message here', '在此处输入消息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Type message', '键入消息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Refresh Periods', '刷新期', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Control Panel', '控制面板', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Gas Properties', '气体特性', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Network', '网络', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Graph Details', '图形详细信息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Check All', '选择所有', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Menus', '菜单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Permission', '允许', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Permissions', '权限', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Rolename', '角色名称', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Role Menus', '角色菜单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Menus are added', '添加菜单', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Please, select role', '请选择角色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', ' is removed', ' 已移除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Role Permissions', '角色权限', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Permissions are added', '添加权限', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'A new role added', '添加了新角色', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Role updated successfully', '角色更新成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Role is removed', '角色已删除', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Reset Password', '重设密码', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Password Info', '密码信息', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'New Password', '新密码', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Repeat New Password', '重复新密码', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Passwords are not the same', '密码不一样', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Email Address', '电子邮件地址', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'User', '用户', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Password changed successfully', '密码更换成功', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Password change failed', '密码更改失败', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Enter new value', '输入新值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Set Value', '设定值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Increment Value', '增值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Send Flags', '发送标志', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'False/True', '错误/正确', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Decrement Value', '减量值', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Byte Swap?', '是字节交换吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Is Word Swap?', '是单词交换吗？', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Point Class', '积分课', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Deadband', '死区', NEW.space_id, 'system_update', now(), 'system_update', now()),
		('zh', 'Static Variation', '静态变化', NEW.