-- Step 1: Add order_index to animation_script
ALTER TABLE animation_script ADD COLUMN order_index integer NOT NULL DEFAULT 0;

-- Step 2: Migrate pre_anim_code into script + animation_script records
INSERT INTO script (script_id, project_id, name, code, sch_type, log_flag, insert_user, insert_dttm, space_id)
SELECT uuid(md5(a.animation_id || '::pre_script'))::text,
       a.project_id,
       'Pre Animation - ' || a.name,
       a.pre_anim_code,
       'None',
       false,
       a.insert_user,
       now(),
       a.space_id
FROM animation a
WHERE a.pre_anim_code IS NOT NULL
  AND a.pre_anim_code <> ''
  AND a.deleted_dttm IS NULL;

INSERT INTO animation_script (animation_script_id, animation_id, script_id, type, order_index, insert_user, insert_dttm, space_id)
SELECT uuid(md5(a.animation_id || '::pre_anim_script'))::text,
       a.animation_id,
       uuid(md5(a.animation_id || '::pre_script'))::text,
       'Pre',
       0,
       a.insert_user,
       now(),
       a.space_id
FROM animation a
WHERE a.pre_anim_code IS NOT NULL
  AND a.pre_anim_code <> ''
  AND a.deleted_dttm IS NULL;

-- Step 3: Migrate post_anim_code into script + animation_script records
INSERT INTO script (script_id, project_id, name, code, sch_type, log_flag, insert_user, insert_dttm, space_id)
SELECT uuid(md5(a.animation_id || '::post_script'))::text,
       a.project_id,
       'Post Animation - ' || a.name,
       a.post_anim_code,
       'None',
       false,
       a.insert_user,
       now(),
       a.space_id
FROM animation a
WHERE a.post_anim_code IS NOT NULL
  AND a.post_anim_code <> ''
  AND a.deleted_dttm IS NULL;

INSERT INTO animation_script (animation_script_id, animation_id, script_id, type, order_index, insert_user, insert_dttm, space_id)
SELECT uuid(md5(a.animation_id || '::post_anim_script'))::text,
       a.animation_id,
       uuid(md5(a.animation_id || '::post_script'))::text,
       'Post',
       0,
       a.insert_user,
       now(),
       a.space_id
FROM animation a
WHERE a.post_anim_code IS NOT NULL
  AND a.post_anim_code <> ''
  AND a.deleted_dttm IS NULL;

-- Step 4: Drop the legacy inline columns
ALTER TABLE animation DROP COLUMN pre_anim_code;
ALTER TABLE animation DROP COLUMN post_anim_code;
