-- Rename login_settings image_file_id column to image_file_name
-- This reflects the change from storing FileInfo ID reference to storing just the filename

-- First, add the new column
ALTER TABLE login_settings ADD COLUMN image_file_name VARCHAR(255);

-- Update the new column with filename data from the existing FileInfo references
-- This assumes we need to extract just the filename from the FileInfo table
UPDATE login_settings
SET image_file_name = (
    SELECT fi.file_name
    FROM file_info fi
    WHERE fi.file_info_id = login_settings.image_file_id
)
WHERE login_settings.image_file_id IS NOT NULL;

-- Drop the old column
ALTER TABLE login_settings DROP COLUMN image_file_id;

-- Add comment to document the change
COMMENT ON COLUMN login_settings.image_file_name IS 'Filename of the login background image stored in login-images subdirectory';
