-- Remove role-administration permissions and the 'Roles' menu
-- This migration deletes the following permission names:
--   CREATE_ANY_ROLE, UPDATE_ANY_ROLE, VIEW_ANY_ROLE, DELETE_ANY_ROLE
-- and removes the 'Roles' menu and any role-menu links to it.

-- Remove role_menu entries that reference the Roles menu
WITH roles_menu AS (
    SELECT menu_id FROM inscada.menus WHERE name IN ('Roles')
)
DELETE FROM inscada.role_menus rm
USING roles_menu rm2
WHERE rm.menu_id = rm2.menu_id;

-- Remove the Roles menu itself
DELETE FROM inscada.menus
WHERE name IN ('Roles');

-- Remove role_permissions entries that reference the target permissions
DELETE FROM inscada.role_permissions rp
USING inscada.permissions p
WHERE rp.permission_id = p.permission_id
  AND p.name IN ('CREATE_ANY_ROLE', 'UPDATE_ANY_ROLE', 'VIEW_ANY_ROLE', 'DELETE_ANY_ROLE');

-- Remove the permissions from the permissions table
DELETE FROM inscada.permissions
WHERE name IN ('CREATE_ANY_ROLE', 'UPDATE_ANY_ROLE', 'VIEW_ANY_ROLE', 'DELETE_ANY_ROLE');
