@echo off
REM Script to generate a self-signed SSL certificate and keystore for inSCADA

REM Prompt for values with defaults
set /p KEYS="Enter keystore file name [inscada-keystore.p12]: "
if "%KEYS%"=="" set KEYS=inscada-keystore.p12
set /p PASS="Enter password (must be at least 6 characters): "
:checkpass
if "%PASS%"=="" (
    echo [ERROR] Password is required and must be at least 6 characters.
    set /p PASS="Enter password (must be at least 6 characters): "
    goto checkpass
)
if not "%PASS:~5,1%"=="" goto passok
    echo [ERROR] Password must be at least 6 characters.
    set /p PASS="Enter password (must be at least 6 characters): "
    goto checkpass
:passok
set /p CN="Enter Common Name (CN) [localhost]: "
if "%CN%"=="" set CN=localhost
set /p IP="Enter IP address for SAN [127.0.0.1]: "
if "%IP%"=="" set IP=127.0.0.1
set /p HOSTNAME="Enter DNS hostname for SAN [%COMPUTERNAME%]: "
if "%HOSTNAME%"=="" set HOSTNAME=%COMPUTERNAME%

echo [INFO] Using provided password: %PASS%

REM Remove existing keystore if present
if exist "%KEYS%" del "%KEYS%"

REM Create a config file for SAN extension with multiple names
set SANFILE=san.cnf
(
    echo [req]
    echo distinguished_name=req
    echo x509_extensions=v3_req
    echo prompt=no
    echo [v3_req]
    echo subjectAltName=@alt_names
    echo [alt_names]
    echo DNS.1=localhost
    echo DNS.2=%HOSTNAME%
    echo IP.1=%IP%
    echo DNS.3=%CN%
) > %SANFILE%

REM Generate the keystore with SAN (requires keytool 1.8+)
keytool -genkeypair -alias inscada -keyalg RSA -keysize 2048 -storetype PKCS12 -keystore "%KEYS%" -validity 3650 -storepass "%PASS%" -keypass "%PASS%" -dname "CN=%CN%, OU=INS, O=inSCADA, L=Ankara, S=Ankara, C=TR" -ext "SAN=dns:localhost,dns:%HOSTNAME%,dns:%CN%,ip:%IP%"

if %ERRORLEVEL% NEQ 0 (
    echo Failed to create keystore!
    del %SANFILE%
    exit /b 1
) else (
    echo Keystore created: %KEYS%
    echo Password: %PASS%
    del %SANFILE%
)

REM Export the public certificate for client import as inscada.cer
set CERTFILE=inscada.cer
keytool -exportcert -alias inscada -keystore "%KEYS%" -storetype PKCS12 -storepass "%PASS%" -file "%CERTFILE%"
if %ERRORLEVEL% NEQ 0 (
    echo Failed to export public certificate!
    exit /b 1
) else (
    echo Public certificate exported: %CERTFILE%
)
