-- 1) role_members (UserRole)
ALTER TABLE IF EXISTS inscada.role_members ADD COLUMN IF NOT EXISTS space_id VARCHAR(36);

UPDATE inscada.role_members rm
SET space_id = (SELECT r.space_id FROM inscada.roles r WHERE r.role_id = rm.role_id)
WHERE rm.space_id IS NULL;

ALTER TABLE inscada.role_members
    ALTER COLUMN space_id SET NOT NULL;

ALTER TABLE inscada.role_members
    ADD CONSTRAINT role_members_space_space_id_fk FOREIGN KEY (space_id) REFERENCES inscada.space(space_id);

-- 2) role_permissions (RolePermission)
ALTER TABLE IF EXISTS inscada.role_permissions ADD COLUMN IF NOT EXISTS space_id VARCHAR(36);

UPDATE inscada.role_permissions rp
SET space_id = (SELECT r.space_id FROM inscada.roles r WHERE r.role_id = rp.role_id)
WHERE rp.space_id IS NULL;

ALTER TABLE inscada.role_permissions
    ALTER COLUMN space_id SET NOT NULL;

ALTER TABLE inscada.role_permissions
    ADD CONSTRAINT role_permissions_space_space_id_fk FOREIGN KEY (space_id) REFERENCES inscada.space(space_id);

CREATE INDEX IF NOT EXISTS idx_role_permissions_space_id ON inscada.role_permissions(space_id);

-- 3) role_menus (RoleMenu)
ALTER TABLE IF EXISTS inscada.role_menus ADD COLUMN IF NOT EXISTS space_id VARCHAR(36);

UPDATE inscada.role_menus rm2
SET space_id = (SELECT r.space_id FROM inscada.roles r WHERE r.role_id = rm2.role_id)
WHERE rm2.space_id IS NULL;

ALTER TABLE inscada.role_menus
    ALTER COLUMN space_id SET NOT NULL;

ALTER TABLE inscada.role_menus
    ADD CONSTRAINT role_menus_space_space_id_fk FOREIGN KEY (space_id) REFERENCES inscada.space(space_id);

CREATE INDEX IF NOT EXISTS idx_role_menus_space_id ON inscada.role_menus(space_id);