-- Create entity_access_target table to centralize entity references for role-based entity access control
CREATE TABLE IF NOT EXISTS inscada.entity_access_target (
    entity_access_target_id VARCHAR(36) PRIMARY KEY,
    entity_type VARCHAR(50) NOT NULL,
    entity_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    name VARCHAR(100) NOT NULL,
    dsc VARCHAR(255),
    insert_user VARCHAR(50) NOT NULL,
    insert_dttm TIMESTAMP WITH TIME ZONE NOT NULL,
    version BIGINT NOT NULL DEFAULT 0,
    version_dttm TIMESTAMP WITH TIME ZONE,
    version_user VARCHAR(50),
    deleted_dttm TIMESTAMP WITH TIME ZONE,
    deleted_user VARCHAR(50)
);

CREATE UNIQUE INDEX IF NOT EXISTS entity_access_target_uindex
    ON inscada.entity_access_target (entity_type, entity_id, space_id);

CREATE INDEX IF NOT EXISTS idx_entity_access_target_entity_type_entity_id ON inscada.entity_access_target(entity_type, entity_id);
CREATE INDEX IF NOT EXISTS idx_entity_access_target_space_id ON inscada.entity_access_target(space_id);

-- Create role_access table referencing the new entity_access_target
CREATE TABLE IF NOT EXISTS inscada.role_access (
    role_access_id VARCHAR(36) PRIMARY KEY,
    entity_access_target_id VARCHAR(36) NOT NULL,
    role_id VARCHAR(36) NOT NULL,
    space_id VARCHAR(36) NOT NULL,
    insert_user VARCHAR(50) NOT NULL,
    insert_dttm TIMESTAMP WITH TIME ZONE NOT NULL,
    version BIGINT NOT NULL DEFAULT 0,
    version_dttm TIMESTAMP WITH TIME ZONE,
    version_user VARCHAR(50),
    deleted_dttm TIMESTAMP WITH TIME ZONE,
    deleted_user VARCHAR(50),
    CONSTRAINT role_access_roles_role_id_fk FOREIGN KEY (role_id) REFERENCES inscada.roles(role_id),
    CONSTRAINT role_access_entity_access_target_target_id_fk FOREIGN KEY (entity_access_target_id) REFERENCES inscada.entity_access_target(entity_access_target_id),
    CONSTRAINT role_access_spaces_space_id_fk FOREIGN KEY (space_id) REFERENCES inscada.space(space_id)
);

CREATE UNIQUE INDEX IF NOT EXISTS role_access_entity_access_target_role_uindex ON inscada.role_access(entity_access_target_id, role_id);

-- Indexes for efficient lookups
CREATE INDEX IF NOT EXISTS idx_role_access_entity_access_target ON inscada.role_access(entity_access_target_id);
CREATE INDEX IF NOT EXISTS idx_role_access_role_id ON inscada.role_access(role_id);
CREATE INDEX IF NOT EXISTS idx_role_access_space_id ON inscada.role_access(space_id);