create table unit
(
	unit_id serial not null
		constraint unit_pk
			primary key,
	unit varchar(100) not null,

    space_id     integer      not null,
	insert_user varchar(50) not null,
	insert_dttm timestamp with time zone not null,
	version_user varchar(50),
	version_dttm timestamp with time zone
)
;

create unique index unit_space_id_unit_uindex on unit(space_id, unit);

ALTER SEQUENCE unit_unit_id_seq RENAME TO unit_seq;
ALTER SEQUENCE unit_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (231, 'CREATE_UNIT'), (232, 'VIEW_UNIT'),
        (233, 'UPDATE_UNIT'), (234, 'DELETE_UNIT'),
        (235, 'EXPORT_UNIT'), (236, 'IMPORT_UNIT');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 231), (1, 232), (1, 233), (1, 234), (1, 235), (1, 236);

insert into inscada.menus (menu_id, name) values (87, 'Unit Dev');
insert into inscada.role_menus (role_id, menu_id) values (1, 87);

update variable SET unit = '°C' where unit = '°C ';

----------below, inserts default units into existing spaces ------------------
do
$$
declare
    sp record;
begin
    for sp in select space_id from space
    loop 
    insert into inscada.unit (unit, space_id, insert_user, insert_dttm)
    values ('°C', sp.space_id, 'system_update', now()),
            ('°F', sp.space_id, 'system_update', now()),
            ('%', sp.space_id, 'system_update', now()),
            ('% mole', sp.space_id, 'system_update', now()),
            ('A', sp.space_id, 'system_update', now()),
            ('Adet/Piece', sp.space_id, 'system_update', now()),
            ('Ah', sp.space_id, 'system_update', now()),
            ('Angle', sp.space_id, 'system_update', now()),
            ('Angle/s', sp.space_id, 'system_update', now()),
            ('ATM', sp.space_id, 'system_update', now()),
            ('Bar', sp.space_id, 'system_update', now()),
            ('Bar(a)', sp.space_id, 'system_update', now()),
            ('Bar(g)', sp.space_id, 'system_update', now()),
            ('barrel/varil', sp.space_id, 'system_update', now()),
            ('Box', sp.space_id, 'system_update', now()),
            ('Btu', sp.space_id, 'system_update', now()),
            ('Cal', sp.space_id, 'system_update', now()),
            ('cc', sp.space_id, 'system_update', now()),
            ('cc/s', sp.space_id, 'system_update', now()),
            ('cc/stroke', sp.space_id, 'system_update', now()),
            ('cl', sp.space_id, 'system_update', now()),
            ('cm', sp.space_id, 'system_update', now()),
            ('cm2', sp.space_id, 'system_update', now()),
            ('Day', sp.space_id, 'system_update', now()),
            ('g', sp.space_id, 'system_update', now()),
            ('gallon', sp.space_id, 'system_update', now()),
            ('HF1', sp.space_id, 'system_update', now()),
            ('HF2', sp.space_id, 'system_update', now()),
            ('Hour', sp.space_id, 'system_update', now()),
            ('Hz', sp.space_id, 'system_update', now()),
            ('joule', sp.space_id, 'system_update', now()),
            ('K', sp.space_id, 'system_update', now()),
            ('Kcal', sp.space_id, 'system_update', now()),
            ('kcal/h', sp.space_id, 'system_update', now()),
            ('Kcal/Stdm3', sp.space_id, 'system_update', now()),
            ('Kg', sp.space_id, 'system_update', now()),
            ('kg/h', sp.space_id, 'system_update', now()),
            ('kg/m3', sp.space_id, 'system_update', now()),
            ('kg/Stdm3', sp.space_id, 'system_update', now()),
            ('km', sp.space_id, 'system_update', now()),
            ('km/h', sp.space_id, 'system_update', now()),
            ('km2', sp.space_id, 'system_update', now()),
            ('KVA', sp.space_id, 'system_update', now()),
            ('KVAR', sp.space_id, 'system_update', now()),
            ('KW', sp.space_id, 'system_update', now()),
            ('KWh', sp.space_id, 'system_update', now()),
            ('kw/h', sp.space_id, 'system_update', now()),
            ('KVAh', sp.space_id, 'system_update', now()),
            ('KVArh', sp.space_id, 'system_update', now()),
            ('litre (L)', sp.space_id, 'system_update', now()),
            ('m', sp.space_id, 'system_update', now()),
            ('m/s', sp.space_id, 'system_update', now()),
            ('m2', sp.space_id, 'system_update', now()),
            ('m3', sp.space_id, 'system_update', now()),
            ('m3/s', sp.space_id, 'system_update', now()),
            ('m3/h', sp.space_id, 'system_update', now()),
            ('mBar', sp.space_id, 'system_update', now()),
            ('Mcal', sp.space_id, 'system_update', now()),
            ('MCal/h', sp.space_id, 'system_update', now()),
            ('Minute', sp.space_id, 'system_update', now()),
            ('ml', sp.space_id, 'system_update', now()),
            ('mm', sp.space_id, 'system_update', now()),
            ('mm/s', sp.space_id, 'system_update', now()),
            ('Month', sp.space_id, 'system_update', now()),
            ('MVA', sp.space_id, 'system_update', now()),
            ('MVAR', sp.space_id, 'system_update', now()),
            ('MW', sp.space_id, 'system_update', now()),
            ('MW/h', sp.space_id, 'system_update', now()),
            ('ohm', sp.space_id, 'system_update', now()),
            ('Pascal', sp.space_id, 'system_update', now()),
            ('psi', sp.space_id, 'system_update', now()),
            ('RPM', sp.space_id, 'system_update', now()),
            ('Second', sp.space_id, 'system_update', now()),
            ('Set', sp.space_id, 'system_update', now()),
            ('Stdm3', sp.space_id, 'system_update', now()),
            ('Stdm3/h', sp.space_id, 'system_update', now()),
            ('stroke', sp.space_id, 'system_update', now()),
            ('stroke/s', sp.space_id, 'system_update', now()),
            ('therm', sp.space_id, 'system_update', now()),
            ('Ton', sp.space_id, 'system_update', now()),
            ('USM  Mcal', sp.space_id, 'system_update', now()),
            ('USM Stdm3', sp.space_id, 'system_update', now()),
            ('V', sp.space_id, 'system_update', now()),
            ('Vol', sp.space_id, 'system_update', now()),
            ('Watt', sp.space_id, 'system_update', now()),
            ('Week', sp.space_id, 'system_update', now()),
            ('Year', sp.space_id, 'system_update', now()),
            ('L/H', sp.space_id, 'system_update', now()),
            ('l/h', sp.space_id, 'system_update', now()),
            ('PPM', sp.space_id, 'system_update', now()),
            ('ppm', sp.space_id, 'system_update', now()),
            ('Kcal/m3', sp.space_id, 'system_update', now()),
            ('Kw/m3', sp.space_id, 'system_update', now()),
            ('kw/stdm3', sp.space_id, 'system_update', now()),
            ('mg/sm3', sp.space_id, 'system_update', now()),
            ('m3/dk', sp.space_id, 'system_update', now());
    end loop;
end;
$$;
---------------------------end of loop-----------------------------

CREATE OR REPLACE FUNCTION insert_unit_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
        insert into inscada.unit (unit, space_id, insert_user, insert_dttm)
        values ('°C', NEW.space_id, 'system_update', now()),
        ('°F', NEW.space_id, 'system_update', now()),
        ('%', NEW.space_id, 'system_update', now()),
        ('% mole', NEW.space_id, 'system_update', now()),
        ('A', NEW.space_id, 'system_update', now()),
        ('Adet/Piece', NEW.space_id, 'system_update', now()),
        ('Ah', NEW.space_id, 'system_update', now()),
        ('Angle', NEW.space_id, 'system_update', now()),
        ('Angle/s', NEW.space_id, 'system_update', now()),
        ('ATM', NEW.space_id, 'system_update', now()),
        ('Bar', NEW.space_id, 'system_update', now()),
        ('Bar(a)', NEW.space_id, 'system_update', now()),
        ('Bar(g)', NEW.space_id, 'system_update', now()),
        ('barrel/varil', NEW.space_id, 'system_update', now()),
        ('Box', NEW.space_id, 'system_update', now()),
        ('Btu', NEW.space_id, 'system_update', now()),
        ('Cal', NEW.space_id, 'system_update', now()),
        ('cc', NEW.space_id, 'system_update', now()),
        ('cc/s', NEW.space_id, 'system_update', now()),
        ('cc/stroke', NEW.space_id, 'system_update', now()),
        ('cl', NEW.space_id, 'system_update', now()),
        ('cm', NEW.space_id, 'system_update', now()),
        ('cm2', NEW.space_id, 'system_update', now()),
        ('Day', NEW.space_id, 'system_update', now()),
        ('g', NEW.space_id, 'system_update', now()),
        ('gallon', NEW.space_id, 'system_update', now()),
        ('HF1', NEW.space_id, 'system_update', now()),
        ('HF2', NEW.space_id, 'system_update', now()),
        ('Hour', NEW.space_id, 'system_update', now()),
        ('Hz', NEW.space_id, 'system_update', now()),
        ('joule', NEW.space_id, 'system_update', now()),
        ('K', NEW.space_id, 'system_update', now()),
        ('Kcal', NEW.space_id, 'system_update', now()),
        ('kcal/h', NEW.space_id, 'system_update', now()),
        ('Kcal/Stdm3', NEW.space_id, 'system_update', now()),
        ('Kg', NEW.space_id, 'system_update', now()),
        ('kg/h', NEW.space_id, 'system_update', now()),
        ('kg/m3', NEW.space_id, 'system_update', now()),
        ('kg/Stdm3', NEW.space_id, 'system_update', now()),
        ('km', NEW.space_id, 'system_update', now()),
        ('km/h', NEW.space_id, 'system_update', now()),
        ('km2', NEW.space_id, 'system_update', now()),
        ('KVA', NEW.space_id, 'system_update', now()),
        ('KVAR', NEW.space_id, 'system_update', now()),
        ('KW', NEW.space_id, 'system_update', now()),
        ('KWh', NEW.space_id, 'system_update', now()),
        ('kw/h', NEW.space_id, 'system_update', now()),
        ('KVAh', NEW.space_id, 'system_update', now()),
        ('KVArh', NEW.space_id, 'system_update', now()),
        ('litre (L)', NEW.space_id, 'system_update', now()),
        ('m', NEW.space_id, 'system_update', now()),
        ('m/s', NEW.space_id, 'system_update', now()),
        ('m2', NEW.space_id, 'system_update', now()),
        ('m3', NEW.space_id, 'system_update', now()),
        ('m3/s', NEW.space_id, 'system_update', now()),
        ('m3/h', NEW.space_id, 'system_update', now()),
        ('mBar', NEW.space_id, 'system_update', now()),
        ('Mcal', NEW.space_id, 'system_update', now()),
        ('MCal/h', NEW.space_id, 'system_update', now()),
        ('Minute', NEW.space_id, 'system_update', now()),
        ('ml', NEW.space_id, 'system_update', now()),
        ('mm', NEW.space_id, 'system_update', now()),
        ('mm/s', NEW.space_id, 'system_update', now()),
        ('Month', NEW.space_id, 'system_update', now()),
        ('MVA', NEW.space_id, 'system_update', now()),
        ('MVAR', NEW.space_id, 'system_update', now()),
        ('MW', NEW.space_id, 'system_update', now()),
        ('MW/h', NEW.space_id, 'system_update', now()),
        ('ohm', NEW.space_id, 'system_update', now()),
        ('Pascal', NEW.space_id, 'system_update', now()),
        ('psi', NEW.space_id, 'system_update', now()),
        ('RPM', NEW.space_id, 'system_update', now()),
        ('Second', NEW.space_id, 'system_update', now()),
        ('Set', NEW.space_id, 'system_update', now()),
        ('Stdm3', NEW.space_id, 'system_update', now()),
        ('Stdm3/h', NEW.space_id, 'system_update', now()),
        ('stroke', NEW.space_id, 'system_update', now()),
        ('stroke/s', NEW.space_id, 'system_update', now()),
        ('therm', NEW.space_id, 'system_update', now()),
        ('Ton', NEW.space_id, 'system_update', now()),
        ('USM  Mcal', NEW.space_id, 'system_update', now()),
        ('USM Stdm3', NEW.space_id, 'system_update', now()),
        ('V', NEW.space_id, 'system_update', now()),
        ('Vol', NEW.space_id, 'system_update', now()),
        ('Watt', NEW.space_id, 'system_update', now()),
        ('Week', NEW.space_id, 'system_update', now()),
        ('Year', NEW.space_id, 'system_update', now()),
        ('L/H', NEW.space_id, 'system_update', now()),
        ('l/h', NEW.space_id, 'system_update', now()),
        ('PPM', NEW.space_id, 'system_update', now()),
        ('ppm', NEW.space_id, 'system_update', now()),
        ('Kcal/m3', NEW.space_id, 'system_update', now()),
        ('Kw/m3', NEW.space_id, 'system_update', now()),
        ('kw/stdm3', NEW.space_id, 'system_update', now()),
        ('mg/sm3', NEW.space_id, 'system_update', now()),
        ('m3/dk', NEW.space_id, 'system_update', now());

	RETURN NEW;
END;
$$;

CREATE trigger trg_insert_unit_space_data
AFTER INSERT on inscada.space
FOR EACH ROW EXECUTE PROCEDURE
  insert_unit_space_data();
