create table board_group
(
    board_group_id serial       not null
        constraint board_group_board_group_id_pk
        primary key,
    name          varchar(100) not null,
    color         varchar(100),
    rank         integer,

    insert_user   varchar(50)  not null,
    insert_dttm   timestamp with time zone not null,
    version_user  varchar(50),
    version_dttm  timestamp with time zone
)
;

create unique index board_group_name_uindex
    on board_group (name)
;

create table board
(
    board_id  serial       not null
        constraint board_board_id_pk
        primary key,
    board_group_id      integer      not null
        constraint board_board_group_board_group_id_fk
        references board_group
        on update cascade on delete cascade,
    type                varchar(20) not null,
    x            numeric,
    y            numeric,
    width        numeric,
    height       numeric,
    config       text,

    insert_user   varchar(50)  not null,
    insert_dttm   timestamp with time zone not null,
    version_user  varchar(50),
    version_dttm  timestamp with time zone
)
;

ALTER SEQUENCE board_group_board_group_id_seq INCREMENT 50;
ALTER SEQUENCE board_board_id_seq INCREMENT 50;

INSERT INTO inscada.permissions(permission_id, name)
VALUES (178, 'VIEW_DASHBOARD'), (179, 'CREATE_DASHBOARD'), (180, 'UPDATE_DASHBOARD'), (181, 'DELETE_DASHBOARD'),
(182, 'EXPORT_DASHBOARD'), (183, 'IMPORT_DASHBOARD');

INSERT INTO inscada.role_permissions (role_id, permission_id)
VALUES (1,178), (1,179), (1,180), (1,181), (1,182), (1,183);