DROP TABLE inscada.otp_settings;

DELETE FROM inscada.role_permissions rp
USING inscada.permissions p
WHERE rp.permission_id = p.permission_id
  AND p.name IN ('VIEW_OTP_SETTINGS', 'UPDATE_OTP_SETTINGS');


DELETE FROM inscada.permissions
WHERE name IN ('VIEW_OTP_SETTINGS', 'UPDATE_OTP_SETTINGS');

WITH menus_to_remove AS (
  SELECT menu_id FROM inscada.menus WHERE name IN ('OTP Settings')
)
DELETE FROM inscada.role_menus rm
USING menus_to_remove mr
WHERE rm.menu_id = mr.menu_id;

DELETE FROM inscada.menus
WHERE name IN ('OTP Settings');

INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('277', 'VIEW_APPLICATION_MAIL_SETTINGS', TRUE, NULL, 'system', NOW()),
    ('278', 'UPDATE_APPLICATION_MAIL_SETTINGS', TRUE, NULL, 'system', NOW()),
    ('279', 'VIEW_APPLICATION_SMS_SETTINGS', TRUE, NULL, 'system', NOW()),
    ('280', 'UPDATE_APPLICATION_SMS_SETTINGS', TRUE, NULL, 'system', NOW());

INSERT INTO inscada.role_permissions (role_permission_id, role_id, permission_id, insert_dttm, insert_user)
SELECT
    uuid(md5(r.role_id || '::' || p.permission_id))::text as role_permission_id,
    r.role_id,
    p.permission_id,
    CURRENT_TIMESTAMP,
    'system'
FROM
    inscada.roles r
        JOIN
    inscada.permissions p ON r.space_id = p.space_id
WHERE
    r.name = 'administrator'
  -- 1. ENFORCE NON-NULL SPACE_ID FOR THE ROLE:
  AND r.space_id IS NOT NULL
  -- 2. LIST OF REQUIRED PERMISSIONS:
  AND p.name IN (
                 'VIEW_APPLICATION_MAIL_SETTINGS',
                 'UPDATE_APPLICATION_MAIL_SETTINGS',
                 'VIEW_APPLICATION_SMS_SETTINGS',
                 'UPDATE_APPLICATION_SMS_SETTINGS'
    )
  -- 3. EXCLUDE PERMISSIONS THAT ALREADY EXIST FOR THE ROLE:
  AND NOT EXISTS (
        SELECT 1
        FROM inscada.role_permissions rp
        WHERE rp.role_id = r.role_id AND rp.permission_id = p.permission_id
    );