-- This migration removes the database trigger 'enforce_system_entity_protection'.
-- This trigger was added in V277 to prevent the application from creating system entities.
-- However, the application logic has now matured to handle the creation of system entities
-- through trusted, internal processes (e.g., creating default roles for a new space).
-- The database-level restriction is now in conflict with this application logic and is being removed.
-- The application's service layer is now the single source of truth for these rules.

-- Step 1: Drop the triggers from all tables that use the function.
DROP TRIGGER IF EXISTS protect_system_users_trigger ON inscada.users;
DROP TRIGGER IF EXISTS protect_system_roles_trigger ON inscada.roles;
DROP TRIGGER IF EXISTS protect_system_spaces_trigger ON inscada.space;

-- Step 2: Drop the trigger function itself.
DROP FUNCTION IF EXISTS enforce_system_entity_protection();