-- This migration updates the nullability of audit columns on the former join tables
-- that were converted to entities.
-- 1. insert_user: Becomes NOT NULL. Existing NULLs are populated with 'system'.
-- 2. version_user: Becomes nullable.
-- 3. version_dttm: Becomes nullable.

-- === 1. Table: role_members (UserRole) ===
-- Populate existing NULLs before adding the NOT NULL constraint.
UPDATE role_members SET insert_user = 'system' WHERE insert_user IS NULL;
-- Apply constraints
ALTER TABLE role_members
    ALTER COLUMN insert_user SET NOT NULL,
    ALTER COLUMN version_user DROP NOT NULL,
    ALTER COLUMN version_dttm DROP NOT NULL;


-- === 2. Table: space_users (UserSpace) ===
-- Populate existing NULLs before adding the NOT NULL constraint.
UPDATE space_users SET insert_user = 'system' WHERE insert_user IS NULL;
-- Apply constraints
ALTER TABLE space_users
    ALTER COLUMN insert_user SET NOT NULL,
    ALTER COLUMN version_user DROP NOT NULL,
    ALTER COLUMN version_dttm DROP NOT NULL;


-- === 3. Table: role_permissions (RolePermission) ===
-- Populate existing NULLs before adding the NOT NULL constraint.
UPDATE role_permissions SET insert_user = 'system' WHERE insert_user IS NULL;
-- Apply constraints
ALTER TABLE role_permissions
    ALTER COLUMN insert_user SET NOT NULL,
    ALTER COLUMN version_user DROP NOT NULL,
    ALTER COLUMN version_dttm DROP NOT NULL;


-- === 4. Table: role_menus (RoleMenu) ===
-- Populate existing NULLs before adding the NOT NULL constraint.
UPDATE role_menus SET insert_user = 'system' WHERE insert_user IS NULL;
-- Apply constraints
ALTER TABLE role_menus
    ALTER COLUMN insert_user SET NOT NULL,
    ALTER COLUMN version_user DROP NOT NULL,
    ALTER COLUMN version_dttm DROP NOT NULL;