DROP TABLE sms_settings;
CREATE TABLE sms_settings
(
    sms_settings_id serial              not null
        constraint sms_settings_sms_settings_id_pk
            primary key,
    provider        varchar(50)         not null,
    dp_username        varchar(255),
    dp_password        varchar(255),
    dp_short_number    varchar(255),
    dp_account_number  varchar(255),
    dp_originator      varchar(255),
    dp_operator        varchar(255),
    tw_account_sid     varchar(255),
    tw_auth_token      varchar(255),
    tw_twilio_number   varchar(255),
    default_flag    boolean,
    insert_user     varchar(50)         not null,
    insert_dttm     time with time zone not null,
    version_user    varchar(50),
    version_dttm    time with time zone,
    space_id        int                 not null
);

create unique index sms_settings_space_id_provider_uindex on sms_settings (space_id, provider);

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'dataport',
       true,
       'inscada',
       now(),
       (select space_id from space where space.name = 'default_space')
       where not exists(select * from inscada.sms_settings where provider='dataport');

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'twilio',
       false,
       'inscada',
       now(),
       (select space_id from space where space.name = 'default_space')
       where not exists(select * from inscada.sms_settings where provider='twilio');