-- Add space-aware permissions support
-- Add is_global column to permissions table
ALTER TABLE permissions ADD COLUMN is_global BOOLEAN DEFAULT FALSE;
ALTER TABLE permissions ADD COLUMN space_id VARCHAR(36);

-- Drop the existing unique index on name only
DROP INDEX IF EXISTS permissions_name_uindex;

-- Create new unique index on name and space_id combination
CREATE UNIQUE INDEX permissions_name_space_uindex ON permissions(name, space_id);

-- Create index for better performance
CREATE INDEX idx_permissions_is_global ON permissions(is_global);
CREATE INDEX idx_permissions_space_id ON permissions(space_id);

-- Add foreign key constraint
ALTER TABLE permissions ADD CONSTRAINT fk_permissions_space
    FOREIGN KEY (space_id) REFERENCES space(space_id);

-- Mark existing global admin permissions as global (system-wide)
UPDATE permissions SET is_global = TRUE
WHERE name IN (
    -- System Management
    'EXEC_SYSTEM_COMMAND',
    'VIEW_SYSTEM_STATS',
    'VIEW_SYSTEM_REQUESTS',
    'DELETE_SYSTEM_REQUESTS',

    -- User/Role Management (system-wide)
    'CREATE_ANY_USER',
    'VIEW_ALL_USERS',
    'UPDATE_ANY_USER',
    'DELETE_ANY_USER',
    'CREATE_ANY_ROLE',
    'VIEW_ALL_ROLES',
    'UPDATE_ANY_ROLE',
    'DELETE_ANY_ROLE',
    'EXPORT_ALL_ROLES',
    'IMPORT_ALL_ROLES',
    'VIEW_ALL_PERMISSIONS',
    'VIEW_ALL_MENUS',

    -- Space Management
    'CREATE_ANY_SPACE',
    'UPDATE_ANY_SPACE',
    'DELETE_ANY_SPACE',
    'VIEW_ALL_SPACES',

    -- System Settings
    'VIEW_LICENSE',
    'UPDATE_LICENSE',
    'UPDATE_LOGIN_SETTINGS',
    'UPDATE_IP_FILTER_SETTINGS',
    'VIEW_OTP_SETTINGS',
    'UPDATE_OTP_SETTINGS',

    -- Security & Authentication
    'VIEW_AUTH_LOGGED_IN_USERS',
    'VIEW_AUTH_LOCKED_USERS',
    'VIEW_AUTH_ATTEMPTS'
);

-- Add space-level user management permissions template
INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('260', 'CREATE_SPACE_USER', FALSE, NULL, 'system', NOW()),
    ('261', 'VIEW_SPACE_USERS', FALSE, NULL, 'system', NOW()),
    ('262', 'UPDATE_SPACE_USER', FALSE, NULL, 'system', NOW()),
    ('263', 'DELETE_SPACE_USER', FALSE, NULL, 'system', NOW()),
    ('264', 'CREATE_SPACE_ROLE', FALSE, NULL, 'system', NOW()),
    ('265', 'VIEW_SPACE_ROLES', FALSE, NULL, 'system', NOW()),
    ('266', 'UPDATE_SPACE_ROLE', FALSE, NULL, 'system', NOW()),
    ('267', 'DELETE_SPACE_ROLE', FALSE, NULL, 'system', NOW()),
    ('268', 'IMPORT_SPACE_ROLES', FALSE, NULL, 'system', NOW()),
    ('269', 'EXPORT_SPACE_ROLES', FALSE, NULL, 'system', NOW()),
    ('270', 'VIEW_SPACE_PERMISSIONS', FALSE, NULL, 'system', NOW()),
    ('271', 'VIEW_SPACE_MENUS', FALSE, NULL, 'system', NOW());

