create table symbol
(
	symbol_id serial not null
		constraint symbol_pk
			primary key,
	name varchar(100) not null,
	dsc varchar(100),
	content text,

    space_id     integer      not null,
	insert_user varchar(50) not null,
	insert_dttm timestamp with time zone not null,
	version_user varchar(50),
	version_dttm timestamp with time zone
)
;

create unique index symbol_space_id_name_uindex on symbol(space_id, name);

ALTER SEQUENCE symbol_symbol_id_seq RENAME TO symbol_seq;
ALTER SEQUENCE symbol_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (246, 'CREATE_SYMBOL'), (247, 'VIEW_SYMBOL'),
        (248, 'UPDATE_SYMBOL'), (249, 'DELETE_SYMBOL'),
        (250, 'EXPORT_SYMBOL'), (251, 'IMPORT_SYMBOL');

insert into inscada.menus (menu_id, name) values (93, 'Symbol Dev');

----------below, inserts symbol permissions and menu into all roles ------------------
do
$$
declare
    r record;
begin
    for r in select role_id from roles
    loop
    insert into inscada.role_permissions (role_id, permission_id)
    values (r.role_id, 246), (r.role_id, 247), (r.role_id, 248),
    (r.role_id, 249), (r.role_id, 250), (r.role_id, 251) on conflict do nothing;

    insert into inscada.role_menus (role_id, menu_id) values (r.role_id, 93) on conflict do nothing;
    end loop;
end;
$$;
---------------------------end of loop-----------------------------