-- Fix historical issue:
-- global menus and permissions (templates with is_global = 1)
-- were copied into other spaces. We want to:
--   * Keep all templates (space_id IS NULL) as-is
--   * Keep all data in the default space as-is
--   * Remove any role_menus / role_permissions links in non-default spaces
--     that point to global menus/permissions
--   * Remove any non-default-space rows that are themselves marked as global

-- Assumptions:
--   * Global templates have space_id IS NULL and is_global = 1
--   * Space-specific copies should always have space_id NOT NULL and is_global = 0
--   * Roles are space-scoped via role.space_id

-- 1) Clean up role_menus pointing to global menus for roles in non-default spaces
DELETE FROM role_menus rm
    USING roles r,
      space sp,
      menus mn
WHERE rm.role_id = r.role_id
  AND r.space_id = sp.space_id
  AND rm.menu_id = mn.menu_id
  AND sp.name <> 'default_space'
  AND mn.is_global is true;

-- 2) Clean up role_permissions pointing to global permissions for roles in non-default spaces
DELETE FROM role_permissions rp
    USING roles r,
      space sp,
      permissions perm
WHERE rp.role_id = r.role_id
  AND r.space_id = sp.space_id
  AND rp.permission_id = perm.permission_id
  AND sp.name <> 'default_space'
  AND perm.is_global is true;

-- 3) Remove any menus in non-default spaces that are incorrectly marked global
-- Templates (space_id IS NULL) are fine; we only remove space-scoped rows with is_global = 1
DELETE FROM menus mn
    USING space sp
WHERE mn.space_id = sp.space_id
  AND sp.name <> 'default_space'
  AND mn.is_global is true;

-- 4) Remove any permissions in non-default spaces that are incorrectly marked global
DELETE FROM permissions perm
    USING space sp
WHERE perm.space_id = sp.space_id
  AND sp.name <> 'default_space'
  AND perm.is_global is true;
