--- Create the table to store synchronization records for PostgreSQL entities.
CREATE TABLE sync_outbox (
    id UUID PRIMARY KEY DEFAULT gen_random_uuid(),
    entity_name TEXT NOT NULL,
    entity_id UUID NOT NULL,
    payload JSONB NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
    processed_at TIMESTAMP WITH TIME ZONE
);

--- Create a highly efficient partial index for the sync worker.
--- This index only includes records that have not been processed yet,
--- making the worker's polling query extremely fast.
CREATE INDEX idx_sync_outbox_unprocessed
ON sync_outbox (created_at asc)
WHERE processed_at IS NULL;