-- This migration script transforms the old ManyToMany join tables into proper entities
-- by dropping the composite primary keys, adding a new single-column primary key,
-- and adding the required audit columns from the BaseModel.

-- 1. Transform 'role_members' to 'UserRole' entity table
ALTER TABLE role_members DROP CONSTRAINT IF EXISTS role_members_pk;
ALTER TABLE role_members ADD COLUMN role_member_id VARCHAR(36);
UPDATE role_members SET role_member_id = gen_random_uuid() WHERE role_member_id IS NULL;
ALTER TABLE role_members ALTER COLUMN role_member_id SET NOT NULL;
ALTER TABLE role_members ADD PRIMARY KEY (role_member_id);

ALTER TABLE role_members ADD COLUMN version BIGINT NOT NULL DEFAULT 0;
ALTER TABLE role_members ADD COLUMN insert_user VARCHAR(50);
ALTER TABLE role_members ADD COLUMN insert_dttm TIMESTAMP WITH TIME ZONE;
UPDATE role_members SET insert_dttm = CURRENT_TIMESTAMP WHERE insert_dttm IS NULL;
ALTER TABLE role_members ALTER COLUMN insert_dttm SET NOT NULL;

ALTER TABLE role_members ADD COLUMN version_user VARCHAR(50);
ALTER TABLE role_members ADD COLUMN version_dttm TIMESTAMP WITH TIME ZONE;
UPDATE role_members SET version_dttm = CURRENT_TIMESTAMP WHERE version_dttm IS NULL;
ALTER TABLE role_members ALTER COLUMN version_dttm SET NOT NULL;

ALTER TABLE role_members ADD COLUMN deleted_user VARCHAR(50);
ALTER TABLE role_members ADD COLUMN deleted_dttm TIMESTAMP WITH TIME ZONE;


-- 2. Transform 'space_users' to 'UserSpace' entity table
ALTER TABLE space_users DROP CONSTRAINT IF EXISTS space_users_pk;
ALTER TABLE space_users ADD COLUMN space_user_id VARCHAR(36);
UPDATE space_users SET space_user_id = gen_random_uuid() WHERE space_user_id IS NULL;
ALTER TABLE space_users ALTER COLUMN space_user_id SET NOT NULL;
ALTER TABLE space_users ADD PRIMARY KEY (space_user_id);

ALTER TABLE space_users ADD COLUMN version BIGINT NOT NULL DEFAULT 0;
ALTER TABLE space_users ADD COLUMN insert_user VARCHAR(50);
ALTER TABLE space_users ADD COLUMN insert_dttm TIMESTAMP WITH TIME ZONE;
UPDATE space_users SET insert_dttm = CURRENT_TIMESTAMP WHERE insert_dttm IS NULL;
ALTER TABLE space_users ALTER COLUMN insert_dttm SET NOT NULL;

ALTER TABLE space_users ADD COLUMN version_user VARCHAR(50);
ALTER TABLE space_users ADD COLUMN version_dttm TIMESTAMP WITH TIME ZONE;
UPDATE space_users SET version_dttm = CURRENT_TIMESTAMP WHERE version_dttm IS NULL;
ALTER TABLE space_users ALTER COLUMN version_dttm SET NOT NULL;

ALTER TABLE space_users ADD COLUMN deleted_user VARCHAR(50);
ALTER TABLE space_users ADD COLUMN deleted_dttm TIMESTAMP WITH TIME ZONE;


-- 3. Transform 'role_permissions' to 'RolePermission' entity table
ALTER TABLE role_permissions DROP CONSTRAINT IF EXISTS role_permissions_pk;
ALTER TABLE role_permissions ADD COLUMN role_permission_id VARCHAR(36);
UPDATE role_permissions SET role_permission_id = gen_random_uuid() WHERE role_permission_id IS NULL;
ALTER TABLE role_permissions ALTER COLUMN role_permission_id SET NOT NULL;
ALTER TABLE role_permissions ADD PRIMARY KEY (role_permission_id);

ALTER TABLE role_permissions ADD COLUMN version BIGINT NOT NULL DEFAULT 0;
ALTER TABLE role_permissions ADD COLUMN insert_user VARCHAR(50);
ALTER TABLE role_permissions ADD COLUMN insert_dttm TIMESTAMP WITH TIME ZONE;
UPDATE role_permissions SET insert_dttm = CURRENT_TIMESTAMP WHERE insert_dttm IS NULL;
ALTER TABLE role_permissions ALTER COLUMN insert_dttm SET NOT NULL;

ALTER TABLE role_permissions ADD COLUMN version_user VARCHAR(50);
ALTER TABLE role_permissions ADD COLUMN version_dttm TIMESTAMP WITH TIME ZONE;
UPDATE role_permissions SET version_dttm = CURRENT_TIMESTAMP WHERE version_dttm IS NULL;
ALTER TABLE role_permissions ALTER COLUMN version_dttm SET NOT NULL;

ALTER TABLE role_permissions ADD COLUMN deleted_user VARCHAR(50);
ALTER TABLE role_permissions ADD COLUMN deleted_dttm TIMESTAMP WITH TIME ZONE;


-- 4. Transform 'role_menus' to 'RoleMenu' entity table
ALTER TABLE role_menus DROP CONSTRAINT IF EXISTS role_menus_pk;
ALTER TABLE role_menus ADD COLUMN role_menu_id VARCHAR(36);
UPDATE role_menus SET role_menu_id = gen_random_uuid() WHERE role_menu_id IS NULL;
ALTER TABLE role_menus ALTER COLUMN role_menu_id SET NOT NULL;
ALTER TABLE role_menus ADD PRIMARY KEY (role_menu_id);

ALTER TABLE role_menus ADD COLUMN version BIGINT NOT NULL DEFAULT 0;
ALTER TABLE role_menus ADD COLUMN insert_user VARCHAR(50);
ALTER TABLE role_menus ADD COLUMN insert_dttm TIMESTAMP WITH TIME ZONE;
UPDATE role_menus SET insert_dttm = CURRENT_TIMESTAMP WHERE insert_dttm IS NULL;
ALTER TABLE role_menus ALTER COLUMN insert_dttm SET NOT NULL;

ALTER TABLE role_menus ADD COLUMN version_user VARCHAR(50);
ALTER TABLE role_menus ADD COLUMN version_dttm TIMESTAMP WITH TIME ZONE;
UPDATE role_menus SET version_dttm = CURRENT_TIMESTAMP WHERE version_dttm IS NULL;
ALTER TABLE role_menus ALTER COLUMN version_dttm SET NOT NULL;

ALTER TABLE role_menus ADD COLUMN deleted_user VARCHAR(50);
ALTER TABLE role_menus ADD COLUMN deleted_dttm TIMESTAMP WITH TIME ZONE;

