alter table inscada.users
    add column otp_type varchar(50);

create table otp_settings
(
    otp_settings_id       serial                   not null
        constraint otp_settings_otp_settings_id_pk
            primary key,
    type                  varchar(50)              not null,
    provider              varchar(50)              not null,
    default_flag          boolean,
    sms_dp_username       varchar(255),
    sms_dp_password       varchar(255),
    sms_dp_short_number   varchar(255),
    sms_dp_account_number varchar(255),
    sms_dp_originator     varchar(255),
    sms_dp_operator       varchar(255),
    sms_tw_account_sid    varchar(255),
    sms_tw_auth_token     varchar(255),
    sms_tw_twilio_number  varchar(255),
    mail_df_smtp_host     varchar(50),
    mail_df_smtp_port     integer,
    mail_df_protocol      varchar(10),
    mail_df_username      varchar(50),
    mail_df_password      varchar(60),
    insert_user           varchar(50)              not null,
    insert_dttm           timestamp with time zone not null,
    version_user          varchar(50),
    version_dttm          timestamp with time zone
);

create unique index otp_settings_type_provider_uindex on otp_settings (type, provider);

insert into inscada.otp_settings(type, provider, default_flag, insert_user, insert_dttm)
values ('sms', 'twilio', false, 'inscada', now());

insert into inscada.otp_settings(type, provider, default_flag, insert_user, insert_dttm, sms_dp_password)
values ('sms', 'dataport', true, 'inscada', now(), '');

insert into inscada.otp_settings(type, provider, default_flag, insert_user, insert_dttm, mail_df_password)
values ('mail', 'default', true, 'inscada', now(), '');

insert into inscada.permissions(permission_id, name)
values  (203, 'VIEW_OTP_SETTINGS'), (204, 'UPDATE_OTP_SETTINGS');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 203), (1, 204);

insert into inscada.menus (menu_id, name)
values (74, 'OTP Settings');

insert into inscada.role_menus (role_id, menu_id)
values (1, 74);