INSERT INTO inscada.role_permissions (role_id, permission_id)
SELECT
    r.role_id,
    p.permission_id
FROM
    inscada.roles r
        JOIN
    inscada.permissions p ON r.space_id = p.space_id
WHERE
    r.name = 'administrator'
  -- 1. ENFORCE NON-NULL SPACE_ID FOR THE ROLE:
  AND r.space_id IS NOT NULL
  -- 2. LIST OF REQUIRED PERMISSIONS:
  AND p.name IN (
                 'VIEW_FILE', 'CREATE_FILE', 'UPDATE_FILE',
                 'DELETE_FILE', 'EXPORT_FILE', 'IMPORT_FILE'
    )
-- Prevents errors if the assignments already exist.
    ON CONFLICT (role_id, permission_id) DO NOTHING;


INSERT INTO inscada.role_menus (role_id, menu_id)
SELECT
    r.role_id,
    m.menu_id
FROM
    inscada.roles r
-- Join roles and menus, enforcing the SAME space_id (context)
        JOIN
    inscada.menus m ON r.space_id = m.space_id
WHERE
    r.name = 'administrator'
  -- Ensure the role is tied to a specific space (as requested previously)
  AND r.space_id IS NOT NULL
  -- Filter for the specific menus
  AND m.name IN ('Search', 'Space Users', 'Space Roles')
-- Use ON CONFLICT to avoid errors if the administrator already has access to these menus
    ON CONFLICT (role_id, menu_id) DO NOTHING;