
-- Step 1: Add the new generic OAuth columns.
ALTER TABLE inscada."users" ADD COLUMN oauth_provider_id VARCHAR(255);
ALTER TABLE inscada."users" ADD COLUMN oauth_provider VARCHAR(255);

-- Step 2: Create a composite, partial, unique index for fast lookups and data integrity.
-- This ensures that the combination of provider and provider_id is unique for active (not soft-deleted) users.
CREATE UNIQUE INDEX IF NOT EXISTS uk_user_oauth_provider_id ON inscada."users" (oauth_provider, oauth_provider_id) WHERE deleted_dttm IS NULL;