-- Remove EXPORT_META_DATA and IMPORT_META_DATA permissions
-- Step 1: delete role-permission mappings referencing these permissions (avoids FK violations)
DELETE FROM inscada.role_permissions rp
USING inscada.permissions p
WHERE rp.permission_id = p.permission_id
  AND p.name IN ('EXPORT_META_DATA', 'IMPORT_META_DATA');

-- Step 2: delete the permissions themselves (both global and per-space rows)
DELETE FROM inscada.permissions
WHERE name IN ('EXPORT_META_DATA', 'IMPORT_META_DATA');

-- Step 3: add CLONE_PROJECT and VIEW_IP_FILTER_SETTINGS permissions
INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('275', 'CLONE_PROJECT', FALSE, NULL, 'system', NOW());

INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm) VALUES
    ('276', 'VIEW_IP_FILTER_SETTINGS', TRUE, NULL, 'system', NOW());

INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm)
SELECT
    uuid(md5('CLONE_PROJECT' || '::' || space_id::text))::text as permission_id,
    'CLONE_PROJECT' as name,
    FALSE as is_global,
    s.space_id,
    'system' as insert_user,
    NOW() as insert_dttm
FROM space s
WHERE s.space_id IS NOT NULL;

INSERT INTO permissions (permission_id, name, is_global, space_id, insert_user, insert_dttm)
SELECT
    uuid(md5('VIEW_IP_FILTER_SETTINGS' || '::' || space_id::text))::text as permission_id,
    'VIEW_IP_FILTER_SETTINGS' as name,
    TRUE as is_global,
    s.space_id,
    'system' as insert_user,
    NOW() as insert_dttm
FROM space s
WHERE s.space_id IS NOT NULL;

-- Step 4: assign the new permissions and GLOBAL_SEARCH permission to the 'administrator' role in each space
INSERT INTO inscada.role_permissions (role_permission_id, role_id, permission_id, insert_dttm, insert_user)
SELECT
    uuid(md5(r.role_id || '::' || p.permission_id))::text as role_permission_id,
    r.role_id,
    p.permission_id,
    CURRENT_TIMESTAMP,
    'system'
FROM
    inscada.roles r
        JOIN
    inscada.permissions p ON r.space_id = p.space_id
WHERE
    r.name = 'administrator'
  -- 1. ENFORCE NON-NULL SPACE_ID FOR THE ROLE:
  AND r.space_id IS NOT NULL
  -- 2. LIST OF REQUIRED PERMISSIONS:
  AND p.name IN (
                 'VIEW_IP_FILTER_SETTINGS', 'CLONE_PROJECT', 'GLOBAL_SEARCH'
    )
  -- 3. EXCLUDE PERMISSIONS THAT ALREADY EXIST FOR THE ROLE:
  AND NOT EXISTS (
        SELECT 1
        FROM inscada.role_permissions rp
        WHERE rp.role_id = r.role_id AND rp.permission_id = p.permission_id
    );