ALTER TABLE users ADD COLUMN default_space_id integer;
ALTER TABLE users ADD CONSTRAINT users_space_default_space_id_fk FOREIGN KEY (default_space_id) REFERENCES space(space_id);

-- Set default_space_id for users who have exactly one space
UPDATE users u
SET default_space_id = (
    SELECT su.space_id
    FROM space_users su
    WHERE su.user_id = u.user_id
)
WHERE (
    SELECT COUNT(*)
    FROM space_users su2
    WHERE su2.user_id = u.user_id
) = 1;