CREATE OR REPLACE FUNCTION insert_initial_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
	insert into inscada.mail_settings(smtp_host,smtp_port, protocol, username, password, insert_user, insert_dttm, space_id)
	select 'mail.inscada.com', 25, 'SMTP', 'inscada', '', 'inscada', now(), NEW.space_id;

	insert into inscada.sms_settings(provider, config, default_flag, insert_user, insert_dttm, space_id)
	select 'dataport', '{}', true, 'inscada', now(), NEW.space_id;

	insert into inscada.sms_settings(provider, config, default_flag, insert_user, insert_dttm, space_id)
	select 'twilio', '{}', false, 'inscada', now(), NEW.space_id;

	insert into inscada.broadcast_settings(server_ip_addr, insert_user, insert_dttm, space_id)
	select 'https://www.inscada.com', 'inscada', now(), NEW.space_id;

	insert into inscada.map_settings(map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
	select 'pk.eyJ1IjoieXJ5c2t1bCIsImEiOiJjazc0ZDc0NmswMnlvM2ptdnRqaW4ya3IxIn0.9YN8pWOfuz19ILnJy311ww',
	       'd1a6442a2d89164ee9cc3d3a9c9c7ed3', 'inscada', now(), NEW.space_id;

	insert into inscada.custom_table_settings(url, username, password, insert_user, insert_dttm, space_id)
    select 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(), NEW.space_id;

	INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
	('fr', 'inSCADA Login', 'Connexion inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Username', 'Nom d utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Password', 'Mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Login', 'Connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Language', 'Langue', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Projects', 'Projets', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'User Menu', 'Menu utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Project Map', 'Carte du projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Devices', 'Dispositifs', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animations', 'Animations', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarms', 'Alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Trends', 'Les tendances', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Trend Tags', 'Tags de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Trend Tag', 'Balise de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Scripts', 'Scripts', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Reports', 'Rapports', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Emails', 'E-mails', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Logs', 'Journaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Auth Log', 'Journal d authentification', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Users', 'Utilisateurs', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Help', 'Aider', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'About', 'À propos de', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Home', 'Maison', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Connection', 'Connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Trend Graphic', 'Graphique de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Trend Graphics', 'Graphiques de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Connections', 'Connexions', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Group', 'Groupe de rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Aggregate', 'Agrégat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Device Templates', 'Modèles d appareils', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Frame Templates', 'Modèles de cadre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable Templates', 'Modèles de variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Search', 'Chercher', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure you want to schedule/unschedule the selected script?', 'Êtes-vous sûr de vouloir planifier / annuler la planification du script sélectionné?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Add New', 'Ajouter nouveau', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Save', 'Sauvegarder', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Delete', 'Effacer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Yes', 'Oui', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'No', 'Non', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Status', 'Statut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Properties', 'Propriétés', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure to continue?', 'Êtes-vous sûr de continuer?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Form data is invalid', 'Les données du formulaire ne sont pas valides', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Visualization', 'Visualisation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Development', 'Développement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Gas Metering', 'Comptage de gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Gas Control', 'Contrôle du gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Control panel', 'Panneau de commande', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group', 'Grouper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Module', 'Module', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Station Adress', 'Adresse de la station', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Protocol', 'Protocole', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On DateTime', 'Le DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Acknowledge DateTime', 'Acquitter DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Settings', 'Réglages', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'General', 'Général', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Start adress', 'Adresse de départ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Scan Time', 'Temps de balayage', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Device Library', 'Bibliothèque de périphériques', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Expressions', 'Expressions', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variables', 'Variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Wizard', 'Magicien', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable History', 'Historique des variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Timeout', 'Temps libre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Frames', 'Cadres', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Writeable?', 'Est-il inscriptible?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Readable?', 'Est-ce lisible?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Buffer size', 'Taille du tampon', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print Time', 'Temps d impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print Day', 'Jour d impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print Hour', 'Heure d impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Day', 'Jour du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Time', 'Heure du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Hour', 'Heure du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print?', 'Impression?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Add Descriptions', 'Ajouter des descriptions', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Jobs', 'Emplois', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Last Execution Start Time', 'Heure de début de la dernière exécution', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Last Execution Ended Time', 'Heure de fin de la dernière exécution', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Next Execution Time', 'Prochaine heure d exécution', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Executions Count', 'Nombre d exécutions', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Project', 'Projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Name', 'Nom', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Description', 'Description', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Start Date', 'Date de début', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'End Date', 'Date de fin', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Active?', 'C est actif?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Location', 'Lieu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Address', 'Adresse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Latitude', 'Latitude', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Longitude', 'Longitude', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Contract', 'Contracter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Contract Day', 'Jour du contrat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Contract Hour', 'Heure du contrat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new project added', 'Un nouveau projet ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Project updated successfully', 'Projet mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Project removed', 'Projet supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Value', 'Évaluer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure you want to continue?', 'Es-tu sur de vouloir continuer?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'HPP Unit', 'Unité HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Reload', 'Recharger', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Acknowledge', 'Accuser réception', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Quantity', 'Quantité', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Type', 'Type de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Unit', 'Unité', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Expression Type', 'Type d expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Retain Flag', 'Conserver le drapeau', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Word Swap', 'Échange de mots', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Byte Swap', 'Echange d octets', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Load', 'Charge', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Date Range', 'Plage de dates', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable Picker', 'Sélecteur de variables', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Last Value', 'Dernière valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'First Value', 'Première valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Min Value', 'Valeur min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Value', 'Valeur max', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Sum Value', 'Valeur somme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Count Value', 'Valeur de comptage', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Acknowledge DateTime Filter', 'Acquitter le filtre DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Off DateTime Filter', 'Désactiver le filtre DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On DateTime Filter', 'Sur le filtre DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Search Form', 'Formulaire de recherche', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Interval (Second)', 'Intervalle (seconde)', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On', 'Sur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Off', 'Désactivé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Live', 'Habitent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Preview', 'Aperçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Cancel', 'Annuler', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Schedule', 'Horaire', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Severity', 'Gravité du journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Activity', 'Activité', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Source', 'La source', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Message', 'Un message', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Remove', 'Supprimer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'User Roles', 'Rôles des utilisateurs', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Role', 'Rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Expression', 'Expression', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Delay', 'Retard', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Category', 'Catégorie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On Script', 'Sur script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Off Script', 'Hors script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new alarm added', 'Une nouvelle alarme ajoutée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm updated successfully', 'Alarme mise à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm settings is updated', 'Les paramètres d alarme sont mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm removed', 'Alarme supprimée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm History', 'Historique des alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Type', 'Taper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Import', 'Importer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Date', 'Date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure you want to activate/deactivate the selected alarm?', 'Êtes-vous sûr de vouloir activer / désactiver l alarme sélectionnée?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure you want to Start/Stop the selected connection?', 'Êtes-vous sûr de vouloir démarrer / arrêter la connexion sélectionnée?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Code', 'Code', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Priority', 'Priorité', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Period', 'Point final', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log', 'Enregistrer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new script added', 'Un nouveau script ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Script updated successfully', 'Script mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Script removed', 'Script supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Deviation Variable', 'Variable d écart', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Total Variable', 'Variable totale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Calculation Type', 'Type de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Order', 'Commander', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Variables', 'Variables du rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Subgroup Order', 'Ordre des sous-groupes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Subgroups', 'Signaler les sous-groupes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group Order', 'Ordre de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation Elements', 'Éléments d animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Parent Animation', 'Animation parentale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Color', 'Couleur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Duration', 'Durée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Play at Main?', 'Jouer à Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SVG Content', 'Contenu SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation Type', 'Type d animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new animation added', 'Une nouvelle animation ajoutée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Only SVG files are allowed', 'Seuls les fichiers SVG sont autorisés', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation updated successfully', 'Animation mise à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation removed', 'Animation supprimée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new animation element added', 'Un nouvel élément d animation ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation element updated successfully', 'Élément d animation mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation element removed', 'Élément d animation supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Min. Scale', 'Échelle min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max. Scale', 'Échelle max.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Thickness', 'Épaisseur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Backup', 'Sauvegarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Restore', 'Restaurer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Save & Continue', 'Enregistrer continuer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable', 'Variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Default', 'Défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Add', 'Ajouter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Default value', 'Valeur par défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Text', 'Texte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Title', 'Titre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Size', 'Taille', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Disable', 'Désactiver', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Home View', 'Vue de la maison', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Time', 'Temps', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Second', 'Deuxième', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Last Executed At', 'Dernière exécution à', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please select a master record first', 'Veuillez d abord sélectionner un enregistrement principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Send SMS', 'Envoyer un SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SMS Details', 'Détails SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SMS Service', 'Service SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SMS sended successfully', 'SMS envoyé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SMS Search', 'Recherche SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Content', 'Teneur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SMS Settings', 'Paramètres SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Mail sended successfully', 'Courrier envoyé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'No selected animation', 'Aucune animation sélectionnée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Recipient', 'Destinataire', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Online Help', 'Aide en ligne', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm', 'Alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm Monitor', 'Moniteur d alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Smart Symbol', 'Symbole intelligent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Smart Symbols', 'Symboles intelligents', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable Monitor', 'Moniteur variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm Group', 'Groupe d alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm Groups', 'Groupes d alarmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On No Ack Color', 'Sur aucune couleur d acquittement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On Ack Color', 'Sur Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print When On?', 'Imprimer quand activé?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print When Off?', 'Imprimer quand désactivé?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print When Ack?', 'Imprimer quand Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation', 'Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Inverse', 'Inverse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Set Type', 'Définir le type', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Notify', 'Notifier', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Default Color', 'Couleur par défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Gradient', 'Pente', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group Size', 'Taille de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Decimal', 'Décimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group Seperator', 'Séparateur de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Decimal Seperator', 'Séparateur décimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Leftpad Size', 'Taille du pavé gauche', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Rightpad Size', 'Taille du pavé droit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Character', 'Personnage', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Prefix', 'Préfixe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Suffix', 'Suffixe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'tag', 'étiqueter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Initial Pos', 'Position initiale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Min Pos', 'Pos. Min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'On Drop', 'En dépôt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Join', 'Rejoindre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Template?', 'Est-ce que Template?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation Element', 'Élément d animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Mouse', 'Souris', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'More', 'Suite', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation WebSocket is on', 'L animation WebSocket est activée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation WebSocket is off', 'L animation WebSocket est désactivée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Animation WebSocket error observed', 'Erreur WebSocket d animation observée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Pool Size', 'Taille de la piscine', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Adapter', 'Adaptateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Min Retry Delay', 'Délai minimum de nouvelle tentative', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Retry Delay', 'Délai maximal de nouvelle tentative', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Local Ip', 'IP local', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Local Port', 'Port local', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Cot F. Length', 'Cot F. Longueur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Cot Field Length', 'Longueur du champ du lit bébé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'IOA Field Length', 'Longueur du champ IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Common A. Length', 'Longueur A. commune', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Common Address Field Length', 'Longueur du champ d adresse commune', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'IOA F. Length', 'Longueur IOA F.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Originator Address', 'Adresse de l expéditeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Message F. Timeout', 'Message F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Message Fragment Timeout', 'Délai d expiration du fragment de message', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max T.N.A. Recieved', 'Max T.N.A. Reçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Time No Ack Received', 'Temps maximum sans accusé de réception', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max T.N.A. Sent', 'Max T.N.A. Envoyé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Time No Ack Sent', 'Temps maximum sans accusé de réception envoyé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Idle Time', 'Temps d inactivité max', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max U. IP Recieved', 'Max U. IP reçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Unconfirmed IPdus Received', 'IPdus max non confirmé reçu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Start DT Timeout', 'Démarrer DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Start DT Retries', 'Démarrer les nouvelles tentatives DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Coming Soon...', 'Arrive bientôt...', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Rack', 'Étagère', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Slot', 'Fente', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'No Data Transfer Selected', 'Aucun transfert de données sélectionné', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Destination', 'Destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Detail Form', 'Formulaire de détail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Source Tag', 'Balise source', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Destination Tag', 'Balise de destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Data Transfer', 'Transfert de données', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Detail Transfer', 'Transfert de détails', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Device', 'Dispositif', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Device Picker', 'Sélecteur d appareils', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Import Tmpl', 'Importer Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Start Address', 'Adresse de départ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'General I. Time', 'Général I. Heure', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'General Interrogation Time', 'Heure d interrogation générale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'General Counter Interrogation Time', 'Heure d interrogation générale du compteur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Cnt Point Offset', 'Décalage du point Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Control Point Offset', 'Décalage du point de contrôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'DB Number', 'Numéro DB', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'IEC104 type', 'Type CEI104', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Sender', 'Expéditeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Recepient', 'Recepient', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Subject', 'Sujet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Email View', 'Vue e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'From', 'De', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'To', 'À', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Email Search', 'Recherche par e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Email Service', 'Service de messagerie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Body', 'Corps', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Send Email', 'Envoyer un e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Send', 'Envoyer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'User List', 'Liste d utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Mail send failed', 'L envoi du courrier a échoué', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Email Settings', 'Paramètres de messagerie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Backup/Restore', 'Restauration de sauvegarde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Choose', 'Choisir', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Processes', 'Processus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Data Transfers', 'Transferts de données', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Keywords', 'Mots clés', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Roles', 'Rôles', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Templates', 'Modèles', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Key', 'Clé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Active', 'Actif', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Successful ?', 'Est réussi ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Auth Logs', 'Journaux d authentification', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'License', 'Licence', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Machine Id', 'ID de la machine', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Surname', 'Nom de famille', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'User Limit', 'Limite d utilisateurs', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Update', 'Mettre à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'License Key', 'Clé de licence', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'License to', 'Licence pour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'License successfully activated', 'Licence activée avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Failed to activate', 'Échec de l activation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm Name', 'Nom de l alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Alarm Dsc', 'Alarme Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Start All', 'Tout démarrer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Stop All', 'Arrête tout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Êtes-vous sûr de vouloir planifier / annuler la planification du transfert de données sélectionné?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Process', 'Traiter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'GRAPHICAL VIEW', 'VUE GRAPHIQUE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'FLOW RATE', 'DÉBIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'METERING', 'MESURE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'ENERGY & OTHER VALUES', 'ÉNERGIE ET ​​AUTRES VALEURS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'IN-USE GAS COMPONENTS', 'COMPOSANTS DE GAZ EN USAGE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'TOTALISORS', 'TOTALISATEURS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'PREVIOUS HOURLY & DAILY VALUES', 'VALEURS HORAIRES ET QUOTIDIENNES PRÉCÉDENTES', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'ALARMS ON', 'ALARMES ACTIVÉES', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'NAME', 'NOM', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'CURRENT', 'ACTUEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'KEY-PAD', 'CLAVIER', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'IN-USE', 'UTILISÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'DOWNLOADED', 'TÉLÉCHARGÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'NORMALIZED', 'NORMALISÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'UNIT', 'UNITÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'PROPERTIES', 'PROPRIÉTÉS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'GC MANAGEMENT', 'GESTION GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SET', 'ENSEMBLE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'STATUS', 'STATUT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'QRCODE Reader', 'Lecteur QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Scanned!', 'Scanné!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'deviceName', 'nom de l appareil', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Failed to load data', 'Échec du chargement des données', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'ANIMATION', 'ANIMATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'GAS METERING', 'MESURE DE GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'GAS PROPERTIES', 'PROPRIÉTÉS DU GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'NETWORK', 'RÉSEAU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Fired Alarm Duration In Days', 'Durée de l alarme déclenchée en jours', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Fired Alarm duration is updated', 'La durée de l alarme déclenchée est mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Acknowledger', 'Accusé de réception', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Duration In Days', 'Durée du journal en jours', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log duration is updated', 'La durée du journal est mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Remove All', 'Enlever tout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Firstly load the datatable', 'Commencez par charger le datatable', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Failed to load log data', 'Échec du chargement des données du journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure to remove all logs?', 'Êtes-vous sûr de supprimer tous les journaux?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'All logs removed', 'Tous les journaux supprimés', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'An error occured while removing logs', 'Une erreur s est produite lors de la suppression des journaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Message', 'Message de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Show Weather On Click', 'Afficher la météo au clic', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Updated successfully', 'Mis à jour avec succés', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Removed successfully', 'Supprimé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Map', 'Carte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Weather api', 'API Météo', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Interval', 'Intervalle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Filter', 'Filtre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'SCHEDULED', 'PROGRAMMÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'ON', 'SUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'OFF', 'DÉSACTIVÉ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Print', 'Impression', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Failed to load!', 'Échec du chargement!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Choose Trend', 'Choisissez la tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Avg Value', 'Valeur moyenne', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Integral Value', 'Valeur intégrale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Calculation type', 'Type de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Auto Scroll', 'Défilement automatique', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Failed to load trend data', 'Échec du chargement des données de tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Select the Trend first', 'Sélectionnez d abord la tendance', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Interval cannot be empty', 'L intervalle ne peut pas être vide', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable Duration In Days', 'Durée variable en jours', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable duration is updated', 'La durée variable est mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Frame', 'Cadre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Usual', 'Habituel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Hourly', 'Toutes les heures', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Daily', 'Quotidien', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'CUSTOM', 'DOUANE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'COLLECTION', 'COLLECTION', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Process Form', 'Formulaire de traitement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Background', 'Fond', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Text Color', 'Couleur du texte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Main Flag', 'Drapeau principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Grid Flag', 'Indicateur de grille', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Inputs', 'Contributions', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Choose Default Image', 'Choisir l image par défaut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'States', 'États', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'State Lists', 'Listes d État', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'New State', 'Nouvel État', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'State name', 'Nom d état', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Attach', 'Attacher', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Library', 'Bibliothèque', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Node updated', 'Nœud mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Property', 'Biens', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Project Property', 'Propriété du projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Project Values', 'Valeurs du projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Stream', 'Flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report', 'Signaler', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please choose a period', 'Veuillez choisir une période', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Name field cannot be empty!', 'Le champ de nom ne peut pas être vide!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please choose a report', 'Veuillez choisir un rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group order cannot be empty!', 'L ordre de groupe ne peut pas être vide!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report group removed', 'Groupe de rapports supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new Report group added', 'Un nouveau groupe de rapports a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report group updated successfully', 'Groupe de rapports mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report updated successfully', 'Rapport mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new report added', 'Un nouveau rapport a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report removed', 'Rapport supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please select group', 'Veuillez sélectionner un groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report subgroup removed', 'Sous-groupe du rapport supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new Report subgroup added', 'Un nouveau sous-groupe de rapport a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report subgroup updated successfully', 'Sous-groupe du rapport mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report Variable', 'Variable de rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Subgroup', 'Sous-groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please choose a subgroup', 'Veuillez choisir un sous-groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable Order', 'Ordre variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Variable order cannot be empty', 'L ordre des variables ne peut pas être vide', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please choose calculation type', 'Veuillez choisir le type de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please choose variable', 'Veuillez choisir la variable', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Deviation', 'Déviation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please select subgroup', 'Veuillez sélectionner un sous-groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report variable removed', 'Variable de rapport supprimée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new Report variable added', 'Une nouvelle variable de rapport a été ajoutée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Report variable updated successfully', 'La variable du rapport a bien été mise à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Script Output', 'Sortie de script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Output message', 'Message de sortie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Empty output', 'Sortie vide', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Error in code syntax', 'Erreur dans la syntaxe du code', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group Chat', 'Discussion de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Type message here', 'Tapez le message ici', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Type message', 'Tapez le message', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Refresh Periods', 'Périodes de rafraîchissement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Control Panel', 'Panneau de commande', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Gas Properties', 'Propriétés du gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Network', 'Réseau', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Graph Details', 'Détails du graphique', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Check All', 'Vérifie tout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Menus', 'Menus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Permission', 'Autorisation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Permissions', 'Autorisations', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Rolename', 'Nom de rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Role Menus', 'Menus de rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Menus are added', 'Les menus sont ajoutés', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Please select role', 'Veuillez sélectionner le rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', ' is removed', ' est retiré', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Role Permissions', 'Permissions de rôle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Permissions are added', 'Les autorisations sont ajoutées', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new role added', 'Un nouveau rôle ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Role updated successfully', 'Rôle mis à jour avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Role is removed', 'Le rôle est supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Reset Password', 'Réinitialiser le mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Password Info', 'Informations sur le mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'New Password', 'Nouveau mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Repeat New Password', 'Répété le nouveau mot de passe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Passwords are not the same', 'Les mots de passe ne sont pas les mêmes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Email Address', 'Adresse e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'User', 'Utilisateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Password changed successfully', 'Le mot de passe a été changé avec succès', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Password change failed', 'La modification du mot de passe a échoué', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Enter new value', 'Entrez une nouvelle valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Set Value', 'Définir la valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Increment Value', 'Valeur incrémentale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Send Flags', 'Envoyer des drapeaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'False/True', 'Faux vrai', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Decrement Value', 'Décrémenter la valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Byte Swap?', 'Est-ce que Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Is Word Swap?', 'Est-ce que Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Point Class', 'Classe de points', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Static Variation', 'Variation statique', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Event Variation', 'Variation d événement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Data Type', 'Type de données', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Bit Offset', 'Décalage de bits', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Decimal Point', 'Virgule', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Flags', 'Drapeaux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Protocol Properties', 'Propriétés du protocole', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Raw zero scale', 'Échelle zéro brute', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Raw full scale', 'Pleine échelle brute', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Eng zero scale', 'Échelle zéro Eng', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Period', 'Période du journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Threshold', 'Seuil de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Value Expression', 'Expression de valeur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Log Expression', 'Expression de journal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Protocol Type', 'Type de protocole', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Protocols', 'Protocoles', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new item added', 'Un nouvel élément ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'A new item detail added', 'Un nouveau détail d article a été ajouté', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Item detail updated', 'Détails de l article mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Item updated', 'Article mis à jour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Item removed', 'Élément supprimé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Minutes Offset', 'Décalage des minutes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Local Address', 'Adresse locale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Remote Address', 'Adresse distante', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Unsoliceted Events', 'Événements non sollicités', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Select Timeout', 'Sélectionner le délai', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Confirm Timeout', 'Confirmer le délai', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Retry Timeout', 'Retry Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Response Timeout', 'Délai de réponse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Event Scantime', 'Scantime d événement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Disable Unsolicated', 'Désactiver les non-isolées', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Startup Integrity', 'Intégrité de démarrage', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Integrity Overflow', 'Débordement d intégrité', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Common Address', 'Adresse commune', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Dnp3 type', 'Type DNP3', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Event Buffer Size', 'Taille du tampon d événement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Modbus type', 'Type Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Readable', 'Lisible', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Writeable', 'Inscriptible', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Iec104 type', 'Type Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Back', 'Retour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Next', 'Suivant', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'COMMUNICATION NETWORK', 'RÉSEAU DE COMMUNICATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Finish', 'Finir', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Check connection details', 'Vérifier les détails de connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Connection Details', 'Détails de connexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'GAS STATION MODEL', 'MODÈLE DE STATION À GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Device List', 'Liste des périphériques', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Device Form', 'Formulaire de l appareil', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Item', 'Article', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Station Address', 'Adresse de la station', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'PAY', 'PAYER', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'CHECK', 'CHÈQUE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Stream Details', 'Détails du flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'USE GC', 'UTILISER GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Saved!', 'Enregistré!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'DEFINED GAS STATION MODEL', 'MODÈLE DE STATION À GAZ DÉFINI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Capacity', 'Capacité', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Group Name', 'Nom de groupe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'STREAMS', 'RUISSEAUX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Stream Modules List', 'Liste des modules de flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Analyzer', 'Analyseur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Main Station', 'Gare principale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Sub Station', 'Sous-station', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'REPORT', 'RAPPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Generate', 'Produire', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Failed to generate project', 'Impossible de générer le projet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Station Details', 'Détails de la station', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'WebSocket is on', 'WebSocket est activé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'WebSocket is off', 'WebSocket est désactivé', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'WebSocket error observed', 'Erreur WebSocket observée', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Clear browser storage', 'Effacer le stockage du navigateur', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'System statistics', 'Statistiques système', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Chatting', 'Bavardage', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Notifications', 'Notifications', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Sign-out', 'Déconnexion', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Hide top', 'Cacher le haut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Are you sure you want to clear storage?', 'Êtes-vous sûr de vouloir effacer le stockage?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Press SHIFT+Q to return', 'Appuyez sur SHIFT + Q pour revenir', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Press SHIFT+W to return', 'Appuyez sur SHIFT + W pour revenir', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'You are about to logged out. Are you sure you want to proceed?', 'Vous êtes sur le point de vous déconnecter. Voulez-vous vraiment continuer?', NEW.space_id, 'system_update', now(), 'system_update', now());

	INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
	('pl', 'inSCADA Login', 'Logowanie inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Username', 'Nazwa Użytkownika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Password', 'Hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Login', 'Zaloguj sie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Language', 'Język', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Projects', 'Projektowanie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'User Menu', 'Menu użytkownika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Project Map', 'Mapa projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Devices', 'Urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animations', 'Animacje', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarms', 'Alarmy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Trends', 'Trendy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Trend Tags', 'Tagi trendów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Trend Tag', 'Tag trendu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Scripts', 'Skrypty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Reports', 'Raporty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Emails', 'E-maile', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Logs', 'Dzienniki', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Auth Log', 'Dziennik autoryzacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Users', 'Użytkownicy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Help', 'Wsparcie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'About', 'O', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Home', 'Dom', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Connection', 'Połączenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Trend Graphic', 'Grafika trendu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Trend Graphics', 'Grafika trendów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Connections', 'Znajomości', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Group', 'Zgłoś grupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Aggregate', 'Agregat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Device Templates', 'Szablony urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Frame Templates', 'Szablony ramek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable Templates', 'Zmienne szablony', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Search', 'Szukaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure you want to schedule/unschedule the selected script?', 'Czy na pewno chcesz zaplanować / anulować harmonogram wybranego skryptu?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Add New', 'Dodaj nowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Save', 'Zapisać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Delete', 'Kasować', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Yes', 'Tak', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'No', 'Nie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Status', 'Status', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Properties', 'Nieruchomości', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure to continue?', 'Czy na pewno chcesz kontynuować?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Form data is invalid', 'Dane formularza są nieprawidłowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Visualization', 'Wyobrażanie sobie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Development', 'Rozwój', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Gas Metering', 'Pomiar gazu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Gas Control', 'Kontrola gazu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Control panel', 'Panel sterowania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group', 'Grupa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Module', 'Moduł', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Station Adress', 'Adres stacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Protocol', 'Protokół', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Acknowledge DateTime', 'Potwierdź datę i godzinę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Settings', 'Ustawienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'General', 'Generał', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Start adress', 'Adres początkowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Scan Time', 'Czas skanowania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Device Library', 'Biblioteka urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Expressions', 'Wyrażenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variables', 'Zmienne', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Wizard', 'Czarodziej', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable History', 'Historia zmiennej', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Timeout', 'Koniec czasu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Frames', 'Ramki', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Writeable?', 'Czy można zapisywać?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Readable?', 'Czy jest czytelny?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Buffer size', 'Rozmiar bufora', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print Time', 'Czas druku', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print Day', 'Drukuj dzień', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print Hour', 'Drukuj godzinę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Day', 'Dzień raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Time', 'Czas raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Hour', 'Godzina raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print?', 'Wydrukować?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Add Descriptions', 'Dodaj opisy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Jobs', 'Oferty pracy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Last Execution Start Time', 'Czas rozpoczęcia ostatniego wykonania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Last Execution Ended Time', 'Czas zakończenia ostatniego wykonania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Next Execution Time', 'Czas następnego wykonania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Executions Count', 'Liczba egzekucji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Project', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Name', 'Nazwa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Description', 'Opis', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Start Date', 'Data rozpoczęcia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'End Date', 'Data końcowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Active?', 'Jest aktywny?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Location', 'Lokalizacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Address', 'Adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Latitude', 'Szerokość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Longitude', 'Długość geograficzna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Contract', 'Kontrakt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Contract Day', 'Dzień kontraktu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Contract Hour', 'Godzina kontraktu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new project added', 'Dodano nowy projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Project updated successfully', 'Projekt został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Project removed', 'Projekt usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Value', 'Wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure you want to continue?', 'Jesteś pewien, że chcesz kontynuować?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'HPP Unit', 'Jednostka HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Reload', 'Przeładować', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Acknowledge', 'Uznać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Quantity', 'Ilość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Type', 'Typ dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Unit', 'Jednostka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Expression Type', 'Typ wyrażenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Retain Flag', 'Zachowaj flagę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Word Swap', 'Zamiana słów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Byte Swap', 'Zamiana bajtów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Load', 'Załaduj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Date Range', 'Zakres dat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable Picker', 'Wybór zmiennej', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Last Value', 'Ostatnia wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'First Value', 'Pierwsza wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Min Value', 'Wartość minimalna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Value', 'Maksymalna wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Sum Value', 'Wartość sumy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Count Value', 'Zlicz wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Acknowledge DateTime Filter', 'Potwierdź filtr daty i godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Off DateTime Filter', 'Wyłączony filtr daty i godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On DateTime Filter', 'Filtr daty i godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Search Form', 'Formularz wyszukiwania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Interval (Second)', 'Interwał (sekunda)', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On', 'Na', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Off', 'Poza', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Live', 'Relacja na żywo', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Preview', 'Zapowiedź', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Cancel', 'Anuluj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Schedule', 'Harmonogram', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Severity', 'Loguj wagę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Activity', 'Czynność', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Source', 'Źródło', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Message', 'Wiadomość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Remove', 'Usunąć', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'User Roles', 'Role użytkowników', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Role', 'Rola', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Expression', 'Wyrażenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Delay', 'Opóźnienie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Category', 'Kategoria', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On Script', 'On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Off Script', 'Poza skryptem', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new alarm added', 'Dodano nowy alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm updated successfully', 'Alarm został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm settings is updated', 'Zaktualizowano ustawienia alarmu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm removed', 'Alarm usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm History', 'Historia alarmów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Type', 'Rodzaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Import', 'Import', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Date', 'Data', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure you want to activate/deactivate the selected alarm?', 'Czy na pewno chcesz włączyć / wyłączyć wybrany alarm?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure you want to Start/Stop the selected connection?', 'Czy na pewno chcesz uruchomić / zatrzymać wybrane połączenie?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Code', 'Kod', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Priority', 'Priorytet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Period', 'Kropka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log', 'Log', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new script added', 'Dodano nowy skrypt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Script updated successfully', 'Skrypt został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Script removed', 'Usunięto skrypt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Deviation Variable', 'Zmienna odchylenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Total Variable', 'Całkowita zmienna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Calculation Type', 'Typ obliczenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Order', 'Zamówienie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Variables', 'Zmienne raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Subgroup Order', 'Zamówienie podgrupy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Subgroups', 'Podgrupy raportów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group Order', 'Zamówienie grupowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation Elements', 'Elementy animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Parent Animation', 'Animacja rodzica', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Color', 'Kolor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Duration', 'Trwanie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Play at Main?', 'Play at Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SVG Content', 'Zawartość SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation Type', 'Typ animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new animation added', 'Dodano nową animację', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Only SVG files are allowed', 'Dozwolone są tylko pliki SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation updated successfully', 'Animacja została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation removed', 'Animacja usunięta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new animation element added', 'Dodano nowy element animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation element updated successfully', 'Element animacji został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation element removed', 'Usunięto element animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Min. Scale', 'Min. Skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max. Scale', 'Maks. Skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Thickness', 'Grubość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Backup', 'Utworzyć kopię zapasową', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Restore', 'Przywracać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Save & Continue', 'Zapisz Kontynuuj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable', 'Zmienna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Default', 'Domyślna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Add', 'Dodaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Default value', 'Domyślna wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Text', 'Tekst', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Title', 'Tytuł', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Size', 'Rozmiar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Disable', 'Wyłączyć', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Home View', 'Widok główny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Time', 'Czas', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Second', 'Druga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Last Executed At', 'Ostatnio wykonane o', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please select a master record first', 'Najpierw wybierz rekord główny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Send SMS', 'Wyślij SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SMS Details', 'Szczegóły SMS-a', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SMS Service', 'Usługa SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SMS sended successfully', 'SMS wysłany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SMS Search', 'Wyszukiwanie SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Content', 'Zawartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SMS Settings', 'Ustawienia SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Mail sended successfully', 'Poczta została wysłana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'No selected animation', 'Brak wybranej animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Recipient', 'Odbiorca', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Online Help', 'Pomoc online', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Menu', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm', 'Alarm', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm Monitor', 'Monitor alarmu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Smart Symbol', 'Inteligentny symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Smart Symbols', 'Inteligentne symbole', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable Monitor', 'Zmienny monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm Group', 'Grupa alarmowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm Groups', 'Grupy alarmowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On Ack Color', 'Kolor potwierdzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print When On?', 'Drukuj kiedy wł.?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print When Off?', 'Drukuj kiedy wyłączone?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print When Ack?', 'Print When Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation', 'Animacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Inverse', 'Odwrotność', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Set Type', 'Składać czcionki do druku', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Notify', 'Notyfikować', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Default Color', 'Domyślny kolor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group Size', 'Wielkość grupy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Decimal', 'Dziesiętny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group Seperator', 'Separator grupowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Decimal Seperator', 'Separator dziesiętny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Leftpad Size', 'Rozmiar lewej płytki', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Rightpad Size', 'Rozmiar prawej płytki', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Character', 'Postać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Prefix', 'Prefiks', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Suffix', 'Przyrostek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'tag', 'etykietka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Initial Pos', 'Pozycja początkowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Min Pos', 'Min. Poz.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Pos', 'Maksymalna pozycja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Join', 'Przystąp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Template?', 'Czy szablon?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Dom Id', 'Dom ID', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation Element', 'Element animacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Mouse', 'Mysz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'More', 'Jeszcze', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation WebSocket is on', 'Animacja WebSocket jest włączona', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation WebSocket is off', 'Animacja WebSocket jest wyłączona', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Animation WebSocket error observed', 'Zaobserwowano błąd animacji WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Pool Size', 'Rozmiar basenu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Min Retry Delay', 'Min. Opóźnienie ponowienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Retry Delay', 'Maksymalne opóźnienie ponownych prób', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Local Ip', 'Lokalny IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Local Port', 'Port lokalny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Cot F. Length', 'Cot F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Cot Field Length', 'Cot Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'IOA Field Length', 'IOA Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Common A. Length', 'Common A. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Common Address Field Length', 'Common Address Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'IOA F. Length', 'IOA F. Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Originator Address', 'Adres nadawcy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Message F. Timeout', 'Message F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Message Fragment Timeout', 'Limit czasu fragmentu wiadomości', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max T.N.A. Recieved', 'Max T.N.A. Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Time No Ack Received', 'Max Time No Ack Received', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max T.N.A. Sent', 'Max T.N.A. Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Idle Time', 'Max Idle Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max U. IP Recieved', 'Max U. IP Recieved', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Unconfirmed IPdus Received', 'Max Unconfirmed IPdus Received', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Start DT Timeout', 'Start DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Start DT Retries', 'Start DT Retries', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Coming Soon...', 'Wkrótce...', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Rack', 'Stojak', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Slot', 'Otwór', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'No Data Transfer Selected', 'Nie wybrano przenoszenia danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Destination', 'Miejsce docelowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Detail Form', 'Formularz szczegółowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Source Tag', 'Tag źródłowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Destination Tag', 'Tag docelowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Data Transfer', 'Transfer danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Detail Transfer', 'Transfer szczegółów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Device', 'Urządzenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Device Picker', 'Wybór urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Import Tmpl', 'Importuj Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Start Address', 'Adres początkowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'General I. Time', 'General I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'General Interrogation Time', 'Ogólny czas przesłuchania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'General Counter Interrogation Time', 'General Counter Interrogation Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Cnt Point Offset', 'Odsunięcie punktu Cnt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Control Point Offset', 'Odsunięcie punktu kontrolnego', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'DB Number', 'Numer bazy danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'IEC104 type', 'Typ IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Sender', 'Nadawca', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Recepient', 'Odbiorca', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Subject', 'Przedmiot', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Email View', 'Widok e-maila', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'From', 'Od', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'To', 'Do', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Email Search', 'Wyszukiwanie e-mailowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Email Service', 'Usługa poczty e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Body', 'Ciało', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Send Email', 'Wysłać email', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Send', 'Wysłać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'User List', 'Lista użytkowników', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Mail send failed', 'Wysłanie poczty nie powiodło się', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Email Settings', 'Ustawienia poczty e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Backup/Restore', 'Przywracania kopii zapasowej', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Choose', 'Wybierać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Processes', 'Procesy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Data Transfers', 'Przesyłanie danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Keywords', 'Słowa kluczowe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Roles', 'Role', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Templates', 'Szablony', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Key', 'Klucz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Active', 'Aktywny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Successful ?', 'Zakończony powodzeniem ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Auth Logs', 'Dzienniki autoryzacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'License', 'Licencja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Machine Id', 'Identyfikator urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Surname', 'Nazwisko', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'User Limit', 'Limit użytkowników', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Update', 'Aktualizacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'License Key', 'Klucz licencyjny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'License to', 'Licencja na', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'License successfully activated', 'Licencja została aktywowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Failed to activate', 'Nie udało się aktywować', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm Name', 'Nazwa alarmu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Start All', 'Rozpocznij wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Stop All', 'Zatrzymać wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Czy na pewno chcesz zaplanować / anulować wybrany transfer danych?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Process', 'Proces', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'GRAPHICAL VIEW', 'WIDOK GRAFICZNY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'FLOW RATE', 'PRZEPŁYW', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'METERING', 'DOZOWANIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'ENERGY & OTHER VALUES', 'ENERGIA I INNE WARTOŚCI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'IN-USE GAS COMPONENTS', 'UŻYWANE SKŁADNIKI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'TOTALISORS', 'SUMAŁY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'PREVIOUS HOURLY & DAILY VALUES', 'POPRZEDNIE WARTOŚCI GODZINOWE I DZIENNE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'ALARMS ON', 'ALARMY WŁĄCZONE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'NAME', 'NAZWA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'CURRENT', 'OBECNY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'IN-USE', 'W UŻYCIU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'DOWNLOADED', 'POBRANE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'NORMALIZED', 'NORMALIZOWANY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'UNIT', 'JEDNOSTKA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'PROPERTIES', 'NIERUCHOMOŚCI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'GC MANAGEMENT', 'ZARZĄDZANIE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SET', 'ZESTAW', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'STATUS', 'STATUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'QRCODE Reader', 'Czytnik QRCODE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Scanned!', 'Zeskanowano!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'deviceName', 'Nazwa urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Failed to load data', 'Nie udało się załadować danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'ANIMATION', 'ANIMACJA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'GAS METERING', 'POMIAR GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'GAS PROPERTIES', 'WŁAŚCIWOŚCI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'NETWORK', 'SIEĆ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Fired Alarm Duration In Days', 'Czas trwania alarmu uruchomienia w dniach', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Fired Alarm duration is updated', 'Aktualizacja czasu trwania alarmu pożarowego', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Acknowledger', 'Potwierdzający', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Duration In Days', 'Czas trwania dziennika w dniach', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log duration is updated', 'Czas trwania dziennika jest aktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Remove All', 'Usuń wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Firstly load the datatable', 'Najpierw załaduj dane z możliwością przesyłania danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Failed to load log data', 'Nie udało się załadować danych dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure to remove all logs?', 'Czy na pewno chcesz usunąć wszystkie dzienniki?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'All logs removed', 'Wszystkie dzienniki zostały usunięte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'An error occured while removing logs', 'Wystąpił błąd podczas usuwania dzienników', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Message', 'Komunikat dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Show Weather On Click', 'Pokaż pogodę po kliknięciu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Updated successfully', 'Aktualizacja zakończona sukcesem', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Removed successfully', 'Usunięto pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Map', 'Mapa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Weather api', 'Interfejs API pogody', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Interval', 'Interwał', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Filter', 'Filtr', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'SCHEDULED', 'PLANOWY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'ON', 'NA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'OFF', 'POZA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Print', 'Wydrukować', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Failed to load!', 'Nie udało się załadować!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Choose Trend', 'Wybierz trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Avg Value', 'Średnia wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Integral Value', 'Wartość integralna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Diff Value', 'Maksymalna wartość różnicy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Calculation type', 'Typ obliczenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Auto Scroll', 'Auto Scroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Failed to load trend data', 'Nie udało się załadować danych trendów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Select the Trend first', 'Najpierw wybierz trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Interval cannot be empty', 'Przedział czasu nie może być pusty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable Duration In Days', 'Zmienny czas trwania w dniach', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable duration is updated', 'Zmienny czas trwania jest aktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Frame', 'Rama', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Usual', 'Zwykły', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Hourly', 'Cogodzinny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Daily', 'Codziennie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'CUSTOM', 'ZWYCZAJ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'COLLECTION', 'KOLEKCJA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Process Form', 'Formularz przetwarzania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Background', 'Tło', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Text Color', 'Kolor tekstu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Main Flag', 'Flaga główna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Grid Flag', 'Flaga siatki', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Inputs', 'Wejścia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Choose Default Image', 'Wybierz obraz domyślny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'States', 'Stany', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'State Lists', 'Listy stanów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'New State', 'Nowy stan', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'State name', 'Nazwa stanu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Attach', 'Dołączać', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Library', 'Biblioteka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Node updated', 'Węzeł zaktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Property', 'Własność', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Project Property', 'Właściwość projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Project Values', 'Wartości projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Stream', 'Strumień', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report', 'Raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please choose a period', 'Wybierz okres', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Name field cannot be empty!', 'Pole nazwy nie może być puste!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please choose a report', 'Wybierz raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group order cannot be empty!', 'Zamówienie grupowe nie może być puste!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report group removed', 'Zgłoś grupę usuniętą', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new Report group added', 'Dodano nową grupę raportów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report group updated successfully', 'Grupa raportów została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report updated successfully', 'Raport został zaktualizowany pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new report added', 'Dodano nowy raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report removed', 'Raport usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please select group', 'Wybierz grupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report subgroup removed', 'Zgłoś podgrupę usuniętą', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new Report subgroup added', 'Dodano nową podgrupę raportów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report subgroup updated successfully', 'Podgrupa raportów została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report Variable', 'Zmienna raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Subgroup', 'Podgrupa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please choose a subgroup', 'Proszę wybrać podgrupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable Order', 'Zmienna kolejność', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Variable order cannot be empty', 'Zamówienie zmienne nie może być puste', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please choose calculation type', 'Proszę wybrać typ obliczenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please choose variable', 'Proszę wybrać zmienną', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Total', 'Całkowity', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Deviation', 'Odchylenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please select subgroup', 'Proszę wybrać podgrupę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report variable removed', 'Usunięto zmienną raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new Report variable added', 'Dodano nową zmienną raportu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Report variable updated successfully', 'Zmienna raportu została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Script Output', 'Wyjście skryptu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Output message', 'Komunikat wyjściowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Empty output', 'Puste wyjście', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Error in code syntax', 'Błąd w składni kodu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group Chat', 'Rozmowa grupowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Type message here', 'Tutaj wpisz wiadomość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Type message', 'Wpisz wiadomość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Refresh Periods', 'Okresy odświeżania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Control Panel', 'Panel sterowania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Gas Properties', 'Właściwości gazu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Network', 'Sieć', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Graph Details', 'Szczegóły wykresu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Check All', 'Zaznacz wszystko', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Menus', 'Menu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Permission', 'Pozwolenie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Permissions', 'Uprawnienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Rolename', 'Rolename', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Role Menus', 'Menu ról', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Menus are added', 'Menu zostały dodane', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Please select role', 'Proszę wybrać rolę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', ' is removed', ' jest usunięty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Role Permissions', 'Uprawnienia roli', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Permissions are added', 'Uprawnienia są dodawane', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new role added', 'Dodano nową rolę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Role updated successfully', 'Rola została zaktualizowana pomyślnie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Role is removed', 'Rola została usunięta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Reset Password', 'Zresetuj hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Password Info', 'Informacje o haśle', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'New Password', 'Nowe hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Repeat New Password', 'Powtórz nowe hasło', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Passwords are not the same', 'Hasła nie są takie same', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Email Address', 'Adres e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'User', 'Użytkownik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Password changed successfully', 'Hasło zostało pomyślnie zmienione', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Password change failed', 'Zmiana hasła nie powiodła się', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Enter new value', 'Wprowadź nową wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Set Value', 'Ustalić wartość', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Increment Value', 'Wartość przyrostu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Send Flags', 'Wyślij flagi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'False/True', 'Fałsz PRAWDA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Decrement Value', 'Zmniejszenie wartości', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Byte Swap?', 'Is Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Is Word Swap?', 'Czy jest zamiana słów?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Point Class', 'Klasa punktów', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Deadband', 'Strefa nieczułości', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Static Variation', 'Odchylenie statyczne', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Event Variation', 'Odmiana wydarzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Data Type', 'Typ danych', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Bit Offset', 'Przesunięcie w bitach', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Decimal Point', 'Kropka dziesiętna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Flags', 'Flagi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Protocol Properties', 'Właściwości protokołu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Raw zero scale', 'Surowa skala zerowa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Raw full scale', 'Surowa, pełna skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Eng zero scale', 'Skala zerowa Eng', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Eng full scale', 'Eng na pełną skalę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Period', 'Okres dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Threshold', 'Próg dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Value Expression', 'Wyrażenie wartości', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Log Expression', 'Wyrażenie dziennika', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Protocol Type', 'Typ protokołu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Protocols', 'Protokoły', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new item added', 'Dodano nowy element', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'A new item detail added', 'Dodano nowy szczegół pozycji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Item detail updated', 'Zaktualizowano szczegóły przedmiotu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Item updated', 'Przedmiot zaktualizowany', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Item removed', 'Usunięto element', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Minutes Offset', 'Minut Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Local Address', 'Lokalny adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Remote Address', 'Adres zdalny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Unsoliceted Events', 'Niezamówione wydarzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Select Timeout', 'Wybierz limit czasu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Confirm Timeout', 'Potwierdź limit czasu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Retry Timeout', 'Limit czasu ponowienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Response Timeout', 'Limit czasu odpowiedzi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Disable Unsolicated', 'Wyłącz niezamówione', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Startup Integrity', 'Integralność uruchamiania', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Integrity Overflow', 'Przepełnienie integralności', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Common Address', 'Wspólny adres', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Dnp3 type', 'Typ Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Event Buffer Size', 'Rozmiar bufora zdarzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Modbus type', 'Typ Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Readable', 'Czytelny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Writeable', 'Zapisywalny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Iec104 type', 'Typ Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Back', 'Z powrotem', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Next', 'Kolejny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'COMMUNICATION NETWORK', 'SIEĆ KOMUNIKACYJNA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Finish', 'Koniec', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Check connection details', 'Sprawdź szczegóły połączenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Connection Details', 'Szczegóły połączenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'GAS STATION MODEL', 'MODEL STACJI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Device List', 'Lista urządzeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Device Form', 'Formularz urządzenia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Item', 'Pozycja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Station Address', 'Adres stacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'PAY', 'ZAPŁACIĆ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'CHECK', 'CZEK', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Stream Details', 'Szczegóły transmisji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'USE GC', 'UŻYJ GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Saved!', 'Uratowany!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'DEFINED GAS STATION MODEL', 'ZDEFINIOWANY MODEL STACJI GAZU', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Capacity', 'Pojemność', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Group Name', 'Nazwa grupy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Stream Modules List', 'Lista modułów strumienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Analyzer', 'Analizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Main Station', 'Dworzec Główny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Sub Station', 'Podstacja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'REPORT', 'RAPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Generate', 'Generować', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Failed to generate project', 'Nie udało się wygenerować projektu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Station Details', 'Szczegóły stacji', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'WebSocket is on', 'WebSocket jest włączony', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'WebSocket is off', 'Usługa WebSocket jest wyłączona', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'WebSocket error observed', 'Zaobserwowano błąd WebSocket', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Clear browser storage', 'Wyczyść pamięć przeglądarki', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'System statistics', 'Statystyki systemu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Chatting', 'Czatowanie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Notifications', 'Powiadomienia', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Sign-out', 'Wyloguj się', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Hide top', 'Ukryj górę', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Are you sure you want to clear storage?', 'Czy na pewno chcesz wyczyścić pamięć?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Press SHIFT+Q to return', 'Naciśnij klawisze SHIFT + Q, aby powrócić', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Press SHIFT+W to return', 'Naciśnij klawisze SHIFT + W, aby powrócić', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'You are about to logged out. Are you sure you want to proceed?', 'Za chwilę się wylogujesz. Czy na pewno chcesz kontynuować?', NEW.space_id, 'system_update', now(), 'system_update', now());

	INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
	('sv', 'inSCADA Login', 'inSCADA-inloggning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Username', 'Användarnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Password', 'Lösenord', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Login', 'Logga in', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Language', 'Språk', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Projects', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'User Menu', 'Användarmeny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Project Map', 'Projektkarta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Devices', 'Enheter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animations', 'Animationer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarms', 'Larm', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Trends', 'Trender', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Trend Tags', 'Trend-taggar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Trend Tag', 'Trend Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Scripts', 'Skript', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Reports', 'Rapporter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Emails', 'E-post', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Logs', 'Loggar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Auth Log', 'Auth-logg', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Users', 'Användare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Help', 'Hjälp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'About', 'Handla om', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Home', 'Hem', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Connection', 'Förbindelse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Trend Graphic', 'Trendgrafik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Trend Graphics', 'Trendgrafik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Connections', 'Anslutningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Group', 'Rapportera grupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Aggregate', 'Aggregerat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Device Templates', 'Enhetsmallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Frame Templates', 'Rammallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable Templates', 'Variabla mallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Search', 'Sök', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure you want to schedule/unschedule the selected script?', 'Är du säker på att du vill schemalägga / avinstallera det valda skriptet?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Add New', 'Lägg till ny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Save', 'Spara', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Delete', 'Radera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Yes', 'Ja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'No', 'Nej', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Status', 'Status', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Properties', 'Egenskaper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure to continue?', 'Är du säker på att fortsätta?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Form data is invalid', 'Formdata är ogiltiga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Visualization', 'Visualisering', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Development', 'Utveckling', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Gas Metering', 'Gasmätning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Gas Control', 'Gaskontroll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Control panel', 'Kontrollpanel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group', 'Grupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Module', 'Modul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Station Adress', 'Station Adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Protocol', 'Protokoll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On DateTime', 'On DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Acknowledge DateTime', 'Bekräfta DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Settings', 'Inställningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'General', 'Allmän', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Start adress', 'Startadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Scan Time', 'Scan Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Device Library', 'Enhetsbibliotek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Expressions', 'Uttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variables', 'Variabler', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Wizard', 'Trollkarl', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable History', 'Variabel historik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Port', 'Hamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Timeout', 'Paus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Frames', 'Ramar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Writeable?', 'Är skrivbar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Readable?', 'Är läsbar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Buffer size', 'Buffertstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print Time', 'Utskriftstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print Day', 'Print Day', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print Hour', 'Utskriftstimme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Day', 'Rapportdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Time', 'Rapportera tid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Hour', 'Report Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print?', 'Skriva ut?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Add Descriptions', 'Lägg till beskrivningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Jobs', 'Jobb', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Last Execution Start Time', 'Starttid för senaste körningen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Last Execution Ended Time', 'Tid för senast genomförd slut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Next Execution Time', 'Nästa körningstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Executions Count', 'Avrättningar räknar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Project', 'Projekt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Name', 'Namn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Description', 'Beskrivning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Start Date', 'Start datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'End Date', 'Slutdatum', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Active?', 'Är aktiv?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Location', 'Plats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Address', 'Adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Latitude', 'Latitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Longitude', 'Longitud', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Contract', 'Kontrakt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Contract Day', 'Kontraktsdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Contract Hour', 'Contract Hour', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new project added', 'Ett nytt projekt har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Project updated successfully', 'Projektet uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Project removed', 'Projekt borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Value', 'Värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure you want to continue?', 'Är du säker på att du vill fortsätta?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'HPP Unit', 'HPP-enhet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Reload', 'Ladda om', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Acknowledge', 'Erkänna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Quantity', 'Kvantitet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Type', 'Loggtyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Unit', 'Enhet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Expression Type', 'Uttryckstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Retain Flag', 'Behåll flaggan', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Word Swap', 'Word swap', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Byte Swap', 'Bytebyte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Load', 'Ladda', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Date Range', 'Datumintervall', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable Picker', 'Variabel plockare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Last Value', 'Senaste värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'First Value', 'Första värdet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Min Value', 'Minvärde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Value', 'Max värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Sum Value', 'Sumvärde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Count Value', 'Räkna värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Acknowledge DateTime Filter', 'Bekräfta DateTime-filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Off DateTime Filter', 'Off DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On DateTime Filter', 'On DateTime Filter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Search Form', 'Sökformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Interval (Second)', 'Intervall (andra)', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On', 'På', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Off', 'Av', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Live', 'Leva', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Preview', 'Förhandsvisning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Cancel', 'Avbryt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Schedule', 'Schema', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Severity', 'Logggrad', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Activity', 'Aktivitet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Source', 'Källa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Message', 'Meddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Remove', 'Ta bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'User Roles', 'Användarroller', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Role', 'Roll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Expression', 'Uttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Delay', 'Dröjsmål', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Category', 'Kategori', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On Script', 'On Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new alarm added', 'Ett nytt larm har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm updated successfully', 'Larmet har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm settings is updated', 'Larminställningar har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm removed', 'Larm borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm History', 'Larmhistorik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Type', 'Typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Import', 'Importera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Date', 'Datum', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure you want to activate/deactivate the selected alarm?', 'Är du säker på att du vill aktivera / avaktivera det valda larmet?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure you want to Start/Stop the selected connection?', 'Är du säker på att du vill starta / stoppa den valda anslutningen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Code', 'Koda', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Priority', 'Prioritet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Period', 'Period', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log', 'Logga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new script added', 'Ett nytt skript har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Script updated successfully', 'Skriptet uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Script removed', 'Skript borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Deviation Variable', 'Avvikelse variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Total Variable', 'Total variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Calculation Type', 'Beräkningstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Order', 'Ordning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Variables', 'Rapportera variabler', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Subgroup Order', 'Undergruppsorder', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Subgroups', 'Rapportera undergrupper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group Order', 'Grupporder', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation Elements', 'Animeringselement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Parent Animation', 'Parent Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Color', 'Färg', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Duration', 'Varaktighet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Play Order', 'Spela order', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Play at Main?', 'Spela på Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SVG Content', 'SVG-innehåll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation Type', 'Animationstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new animation added', 'En ny animation har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Only SVG files are allowed', 'Endast SVG-filer är tillåtna', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation updated successfully', 'Animationen har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation removed', 'Animering borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new animation element added', 'Ett nytt animationselement har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation element updated successfully', 'Animeringselement uppdaterat framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation element removed', 'Animeringselement borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Min. Scale', 'Minsta skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max. Scale', 'Max skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Thickness', 'Tjocklek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Backup', 'Säkerhetskopiering', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Restore', 'Återställ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Save & Continue', 'Spara och fortsätt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable', 'Variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Default', 'Standard', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Add', 'Lägg till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Default value', 'Standardvärde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Text', 'Text', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Title', 'Titel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Size', 'Storlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Disable', 'Inaktivera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Home View', 'Hemvy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Time', 'Tid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Second', 'Andra', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Last Executed At', 'Senast utförd kl.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please select a master record first', 'Välj först en huvudpost', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Send SMS', 'Skicka sms', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SMS Details', 'SMS-information', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SMS Service', 'SMS-tjänst', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SMS sended successfully', 'SMS skickat framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SMS Search', 'SMS-sökning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Content', 'Innehåll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SMS Settings', 'SMS-inställningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Mail sended successfully', 'E-post skickad', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'No selected animation', 'Ingen vald animering', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Recipient', 'Mottagare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Online Help', 'Online hjälp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Menu', 'Meny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm', 'Larm', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm Monitor', 'Alarm Monitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Smart Symbol', 'Smart symbol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Smart Symbols', 'Smarta symboler', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable Monitor', 'Variabel bildskärm', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm Group', 'Larmgrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm Groups', 'Larmgrupper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On No Ack Color', 'On No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On Ack Color', 'On Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print When On?', 'Skriv ut när på?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print When Off?', 'Skriv ut när avstängd?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print When Ack?', 'Skriv ut när Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation', 'Animation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Inverse', 'Omvänd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Set Type', 'Set Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Notify', 'Meddela', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Default Color', 'Standardfärg', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Gradient', 'Lutning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Format', 'Formatera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group Size', 'Gruppstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Decimal', 'Decimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group Seperator', 'Gruppavskiljare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Decimal Seperator', 'Decimal separator', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Leftpad Size', 'Leftpad Size', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Rightpad Size', 'Högerplattans storlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Character', 'Karaktär', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Prefix', 'Prefix', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Suffix', 'Ändelse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'tag', 'märka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Initial Pos', 'Initial Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Min Pos', 'Min pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'On Drop', 'On Drop', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Join', 'Ansluta sig', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Template?', 'Är mall?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation Element', 'Animeringselement', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Mouse', 'Mus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'More', 'Mer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation WebSocket is on', 'Animation WebSocket är på', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation WebSocket is off', 'Animation WebSocket är avstängt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Animation WebSocket error observed', 'WebSocket-fel observerades', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Pool Size', 'Poolstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Adapter', 'Adapter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Min Retry Delay', 'Min försök fördröjning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Retry Delay', 'Max försök fördröjning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Local Ip', 'Lokal IP', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Local Port', 'Lokal hamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Cot F. Length', 'Spjälsäng F. Längd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Cot Field Length', 'Cot Field Length', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'IOA Field Length', 'IOA fältlängd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Common A. Length', 'Gemensam A. längd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Common Address Field Length', 'Vanlig adressfältlängd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'IOA F. Length', 'IOA F. Längd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Originator Address', 'Adressadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Message F. Timeout', 'Meddelande F. Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Message Fragment Timeout', 'Timeout för meddelandefragment', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max T.N.A. Recieved', 'Max T.N.A. mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Time No Ack Received', 'Max tid ingen ack mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max T.N.A. Sent', 'Max T.N.A. Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Idle Time', 'Max tomgångstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max U. IP Recieved', 'Max U. IP mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Unconfirmed IPdus Received', 'Max obekräftad IPdus mottagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Start DT Timeout', 'Starta DT-timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Start DT Retries', 'Starta DT försöker igen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Coming Soon...', 'Kommer snart...', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Rack', 'Kuggstång', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Slot', 'Spår', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'No Data Transfer Selected', 'Ingen dataöverföring vald', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Destination', 'Destination', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Detail Form', 'Detaljformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Source Tag', 'Källkod', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Destination Tag', 'Destination Tag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Data Transfer', 'Dataöverföring', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Detail Transfer', 'Detaljöverföring', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Device', 'Enhet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Device Picker', 'Enhetsväljare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Import Tmpl', 'Importera tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Start Address', 'Startadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'General I. Time', 'Allmänt I. Tid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'General Interrogation Time', 'Allmän förhörstid', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'General Counter Interrogation Time', 'General Counter Interrogation Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Cnt Point Offset', 'Cnt Point Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Control Point Offset', 'Kontrollpunktsförskjutning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'DB Number', 'DB-nummer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'IEC104 type', 'IEC104-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Sender', 'Avsändare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Recepient', 'Mottagare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Subject', 'Ämne', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Email View', 'E-postvy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'From', 'Från', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'To', 'Till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Email Search', 'Sök via e-post', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Email Service', 'E-posttjänst', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Body', 'Kropp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Send Email', 'Skicka epost', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Send', 'Skicka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'User List', 'Användarlista', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Mail send failed', 'Skicka e-post misslyckades', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Email Settings', 'E-postinställningar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Email', 'E-post', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Backup/Restore', 'Säkerhetskopiering / återställning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Choose', 'Välja', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Processes', 'Processer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Data Transfers', 'Dataöverföringar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Keywords', 'Nyckelord', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Roles', 'Roller', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Templates', 'Mallar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Key', 'Nyckel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Active', 'Aktiva', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Successful ?', 'Är framgångsrik ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Auth Logs', 'Auth-loggar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'License', 'Licens', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Machine Id', 'Maskin-id', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Surname', 'Efternamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'User Limit', 'Användargräns', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Update', 'Uppdatering', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'License Key', 'Licensnyckel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'License to', 'Licens till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'License successfully activated', 'Licens har aktiverats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Failed to activate', 'Det gick inte att aktivera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm Name', 'Larmnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Start All', 'Starta alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Stop All', 'Stoppa alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Är du säker på att du vill schemalägga / avinstallera den valda dataöverföringen?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Process', 'Bearbeta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'GRAPHICAL VIEW', 'GRAFISK UTSIKT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'FLOW RATE', 'FLÖDESHASTIGHET', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'METERING', 'MÄTNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'ENERGY & OTHER VALUES', 'ENERGI & ANDRA VÄRDEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'IN-USE GAS COMPONENTS', 'GASKOMPONENTER I ANVÄNDNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'TOTALISORS', 'TOTALISORS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'PREVIOUS HOURLY & DAILY VALUES', 'FÖREGÅENDE TIDLIGA & DAGLIGA VÄRDEN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'ALARMS ON', 'LARM PÅ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'NAME', 'NAMN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'CURRENT', 'NUVARANDE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'IN-USE', 'I ANVÄNDNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'DOWNLOADED', 'NEDLADDAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'NORMALIZED', 'NORMALISERAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'UNIT', 'ENHET', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'PROPERTIES', 'EGENSKAPER', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'GC MANAGEMENT', 'GC-HANTERING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SET', 'UPPSÄTTNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'STATUS', 'STATUS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Scanned!', 'Skannad!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'deviceName', 'enhetsnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Failed to load data', 'Det gick inte att läsa in data', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'ANIMATION', 'ANIMATION', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'GAS METERING', 'GASMÄTNING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'GAS PROPERTIES', 'GAS EGENSKAPER', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'NETWORK', 'NÄTVERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Fired Alarm Duration In Days', 'Larmets varaktighet i dagar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Fired Alarm duration is updated', 'Larmets varaktighet aktiveras', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Acknowledger', 'Bekräftare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Duration In Days', 'Loggtid i dagar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log duration is updated', 'Loggens varaktighet uppdateras', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Remove All', 'Ta bort alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Firstly load the datatable', 'Ladda först datatabellen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Failed to load log data', 'Det gick inte att läsa in loggdata', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure to remove all logs?', 'Är du säker på att du tar bort alla loggar?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'All logs removed', 'Alla loggar borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'An error occured while removing logs', 'Ett fel uppstod när loggar togs bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Message', 'Loggmeddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Show Weather On Click', 'Visa väder vid klick', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Updated successfully', 'Uppdateringen lyckades', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Removed successfully', 'Borttagen framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Map', 'Karta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Map api', 'Map api', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Weather api', 'Weather api', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Interval', 'Intervall', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Filter', 'Filtrera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'SCHEDULED', 'SCHEMA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'ON', 'PÅ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'OFF', 'AV', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Print', 'Skriva ut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Failed to load!', 'Misslyckades att ladda!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Choose Trend', 'Välj trend', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Avg Value', 'Genomsnittligt värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Integral Value', 'Integrerat värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Diff Value', 'Max Diff Value', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Calculation type', 'Beräkningstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Auto Scroll', 'Auto-scrolla', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Failed to load trend data', 'Det gick inte att ladda trenddata', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Select the Trend first', 'Välj trend först', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Interval cannot be empty', 'Intervallet kan inte vara tomt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable Duration In Days', 'Variabel varaktighet i dagar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable duration is updated', 'Variabel varaktighet uppdateras', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Frame', 'Ram', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Usual', 'Vanliga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Hourly', 'Varje timme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Daily', 'Dagligen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'CUSTOM', 'BESTÄLLNINGS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'COLLECTION', 'SAMLING', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Process Form', 'Processformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Background', 'Bakgrund', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Text Color', 'Text färg', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Main Flag', 'Huvudflagga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Grid Flag', 'Grid Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Inputs', 'Ingångar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Choose Default Image', 'Välj standardbild', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'States', 'Stater', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'State Lists', 'Statliga listor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'New State', 'Ny stat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'State name', 'Statligt namn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Attach', 'Bifoga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Library', 'Bibliotek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Node updated', 'Nod uppdaterad', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Property', 'Fast egendom', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Project Property', 'Projektfastighet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Project Values', 'Projektvärden', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Stream', 'Ström', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report', 'Rapportera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please choose a period', 'Välj en period', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Name field cannot be empty!', 'Namnfältet får inte vara tomt!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please choose a report', 'Välj en rapport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group order cannot be empty!', 'Grupporder kan inte vara tom!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report group removed', 'Rapportgrupp har tagits bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new Report group added', 'En ny rapportgrupp har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report group updated successfully', 'Rapportgrupp har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report updated successfully', 'Rapporten uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new report added', 'En ny rapport har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report removed', 'Rapport borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please select group', 'Välj grupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report subgroup removed', 'Rapportera undergrupp borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new Report subgroup added', 'En ny rapportgrupp har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report subgroup updated successfully', 'Rapportera undergrupp har uppdaterats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report Variable', 'Rapportvariabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Subgroup', 'Undergrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please choose a subgroup', 'Välj en undergrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable Order', 'Variabel ordning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Variable order cannot be empty', 'Variabel ordning kan inte vara tom', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please choose calculation type', 'Välj beräkningstyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please choose variable', 'Välj variabel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Deviation', 'Avvikelse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please select subgroup', 'Välj undergrupp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report variable removed', 'Rapportvariabel borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new Report variable added', 'En ny rapportvariabel har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Report variable updated successfully', 'Rapportvariabel uppdaterades framgångsrikt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Script Output', 'Skriptutmatning', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Output message', 'Output meddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Empty output', 'Tom utdata', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Error in code syntax', 'Fel i kodsyntax', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group Chat', 'Gruppchatt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Type message here', 'Skriv meddelande här', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Type message', 'Skriv meddelande', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Refresh Periods', 'Uppdatera perioder', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Control Panel', 'Kontrollpanel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Gas Properties', 'Gasegenskaper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Network', 'Nätverk', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Graph Details', 'Grafinformation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Check All', 'Markera alla', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Menus', 'Menyer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Permission', 'Lov', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Permissions', 'Behörigheter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Rolename', 'Rollnamn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Role Menus', 'Rollmenyer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Menus are added', 'Menyer läggs till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Please select role', 'Vänligen välj roll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', ' is removed', ' är borttagen', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Role Permissions', 'Rolltillstånd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Permissions are added', 'Behörigheter läggs till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new role added', 'En ny roll tillagd', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Role updated successfully', 'Roll uppdaterad', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Role is removed', 'Roll har tagits bort', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Reset Password', 'Återställ lösenord', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Password Info', 'Lösenordsinfo', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'New Password', 'Nytt lösenord', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Repeat New Password', 'Upprepa nya lösenordet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Passwords are not the same', 'Lösenorden är inte samma', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Email Address', 'E-postadress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'User', 'Användare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Password changed successfully', 'Lösenordet har ändrats', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Password change failed', 'Ändring av lösenord misslyckades', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Enter new value', 'Ange nytt värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Set Value', 'Satt värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Increment Value', 'Öka värdet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Send Flags', 'Skicka flaggor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'False/True', 'Falsk sann', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Decrement Value', 'Minska värde', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Byte Swap?', 'Är bytebyte?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Is Word Swap?', 'Är ordbyte?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Point Class', 'Point Class', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Static Variation', 'Statisk variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Event Variation', 'Event Variation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Data Type', 'Data typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Bit Offset', 'Bit Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Decimal Point', 'Decimalpunkt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Flags', 'Flaggor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Protocol Properties', 'Protokollegenskaper', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Raw zero scale', 'Rå nollskala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Raw full scale', 'Rå fullskala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Eng zero scale', 'Eng noll skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Eng full scale', 'Eng full skala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Period', 'Loggperiod', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Threshold', 'Loggräns', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Value Expression', 'Värdeuttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Log Expression', 'Logguttryck', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Protocol Type', 'Protokolltyp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Protocols', 'Protokoll', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new item added', 'Ett nytt objekt har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'A new item detail added', 'En ny artikel har lagts till', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Item detail updated', 'Uppdaterad artikeldetalj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Item updated', 'Uppdaterad artikel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Item removed', 'Objekt borttaget', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Minutes Offset', 'Minute Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Local Address', 'Lokal adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Remote Address', 'Fjärradress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Unsoliceted Events', 'Oönskade händelser', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Max Controls', 'Max kontroller', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Select Timeout', 'Välj timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Confirm Timeout', 'Bekräfta timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Retry Timeout', 'Försök timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Response Timeout', 'Timeout för svar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Disable Unsolicated', 'Inaktivera olösta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Startup Integrity', 'Startup Integrity', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Integrity Overflow', 'Överflöd av integritet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Common Address', 'Gemensam adress', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Dnp3 type', 'Dnp3-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Event Buffer Size', 'Händelsebuffertstorlek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Modbus type', 'Modbus-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Readable', 'Läsbar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Writeable', 'Skrivbar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Iec104 type', 'Iec104-typ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Back', 'Tillbaka', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Next', 'Nästa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'COMMUNICATION NETWORK', 'KOMMUNIKATIONSNÄTVERK', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Finish', 'Avsluta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Check connection details', 'Kontrollera anslutningsinformation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Connection Details', 'Anslutningsdetaljer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'GAS STATION MODEL', 'GAS STATION MODEL', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Device List', 'Enhetslista', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Device Form', 'Enhetsformulär', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Item', 'Artikel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Station Address', 'Station Address', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'PAY', 'BETALA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'CHECK', 'KOLLA UPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Stream Details', 'Strömdetaljer', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'USE GC', 'ANVÄND GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Saved!', 'Sparat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'DEFINED GAS STATION MODEL', 'DEFINERAD BENSINSTATIONSMODELL', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Capacity', 'Kapacitet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Group Name', 'Grupp namn', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Stream Modules List', 'Stream Modules List', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Analyzer', 'Analysator', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Main Station', 'Huvudstation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Sub Station', 'Substation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'REPORT', 'RAPPORTERA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Generate', 'Generera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Failed to generate project', 'Det gick inte att generera projektet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Station Details', 'Stationinformation', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'WebSocket is on', 'WebSocket är på', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'WebSocket is off', 'WebSocket är avstängt', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'WebSocket error observed', 'WebSocket-fel observerat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Clear browser storage', 'Rensa webbläsarlagring', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'System statistics', 'Systemstatistik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Chatting', 'Chattar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Notifications', 'Meddelanden', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Sign-out', 'Logga ut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Hide top', 'Göm topp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Are you sure you want to clear storage?', 'Är du säker på att du vill rensa lagring?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Press SHIFT+Q to return', 'Tryck på SKIFT + Q för att återvända', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Press SHIFT+W to return', 'Tryck på SKIFT + W för att återvända', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'You are about to logged out. Are you sure you want to proceed?', 'Du håller på att logga ut. Är du säker på att du vill fortsätta?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'inSCADA Login', 'Conectare inSCADA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Username', 'Nume de utilizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Password', 'Parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Login', 'Logare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Language', 'Limba', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Projects', 'Proiecte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'User Menu', 'Meniul utilizatorului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Project Map', 'Harta proiectului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Devices', 'Dispozitive', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animations', 'Animații', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarms', 'Alarme', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Trends', 'Tendințe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Trend Tags', 'Etichete de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Trend Tag', 'Etichetă de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Scripts', 'Scripturi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Reports', 'Rapoarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Emails', 'E-mailuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Logs', 'Jurnale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Auth Log', 'Jurnal de autentificare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Users', 'Utilizatori', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Help', 'Ajutor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'About', 'Despre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Home', 'Acasă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Connection', 'Conexiune', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Trend Graphic', 'Grafic de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Trend Graphics', 'Grafică de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Connections', 'Conexiuni', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Group', 'Grup de raportare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Aggregate', 'Agregat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Device Templates', 'Șabloane de dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Frame Templates', 'Șabloane de cadre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable Templates', 'Șabloane variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Search', 'Căutare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure you want to schedule/unschedule the selected script?', 'Sigur doriți să programați / să nu programați scriptul selectat?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Add New', 'Adăuga nou', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Save', 'Salvați', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Delete', 'Șterge', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Yes', 'Da', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'No', 'Nu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Status', 'Stare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Properties', 'Proprietăți', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure to continue?', 'Ești sigur că vei continua?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Form data is invalid', 'Datele formularului sunt nevalide', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Visualization', 'Vizualizare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Development', 'Dezvoltare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Gas Metering', 'Măsurare gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Gas Control', 'Control gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Control panel', 'Panou de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group', 'Grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Module', 'Modul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Station Adress', 'Adresa stației', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Protocol', 'Protocol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On DateTime', 'La ora dată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Acknowledge DateTime', 'Confirmați data și ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Settings', 'Setări', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'General', 'General', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Start adress', 'Începeți adresa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Scan Time', 'Scan Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Device Library', 'Biblioteca de dispozitive', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Expressions', 'Expresii', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variables', 'Variabile', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Wizard', 'Vrăjitor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable History', 'Istoria variabilă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Ip', 'Ip', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Port', 'Port', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Timeout', 'Pauză', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Frames', 'Rame', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Writeable?', 'Este scris?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Readable?', 'Este de citit?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Buffer size', 'Dimensiunea memoriei tampon', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print Time', 'Timp de imprimare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print Day', 'Ziua tipăririi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print Hour', 'Ora de tipărire', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Day', 'Ziua raportului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Time', 'Ora raportului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Hour', 'Raportați ora', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print?', 'Imprimare?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Add Descriptions', 'Adăugați descrieri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Jobs', 'Locuri de munca', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Last Execution Start Time', 'Ora de începere a ultimei execuții', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Last Execution Ended Time', 'Ultima perioadă de executare încheiată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Next Execution Time', 'Următorul timp de execuție', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Executions Count', 'Execuțiile contează', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Project', 'Proiect', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Name', 'Nume', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Description', 'Descriere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Start Date', 'Data de început', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'End Date', 'Data de încheiere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Active?', 'Este activ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Location', 'Locație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Address', 'Abordare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Latitude', 'Latitudine', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Longitude', 'Longitudine', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Contract', 'Contracta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Contract Day', 'Ziua contractului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Contract Hour', 'Ora contractului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new project added', 'A fost adăugat un nou proiect', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Project updated successfully', 'Proiectul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Project removed', 'Proiect eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Value', 'Valoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure you want to continue?', 'Esti sigur ca vrei sa continui?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'HPP Unit', 'Unitate HPP', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Reload', 'Reîncarcă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Acknowledge', 'Recunoaște', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Quantity', 'Cantitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Type', 'Tip jurnal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Unit', 'Unitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Expression Type', 'Tip de expresie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Retain Flag', 'Păstrați steagul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Word Swap', 'Schimb de cuvinte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Byte Swap', 'Schimb de octeți', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Load', 'Sarcină', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Date Range', 'Interval de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable Picker', 'Selector variabil', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Last Value', 'Ultima valoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'First Value', 'Prima valoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Min Value', 'Valoare min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Value', 'Valoare maximă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Sum Value', 'Valoare sumă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Count Value', 'Valoare de numărare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Acknowledge DateTime Filter', 'Confirmați filtrul de dată și oră', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Off DateTime Filter', 'Filtru Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On DateTime Filter', 'La data și ora filtrului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Search Form', 'Formular de căutare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Off DateTime', 'Off DateTime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Interval (Second)', 'Interval (al doilea)', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On', 'Pe', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Off', 'Dezactivat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Live', 'Trăi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Preview', 'Previzualizare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Cancel', 'Anulare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Schedule', 'Programa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Severity', 'Severitatea jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Activity', 'Activitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Source', 'Sursă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Message', 'Mesaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Remove', 'Elimina', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'User Roles', 'Roluri utilizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Role', 'Rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Expression', 'Expresie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Delay', 'Întârziere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Category', 'Categorie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On Script', 'Pe script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Off Script', 'Off Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Ack Script', 'Ack Script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new alarm added', 'A adăugat o nouă alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm updated successfully', 'Alarma actualizată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm settings is updated', 'Setările de alarmă sunt actualizate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm removed', 'Alarma eliminată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm History', 'Istoricul alarmelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Type', 'Tip', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Import', 'Import', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Date', 'Data', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure you want to activate/deactivate the selected alarm?', 'Sigur doriți să activați / dezactivați alarma selectată?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure you want to Start/Stop the selected connection?', 'Sigur doriți să porniți / opriți conexiunea selectată?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Code', 'Cod', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Priority', 'Prioritate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Period', 'Perioadă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log', 'Buturuga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new script added', 'A fost adăugat un nou script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Script updated successfully', 'Scriptul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Script removed', 'Script eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Deviation Variable', 'Variabilă de deviere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Total Variable', 'Variabilă totală', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Calculation Type', 'Tipul de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Order', 'Ordin', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Variables', 'Raportați variabilele', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Subgroup Order', 'Comandă subgrup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Subgroups', 'Raportați subgrupuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group Order', 'Comandă de grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation Elements', 'Elemente de animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Parent Animation', 'Animație părinte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Color', 'Culoare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Duration', 'Durată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Play Order', 'Play Order', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Play at Main?', 'Joacă la Main?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SVG Content', 'Conținut SVG', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation Type', 'Tipul animației', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new animation added', 'A fost adăugată o nouă animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Only SVG files are allowed', 'Doar fișierele SVG sunt permise', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation updated successfully', 'Animația a fost actualizată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation removed', 'Animație eliminată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new animation element added', 'A fost adăugat un nou element de animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation element updated successfully', 'Element de animație actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation element removed', 'Element de animație eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Min. Scale', 'Scală min.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max. Scale', 'Scală maximă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Thickness', 'Grosime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Backup', 'Backup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Restore', 'Restabili', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Save & Continue', 'Salvați și continuați', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable', 'Variabil', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Default', 'Mod implicit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Add', 'Adăuga', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Default value', 'Valoare implicită', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Text', 'Text', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Title', 'Titlu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Size', 'Mărimea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Disable', 'Dezactivează', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Home View', 'Vizualizare la domiciliu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Time', 'Timp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Second', 'Al doilea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Last Executed At', 'Ultima executare la', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please select a master record first', 'Vă rugăm să selectați mai întâi o înregistrare principală', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Send SMS', 'Trimite SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SMS Details', 'Detalii SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SMS Service', 'Serviciu SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SMS sended successfully', 'SMS trimis cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SMS Search', 'Căutare SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Content', 'Conţinut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SMS Settings', 'Setări SMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Mail sended successfully', 'E-mail trimis cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'No selected animation', 'Fără animație selectată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Recipient', 'Destinatar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Online Help', 'Ajutor online', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Menu', 'Meniul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm', 'Alarma', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm Monitor', 'Monitor alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Smart Symbol', 'Simbol inteligent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Smart Symbols', 'Simboluri inteligente', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable Monitor', 'Monitor variabil', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm Group', 'Grup de alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm Groups', 'Grupuri de alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On No Ack Color', 'Fără culoare Ack', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On Ack Color', 'Pe Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Off No Ack Color', 'Off No Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Off Ack Color', 'Off Ack Color', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print When On?', 'Imprimați când este activat?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print When Off?', 'Imprimați când este oprit?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print When Ack?', 'Imprimați când Ack?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation', 'Animaţie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Inverse', 'Invers', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Set Type', 'Set Type', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Notify', 'Notificați', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Default Color', 'Culoare implicită', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Gradient', 'Gradient', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Min', 'Min', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max', 'Max', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Format', 'Format', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group Size', 'Dimensiunea grupului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Decimal', 'Zecimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group Seperator', 'Separator de grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Decimal Seperator', 'Seperator zecimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Leftpad Size', 'Dimensiunea panoului stâng', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Rightpad Size', 'Dimensiunea tastaturii dreapta', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Character', 'Caracter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Prefix', 'Prefix', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Suffix', 'Sufix', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'tag', 'etichetă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Initial Pos', 'Poziție inițială', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Min Pos', 'Min Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Pos', 'Max Pos', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'On Drop', 'La picătură', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Join', 'A te alatura', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Template?', 'Șablonul este?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Dom Id', 'Dom Id', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation Element', 'Element de animație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Mouse', 'Mouse', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'More', 'Mai mult', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation WebSocket is on', 'Animation WebSocket este activat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation WebSocket is off', 'Animation WebSocket este dezactivat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Animation WebSocket error observed', 'Eroare WebSocket de animație observată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Pool Size', 'Dimensiunea piscinei', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Adapter', 'Adaptor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Min Retry Delay', 'Întârziere reîncercare minimă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Retry Delay', 'Întârziere reîncercare maximă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Local Ip', 'Ip local', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Local Port', 'Port local', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Cot F. Length', 'Pat F. Lungime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Cot Field Length', 'Lungimea câmpului pătuțului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'IOA Field Length', 'Lungimea câmpului IOA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Common A. Length', 'Lungime comună A.', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Common Address Field Length', 'Lungimea câmpului de adresă comună', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'IOA F. Length', 'IOA F. Lungime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Originator Address', 'Adresa inițiatorului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Message F. Timeout', 'Mesaj F. Expirare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Message Fragment Timeout', 'Expirarea fragmentului mesajului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max T.N.A. Recieved', 'Max T.N.A. primit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Time No Ack Received', 'Timp maxim fără recepție primită', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max T.N.A. Sent', 'Max T.N.A. Trimis', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Time No Ack Sent', 'Max Time No Ack Sent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Idle Time', 'Timp maxim de inactivitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max U. IP Recieved', 'IP maxim U. primit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Unconfirmed IPdus Received', 'IPdus maxim neconfirmat primit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Start DT Timeout', 'Start DT Timeout', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Start DT Retries', 'Porniți reîncercări DT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Coming Soon...', 'In curand...', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Rack', 'Rack', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Slot', 'Slot', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'No Data Transfer Selected', 'Nu a fost selectat niciun transfer de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Destination', 'Destinaţie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Detail Form', 'Formular de detalii', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Source Tag', 'Etichetă sursă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Destination Tag', 'Etichetă de destinație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Data Transfer', 'Transfer de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Detail Transfer', 'Transfer detaliu', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Device', 'Dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Device Picker', 'Selector de dispozitive', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Import Tmpl', 'Import Tmpl', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Start Address', 'Adresa de început', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'General I. Time', 'Generalul I. Timpul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'General Interrogation Time', 'Timpul general de interogare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'General C.I. Time', 'General C.I. Time', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'General Counter Interrogation Time', 'Timpul general de interogare a contracarării', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Cnt Point Offset', 'Offset Cnt Point', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Control Point Offset', 'Offset punct de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'DB Number', 'Număr DB', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'IEC104 type', 'Tip IEC104', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Sender', 'Expeditor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Recepient', 'Receptor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Subject', 'Subiect', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Email View', 'Vizualizare e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'From', 'Din', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'To', 'La', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Email Search', 'Căutare prin e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Email Service', 'Serviciu de e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Body', 'Corp', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Send Email', 'Trimite email', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Send', 'Trimite', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'User List', 'Lista de utilizatori', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Mail send failed', 'Trimiterea e-mailului a eșuat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Email Settings', 'Setări e-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Email', 'E-mail', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Backup/Restore', 'Backup / Restore', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Choose', 'Alege', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Processes', 'Procese', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Data Transfers', 'Transferuri de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Keywords', 'Cuvinte cheie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Roles', 'Roluri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Templates', 'Șabloane', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Key', 'Cheie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Active', 'Activ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Successful ?', 'Este de succes ?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Auth Logs', 'Jurnaluri de autentificare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'License', 'Licență', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Machine Id', 'ID mașină', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Surname', 'Nume de familie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'User Limit', 'Limita utilizatorului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Update', 'Actualizați', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'License Key', 'Cheie de licență', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'License to', 'Licență pentru', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'License successfully activated', 'Licența a fost activată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Failed to activate', 'Activarea nu a reușit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm Name', 'Nume alarmă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Alarm Dsc', 'Alarm Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Start All', 'Începeți totul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Stop All', 'Oprește-le pe toate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure you want to schedule/unschedule the selected data transfer?', 'Sigur doriți să programați / să nu programați transferul de date selectat?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Process', 'Proces', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'GRAPHICAL VIEW', 'VEDERE GRAFICĂ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'FLOW RATE', 'VITEZA DE DEBIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'METERING', 'MĂSURARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'ENERGY & OTHER VALUES', 'ENERGIE ȘI ALTE VALORI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'IN-USE GAS COMPONENTS', 'COMPONENTE GAZE IN UTILIZARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'TOTALISORS', 'TOTALIZATORI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'PREVIOUS HOURLY & DAILY VALUES', 'VALORI ORARE ȘI ZILNICE ANTERIOARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'ALARMS ON', 'ALARME ACTIVE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'NAME', 'NUME', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'CURRENT', 'ACTUAL', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'C.HOUR', 'C.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'P.HOUR', 'P.HOUR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'C.DAY', 'C.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'P.DAY', 'P.DAY', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'G.C.A', 'G.C.A', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'G.C.B', 'G.C.B', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'KEY-PAD', 'KEY-PAD', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'IN-USE', 'IN FOLOSINTA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'MIN', 'MIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'MAX', 'MAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'DOWNLOADED', 'DESCĂRCAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'NORMALIZED', 'NORMALIZAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'UNIT', 'UNITATE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'PROPERTIES', 'PROPRIETĂȚI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'GC MANAGEMENT', 'GC MANAGEMENT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'INUSE GC', 'INUSE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SET', 'A STABILIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'STATUS', 'STARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'QRCODE Reader', 'QRCODE Reader', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Scanned!', 'Scanat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'deviceName', 'Nume dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Failed to load data', 'Nu s-au putut încărca datele', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'ANIMATION', 'ANIMAŢIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'GAS METERING', 'MĂSURAREA GAZELOR', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'GAS PROPERTIES', 'PROPRIETĂȚI CU GAZ', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'NETWORK', 'REŢEA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Fired Alarm Duration In Days', 'Durată alarmă declanșată în zile', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Fired Alarm duration is updated', 'Durata alarmei lansate este actualizată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Acknowledger', 'Recunoscător', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Dsc', 'Dsc', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Duration In Days', 'Durata jurnalului în zile', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log duration is updated', 'Durata jurnalului este actualizată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Remove All', 'Inlătură tot', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Firstly load the datatable', 'În primul rând încărcați baza de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Failed to load log data', 'Nu s-au putut încărca datele jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure to remove all logs?', 'Sigur eliminați toate jurnalele?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'All logs removed', 'Toate jurnalele au fost eliminate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'An error occured while removing logs', 'A apărut o eroare la eliminarea jurnalelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Message', 'Mesaj jurnal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Show Weather On Click', 'Afișați vremea la clic', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Updated successfully', 'Actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Removed successfully', 'Eliminat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Map', 'Hartă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Map api', 'Harta API', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Weather api', 'Api meteo', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Interval', 'Interval', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Filter', 'Filtru', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'SCHEDULED', 'PROGRAMAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'ON', 'PE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'OFF', 'OFF', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Print', 'Imprimare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Failed to load!', 'Incarcarea a esuat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Choose Trend', 'Alegeți tendința', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Avg Value', 'Valoare medie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Integral Value', 'Valoare integrală', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Diff Value', 'Valoare maximă a diferenței', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Calculation type', 'Tipul de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Auto Scroll', 'Derulare automată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Failed to load trend data', 'Nu s-au putut încărca datele de tendință', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Select the Trend first', 'Selectați mai întâi tendința', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Interval cannot be empty', 'Intervalul nu poate fi gol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable Duration In Days', 'Durata variabilă în zile', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable duration is updated', 'Durata variabilei este actualizată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Frame', 'Cadru', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Usual', 'Ca de obicei', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Hourly', 'Orar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Daily', 'Zilnic', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'CUSTOM', 'PERSONALIZAT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'COLLECTION', 'COLECTIE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Process Form', 'Formular de proces', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Background', 'Fundal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Text Color', 'Culoarea textului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Main Flag', 'Steagul principal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Grid Flag', 'Grid Flag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Inputs', 'Intrări', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Choose Default Image', 'Alegeți imaginea implicită', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'States', 'State', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'State Lists', 'Liste de stat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'New State', 'Stat nou', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'State name', 'Numele statului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Attach', 'Atașează', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Library', 'Bibliotecă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Node updated', 'Nod actualizat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Property', 'Proprietate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Project Property', 'Proprietatea proiectului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Project Values', 'Valorile proiectului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Stream', 'Curent', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report', 'Raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please choose a period', 'Vă rugăm să alegeți o perioadă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Name field cannot be empty!', 'Câmpul de nume nu poate fi gol!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please choose a report', 'Vă rugăm să alegeți un raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group order cannot be empty!', 'Comanda de grup nu poate fi goală!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report group removed', 'Grupul de raportare a fost eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new Report group added', 'A fost adăugat un nou grup de rapoarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report group updated successfully', 'Grupul de rapoarte a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report updated successfully', 'Raportul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new report added', 'A fost adăugat un nou raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report removed', 'Raport eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please select group', 'Vă rugăm să selectați grupul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report subgroup removed', 'Raportați subgrupul eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new Report subgroup added', 'A fost adăugat un nou subgrup de rapoarte', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report subgroup updated successfully', 'Raportați subgrupul actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report Variable', 'Variabilă de raportare', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Subgroup', 'Subgrup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please choose a subgroup', 'Vă rugăm să alegeți un subgrup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable Order', 'Comandă variabilă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Variable order cannot be empty', 'Comanda variabilă nu poate fi goală', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please choose calculation type', 'Vă rugăm să alegeți tipul de calcul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please choose variable', 'Vă rugăm să alegeți variabila', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Total', 'Total', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Deviation', 'Deviere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please select subgroup', 'Vă rugăm să selectați subgrupul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report variable removed', 'Raport variabilă eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new Report variable added', 'A fost adăugată o nouă variabilă de raport', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Report variable updated successfully', 'Raport variabilă actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Script Output', 'Ieșire script', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Output message', 'Mesaj de ieșire', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Empty output', 'Ieșire goală', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Error in code syntax', 'Eroare în sintaxa codului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group Chat', 'Chat de grup', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Type message here', 'Introduceți mesajul aici', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Type message', 'Tastați mesajul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Refresh Periods', 'Actualizați perioadele', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Control Panel', 'Panou de control', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Gas Properties', 'Proprietăți de gaz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Network', 'Reţea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Graph Details', 'Detalii grafic', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Check All', 'Selectați toate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Menus', 'Meniuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Permission', 'Permisiune', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Permissions', 'Permisiuni', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Rolename', 'Nume rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Role Menus', 'Meniuri de rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Menus are added', 'Meniurile sunt adăugate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Please select role', 'Vă rugăm să selectați rolul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', ' is removed', ' este eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Role Permissions', 'Permisiuni de rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Permissions are added', 'Permisiunile sunt adăugate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new role added', 'A fost adăugat un nou rol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Role updated successfully', 'Rolul a fost actualizat cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Role is removed', 'Rolul este eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Reset Password', 'Reseteaza parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Password Info', 'Informații despre parolă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'New Password', 'Parolă Nouă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Repeat New Password', 'Repeta noua parola', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Passwords are not the same', 'Parolele nu sunt la fel', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Email Address', 'Adresa de email', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'User', 'Utilizator', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Password changed successfully', 'Parola a fost schimbată cu succes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Password change failed', 'Schimbarea parolei a eșuat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Enter new value', 'Introduceți o valoare nouă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Set Value', 'Setați valoarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Increment Value', 'Valoare de creștere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Send Flags', 'Trimiteți steaguri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'False/True', 'Fals adevarat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Decrement Value', 'Decrementează valoarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Byte Swap?', 'Este Byte Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Is Word Swap?', 'Este Word Swap?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Point Class', 'Clasa punctelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Deadband', 'Deadband', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Static Variation', 'Variație statică', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Event Variation', 'Variația evenimentului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Data Type', 'Tipul de date', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Bit Offset', 'Bit Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Decimal Point', 'Punct zecimal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Flags', 'Steaguri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Protocol Properties', 'Proprietăți protocol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Raw zero scale', 'Scală zero brută', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Raw full scale', 'Raw full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Eng zero scale', 'Eng zero scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Eng full scale', 'Eng full scale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Period', 'Perioada jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Threshold', 'Prag jurnal', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Value Expression', 'Expresia valorii', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Log Expression', 'Expresia jurnalului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Protocol Type', 'Tipul protocolului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Protocols', 'Protocoale', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new item added', 'A fost adăugat un nou articol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'A new item detail added', 'A fost adăugat un nou detaliu de articol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Item detail updated', 'Detaliile articolului au fost actualizate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Item updated', 'Element actualizat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Item removed', 'Element eliminat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Minutes Offset', 'Minute Offset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'MinuteOffset', 'MinuteOffset', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Local Address', 'Adresă locală', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Remote Address', 'Adresă la distanță', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Integrity Scantime', 'Integrity Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Unsoliceted Events', 'Evenimente nesolicitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Max Controls', 'Max Controls', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Select Timeout', 'Selectați expirarea timpului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Confirm Timeout', 'Confirmați expirarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Retry Timeout', 'Expirarea din nou a încercării', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Response Timeout', 'Expirarea răspunsului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Event Scantime', 'Event Scantime', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Disable Unsolicated', 'Dezactivează nesolicitat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Startup Integrity', 'Integritate la pornire', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Integrity Overflow', 'Depășirea integrității', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Common Address', 'Adresă comună', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Dnp3 type', 'Tip Dnp3', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Event Buffer Size', 'Dimensiunea bufferului pentru evenimente', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Modbus type', 'Tip Modbus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Readable', 'Citibil', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Writeable', 'Scriere', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Iec104 type', 'Tip Iec104', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Back', 'Înapoi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Next', 'Următorul', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'COMMUNICATION NETWORK', 'REȚEA DE COMUNICARE', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Finish', 'Finalizarea', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Check connection details', 'Verificați detaliile conexiunii', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Connection Details', 'Detalii conexiune', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'GAS STATION MODEL', 'MODELUL GAZEI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Device List', 'Lista dispozitivelor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Device Form', 'Formular dispozitiv', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Item', 'Articol', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Station Address', 'Adresa stației', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'PAY', 'A PLATI', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'CHECK', 'VERIFICA', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Stream Details', 'Detalii flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'QMIN', 'QMIN', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'QMAX', 'QMAX', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'USE GC', 'USE GC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Saved!', 'Salvat!', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'DEFINED GAS STATION MODEL', 'MODEL DE GAZE DEFINIT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Capacity', 'Capacitate', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Group Name', 'Numele Grupului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'STREAMS', 'STREAMS', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Stream Modules List', 'Lista modulelor de flux', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Analyzer', 'Analizor', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'RTU/PLC', 'RTU / PLC', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Main Station', 'Statie principala', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Sub Station', 'Stație de metrou', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'REPORT', 'RAPORT', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Generate', 'Genera', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Failed to generate project', 'Generarea proiectului nu a reușit', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Station Details', 'Detalii stație', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'WebSocket is on', 'WebSocket este activat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'WebSocket is off', 'WebSocket este dezactivat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'WebSocket error observed', 'Eroare WebSocket observată', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Clear browser storage', 'Ștergeți spațiul de stocare al browserului', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'System statistics', 'Statistici de sistem', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Chatting', 'Chat', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Notifications', 'Notificări', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Sign-out', 'Sign out', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Hide top', 'Ascundeți partea de sus', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Are you sure you want to clear storage?', 'Sigur doriți să ștergeți spațiul de stocare?', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Press SHIFT+Q to return', 'Apăsați SHIFT + Q pentru a reveni', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Press SHIFT+W to return', 'Apăsați SHIFT + W pentru a reveni', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'You are about to logged out. Are you sure you want to proceed?', 'Sunteți pe cale să vă deconectați. Sigur doriți să continuați?', NEW.space_id, 'system_update', now(), 'system_update', now());

	INSERT INTO inscada.language(lang, key, value, space_id, insert_user, insert_dttm, version_user, version_dttm) VALUES
	('fr', 'January', 'Janvier', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'February', 'Février', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'March', 'Mars', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'April', 'Avril', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'May', 'Peut', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'June', 'Juin', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'July', 'Juillet', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'August', 'Août', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'September', 'Septembre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'October', 'Octobre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'November', 'Novembre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'December', 'Décembre', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Sunday', 'Dimanche', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Monday', 'Lundi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Tuesday', 'Mardi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Wednesday', 'Mercredi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Thursday', 'Jeudi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Friday', 'Vendredi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Saturday', 'Samedi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Today', 'Aujourd hui', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Clear', 'Dégager', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Hours', 'Les heures', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Minutes', 'Minutes', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('fr', 'Done', 'Fait', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'January', 'Styczeń', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'February', 'Luty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'March', 'Marsz', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'April', 'Kwiecień', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'May', 'Może', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'June', 'Czerwiec', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'July', 'Lipiec', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'August', 'Sierpień', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'September', 'Wrzesień', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'October', 'Październik', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'November', 'Listopad', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'December', 'Grudzień', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Sunday', 'Niedziela', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Monday', 'Poniedziałek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Tuesday', 'Wtorek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Wednesday', 'Środa', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Thursday', 'Czwartek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Friday', 'Piątek', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Saturday', 'Sobota', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Today', 'Dzisiaj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Clear', 'Jasny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Hours', 'Godziny', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Minutes', 'Minuty', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('pl', 'Done', 'Gotowy', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'January', 'Januari', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'February', 'Februari', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'March', 'Mars', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'April', 'April', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'May', 'Maj', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'June', 'Juni', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'July', 'Juli', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'August', 'Augusti', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'September', 'September', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'October', 'Oktober', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'November', 'November', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'December', 'December', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Sunday', 'Söndag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Monday', 'Måndag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Tuesday', 'Tisdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Wednesday', 'Onsdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Thursday', 'Torsdag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Friday', 'Fredag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Saturday', 'Lördag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Today', 'I dag', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Clear', 'Klar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Hours', 'Timmar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Minutes', 'Minuter', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('sv', 'Done', 'Gjort', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'January', 'Ianuarie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'February', 'Februarie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'March', 'Martie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'April', 'Aprilie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'May', 'Mai', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'June', 'Iunie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'July', 'Iulie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'August', 'August', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'September', 'Septembrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'October', 'Octombrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'November', 'Noiembrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'December', 'Decembrie', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Sunday', 'Duminică', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Monday', 'Luni', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Tuesday', 'Marţi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Wednesday', 'Miercuri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Thursday', 'Joi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Friday', 'Vineri', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Saturday', 'Sâmbătă', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Today', 'Astăzi', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Clear', 'Clar', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Hours', 'Ore', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Minutes', 'Minute', NEW.space_id, 'system_update', now(), 'system_update', now()),
	('ro', 'Done', 'Terminat', NEW.space_id, 'system_update', now(), 'system_update', now());

	RETURN NEW;
END;
$$;

CREATE trigger trg_insert_initial_space_data
AFTER INSERT on inscada.space
FOR EACH ROW EXECUTE PROCEDURE
  insert_initial_space_data();
