ALTER TABLE dnp3_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE modbus_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE s7_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE iec104_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE iec61850_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE mqtt_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE opc_ua_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE ethernet_ip_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE fatek_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE local_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE opc_da_variable ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;

ALTER TABLE dnp3_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE modbus_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE s7_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE iec104_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE iec61850_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE mqtt_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE opc_ua_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE ethernet_ip_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE fatek_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE local_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;
ALTER TABLE opc_da_variable_template ADD COLUMN writable_flag BOOLEAN NOT NULL DEFAULT TRUE;

DROP VIEW IF EXISTS variable;

-- Recreate variable view with isWritable columns
CREATE VIEW variable AS
-- DNP3 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM dnp3_variable v
JOIN dnp3_frame f ON v.frame_id = f.frame_id
JOIN dnp3_device d ON f.device_id = d.device_id
JOIN dnp3_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Modbus Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM modbus_variable v
JOIN modbus_frame f ON v.frame_id = f.frame_id
JOIN modbus_device d ON f.device_id = d.device_id
JOIN modbus_connection c ON d.conn_id = c.conn_id

UNION ALL

-- S7 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM s7_variable v
JOIN s7_frame f ON v.frame_id = f.frame_id
JOIN s7_device d ON f.device_id = d.device_id
JOIN s7_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC104 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM iec104_variable v
JOIN iec104_frame f ON v.frame_id = f.frame_id
JOIN iec104_device d ON f.device_id = d.device_id
JOIN iec104_connection c ON d.conn_id = c.conn_id

UNION ALL

-- IEC61850 Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM iec61850_variable v
JOIN iec61850_frame f ON v.frame_id = f.frame_id
JOIN iec61850_device d ON f.device_id = d.device_id
JOIN iec61850_connection c ON d.conn_id = c.conn_id

UNION ALL

-- MQTT Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM mqtt_variable v
JOIN mqtt_frame f ON v.frame_id = f.frame_id
JOIN mqtt_device d ON f.device_id = d.device_id
JOIN mqtt_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC UA Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM opc_ua_variable v
JOIN opc_ua_frame f ON v.frame_id = f.frame_id
JOIN opc_ua_device d ON f.device_id = d.device_id
JOIN opc_ua_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Ethernet IP Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM ethernet_ip_variable v
JOIN ethernet_ip_frame f ON v.frame_id = f.frame_id
JOIN ethernet_ip_device d ON f.device_id = d.device_id
JOIN ethernet_ip_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Fatek Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM fatek_variable v
JOIN fatek_frame f ON v.frame_id = f.frame_id
JOIN fatek_device d ON f.device_id = d.device_id
JOIN fatek_connection c ON d.conn_id = c.conn_id

UNION ALL

-- Local Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM local_variable v
JOIN local_frame f ON v.frame_id = f.frame_id
JOIN local_device d ON f.device_id = d.device_id
JOIN local_connection c ON d.conn_id = c.conn_id

UNION ALL

-- OPC DA Variables
SELECT
    v.variable_id,
    v.project_id,
    v.frame_id,
    v.space_id,
    v.insert_user,
    v.insert_dttm,
    v.version_user,
    v.version_dttm,
    v.deleted_dttm,
    v.deleted_user,
    v.name,
    v.dsc,
    v.code,
    v.value_expression_type,
    v.value_expression_id,
    v.value_expression,
    v.raw_zero_scale,
    v.raw_full_scale,
    v.eng_zero_scale,
    v.eng_full_scale,
    v.fractional_digit_count,
    v.unit,
    v.log_type,
    v.log_expression_id,
    v.log_expression,
    v.log_period,
    v.log_threshold,
    v.log_min_value,
    v.log_max_value,
    v.set_min_value,
    v.set_max_value,
    v.active_flag,
    v.writable_flag,
    v.pulse_on_flag,
    v.pulse_on_duration,
    v.pulse_off_flag,
    v.pulse_off_duration,
    v.keep_last_values,
    c.protocol as protocol
FROM opc_da_variable v
JOIN opc_da_frame f ON v.frame_id = f.frame_id
JOIN opc_da_device d ON f.device_id = d.device_id
JOIN opc_da_connection c ON d.conn_id = c.conn_id;
