INSERT INTO menus (menu_id, name, is_global, space_id, insert_user, insert_dttm)
VALUES ('114', 'App Email Settings', TRUE, NULL, 'system', NOW()),
       ('115', 'App SMS Settings', TRUE, NULL, 'system', NOW());

INSERT INTO inscada.menus (menu_id, name, is_global, space_id, insert_user, insert_dttm)
SELECT uuid(md5(m.name || '::' || s.space_id::text))::text AS menu_id, m.name,
       TRUE    AS is_global,
       s.space_id,
       'system' AS insert_user,
       NOW()    AS insert_dttm
FROM inscada.space s
         CROSS JOIN (VALUES ('App Email Settings'),
                            ('App SMS Settings')) AS m(name)
WHERE s.space_id is not null;

INSERT INTO inscada.role_menus (role_menu_id, role_id, menu_id, insert_dttm, insert_user)
SELECT uuid(md5(r.role_id || '::' || m.menu_id))::text AS role_menu_id, r.role_id,
       m.menu_id,
       CURRENT_TIMESTAMP AS insert_dttm,
       'system'          AS insert_user
FROM inscada.roles r
         JOIN inscada.menus m ON r.space_id = m.space_id
WHERE r.name = 'administrator'
  AND r.space_id IS NOT NULL
  AND m.name IN ('App Email Settings', 'App SMS Settings')
  -- exclude already existing assignments
  AND NOT EXISTS (SELECT 1
                  FROM inscada.role_menus rm
                  WHERE rm.role_id = r.role_id
                    AND rm.menu_id = m.menu_id);
