-- Rename existing tables to new dashboard naming
ALTER TABLE inscada.board RENAME TO dashboard;
ALTER TABLE inscada.board_group RENAME TO dashboard_group;

-- Apply column changes on the renamed tables
ALTER TABLE inscada.dashboard ALTER COLUMN config SET NOT NULL;
ALTER TABLE inscada.dashboard ALTER COLUMN header SET NOT NULL;
ALTER TABLE inscada.dashboard_group ALTER COLUMN color TYPE VARCHAR(7);

-- Migrate numeric type codes to enum string values
UPDATE inscada.dashboard SET type = 'Animation' WHERE type = '0';
UPDATE inscada.dashboard SET type = 'Trend'     WHERE type = '1';
UPDATE inscada.dashboard SET type = 'Alarm'     WHERE type = '2';
UPDATE inscada.dashboard SET type = 'Iframe'    WHERE type = '3';

-- Normalize existing Iframe dashboard configs to the new iframeUrl-based JSON shape
-- This effectively resets iframe dashboards, requiring explicit reconfiguration under the new
-- security model while ensuring config remains non-null and structurally consistent.
UPDATE inscada.dashboard
SET config = '{"iframeUrl":""}'
WHERE type = 'Iframe';
