CREATE TABLE inscada.trace_table
(
    trace_table_id serial not null
    constraint trace_table_id_pk
        primary key,
    project_id integer not null
     constraint trace_table_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name varchar(100) not null,
    config text not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
);

create unique index trace_table_project_id_name_uindex
    on trace_table (project_id, name);

INSERT INTO inscada.permissions(permission_id, name)
VALUES (172, 'VIEW_TRACE_TABLE'), (173, 'CREATE_TRACE_TABLE'), (174, 'UPDATE_TRACE_TABLE'), (175, 'DELETE_TRACE_TABLE'),
(176, 'EXPORT_TRACE_TABLE'), (177, 'IMPORT_TRACE_TABLE');

INSERT INTO inscada.role_permissions (role_id, permission_id)
VALUES (1,172), (1,173), (1,174), (1,175), (1,176), (1,177);

INSERT INTO inscada.menus (menu_id, name)
VALUES (51, 'Variable Trace'), (52, 'Variable Tracking');

INSERT INTO inscada.role_menus (role_id, menu_id)
VALUES (1, 51), (1, 52);

ALTER SEQUENCE trace_table_trace_table_id_seq INCREMENT 50;