create table custom_datasource
(
    custom_datasource_id serial    not null
        constraint custom_datasource_custom_datasource_id_pk
        primary key,
    project_id   integer      not null
        constraint custom_datasource_project_project_id_fk
        references project
        on update cascade on delete cascade,
    name         varchar(100) not null,
    dsc          varchar(255),
    url    text         not null,
    username      text,
    password      text,
    default_flag  boolean not null default false,

    space_id     integer      not null,
    insert_user  varchar(50)  not null,
    insert_dttm  timestamp with time zone not null,
    version_user varchar(50),
    version_dttm timestamp with time zone
)
;

create unique index custom_datasource_project_id_name_uindex
    on custom_datasource(project_id, name)
;

ALTER SEQUENCE custom_datasource_custom_datasource_id_seq RENAME TO custom_datasource_seq;

ALTER SEQUENCE custom_datasource_seq INCREMENT 50;

insert into inscada.permissions(permission_id, name)
values  (224, 'CREATE_CUSTOM_DATASOURCE'), (225, 'VIEW_CUSTOM_DATASOURCE'),
        (226, 'UPDATE_CUSTOM_DATASOURCE'), (227, 'DELETE_CUSTOM_DATASOURCE'),
        (228, 'EXPORT_CUSTOM_DATASOURCE'), (229, 'IMPORT_CUSTOM_DATASOURCE');

insert into inscada.role_permissions (role_id, permission_id)
values (1, 224), (1, 225), (1, 226), (1, 227), (1, 228), (1, 229);

update menus set name = 'Custom Datasource Dev' where name = 'Custom Query Dev';

update menus set name = 'Custom Query Dev' where name = 'Custom Table SQL';

