class InscadaApi {

  constructor(projectName) {
    this.projectName = projectName;
    this.sessionId = window.sessionId;
    this.activeSpace = window.activeSpace;
    this.url = window.serverUrl;
  }

  async call(method, ...args) {
    const response = await fetch(this.url + "/scripts/call-api", {
      method: 'POST',
      headers: { 'Content-Type': 'application/json', 'X-Space': this.activeSpace },
      credentials: 'include',
      body: JSON.stringify({ method: method, args: args, projectName: this.projectName, sessionId: this.sessionId })
    });
    if (!response.ok) throw new Error(await response.text());
    return response.json();
  }
  // --- ProjectApi ---
  getProjects(...args) { return this.call('getProjects', ...args); }
  getProject(...args) { return this.call('getProject', ...args); }
  updateProjectLocation(...args) { return this.call('updateProjectLocation', ...args); }
  // --- ConnectionApi ---
  startConnection(...args) { return this.call('startConnection', ...args); }
  stopConnection(...args) { return this.call('stopConnection', ...args); }
  updateConnection(...args) { return this.call('updateConnection', ...args); }
  getConnectionStatus(...args) { return this.call('getConnectionStatus', ...args); }
  getConnection(...args) { return this.call('getConnection', ...args); }
  updateDevice(...args) { return this.call('updateDevice', ...args); }
  updateFrame(...args) { return this.call('updateFrame', ...args); }
  // --- VariableApi ---
  getVariableValue(...args) { return this.call('getVariableValue', ...args); }
  getVariableValues(...args) { return this.call('getVariableValues', ...args); }
  getProjectVariableValues(...args) { return this.call('getProjectVariableValues', ...args); }
  setVariableValue(...args) { return this.call('setVariableValue', ...args); }
  setVariableValues(...args) { return this.call('setVariableValues', ...args); }
  mapVariableValue(...args) { return this.call('mapVariableValue', ...args); }
  toggleVariableValue(...args) { return this.call('toggleVariableValue', ...args); }
  getLoggedVariableValuesByPage(...args) { return this.call('getLoggedVariableValuesByPage', ...args); }
  getLoggedVariableValuesByPageAsc(...args) { return this.call('getLoggedVariableValuesByPageAsc', ...args); }
  getLoggedVariableValueStats(...args) { return this.call('getLoggedVariableValueStats', ...args); }
  getLoggedHourlyVariableValueStats(...args) { return this.call('getLoggedHourlyVariableValueStats', ...args); }
  getLoggedDailyVariableValueStats(...args) { return this.call('getLoggedDailyVariableValueStats', ...args); }
  getLoggedVariableValueStatsByInterval(...args) { return this.call('getLoggedVariableValueStatsByInterval', ...args); }
  getLoggedVariableNames(...args) { return this.call('getLoggedVariableNames', ...args); }
  getVariables(...args) { return this.call('getVariables', ...args); }
  getVariablesByConnectionName(...args) { return this.call('getVariablesByConnectionName', ...args); }
  getVariablesByDeviceName(...args) { return this.call('getVariablesByDeviceName', ...args); }
  getVariablesByFrameName(...args) { return this.call('getVariablesByFrameName', ...args); }
  getVariable(...args) { return this.call('getVariable', ...args); }
  updateVariable(...args) { return this.call('updateVariable', ...args); }
  // --- TrendApi ---
  getTrends(...args) { return this.call('getTrends', ...args); }
  getTrendTags(...args) { return this.call('getTrendTags', ...args); }
  setTrendTagMinMaxScale(...args) { return this.call('setTrendTagMinMaxScale', ...args); }
  // --- AlarmApi ---
  getAlarmGroup(...args) { return this.call('getAlarmGroup', ...args); }
  getAlarm(...args) { return this.call('getAlarm', ...args); }
  activateAlarmGroup(...args) { return this.call('activateAlarmGroup', ...args); }
  deactivateAlarmGroup(...args) { return this.call('deactivateAlarmGroup', ...args); }
  updateAlarm(...args) { return this.call('updateAlarm', ...args); }
  getAlarmStatus(...args) { return this.call('getAlarmStatus', ...args); }
  getAlarmGroupStatus(...args) { return this.call('getAlarmGroupStatus', ...args); }
  getLastFiredAlarm(...args) { return this.call('getLastFiredAlarm', ...args); }
  getLastFiredAlarms(...args) { return this.call('getLastFiredAlarms', ...args); }
  getLastFiredAlarmsByDate(...args) { return this.call('getLastFiredAlarmsByDate', ...args); }
  getAlarmLastFiredAlarms(...args) { return this.call('getAlarmLastFiredAlarms', ...args); }
  getAlarmLastFiredAlarmsByName(...args) { return this.call('getAlarmLastFiredAlarmsByName', ...args); }
  getLastFiredAlarmsByPartInPages(...args) { return this.call('getLastFiredAlarmsByPartInPages', ...args); }
  getLastOnFiredAlarmsInfoByGroupName(...args) { return this.call('getLastOnFiredAlarmsInfoByGroupName', ...args); }
  acknowledgeAlarm(...args) { return this.call('acknowledgeAlarm', ...args); }
  showAlarmSetValuesForm(...args) { return this.call('showAlarmSetValuesForm', ...args); }
  forceOffAlarm(...args) { return this.call('forceOffAlarm', ...args); }
  commentAlarm(...args) { return this.call('commentAlarm', ...args); }
  // --- ScriptApi ---
  getScript(...args) { return this.call('getScript', ...args); }
  getScriptStatus(...args) { return this.call('getScriptStatus', ...args); }
  scheduleScript(...args) { return this.call('scheduleScript', ...args); }
  cancelScript(...args) { return this.call('cancelScript', ...args); }
  executeScript(...args) { return this.call('executeScript', ...args); }
  getGlobalObject(...args) { return this.call('getGlobalObject', ...args); }
  setGlobalObject(...args) { return this.call('setGlobalObject', ...args); }
  // --- DataTransferApi ---
  scheduleDataTransfer(...args) { return this.call('scheduleDataTransfer', ...args); }
  cancelDataTransfer(...args) { return this.call('cancelDataTransfer', ...args); }
  getDataTransferStatus(...args) { return this.call('getDataTransferStatus', ...args); }
  // --- NotificationApi ---
  sendMail(...args) { return this.call('sendMail', ...args); }
  sendSMS(...args) { return this.call('sendSMS', ...args); }
  notify(...args) { return this.call('notify', ...args); }
  // --- MapApi ---
  sendMapFiredAlarmStatus(...args) { return this.call('sendMapFiredAlarmStatus', ...args); }
  sendMapData(...args) { return this.call('sendMapData', ...args); }
  setMapColor(...args) { return this.call('setMapColor', ...args); }
  drawMapLines(...args) { return this.call('drawMapLines', ...args); }
  // --- LogApi ---
  writeLog(...args) { return this.call('writeLog', ...args); }
  getLogsByPage(...args) { return this.call('getLogsByPage', ...args); }
  // --- UtilsApi ---
  uuid(...args) { return this.call('uuid', ...args); }
  getDate(...args) { return this.call('getDate', ...args); }
  now(...args) { return this.call('now', ...args); }
  getBit(...args) { return this.call('getBit', ...args); }
  setBit(...args) { return this.call('setBit', ...args); }
  leftPad(...args) { return this.call('leftPad', ...args); }
  formatNumber(...args) { return this.call('formatNumber', ...args); }
  rest(...args) { return this.call('rest', ...args); }
  runSql(...args) { return this.call('runSql', ...args); }
  runInfluxQL(...args) { return this.call('runInfluxQL', ...args); }
  getCustomQuerySql(...args) { return this.call('getCustomQuerySql', ...args); }
  getCustomSqlQuery(...args) { return this.call('getCustomSqlQuery', ...args); }
  getCustomInfluxQLQuery(...args) { return this.call('getCustomInfluxQLQuery', ...args); }
  loc(...args) { return this.call('loc', ...args); }
  javaArrayList(...args) { return this.call('javaArrayList', ...args); }
  ping(...args) { return this.call('ping', ...args); }
  toJSONStr(...args) { return this.call('toJSONStr', ...args); }
  numpad(...args) { return this.call('numpad', ...args); }
  customNumpad(...args) { return this.call('customNumpad', ...args); }
  customKeyboard(...args) { return this.call('customKeyboard', ...args); }
  setStringValue(...args) { return this.call('setStringValue', ...args); }
  customStringValue(...args) { return this.call('customStringValue', ...args); }
  sliderPad(...args) { return this.call('sliderPad', ...args); }
  confirm(...args) { return this.call('confirm', ...args); }
  playAudio(...args) { return this.call('playAudio', ...args); }
  setDayNightMode(...args) { return this.call('setDayNightMode', ...args); }
  consoleLog(...args) { return this.call('consoleLog', ...args); }
  objectEditor(...args) { return this.call('objectEditor', ...args); }
  setUiVisibility(...args) { return this.call('setUiVisibility', ...args); }
  writeToFile(...args) { return this.call('writeToFile', ...args); }
  readFile(...args) { return this.call('readFile', ...args); }
  refreshAllClients(...args) { return this.call('refreshAllClients', ...args); }
  reloadUi(...args) { return this.call('reloadUi', ...args); }
  getAllUsernames(...args) { return this.call('getAllUsernames', ...args); }
  saveKeyword(...args) { return this.call('saveKeyword', ...args); }
  getSpaceActiveUsers(...args) { return this.call('getSpaceActiveUsers', ...args); }
  switchUser(...args) { return this.call('switchUser', ...args); }
  toggleUiVisibility(...args) { return this.call('toggleUiVisibility', ...args); }
  closeConfirmPopup(...args) { return this.call('closeConfirmPopup', ...args); }
  // --- SystemApi ---
  getLastAuthAttempts(...args) { return this.call('getLastAuthAttempts', ...args); }
  getSystemRequests(...args) { return this.call('getSystemRequests', ...args); }
  deleteSystemRequest(...args) { return this.call('deleteSystemRequest', ...args); }
  getSystemStats(...args) { return this.call('getSystemStats', ...args); }
  shutdown(...args) { return this.call('shutdown', ...args); }
  restart(...args) { return this.call('restart', ...args); }
  setDateTime(...args) { return this.call('setDateTime', ...args); }
  exec(...args) { return this.call('exec', ...args); }
  // --- ReportApi ---
  getReportStatus(...args) { return this.call('getReportStatus', ...args); }
  scheduleReports(...args) { return this.call('scheduleReports', ...args); }
  cancelReports(...args) { return this.call('cancelReports', ...args); }
  scheduleReport(...args) { return this.call('scheduleReport', ...args); }
  cancelReport(...args) { return this.call('cancelReport', ...args); }
  mailReport(...args) { return this.call('mailReport', ...args); }
  mailJasperReport(...args) { return this.call('mailJasperReport', ...args); }
  mailJasperExcelReport(...args) { return this.call('mailJasperExcelReport', ...args); }
  exportJasperPdfToFile(...args) { return this.call('exportJasperPdfToFile', ...args); }
  exportJasperExcelToFile(...args) { return this.call('exportJasperExcelToFile', ...args); }
  exportJasperPdf(...args) { return this.call('exportJasperPdf', ...args); }
  exportJasperExcel(...args) { return this.call('exportJasperExcel', ...args); }
  exportJsPdf(...args) { return this.call('exportJsPdf', ...args); }
}