-- Migration Phase 3: Cleanup and finalize TABLE_PER_CLASS migration for ALL 11 protocols
-- Drop old tables and rename new ones for Connection, Device, Frame, and Variable hierarchies
-- Protocols: DNP3, Modbus, S7, IEC104, IEC61850, MQTT, OPC_UA, Ethernet_IP, Fatek, Local, OPC_DA

-- =============================================================================
-- STEP 1: Drop foreign key constraints that reference old tables
-- =============================================================================

-- Drop constraints from alarm tables that reference variables
ALTER TABLE alarm DROP CONSTRAINT IF EXISTS alarm_variable_off_time_variable_id_fk;
ALTER TABLE alarm DROP CONSTRAINT IF EXISTS alarm_variable_on_time_variable_id_fk;
ALTER TABLE digital_alarm DROP CONSTRAINT IF EXISTS digital_alarm_variable_a_variable_a_id_fk;
ALTER TABLE digital_alarm DROP CONSTRAINT IF EXISTS digital_alarm_variable_b_variable_b_id_fk;
ALTER TABLE analog_alarm DROP CONSTRAINT IF EXISTS analog_alarm_variable_variable_id_fk;

-- Drop constraints from data_transfer_detail that reference variables
ALTER TABLE data_transfer_detail DROP CONSTRAINT IF EXISTS data_transfer_detail_variable_source_var_id_fk;
ALTER TABLE data_transfer_detail DROP CONSTRAINT IF EXISTS data_transfer_detail_variable_target_var_id_fk;

-- Drop constraints from report_variable, trend_tag, and map_variable that reference variables
ALTER TABLE report_variable DROP CONSTRAINT IF EXISTS report_variable_variable_deviation_variable_id_fk;
ALTER TABLE report_variable DROP CONSTRAINT IF EXISTS report_variable_variable_total_variable_id_fk;
ALTER TABLE report_variable DROP CONSTRAINT IF EXISTS report_variable_variable_variable_id_fk;
ALTER TABLE trend_tag DROP CONSTRAINT IF EXISTS trend_tag_variable_variable_id_fk;
ALTER TABLE map_variable DROP CONSTRAINT IF EXISTS map_variable_variable_variable_id_fk;

-- Drop constraints between communication entities
ALTER TABLE variable DROP CONSTRAINT IF EXISTS variable_frame_frame_id_fk;
ALTER TABLE variable DROP CONSTRAINT IF EXISTS variable_project_project_id_fk;
ALTER TABLE variable DROP CONSTRAINT IF EXISTS variable_expression_value_expression_id_fk;
ALTER TABLE variable DROP CONSTRAINT IF EXISTS variable_expression_log_expression_id_fk;

ALTER TABLE frame DROP CONSTRAINT IF EXISTS frame_device_device_id_fk;
ALTER TABLE device DROP CONSTRAINT IF EXISTS device_connection_conn_id_fk;

-- =============================================================================
-- STEP 2: Drop all old subclass tables for ALL 11 protocols
-- =============================================================================

-- Variable subclass tables (11 protocols)
DROP TABLE IF EXISTS dnp3_variable CASCADE;
DROP TABLE IF EXISTS modbus_variable CASCADE;
DROP TABLE IF EXISTS s7_variable CASCADE;
DROP TABLE IF EXISTS iec104_variable CASCADE;
DROP TABLE IF EXISTS iec61850_variable CASCADE;
DROP TABLE IF EXISTS mqtt_variable CASCADE;
DROP TABLE IF EXISTS opc_ua_variable CASCADE;
DROP TABLE IF EXISTS ethernet_ip_variable CASCADE;
DROP TABLE IF EXISTS fatek_variable CASCADE;
DROP TABLE IF EXISTS local_variable CASCADE;
DROP TABLE IF EXISTS opc_da_variable CASCADE;

-- Frame subclass tables (11 protocols)
DROP TABLE IF EXISTS dnp3_frame CASCADE;
DROP TABLE IF EXISTS modbus_frame CASCADE;
DROP TABLE IF EXISTS s7_frame CASCADE;
DROP TABLE IF EXISTS iec104_frame CASCADE;
DROP TABLE IF EXISTS iec61850_frame CASCADE;
DROP TABLE IF EXISTS mqtt_frame CASCADE;
DROP TABLE IF EXISTS opc_ua_frame CASCADE;
DROP TABLE IF EXISTS ethernet_ip_frame CASCADE;
DROP TABLE IF EXISTS fatek_frame CASCADE;
DROP TABLE IF EXISTS local_frame CASCADE;
DROP TABLE IF EXISTS opc_da_frame CASCADE;

-- Device subclass tables (11 protocols)
DROP TABLE IF EXISTS dnp3_device CASCADE;
DROP TABLE IF EXISTS modbus_device CASCADE;
DROP TABLE IF EXISTS s7_device CASCADE;
DROP TABLE IF EXISTS iec104_device CASCADE;
DROP TABLE IF EXISTS iec61850_device CASCADE;
DROP TABLE IF EXISTS mqtt_device CASCADE;
DROP TABLE IF EXISTS opc_ua_device CASCADE;
DROP TABLE IF EXISTS ethernet_ip_device CASCADE;
DROP TABLE IF EXISTS fatek_device CASCADE;
DROP TABLE IF EXISTS local_device CASCADE;
DROP TABLE IF EXISTS opc_da_device CASCADE;

-- Connection subclass tables (11 protocols)
DROP TABLE IF EXISTS dnp3_connection CASCADE;
DROP TABLE IF EXISTS modbus_connection CASCADE;
DROP TABLE IF EXISTS s7_connection CASCADE;
DROP TABLE IF EXISTS iec104_connection CASCADE;
DROP TABLE IF EXISTS iec61850_connection CASCADE;
DROP TABLE IF EXISTS mqtt_connection CASCADE;
DROP TABLE IF EXISTS opc_ua_connection CASCADE;
DROP TABLE IF EXISTS ethernet_ip_connection CASCADE;
DROP TABLE IF EXISTS fatek_connection CASCADE;
DROP TABLE IF EXISTS local_connection CASCADE;
DROP TABLE IF EXISTS opc_da_connection CASCADE;

-- =============================================================================
-- STEP 3: Drop old base tables (only after all subclass tables are dropped)
-- =============================================================================

DROP TABLE IF EXISTS variable CASCADE;
DROP TABLE IF EXISTS frame CASCADE;
DROP TABLE IF EXISTS device CASCADE;
DROP TABLE IF EXISTS connection CASCADE;

-- =============================================================================
-- STEP 4: Rename new tables to final names for ALL 11 protocols
-- =============================================================================

-- Rename connection tables (11 protocols)
ALTER TABLE dnp3_connection_new RENAME TO dnp3_connection;
ALTER TABLE modbus_connection_new RENAME TO modbus_connection;
ALTER TABLE s7_connection_new RENAME TO s7_connection;
ALTER TABLE iec104_connection_new RENAME TO iec104_connection;
ALTER TABLE iec61850_connection_new RENAME TO iec61850_connection;
ALTER TABLE mqtt_connection_new RENAME TO mqtt_connection;
ALTER TABLE opc_ua_connection_new RENAME TO opc_ua_connection;
ALTER TABLE ethernet_ip_connection_new RENAME TO ethernet_ip_connection;
ALTER TABLE fatek_connection_new RENAME TO fatek_connection;
ALTER TABLE local_connection_new RENAME TO local_connection;
ALTER TABLE opc_da_connection_new RENAME TO opc_da_connection;

-- Rename device tables (11 protocols)
ALTER TABLE dnp3_device_new RENAME TO dnp3_device;
ALTER TABLE modbus_device_new RENAME TO modbus_device;
ALTER TABLE s7_device_new RENAME TO s7_device;
ALTER TABLE iec104_device_new RENAME TO iec104_device;
ALTER TABLE iec61850_device_new RENAME TO iec61850_device;
ALTER TABLE mqtt_device_new RENAME TO mqtt_device;
ALTER TABLE opc_ua_device_new RENAME TO opc_ua_device;
ALTER TABLE ethernet_ip_device_new RENAME TO ethernet_ip_device;
ALTER TABLE fatek_device_new RENAME TO fatek_device;
ALTER TABLE local_device_new RENAME TO local_device;
ALTER TABLE opc_da_device_new RENAME TO opc_da_device;

-- Rename frame tables (11 protocols)
ALTER TABLE dnp3_frame_new RENAME TO dnp3_frame;
ALTER TABLE modbus_frame_new RENAME TO modbus_frame;
ALTER TABLE s7_frame_new RENAME TO s7_frame;
ALTER TABLE iec104_frame_new RENAME TO iec104_frame;
ALTER TABLE iec61850_frame_new RENAME TO iec61850_frame;
ALTER TABLE mqtt_frame_new RENAME TO mqtt_frame;
ALTER TABLE opc_ua_frame_new RENAME TO opc_ua_frame;
ALTER TABLE ethernet_ip_frame_new RENAME TO ethernet_ip_frame;
ALTER TABLE fatek_frame_new RENAME TO fatek_frame;
ALTER TABLE local_frame_new RENAME TO local_frame;
ALTER TABLE opc_da_frame_new RENAME TO opc_da_frame;

-- Rename variable tables (11 protocols)
ALTER TABLE dnp3_variable_new RENAME TO dnp3_variable;
ALTER TABLE modbus_variable_new RENAME TO modbus_variable;
ALTER TABLE s7_variable_new RENAME TO s7_variable;
ALTER TABLE iec104_variable_new RENAME TO iec104_variable;
ALTER TABLE iec61850_variable_new RENAME TO iec61850_variable;
ALTER TABLE mqtt_variable_new RENAME TO mqtt_variable;
ALTER TABLE opc_ua_variable_new RENAME TO opc_ua_variable;
ALTER TABLE ethernet_ip_variable_new RENAME TO ethernet_ip_variable;
ALTER TABLE fatek_variable_new RENAME TO fatek_variable;
ALTER TABLE local_variable_new RENAME TO local_variable;
ALTER TABLE opc_da_variable_new RENAME TO opc_da_variable;

-- =============================================================================
-- STEP 5: Create optimized indexes for ALL 11 protocols
-- =============================================================================

-- Connection indexes (11 protocols)
CREATE INDEX idx_dnp3_connection_project ON dnp3_connection(project_id);
CREATE INDEX idx_dnp3_connection_space ON dnp3_connection(space_id);
CREATE INDEX idx_dnp3_connection_owner ON dnp3_connection(owner_id);
CREATE INDEX idx_dnp3_connection_name ON dnp3_connection(project_id, name);

CREATE INDEX idx_modbus_connection_project ON modbus_connection(project_id);
CREATE INDEX idx_modbus_connection_space ON modbus_connection(space_id);
CREATE INDEX idx_modbus_connection_owner ON modbus_connection(owner_id);
CREATE INDEX idx_modbus_connection_name ON modbus_connection(project_id, name);

CREATE INDEX idx_s7_connection_project ON s7_connection(project_id);
CREATE INDEX idx_s7_connection_space ON s7_connection(space_id);
CREATE INDEX idx_s7_connection_owner ON s7_connection(owner_id);
CREATE INDEX idx_s7_connection_name ON s7_connection(project_id, name);

CREATE INDEX idx_iec104_connection_project ON iec104_connection(project_id);
CREATE INDEX idx_iec104_connection_space ON iec104_connection(space_id);
CREATE INDEX idx_iec104_connection_owner ON iec104_connection(owner_id);
CREATE INDEX idx_iec104_connection_name ON iec104_connection(project_id, name);

CREATE INDEX idx_iec61850_connection_project ON iec61850_connection(project_id);
CREATE INDEX idx_iec61850_connection_space ON iec61850_connection(space_id);
CREATE INDEX idx_iec61850_connection_owner ON iec61850_connection(owner_id);
CREATE INDEX idx_iec61850_connection_name ON iec61850_connection(project_id, name);

CREATE INDEX idx_mqtt_connection_project ON mqtt_connection(project_id);
CREATE INDEX idx_mqtt_connection_space ON mqtt_connection(space_id);
CREATE INDEX idx_mqtt_connection_owner ON mqtt_connection(owner_id);
CREATE INDEX idx_mqtt_connection_name ON mqtt_connection(project_id, name);

CREATE INDEX idx_opc_ua_connection_project ON opc_ua_connection(project_id);
CREATE INDEX idx_opc_ua_connection_space ON opc_ua_connection(space_id);
CREATE INDEX idx_opc_ua_connection_owner ON opc_ua_connection(owner_id);
CREATE INDEX idx_opc_ua_connection_name ON opc_ua_connection(project_id, name);

CREATE INDEX idx_ethernet_ip_connection_project ON ethernet_ip_connection(project_id);
CREATE INDEX idx_ethernet_ip_connection_space ON ethernet_ip_connection(space_id);
CREATE INDEX idx_ethernet_ip_connection_owner ON ethernet_ip_connection(owner_id);
CREATE INDEX idx_ethernet_ip_connection_name ON ethernet_ip_connection(project_id, name);

CREATE INDEX idx_fatek_connection_project ON fatek_connection(project_id);
CREATE INDEX idx_fatek_connection_space ON fatek_connection(space_id);
CREATE INDEX idx_fatek_connection_owner ON fatek_connection(owner_id);
CREATE INDEX idx_fatek_connection_name ON fatek_connection(project_id, name);

CREATE INDEX idx_local_connection_project ON local_connection(project_id);
CREATE INDEX idx_local_connection_space ON local_connection(space_id);
CREATE INDEX idx_local_connection_owner ON local_connection(owner_id);
CREATE INDEX idx_local_connection_name ON local_connection(project_id, name);

CREATE INDEX idx_opc_da_connection_project ON opc_da_connection(project_id);
CREATE INDEX idx_opc_da_connection_space ON opc_da_connection(space_id);
CREATE INDEX idx_opc_da_connection_owner ON opc_da_connection(owner_id);
CREATE INDEX idx_opc_da_connection_name ON opc_da_connection(project_id, name);

-- Device indexes (11 protocols)
CREATE INDEX idx_dnp3_device_conn ON dnp3_device(conn_id);
CREATE INDEX idx_dnp3_device_space ON dnp3_device(space_id);
CREATE INDEX idx_dnp3_device_name ON dnp3_device(conn_id, name);

CREATE INDEX idx_modbus_device_conn ON modbus_device(conn_id);
CREATE INDEX idx_modbus_device_space ON modbus_device(space_id);
CREATE INDEX idx_modbus_device_name ON modbus_device(conn_id, name);

CREATE INDEX idx_s7_device_conn ON s7_device(conn_id);
CREATE INDEX idx_s7_device_space ON s7_device(space_id);
CREATE INDEX idx_s7_device_name ON s7_device(conn_id, name);

CREATE INDEX idx_iec104_device_conn ON iec104_device(conn_id);
CREATE INDEX idx_iec104_device_space ON iec104_device(space_id);
CREATE INDEX idx_iec104_device_name ON iec104_device(conn_id, name);

CREATE INDEX idx_iec61850_device_conn ON iec61850_device(conn_id);
CREATE INDEX idx_iec61850_device_space ON iec61850_device(space_id);
CREATE INDEX idx_iec61850_device_name ON iec61850_device(conn_id, name);

CREATE INDEX idx_mqtt_device_conn ON mqtt_device(conn_id);
CREATE INDEX idx_mqtt_device_space ON mqtt_device(space_id);
CREATE INDEX idx_mqtt_device_name ON mqtt_device(conn_id, name);

CREATE INDEX idx_opc_ua_device_conn ON opc_ua_device(conn_id);
CREATE INDEX idx_opc_ua_device_space ON opc_ua_device(space_id);
CREATE INDEX idx_opc_ua_device_name ON opc_ua_device(conn_id, name);

CREATE INDEX idx_ethernet_ip_device_conn ON ethernet_ip_device(conn_id);
CREATE INDEX idx_ethernet_ip_device_space ON ethernet_ip_device(space_id);
CREATE INDEX idx_ethernet_ip_device_name ON ethernet_ip_device(conn_id, name);

CREATE INDEX idx_fatek_device_conn ON fatek_device(conn_id);
CREATE INDEX idx_fatek_device_space ON fatek_device(space_id);
CREATE INDEX idx_fatek_device_name ON fatek_device(conn_id, name);

CREATE INDEX idx_local_device_conn ON local_device(conn_id);
CREATE INDEX idx_local_device_space ON local_device(space_id);
CREATE INDEX idx_local_device_name ON local_device(conn_id, name);

CREATE INDEX idx_opc_da_device_conn ON opc_da_device(conn_id);
CREATE INDEX idx_opc_da_device_space ON opc_da_device(space_id);
CREATE INDEX idx_opc_da_device_name ON opc_da_device(conn_id, name);

-- Frame indexes (11 protocols)
CREATE INDEX idx_dnp3_frame_device ON dnp3_frame(device_id);
CREATE INDEX idx_dnp3_frame_space ON dnp3_frame(space_id);
CREATE INDEX idx_dnp3_frame_name ON dnp3_frame(device_id, name);

CREATE INDEX idx_modbus_frame_device ON modbus_frame(device_id);
CREATE INDEX idx_modbus_frame_space ON modbus_frame(space_id);
CREATE INDEX idx_modbus_frame_name ON modbus_frame(device_id, name);

CREATE INDEX idx_s7_frame_device ON s7_frame(device_id);
CREATE INDEX idx_s7_frame_space ON s7_frame(space_id);
CREATE INDEX idx_s7_frame_name ON s7_frame(device_id, name);

CREATE INDEX idx_iec104_frame_device ON iec104_frame(device_id);
CREATE INDEX idx_iec104_frame_space ON iec104_frame(space_id);
CREATE INDEX idx_iec104_frame_name ON iec104_frame(device_id, name);

CREATE INDEX idx_iec61850_frame_device ON iec61850_frame(device_id);
CREATE INDEX idx_iec61850_frame_space ON iec61850_frame(space_id);
CREATE INDEX idx_iec61850_frame_name ON iec61850_frame(device_id, name);

CREATE INDEX idx_mqtt_frame_device ON mqtt_frame(device_id);
CREATE INDEX idx_mqtt_frame_space ON mqtt_frame(space_id);
CREATE INDEX idx_mqtt_frame_name ON mqtt_frame(device_id, name);

CREATE INDEX idx_opc_ua_frame_device ON opc_ua_frame(device_id);
CREATE INDEX idx_opc_ua_frame_space ON opc_ua_frame(space_id);
CREATE INDEX idx_opc_ua_frame_name ON opc_ua_frame(device_id, name);

CREATE INDEX idx_ethernet_ip_frame_device ON ethernet_ip_frame(device_id);
CREATE INDEX idx_ethernet_ip_frame_space ON ethernet_ip_frame(space_id);
CREATE INDEX idx_ethernet_ip_frame_name ON ethernet_ip_frame(device_id, name);

CREATE INDEX idx_fatek_frame_device ON fatek_frame(device_id);
CREATE INDEX idx_fatek_frame_space ON fatek_frame(space_id);
CREATE INDEX idx_fatek_frame_name ON fatek_frame(device_id, name);

CREATE INDEX idx_local_frame_device ON local_frame(device_id);
CREATE INDEX idx_local_frame_space ON local_frame(space_id);
CREATE INDEX idx_local_frame_name ON local_frame(device_id, name);

CREATE INDEX idx_opc_da_frame_device ON opc_da_frame(device_id);
CREATE INDEX idx_opc_da_frame_space ON opc_da_frame(space_id);
CREATE INDEX idx_opc_da_frame_name ON opc_da_frame(device_id, name);

-- Variable indexes (11 protocols)
CREATE INDEX idx_dnp3_variable_project ON dnp3_variable(project_id);
CREATE INDEX idx_dnp3_variable_frame ON dnp3_variable(frame_id);
CREATE INDEX idx_dnp3_variable_space ON dnp3_variable(space_id);
CREATE INDEX idx_dnp3_variable_name ON dnp3_variable(project_id, name);

CREATE INDEX idx_modbus_variable_project ON modbus_variable(project_id);
CREATE INDEX idx_modbus_variable_frame ON modbus_variable(frame_id);
CREATE INDEX idx_modbus_variable_space ON modbus_variable(space_id);
CREATE INDEX idx_modbus_variable_name ON modbus_variable(project_id, name);

CREATE INDEX idx_s7_variable_project ON s7_variable(project_id);
CREATE INDEX idx_s7_variable_frame ON s7_variable(frame_id);
CREATE INDEX idx_s7_variable_space ON s7_variable(space_id);
CREATE INDEX idx_s7_variable_name ON s7_variable(project_id, name);

CREATE INDEX idx_iec104_variable_project ON iec104_variable(project_id);
CREATE INDEX idx_iec104_variable_frame ON iec104_variable(frame_id);
CREATE INDEX idx_iec104_variable_space ON iec104_variable(space_id);
CREATE INDEX idx_iec104_variable_name ON iec104_variable(project_id, name);

CREATE INDEX idx_iec61850_variable_project ON iec61850_variable(project_id);
CREATE INDEX idx_iec61850_variable_frame ON iec61850_variable(frame_id);
CREATE INDEX idx_iec61850_variable_space ON iec61850_variable(space_id);
CREATE INDEX idx_iec61850_variable_name ON iec61850_variable(project_id, name);

CREATE INDEX idx_mqtt_variable_project ON mqtt_variable(project_id);
CREATE INDEX idx_mqtt_variable_frame ON mqtt_variable(frame_id);
CREATE INDEX idx_mqtt_variable_space ON mqtt_variable(space_id);
CREATE INDEX idx_mqtt_variable_name ON mqtt_variable(project_id, name);

CREATE INDEX idx_opc_ua_variable_project ON opc_ua_variable(project_id);
CREATE INDEX idx_opc_ua_variable_frame ON opc_ua_variable(frame_id);
CREATE INDEX idx_opc_ua_variable_space ON opc_ua_variable(space_id);
CREATE INDEX idx_opc_ua_variable_name ON opc_ua_variable(project_id, name);

CREATE INDEX idx_ethernet_ip_variable_project ON ethernet_ip_variable(project_id);
CREATE INDEX idx_ethernet_ip_variable_frame ON ethernet_ip_variable(frame_id);
CREATE INDEX idx_ethernet_ip_variable_space ON ethernet_ip_variable(space_id);
CREATE INDEX idx_ethernet_ip_variable_name ON ethernet_ip_variable(project_id, name);

CREATE INDEX idx_fatek_variable_project ON fatek_variable(project_id);
CREATE INDEX idx_fatek_variable_frame ON fatek_variable(frame_id);
CREATE INDEX idx_fatek_variable_space ON fatek_variable(space_id);
CREATE INDEX idx_fatek_variable_name ON fatek_variable(project_id, name);

CREATE INDEX idx_local_variable_project ON local_variable(project_id);
CREATE INDEX idx_local_variable_frame ON local_variable(frame_id);
CREATE INDEX idx_local_variable_space ON local_variable(space_id);
CREATE INDEX idx_local_variable_name ON local_variable(project_id, name);

CREATE INDEX idx_opc_da_variable_project ON opc_da_variable(project_id);
CREATE INDEX idx_opc_da_variable_frame ON opc_da_variable(frame_id);
CREATE INDEX idx_opc_da_variable_space ON opc_da_variable(space_id);
CREATE INDEX idx_opc_da_variable_name ON opc_da_variable(project_id, name);

-- =============================================================================
-- TEMPLATE TABLE INDEXES - ALL 11 PROTOCOLS
-- =============================================================================

-- Device template indexes (11 protocols)
CREATE INDEX idx_dnp3_device_template_space ON dnp3_device_template(space_id);
CREATE INDEX idx_dnp3_device_template_name ON dnp3_device_template(name);

CREATE INDEX idx_modbus_device_template_space ON modbus_device_template(space_id);
CREATE INDEX idx_modbus_device_template_name ON modbus_device_template(name);

CREATE INDEX idx_s7_device_template_space ON s7_device_template(space_id);
CREATE INDEX idx_s7_device_template_name ON s7_device_template(name);

CREATE INDEX idx_iec104_device_template_space ON iec104_device_template(space_id);
CREATE INDEX idx_iec104_device_template_name ON iec104_device_template(name);

CREATE INDEX idx_iec61850_device_template_space ON iec61850_device_template(space_id);
CREATE INDEX idx_iec61850_device_template_name ON iec61850_device_template(name);

CREATE INDEX idx_mqtt_device_template_space ON mqtt_device_template(space_id);
CREATE INDEX idx_mqtt_device_template_name ON mqtt_device_template(name);

CREATE INDEX idx_opc_ua_device_template_space ON opc_ua_device_template(space_id);
CREATE INDEX idx_opc_ua_device_template_name ON opc_ua_device_template(name);

CREATE INDEX idx_ethernet_ip_device_template_space ON ethernet_ip_device_template(space_id);
CREATE INDEX idx_ethernet_ip_device_template_name ON ethernet_ip_device_template(name);

CREATE INDEX idx_fatek_device_template_space ON fatek_device_template(space_id);
CREATE INDEX idx_fatek_device_template_name ON fatek_device_template(name);

CREATE INDEX idx_local_device_template_space ON local_device_template(space_id);
CREATE INDEX idx_local_device_template_name ON local_device_template(name);

CREATE INDEX idx_opc_da_device_template_space ON opc_da_device_template(space_id);
CREATE INDEX idx_opc_da_device_template_name ON opc_da_device_template(name);

-- Frame template indexes (11 protocols)
CREATE INDEX idx_dnp3_frame_template_device ON dnp3_frame_template(device_id);
CREATE INDEX idx_dnp3_frame_template_space ON dnp3_frame_template(space_id);
CREATE INDEX idx_dnp3_frame_template_name ON dnp3_frame_template(device_id, name);

CREATE INDEX idx_modbus_frame_template_device ON modbus_frame_template(device_id);
CREATE INDEX idx_modbus_frame_template_space ON modbus_frame_template(space_id);
CREATE INDEX idx_modbus_frame_template_name ON modbus_frame_template(device_id, name);

CREATE INDEX idx_s7_frame_template_device ON s7_frame_template(device_id);
CREATE INDEX idx_s7_frame_template_space ON s7_frame_template(space_id);
CREATE INDEX idx_s7_frame_template_name ON s7_frame_template(device_id, name);

CREATE INDEX idx_iec104_frame_template_device ON iec104_frame_template(device_id);
CREATE INDEX idx_iec104_frame_template_space ON iec104_frame_template(space_id);
CREATE INDEX idx_iec104_frame_template_name ON iec104_frame_template(device_id, name);

CREATE INDEX idx_iec61850_frame_template_device ON iec61850_frame_template(device_id);
CREATE INDEX idx_iec61850_frame_template_space ON iec61850_frame_template(space_id);
CREATE INDEX idx_iec61850_frame_template_name ON iec61850_frame_template(device_id, name);

CREATE INDEX idx_mqtt_frame_template_device ON mqtt_frame_template(device_id);
CREATE INDEX idx_mqtt_frame_template_space ON mqtt_frame_template(space_id);
CREATE INDEX idx_mqtt_frame_template_name ON mqtt_frame_template(device_id, name);

CREATE INDEX idx_opc_ua_frame_template_device ON opc_ua_frame_template(device_id);
CREATE INDEX idx_opc_ua_frame_template_space ON opc_ua_frame_template(space_id);
CREATE INDEX idx_opc_ua_frame_template_name ON opc_ua_frame_template(device_id, name);

CREATE INDEX idx_ethernet_ip_frame_template_device ON ethernet_ip_frame_template(device_id);
CREATE INDEX idx_ethernet_ip_frame_template_space ON ethernet_ip_frame_template(space_id);
CREATE INDEX idx_ethernet_ip_frame_template_name ON ethernet_ip_frame_template(device_id, name);

CREATE INDEX idx_fatek_frame_template_device ON fatek_frame_template(device_id);
CREATE INDEX idx_fatek_frame_template_space ON fatek_frame_template(space_id);
CREATE INDEX idx_fatek_frame_template_name ON fatek_frame_template(device_id, name);

CREATE INDEX idx_local_frame_template_device ON local_frame_template(device_id);
CREATE INDEX idx_local_frame_template_space ON local_frame_template(space_id);
CREATE INDEX idx_local_frame_template_name ON local_frame_template(device_id, name);

CREATE INDEX idx_opc_da_frame_template_device ON opc_da_frame_template(device_id);
CREATE INDEX idx_opc_da_frame_template_space ON opc_da_frame_template(space_id);
CREATE INDEX idx_opc_da_frame_template_name ON opc_da_frame_template(device_id, name);

-- Variable template indexes (11 protocols)
CREATE INDEX idx_dnp3_variable_template_frame ON dnp3_variable_template(frame_id);
CREATE INDEX idx_dnp3_variable_template_space ON dnp3_variable_template(space_id);
CREATE INDEX idx_dnp3_variable_template_name ON dnp3_variable_template(name);

CREATE INDEX idx_modbus_variable_template_frame ON modbus_variable_template(frame_id);
CREATE INDEX idx_modbus_variable_template_space ON modbus_variable_template(space_id);
CREATE INDEX idx_modbus_variable_template_name ON modbus_variable_template(name);

CREATE INDEX idx_s7_variable_template_frame ON s7_variable_template(frame_id);
CREATE INDEX idx_s7_variable_template_space ON s7_variable_template(space_id);
CREATE INDEX idx_s7_variable_template_name ON s7_variable_template(name);

CREATE INDEX idx_iec104_variable_template_frame ON iec104_variable_template(frame_id);
CREATE INDEX idx_iec104_variable_template_space ON iec104_variable_template(space_id);
CREATE INDEX idx_iec104_variable_template_name ON iec104_variable_template(name);

CREATE INDEX idx_iec61850_variable_template_frame ON iec61850_variable_template(frame_id);
CREATE INDEX idx_iec61850_variable_template_space ON iec61850_variable_template(space_id);
CREATE INDEX idx_iec61850_variable_template_name ON iec61850_variable_template(name);

CREATE INDEX idx_mqtt_variable_template_frame ON mqtt_variable_template(frame_id);
CREATE INDEX idx_mqtt_variable_template_space ON mqtt_variable_template(space_id);
CREATE INDEX idx_mqtt_variable_template_name ON mqtt_variable_template(name);

CREATE INDEX idx_opc_ua_variable_template_frame ON opc_ua_variable_template(frame_id);
CREATE INDEX idx_opc_ua_variable_template_space ON opc_ua_variable_template(space_id);
CREATE INDEX idx_opc_ua_variable_template_name ON opc_ua_variable_template(name);

CREATE INDEX idx_ethernet_ip_variable_template_frame ON ethernet_ip_variable_template(frame_id);
CREATE INDEX idx_ethernet_ip_variable_template_space ON ethernet_ip_variable_template(space_id);
CREATE INDEX idx_ethernet_ip_variable_template_name ON ethernet_ip_variable_template(name);

CREATE INDEX idx_fatek_variable_template_frame ON fatek_variable_template(frame_id);
CREATE INDEX idx_fatek_variable_template_space ON fatek_variable_template(space_id);
CREATE INDEX idx_fatek_variable_template_name ON fatek_variable_template(name);

CREATE INDEX idx_local_variable_template_frame ON local_variable_template(frame_id);
CREATE INDEX idx_local_variable_template_space ON local_variable_template(space_id);
CREATE INDEX idx_local_variable_template_name ON local_variable_template(name);

CREATE INDEX idx_opc_da_variable_template_frame ON opc_da_variable_template(frame_id);
CREATE INDEX idx_opc_da_variable_template_space ON opc_da_variable_template(space_id);
CREATE INDEX idx_opc_da_variable_template_name ON opc_da_variable_template(name);
