DROP INDEX IF EXISTS custom_menu_space_id_parent_id_name_uindex;

-- First, create a temporary table to store duplicates
CREATE TEMPORARY TABLE duplicate_menus AS
SELECT space_id, name, COUNT(*), array_agg(custom_menu_id ORDER BY custom_menu_id) as ids
FROM custom_menu
GROUP BY space_id, name
HAVING COUNT(*) > 1;

-- Update duplicate names by appending a number
WITH RECURSIVE numbered_duplicates AS (
    SELECT
        dm.space_id,
        dm.name as original_name,
        unnest(dm.ids) as custom_menu_id,
        generate_series(1, array_length(dm.ids, 1)) as seq
    FROM duplicate_menus dm
)
UPDATE custom_menu cm
SET name = nd.original_name || '_' || nd.seq
FROM numbered_duplicates nd
WHERE cm.custom_menu_id = nd.custom_menu_id
AND cm.custom_menu_id != (
    -- Keep the original name for the oldest record (lowest ID)
    SELECT MIN(custom_menu_id)
    FROM numbered_duplicates nd2
    WHERE nd2.space_id = nd.space_id
    AND nd2.original_name = nd.original_name
);

-- Drop temporary table
DROP TABLE duplicate_menus;

-- Now create the unique index
CREATE UNIQUE INDEX custom_menu_space_id_name_uindex
ON custom_menu(space_id, name);
