create table inscada.custom_sql_datasource
(
    custom_datasource_id  integer not null primary key,
    default_flag boolean not null default false
);

create table inscada.custom_influxdb_datasource
(
    custom_datasource_id integer not null primary key,
    db varchar(50),
    default_flag boolean not null default false
);

create table inscada.custom_sql_query
(
    custom_query_id integer not null primary key
);

create table inscada.custom_influxdb_query
(
    custom_query_id integer not null primary key
);

insert into inscada.custom_sql_query(custom_query_id)
select custom_query_id from inscada.custom_query;

insert into inscada.custom_sql_datasource(custom_datasource_id, default_flag)
select custom_datasource_id, default_flag from inscada.custom_datasource;

alter table inscada.custom_datasource drop column default_flag;

update inscada.permissions set name = 'RUN_QUERY' where permission_id = 199;

update menus set name = 'Custom SQL Database' where name = 'Custom Database';
update menus set name = 'Custom SQL Datasource Dev' where name = 'Custom Datasource Dev';
update menus set name = 'Custom SQL Query Dev' where name = 'Custom Query Dev';

insert into inscada.menus (menu_id, name) values (94, 'Custom SQL Databases');
insert into inscada.menus (menu_id, name) values (95, 'Custom InfluxDB Databases');
insert into inscada.menus (menu_id, name) values (96, 'Custom InfluxDB Datasource Dev');
insert into inscada.menus (menu_id, name) values (97, 'Custom InfluxDB Query Dev');

----------below, inserts symbol permissions and menu into all roles ------------------
do
$$
declare
    r record;
begin
    for r in select role_id from roles
    loop
    insert into inscada.role_menus (role_id, menu_id) values (r.role_id, 94), (r.role_id, 95), (r.role_id, 96),
            (r.role_id, 97) on conflict do nothing;
    end loop;
end;
$$;
---------------------------end of loop-----------------------------