create table logo_settings
(
    logo_settings_id serial not null constraint logo_settings_logo_settings_id_pk primary key,
    height     int,
    image      bytea,

    insert_user     varchar(50),
    insert_dttm     timestamp with time zone,
    version_user    varchar(50),
    version_dttm    timestamp with time zone,
    space_id        int
);

insert into inscada.permissions(permission_id, name)
values (243, 'VIEW_LOGO_SETTINGS'), (244, 'UPDATE_LOGO_SETTINGS');

insert into inscada.menus (menu_id, name)
values  (89, 'Logo Settings');

----------below, inserts logo_settings permissions and menu into all roles ------------------
do
$$
declare
    r record;
begin
    for r in select role_id from roles
    loop
    insert into inscada.role_permissions (role_id, permission_id)
    values (r.role_id, 243), (r.role_id, 244) on conflict do nothing;

    insert into inscada.role_menus (role_id, menu_id) values (r.role_id, 89) on conflict do nothing;
    end loop;
end;
$$;
---------------------------end of loop-----------------------------

----------below, inserts logo_settings data into all spaces ------------------
do
$$
declare
    r record;
begin
    for r in select space_id from space
    loop

    insert into inscada.logo_settings(height, insert_user, insert_dttm, space_id)
    values (70, 'inscada', now(), r.space_id) on conflict do nothing;

    end loop;
end;
$$;
---------------------------end of loop-----------------------------

CREATE
OR REPLACE FUNCTION insert_initial_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
insert into inscada.mail_settings(smtp_host, smtp_port, protocol, username, password, insert_user, insert_dttm,
                                  space_id)
select 'mail.inscada.com',
       25,
       'SMTP',
       'inscada',
       '',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'dataport', true, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'twilio', false, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'netgsm', false, 'inscada', now(), NEW.space_id;

insert into inscada.broadcast_settings(server_ip_addr, insert_user, insert_dttm, space_id)
select 'https://www.inscada.com', 'inscada', now(), NEW.space_id;

insert into inscada.map_settings(map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
select 'pk.eyJ1IjoieXJ5c2t1bCIsImEiOiJjazc0ZDc0NmswMnlvM2ptdnRqaW4ya3IxIn0.9YN8pWOfuz19ILnJy311ww',
       'd1a6442a2d89164ee9cc3d3a9c9c7ed3',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.custom_table_settings(url, username, password, insert_user, insert_dttm, space_id)
select 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(), NEW.space_id;

insert into inscada.logo_settings(height, insert_user, insert_dttm, space_id)
select 70, 'inscada', now(), NEW.space_id;


RETURN NEW;
END;
$$;