-- initial_space_security_data
-- Creates a function to insert initial security data (permissions, menus, and a role) for a new space

CREATE OR REPLACE FUNCTION insert_initial_security_data()
RETURNS TRIGGER
LANGUAGE plpgsql
AS $$
DECLARE
    initial_role_id UUID;
BEGIN
    -- Create the initial role for the new space
    INSERT INTO inscada.roles(role_id, name, space_id, insert_user, insert_dttm)
    VALUES (gen_random_uuid(), 'Space Admin', NEW.space_id, 'inscada', now())
    RETURNING role_id INTO initial_role_id;

    -- Assign all space permissions to the role
    INSERT INTO inscada.role_permissions(role_id, permission_id)
    SELECT initial_role_id, p.permission_id
    FROM inscada.permissions p
    WHERE p.is_global = false;

    -- Assign all space menus to the role
    INSERT INTO inscada.role_menus(role_id, menu_id)
    SELECT initial_role_id, m.menu_id
    FROM inscada.menus m
    WHERE m.is_global = false;

    RETURN NEW;
END;
$$;

-- Drop the trigger if it exists
DROP TRIGGER IF EXISTS trg_insert_initial_security_data ON inscada.space;

-- Create the trigger to call the function after a new space is inserted
CREATE TRIGGER trg_insert_initial_security_data
AFTER INSERT ON inscada.space
FOR EACH ROW
EXECUTE FUNCTION insert_initial_security_data();

