-- Remove EXPORT_SPACE_USERS and IMPORT_SPACE_USERS permissions
-- Step 1: delete role-permission mappings referencing these permissions (avoids FK violations)
DELETE FROM inscada.role_permissions rp
USING inscada.permissions p
WHERE rp.permission_id = p.permission_id
  AND p.name IN ('EXPORT_SPACE_USERS', 'IMPORT_SPACE_USERS');

-- Step 2: delete the permissions themselves (both global and per-space rows)
DELETE FROM inscada.permissions
WHERE name IN ('EXPORT_SPACE_USERS', 'IMPORT_SPACE_USERS');