-- Step 1: Clean up existing case-insensitive duplicate usernames among ACTIVE users.
-- This keeps the oldest created user and renames newer duplicates by appending their ID.
WITH duplicates AS (
    SELECT
        user_id,
        ROW_NUMBER() OVER(PARTITION BY LOWER(username) ORDER BY insert_dttm ASC) as rn
    FROM
        inscada."users"
    WHERE
        deleted_dttm IS NULL
)
UPDATE
    inscada."users"
SET
    username = username || '-' || duplicates.user_id
FROM
    duplicates
WHERE
    inscada."users".user_id = duplicates.user_id AND duplicates.rn > 1;


-- Step 2: Drop the old, case-sensitive unique index if it exists.
-- This avoids redundancy and potential confusion.
DROP INDEX IF EXISTS inscada.users_name_uindex;


-- Step 3: Create the new, case-insensitive, partial unique index.
-- This enforces uniqueness only on active (not soft-deleted) users.
CREATE UNIQUE INDEX IF NOT EXISTS uk_user_username_lower ON inscada."users" (LOWER(username)) WHERE deleted_dttm IS NULL;