-- Migrate all file content from database to file storage system
-- This migration will:
-- 1. Add file reference columns to all entities with file content
-- 2. Create indexes for performance
-- 3. Add foreign key constraints
-- Note: Columns are nullable initially, NOT NULL constraints will be added in V237 after data migration

-- Add file reference columns for Animation (will be NOT NULL after V235 migration)
ALTER TABLE animation ADD COLUMN svg_file_id VARCHAR(36);

-- Add file reference columns for Faceplate (will be NOT NULL after V235 migration)
ALTER TABLE faceplate ADD COLUMN svg_file_id VARCHAR(36);

-- Add file reference columns for IEC61850 Connection (nullable - not all connections have SCL content)
ALTER TABLE iec61850_connection ADD COLUMN scl_file_id VARCHAR(36);

-- Add file reference columns for Project (nullable - not all projects have icons)
ALTER TABLE project ADD COLUMN icon_file_id VARCHAR(36);

-- Add file reference columns for Jasper Report (will be NOT NULL after V235 migration)
ALTER TABLE jasper_report ADD COLUMN template_file_id VARCHAR(36);

-- Add file reference columns for Symbol (will be NOT NULL after V235 migration)
ALTER TABLE symbol ADD COLUMN content_file_id VARCHAR(36);

-- Add file reference columns for LoginSettings (nullable - not all have images)
ALTER TABLE login_settings ADD COLUMN image_file_id VARCHAR(36);

-- Add file reference columns for LogoSettings (nullable - not all have sidebar logo images)
ALTER TABLE logo_settings ADD COLUMN sidebar_logo_image_file_id VARCHAR(36);

-- Add foreign key constraints
ALTER TABLE animation ADD CONSTRAINT fk_animation_svg_file
    FOREIGN KEY (svg_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE faceplate ADD CONSTRAINT fk_faceplate_svg_file
    FOREIGN KEY (svg_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE iec61850_connection ADD CONSTRAINT fk_iec61850_connection_scl_file
    FOREIGN KEY (scl_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE project ADD CONSTRAINT fk_project_icon_file
    FOREIGN KEY (icon_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE jasper_report ADD CONSTRAINT fk_jasper_report_template_file
    FOREIGN KEY (template_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE symbol ADD CONSTRAINT fk_symbol_content_file
    FOREIGN KEY (content_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE login_settings ADD CONSTRAINT fk_login_settings_image_file
    FOREIGN KEY (image_file_id) REFERENCES file_info(file_info_id);

ALTER TABLE logo_settings ADD CONSTRAINT fk_logo_settings_sidebar_logo_image_file
    FOREIGN KEY (sidebar_logo_image_file_id) REFERENCES file_info(file_info_id);

-- Add indexes for performance
CREATE INDEX idx_animation_svg_file_id ON animation(svg_file_id);
CREATE INDEX idx_faceplate_svg_file_id ON faceplate(svg_file_id);
CREATE INDEX idx_iec61850_connection_scl_file_id ON iec61850_connection(scl_file_id);
CREATE INDEX idx_project_icon_file_id ON project(icon_file_id);
CREATE INDEX idx_jasper_report_template_file_id ON jasper_report(template_file_id);
CREATE INDEX idx_symbol_content_file_id ON symbol(content_file_id);
CREATE INDEX idx_login_settings_image_file_id ON login_settings(image_file_id);
CREATE INDEX idx_logo_settings_sidebar_logo_image_file_id ON logo_settings(sidebar_logo_image_file_id);