create sequence file_info_seq increment by 100 start with 1;

create table file_info
(
    file_info_id integer not null default nextval('file_info_seq'),
    name                varchar(100) not null,
    dsc                 varchar(255),
    file_name           varchar(255) not null,
    target_subdirectory varchar(255),
    relative_path       varchar(1024) not null,
    file_size           bigint not null,
    file_type           varchar(255) not null,
    space_id            integer not null,
    insert_user         varchar(50),
    insert_dttm         timestamp with time zone,
    version_user        varchar(50),
    version_dttm        timestamp with time zone,
    constraint file_info_file_info_id_pk primary key (file_info_id)
);

alter table file_info
add constraint file_info_space_id_name_uindex UNIQUE (space_id, name);

alter table file_info
add constraint file_info_space_id_relative_path_uindex UNIQUE (space_id, relative_path);

insert into inscada.permissions(permission_id, name)
values (254, 'VIEW_FILE'),
       (255, 'CREATE_FILE'),
       (256, 'UPDATE_FILE'),
       (257, 'DELETE_FILE'),
       (258, 'EXPORT_FILE'),
       (259, 'IMPORT_FILE');

insert into inscada.menus (menu_id, name)
values (108, 'File Management');

do
$$
declare
    r record;
begin
    for r in select role_id from roles
    loop
    insert into inscada.role_menus (role_id, menu_id)
    values (r.role_id, 108) on conflict do nothing;
    end loop;
end;
$$;
