alter table inscada.otp_settings
    add column sms_nt_username varchar(255),
    add column sms_nt_password varchar(255),
    add column sms_nt_header varchar(255),
    add column sms_nt_bayi_code varchar(255);

insert into inscada.otp_settings(type, provider, default_flag, insert_user, insert_dttm)
values ('sms', 'netgsm', false, 'inscada', now());

alter table inscada.sms_settings
    add column nt_username varchar(255),
    add column nt_password varchar(255),
    add column nt_header varchar(255),
    add column nt_bayi_code varchar(255);

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'netgsm',
       false,
       'inscada',
       now(),
       (select space_id from space where space.name = 'default_space')
       where not exists(select * from inscada.sms_settings where provider='netgsm');


CREATE
OR REPLACE FUNCTION insert_initial_space_data()
  RETURNS TRIGGER
  LANGUAGE PLPGSQL
  AS
$$
begin
insert into inscada.mail_settings(smtp_host, smtp_port, protocol, username, password, insert_user, insert_dttm,
                                  space_id)
select 'mail.inscada.com',
       25,
       'SMTP',
       'inscada',
       '',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'dataport', true, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'twilio', false, 'inscada', now(), NEW.space_id;

insert into inscada.sms_settings(provider, default_flag, insert_user, insert_dttm, space_id)
select 'netgsm', false, 'inscada', now(), NEW.space_id;

insert into inscada.broadcast_settings(server_ip_addr, insert_user, insert_dttm, space_id)
select 'https://www.inscada.com', 'inscada', now(), NEW.space_id;

insert into inscada.map_settings(map_api_key, weather_api_key, insert_user, insert_dttm, space_id)
select 'pk.eyJ1IjoieXJ5c2t1bCIsImEiOiJjazc0ZDc0NmswMnlvM2ptdnRqaW4ya3IxIn0.9YN8pWOfuz19ILnJy311ww',
       'd1a6442a2d89164ee9cc3d3a9c9c7ed3',
       'inscada',
       now(),
       NEW.space_id;

insert into inscada.custom_table_settings(url, username, password, insert_user, insert_dttm, space_id)
select 'jdbc:postgresql://localhost:5432/mydb', 'postgres', '', 'inscada', now(), NEW.space_id;


RETURN NEW;
END;
$$;